#ifndef __ELEMENT_SKILL_H
#define __ELEMENT_SKILL_H

// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the ELEMENTSKILL_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// ELEMENTSKILL_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.
#ifdef ELEMENTSKILL_EXPORTS
#define ELEMENTSKILL_API __declspec(dllexport)
#else
#define ELEMENTSKILL_API __declspec(dllimport)
#endif

#include <vector>
#include <utility>

namespace GNET
{
enum skill_type{
    TYPE_ATTACK   = 1,  // 
    TYPE_BLESS    = 2,  // ף
    TYPE_CURSE    = 3,  // 
    TYPE_SUMMON   = 4,  // Ʒ
    TYPE_PASSIVE  = 5,  // 
    TYPE_ENABLED  = 6,  // 
    TYPE_LIVE     = 7,  // 
    TYPE_JUMP     = 8,  // ˲
	TYPE_PRODUCE  = 9,  // ()
	TYPE_BLESSPET = 10,  // ף
	TYPE_NEUTRALBLESS = 11,	//ף
};

enum range_type{
	TYPE_POINT = 0,          //  
	TYPE_LINE  = 1,          //  
	TYPE_SELFSPHERE  = 2,    // Ϊĵ
	TYPE_TARGETSPHERE = 3,   // ĿΪĵ
	TYPE_TAPER  = 4,         // Բ׶
	TYPE_SLEF  = 5,          // 
};

enum form{
	FORM_MASK_HIGH	= 0xC0,
	FORM_NORMAL		= 0,	//̬ͨ
	FORM_CLASS		= 1,	//ְҵ
	FORM_BEASTIE	= 2,	//С
};

struct LearnRequirement
{
	int level;		//Ҽ
	int sp;         //ܵ
	int money;      //Ǯ
	int profession; //ְҵ
	int rank;       //漶
	int realm_level;//ȼ
};

struct PetRequirement
{
	int  level;		 //Ｖ
	int  sp;         //˼ܵ
	int* list;       //мб
	int  lsize;      //бС
};

struct GoblinRequirement
{
	int  genius[5];	  //С鼼츳
	int  profession;  //ְҵ
	int  sp;		  //Ԫ
	int  money;		  //˽Ǯ
	int  level;		  //Сȼ
	int  mp;		  //С鵱ǰ
};

struct ComboSkillState
{
	enum{ MAX_COMBO_ARG = 3 };
	unsigned int skillid;
	int arg[MAX_COMBO_ARG];
	ComboSkillState():skillid(0)
	{
		memset(arg, 0, sizeof(arg));
	}
};

struct UseRequirement
{
	int mp;            //ħ
	int ap;            //ŭֵ
	int form;          //״̬
	int weapon;        //
	int freepackage;   //ʣĿ
	int arrow;         //װ֧Ŀ
	int move_env;	//ƶ
	bool is_combat;   //Ƿս״̬
	int hp;				//ǰhp
	int max_hp;			//hp
	ComboSkillState combo_state;	//
};

struct GoblinUseRequirement
{
	int mp;			//(Ԫ)
	int ap;			//()
	int genius[5];	//С鼼츳
	int profession; //ְҵ
	int level;		//Сȼڼ
	int move_env;	//˵ǰƶ 
};

class SkillStub;

class ELEMENTSKILL_API SkillStr
{
public:
	virtual wchar_t* Find(int id) const {  return L""; }
};

class ELEMENTSKILL_API ElementSkill
{
public:
	enum {
		SKILL_PERFORM,
		SKILL_DONE,
	};
	typedef unsigned int ID;
	
	static ID NextSkill(ID id = 0);

	// 
	virtual const wchar_t* GetName() { return NULL;}
	virtual const char* GetNativeName() { return NULL;}
	// ,skill_type
	virtual char GetType() const { return 1; }        
	// ͼ
	virtual const char* GetIcon() { return NULL; }
	// ˵
	virtual const wchar_t* GetIntroduction(wchar_t* buf,int len,const SkillStr& table) { return L""; }
	// ְҵ
	virtual int GetCls() const { return -1; }
	// ȴʱ䣬λ
	virtual int GetCoolingTime() { return 5000; }
	// ִʱ䣬λ
	virtual int GetExecuteTime() { return 1000; }
	// Ŀ, 0:Ŀ꣬1:ҪĿ꣬2:Ŀʬ, 3:ĿΪ, 4:ĿΪ 
	virtual int GetTargetType(){return 0;}
	// Чͷž: <-0.001Ŀ -0.001-0.001 ĬϹ룬>0.001 ͷž
	virtual float GetPrayRange(float range, float prayplus) { return 0; }  


	// 漶
	virtual int GetRank() { return 0; }
	// ѧϰnҪҼ
	virtual int GetRequiredLevel() { return 0;}
	// ѧϰnҪļܵ
	virtual int GetRequiredSp() { return 0;}
	// ѧϰnҪļ
	virtual int GetRequiredBook() { return 0;}
	// ѧϰҪǮ
	virtual int GetRequiredMoney() { return 0;}
	// ѧϰ󾳽ȼ
	virtual int GetRequiredRealmLevel() { return 0; }
	// ǰἼ
	virtual const std::vector<std::pair<unsigned int, int> > & GetRequiredSkill() = 0;
	// ʾ˳
	virtual int GetShowOrder() { return 0; }
	// üܼ
	virtual int SetLevel(int) { return 0; } 
	// 󼶱
	virtual int GetMaxLevel() { return 0; }

	// Ƿ
	virtual bool IsWarmup() { return false; }
	// ʹúǷԶ
	virtual bool IsAutoAttack(){return false;}
	// ˲
	virtual bool IsInstant(){return false;}
	// Ƿ
	virtual bool IsDurative() { return false; }
	// ɱ˷Χ
	virtual int  GetRangeType() { return 0; }
	// ͷŻС桢ˮ
	virtual int  GetCastEnv() { return 0; }
	// ȡСѧϰͷż츳
	virtual int* GetRequiredGenius(int idSkill) { return NULL; }

	// Чļ
	virtual const char* GetEffect() { return NULL;}
	virtual const char* GetElseEffect() { return NULL;}

	// ʹҪMP
	virtual int GetMpCost(){return 1;}

	// ʹҪAP
	virtual int GetApCost(){return 0;}

	// ֧
	virtual int GetArrowCost(){return 0;}

	// ж
	virtual bool ValidWeapon(int w) const { return true; }
	// 0, ɹ1ƥ䣻2, mp㣻3λ㣻4㣻5ID, 6δѡĿ
	int Condition(UseRequirement& info);

	virtual bool IsAllowLand(){ return true; }
	virtual bool IsAllowWater(){ return true; }
	virtual bool IsAllowAir(){ return true; }
	virtual bool GetNotuseInCombat(){ return false; }
	//Ƿƶʩ
	virtual bool IsMovingSkill() { return false; }
	// ܷڵǰ״̬ʹ
	bool IsValidForm(char form);
	virtual char GetAllowForms() { return 0; }
	virtual bool Interrupt() { return true; }
	int GetAbilityPercent();

	// ȡӦĳ
	virtual std::vector<std::pair<unsigned int, int> > GetJunior() { return std::vector<std::pair<unsigned int, int> >(); };

	// ȡС鼼ְҵ
	virtual int GetClsLimit() { return 0; }
	
	//ȡȴmask bit0-4 ȴ0-4 bit5-9 Ʒȴ0-4
	virtual int GetCommonCoolDown() { return 0; }

	//ȡȴʱ䣬λ
	virtual int GetCommonCoolDownTime() { return 0; }

	//ȡƷ
	virtual int GetItemCost() { return 0; }

	//ȡʩǰ
	virtual int GetComboSkPreSkill(){ return 0; }

	//ʩʱhp
	virtual bool CheckHpCondition(int hp, int max_hp) { return true; }

	//
	virtual bool CheckComboSkExtraCondition(){ return true; } 
	
	// 0:ɹ            1:SP            2:𲻹
	// 3:            4:岻ƥ        5:ID
	// 6:Ǯ        7:漶    8:ûм
	// 9:ûǰἼ    10:Ȳ       11:Ѿѧ˸߼
	// 12:
	static int LearnCondition(ID id, LearnRequirement& info, int level ); 

	// 0:ɹ            1:ƥ        2:mp
	// 3:λ  4:    5:ID
	// 6:δѡĿ      7:״̬      8:ŭֵ
	// 9:֧        10:ûʣλ 11: սʹ
	// 12:HP   13:ǰ᲻
	static int Condition(ID id, UseRequirement& performer, int level );

	// 0:ɹ            1:SP        2:𲻹
	// 3:            9:ǰἼܼ𲻹  5:ID
	static int PetLearn(ID id, PetRequirement& info, int level); 

	// 0:ɹ            1:SP        2:츳㲻
	// 3:            4:ܸ		 5:ID
	// 6:Ǯ		 7:С鼼		 8:ûм
	// 9:ȼ       10:޲     11:ְҵƥ
    // 12:޲㣬ְҵƥ
	static int GoblinLearn(ID id, GoblinRequirement& info, int level); 

	// 0:ɹ            1:ְҵƥ        2:mp
	// 3:AP			 4:츳㲻		 5:ID
	// 6:δѡĿ      7:С鼼      8:ƶ
	static int GoblinCondition(ID id, GoblinUseRequirement& info, int level );

	//ȡְҵ
	static const std::vector<ID>& GetInherentSkills(int cls);

	//ȡб
	static void GetComboSkActivated(const ComboSkillState & combo_state, std::vector<std::pair<ID, int> >& list);
	//Ƿƶʩ
	static bool IsMovingSkill(ID id);

	static char GetType(ID id);  
	static const char* GetIcon(ID id);
	static const wchar_t* GetName(ID id);
	static const char* GetNativeName(ID id);
	static const char* GetEffect(ID id);
	static const char* GetElseEffect(ID id);
	static const wchar_t* GetIntroduction(ID id, int level, wchar_t* buf, unsigned int len, const SkillStr& table);
	static int GetRequiredLevel(ID id, int level);
	static int GetRequiredSp(ID id, int level);
	static int GetRequiredBook(ID id, int level);
	static int GetRequiredMoney(ID id, int level);
	static int GetRequiredRealmLevel(ID id, int level);
	static bool IsValidForm(ID id, char form);
	static int GetExecuteTime(ID id, int level);
	static int GetAbilityPercent(ID id);
	static std::vector<std::pair<unsigned int, int> > GetJunior(ID id);
	static int GetCommonCoolDown(ID id);
	static int GetCommonCoolDownTime(ID id);
	static int GetItemCost(ID id);
	
	static bool IsGoblinSkill(ID id);
	static int GetComboSkPreSkill(ID id);
	
	//Ǽ  <0ûѧ˼ >=0 
	static int GetAbility(ID id); 
	static int SetAbility(ID id, int ability);
	static int SetLevel(ID id, int level);
	static int GetLevel(ID id);
	static bool IsOverridden(ID id);
	static int GetMaxAbility(ID id, int level);

	static void LoadSkillData(void * data);

	static ElementSkill* Create(ID id, int level);
	void Destroy();

	static int GetVersion();
	
	//
	// ʼڲ̬ݣʹÿ֮ǰã
	//
	static void InitStaticData();
};

class ELEMENTSKILL_API VisibleState
{
public:
	virtual const int GetID() const { return 0; }
	virtual const wchar_t* GetName() const {  return NULL; }
	virtual const char* GetHH() const { return NULL; }
	virtual const char* GetEffect() const {  return NULL; }
	static const VisibleState* Query(int profession, int id);
};

class ELEMENTSKILL_API TeamState
{
public:
	virtual const int GetID() const { return 0; }
	virtual const wchar_t* GetName() const {  return NULL; }
	virtual const char* GetIcon() const { return NULL; }
	static const TeamState* Query(int id);
};

}

#endif
