// Filename	: WikiSearcher.cpp
// Creator	: Feng Ning
// Date		: 2010/04/23

#include "WikiSearcher.h"

#define new A_DEBUG_NEW

WikiSearcher::WikiSearcher()
:m_pCommand(NULL)
,m_pProvider(NULL)
,m_IsSearched(false)
{
}

WikiSearcher::~WikiSearcher()
{
	WikiSearcher::Release();
}

int WikiSearcher::GetPageSize() const
{
	return 13;
}

void WikiSearcher::TurnPageHome()
{
	if(!GetSearchCommand() || !GetContentProvider() ||
		(IsSearched() && !HavePrevPage()))
	{
		return;
	}
	
	// ʼ֤
	FirstPage(GetContentProvider()->Begin());
	
	// ʼ
	SearchNextPage();
}

void WikiSearcher::SearchNextPage()
{
	if(!GetSearchCommand() || !GetContentProvider())
	{
		// must assign a command instance first
		return;
	}

	if (IsPageInvalid())
	{
		// Ƿ
		// m_pagesBegin һԪأָʾǰҪλ
		// m_pagesBegin һԪأָʾʼλ
		// һҳʼλΪ 0
		return;
	}

	SearchCommand& command = *GetSearchCommand();
	ContentProvider& provider = *GetContentProvider();
	
	// ǰڴ
	OnBeginSearch();
	
	// ʼλ
	WikiEntityPtr pCandidate = GetPageBack();

	// 
	int nAdded(0);

	while (pCandidate)
	{
		// жϵǰ idNext ǷϷ
		if (command(pCandidate))
		{
			// ǺϷ
			if (nAdded < GetPageSize())
			{
				// ӵ
				if(OnAddSearch(pCandidate))
				{
					nAdded ++;
					
					// ֪ͨҳƷӣͳ
					AddPageItem();
				}
			}
			else
			{
				// Ϊһʼλ
				// ѭ
				break;
			}
		}
		
		// һѡ
		pCandidate = provider.Next(pCandidate);
	}

	// 
	if (pCandidate)
	{
		// ѾѳһҳĵһϷֵ
		AddPage(pCandidate);
	}
	else
	{
		// ûкϷһҳ
		FinishPage();

		// m_pagesBegin δ£m_pagesBegin һӦǰҳһҳʼλ
		//  SearchNextPageҲֻ²ҵǰҳ
	}

	// ֪ͨбѾ
	// ɸбеݣʼ
	OnEndSearch();

	m_IsSearched = true;
}

void WikiSearcher::SetSearchCommand(const SearchCommand* pCommand)
{
	if(m_pCommand) delete m_pCommand;
	m_pCommand = pCommand ? pCommand->Clone():NULL;

	m_IsSearched = false;
}

void WikiSearcher::SetContentProvider(const ContentProvider* pProvider)
{
	if(m_pProvider) delete m_pProvider;
	m_pProvider = pProvider ? pProvider->Clone():NULL;

	m_IsSearched = false;
}

void WikiSearcher::ResetSearchCommand()
{
	SetSearchCommand(NULL);
}

bool WikiSearcher::TestEmpty()
{
	if (!IsSearched())
	{
		TurnPageHome();
	}
	
	return IsPageEmpty();
}

void WikiSearcher::Release()
{
	WikiPage<WikiEntityPtr>::Clear();
	
	// delete current command
	SetSearchCommand(NULL);
	
	// delete current provider
	SetContentProvider(NULL);
}

void WikiSearcher::TurnPageDown()
{
	// ǰҳһҳ
	//
	if (!HaveNextPage())
		return;
	
	SearchNextPage();
}

void WikiSearcher::TurnPageUp()
{
	// ǰҳǰһҳ
	//
	if (!HavePrevPage())
		return;
	
	// ҳƵǰҳǰһҳ
	PrevPage();
	
	// m_pagesBegin һԪأָǰһҳλãԿʼ
	SearchNextPage();
}

bool WikiSearcher::Refresh(const SearchCommand* pCommand)
{
	SetSearchCommand(pCommand);
	
	return !TestEmpty();
}