// File		: EC_UIConfig.h
// Creator	: Xu Wenbin
// Date		: 2012/5/14

#pragma once
#include <vector.h>
#include <hashmap.h>
#include <AAssist.h>
#include <time.h>

//	configs/uiconfig.ini ļý
class CECUIConfig
{
private:
	CECUIConfig(){}
	CECUIConfig(const CECUIConfig &);
	CECUIConfig & operator == (const CECUIConfig &);

public:

	void	Load(const char *filePath);

	//	¼ص
	struct LoginUI 
	{
		bool	bEnableOtherLogin;		//	˺Ž¼ʽ
		bool	bAlwaysTryAutoLogin;	//	ÿε¼ǳʹԶ¼
		bool	bEnableForceLogin;		//	¼ʼմǿƵ¼
		bool	bSkipFirstLoadProgress;	//	״νϷʾؽԶ¼ʵֽϷ¼б
		bool	bAvoidLoginUI;			//	ص¼棨¼ʧܻߺ˳ͻˣ
		ACString strHotServerGroupName;	//	·ʾ
		int		nMaxRecordAccount;		//	¼ɹ¼˺
		int		nMinInputToRemindAccount;	//	˺˺ַ

		LoginUI(): bEnableOtherLogin(true)
			, bAlwaysTryAutoLogin(false)
			, bEnableForceLogin(false)
			, bSkipFirstLoadProgress(false)
			, bAvoidLoginUI(false)
			, strHotServerGroupName(_AL("Hot"))
			, nMaxRecordAccount(100)
			, nMinInputToRemindAccount(5)
		{}
	};
	struct LoginUI m_loginUI;
	LoginUI & GetLoginUI() { return m_loginUI; }
	const LoginUI & GetLoginUI() const { return m_loginUI; }

	// ͼMͼֲƷ
	struct RandomMapItem
	{
		RandomMapItem(){ itemID = 0; count = 0;}
		int itemID;
		int count;
	} ;

	//	Ϸ߼ص
	struct GameUI 
	{
		bool	bMailToFriendsSwitch;			//	ǧﴫ
		int		nMailToFriendsDaysNoLogin;		//  δ½ֵ
		int		nMailToFriendsLevel;			//  ʹǧﴫļ
		int		nMailToFriendsDaysSendMail;		//  ٻʼֵٴη

		bool	bActivityReminder;				//  ŮƬIE
		int		nActivityReminderLevel;			//	ȼ
		int		nActivityReminderMaxLevelSoFar;	//	ʷߵȼ
		int		nActivityReminderLevel2;		//	ȼ
		int		nActivityReminderReincarnationTimes;	//	ת
		int		nActivityReminderRealmLevel;	//	ȼ
		int		nActivityReminderReputation;	//	
		struct tm tActivityReminderStartTime;	//	ʼʱ䣨ʱ䣩
		struct tm tActivityReminderEndTime;		//	ʱ䣨ʱ䣩
		
		bool	bEnableTalkToGM;				//	GMͷǱ׼Ϣ
		bool	bEnableTrashPwdRemind;			//	Ҳֿû
		
		enum WallowHintType // wallow hint info type
		{
			WHT_DEFAULT = 0,					//	ĬϷʽ
			WHT_KOREA = 1,						//	ʽ
		};
		WallowHintType	nWallowHintType;		//	ʾ

		bool	bEnableIE;						//	ʹ IE ʾҳ
		bool	bEnableShowIP;					//	Ƿʾϴε¼Ϣ
		bool	bEnableCompleteAccount;			//	Ƿʾ˺ŲϢ
		bool	bEnableFortressBuildDestroy;	//	Ƿհɻʩ
		abase::vector<int>	nCountryWarBonus;	//	սּ
		bool	bShowNameInCountryWar;			//	սսʾƵ
		int		nCountryWarEnterLevel;			//	սȼ
		int		nCountryWarEnterItem;			//	սƷid
		int		nCountryWarEnterItemCount;		//	սƷ
		bool	bEnableQuickPay;				//	֧
		int		nEquipMarkMinInkNum;			//	װǩ޸Ҫīˮ
		bool    bEnableReportPlayerSpeakToGM;   //  GMٱҵķϢ
		bool	bEnableReportPluginWithFeedback;//	ϵͳľٱ
		unsigned int nGTLoginCoolDown;			//	Ϸ GT ¼ȴʱ룩
		bool	bEnableGTOnSpecialServer;		//	ǷGT
		int		nCrossServerEnterLevel;			//	ȼ
		int		nCrossServerEnterLevel2;		//	
		bool	bEnableWebTradeSort;			//	ѰƷʱѰҳ
		bool    bEnablePlayerRename;            //  Ҹ
		bool	bEnableCheckNewbieGift;			//	ֿʾ
		bool    bEnableQShopFilter;				//	̳ʾ˹ܣҵȼã
		bool    bEnableGivingFor;               //  ̳ͺȡ
		bool    bEnableGivingForTaskLimitedItem;//  ̳ĳЩƷͺȡ
		abase::vector<int>	nCountryWarPlayerLimit;	//	սս
		int		nCountryWarKingMaxDomainLimit;		//	
		int		nFashionSplitCost;				//	ʱװĽ
		bool	bEnableTouch;					//	Touch ̳ǿ
		bool	bEnableOptimize;				//  ǷͻŻ
		int		nMemoryUsageLow;				//  ڴֵϵͳԶָģ
		int		nMemoryUsageHigh;				//  ڴֵϵͳȼģ
		int		nAutoSimplifySpeed;				//  ೤ʱŻһ
		abase::vector<int>	nTouchEnabledMap;	//	TOUCH ̳ǿĵͼ
		bool	bEnableTWRecharge;				//	̳ǳֵťض̨
		AString strTWRechargeAppID;				//	ֵ̨в AppID̴룩
		AString	strTWRechargeGame;				//	ֵ̨в GameϷ
		AString	strTWRechargeKey;				//	ֵ̨в KeyӸУ
		bool	bEnableTitle;					//  TitleUI
		abase::vector<int> nAutoTeamTransmitEnabledMap;	//  ϣԽд͵ĵͼID
		int		nChariotApplyLevel;					//	ս ȼ
		int		nChariotApplyLevel2;				//	ս 
		int		nChariotApplyReincarnation;			//	ս ת
		int		nChariotReviveTimeout;				//	սʱʱ
		int		nChariotAmount;						//	սսս
		int		nHistoryQueryTimeInterval;			//	ѯʷʱ
		bool	bEnableAutoWiki;					//	ܰٿƿ
		int		nExitAutoExtractWikiStateTime;		//	ܰٿ: ˳Զץȡ 
		int		nCloseWikiPopDlgTime;				//	ܰٿ: رʱ䣻
		int		nCloseWikiMsgInfoTime;				//	ܰٿ: ʧʱ
		int		nOpenWikiPopDlgTime;				//	ܰٿ: ʱ
		abase::vector<int> nTaskDisabledInMiniClient;	//	ͻнõ
		abase::vector<int> nItemDisabledInMiniClient;	//	ͻнõƷ
		abase::vector<int> nMeridianFreeItem;			//	IDб
		abase::vector<int> nMeridianNotFreeItem;		//	ʤIDб
		int		nMonsterSpiritGatherTimesPerWeekMax;	//	ÿܲȡԪ
		bool	bEnableAutoPolicy;						//	Զϵͳ
		bool	bEnablePWService;						//	濪
		bool	bEnableActionSwitch;					//	лأ ->У->ˣʹüǰԶٻ
		int		nCountryWarLiveShowUpdateInterval;		//	սݸ¼
		abase::vector<int> nDefaultSystemModuleIndex;	//	ϵͳĬϹindex
		bool	bEnableRecommendQShopItem;				//	ʵʱƼ̳Ʒ
		abase::vector<int> nRecommendShopItems;			//	Ƽ̳Ʒ
		bool	bEnableRandShop;						//	Ƿ̳ǣں汾汾Эԭ򡢱ֹ
		int		nPokerShopConfig;						//	ս̳ñID
		int		nPokerShopLevelLimit;					//	ս̳ʹõȼ
		int		nContributionTaskLevelLimit;			//	Ծֵϵͳʹõȼ
		abase::vector<AString> strFashionShopAdImage;	//	ʱװ̳ǹͼƬ
		bool	bEnableQShopFashionShop;				//	Ǭʱװ̳
		bool	bEnableBackShopFashionShop;				//	̳ʱװ̳
		bool	bEnableCeilPriceBeforeDiscountToGold;	//	̳ǴƷԭֻʾȡĻƽʹԭۿг⣩
		abase::vector<AString> strFullScreenGfxForeground;//ȫЧǰЧ
		abase::vector<AString> strFullScreenGfxBackground;//ȫЧЧ
		abase::vector<int> nRandomMaps;					// ͼ
		abase::vector<int> nTaskIDForDisableWayPointUITips; // ЩʱҪرմ͵tipʾ
		RandomMapItem DefaultRandomMapItem; // ĬͼMͼֲƷ
		abase::hash_map<int,RandomMapItem> SpecialRandomMapItems; // ضͼͼMͼֲƷ
		int		nMaxFriendRemarksNameLength;			//	ѱעֳ
		bool	bEnableQShopFashionShopFlashSale;			//	Ǭʱװ̳
		bool	bEnableBackShopFashionShopFlashSale;		//	̳ʱװ̳
		ACString	strQShopFashionShopFlashSaleTitle;		//	Ǭʱװ̳ť
		ACString	strBackShopFashionShopFlashSaleTitle;	//	̳ʱװ̳ť
		bool    bEnablePlayerChangeGender;				//  ұԷ

		GameUI();

		int	GetCountryWarBonusLevel(int currentBonus)const;
		int	GetCountryWarPlayerLimit(int warType)const;
		bool GetCanShowTouchShop(int idInst)const;
		bool IsTaskDisabledInMiniClient(int task_id) const;
		bool IsItemDisabledInMiniClient(int item_id) const;
		bool IsMeridianFreeItem(int item_id) const;
		bool IsMeridianNotFreeItem(int item_id) const;
		bool IsRandomMap(int mapid) const;
		int GetRandomMapCount() const { return nRandomMaps.size();}
		int GetRandomMapID(int idx) { return nRandomMaps[idx];}
		bool GetRandomMapItemInfo(int mapID,RandomMapItem& info);
		int GetTaskIDDisableWayPointsUITipsCount() { return nTaskIDForDisableWayPointUITips.size();}
		int GetTaskIDDisableWayPointsUITips(int idx) { return nTaskIDForDisableWayPointUITips[idx];}
		

		enum RecommendShopItemType{
			RECOMMEND_REFINE_1,		//	װ
			RECOMMEND_REFINE_2,		//	װ
			RECOMMEND_REFINE_3,		//	װ
			RECOMMEND_REFINE_4,		//	װ
			RECOMMEND_REFINE_5,		//	װ
			RECOMMEND_SAVE_LIFE,	//	
			RECOMMEND_ACTIVITY,		//	ǰ
		};
		int	GetRecommendShopItem(int type)const;
	};
	struct GameUI m_gameUI;
	GameUI & GetGameUI() {return m_gameUI;}
	const GameUI & GetGameUI()const {return m_gameUI;}

	static CECUIConfig & Instance();
};

//	configs/qshopitem.ini ļý
class CECQShopConfig
{
private:
	CECQShopConfig();
	CECQShopConfig(const CECQShopConfig &);
	CECQShopConfig & operator == (const CECQShopConfig &);

	// Ʒȼ
	struct LevelFilterCondition
	{
		int minLevel;
		int maxLevel;

		LevelFilterCondition()
		{
			minLevel = 1;
			maxLevel = 1;
		}

		bool Meet(int level)const
		{
			return level >= minLevel && level <= maxLevel;
		}
	};
	typedef abase::hash_map<int, LevelFilterCondition> LevelFilterMap;	// ƷIDΧӳ䣬Լٲѯ
	LevelFilterMap m_levelFilters;
	
	//	Ʒƹ
	typedef abase::hash_map<int, bool> IDFilterMap;
	IDFilterMap	m_idFilters;

	//	ʶƷ߼
	struct CategoryPosition 
	{
		int	mainType;
		int	subType;
		CategoryPosition()
		{
			mainType = 0;
			subType = 0;
		}
		CategoryPosition(int m, int s): mainType(m), subType(s){}
	};
	typedef abase::hash_map<int, CategoryPosition>	CategoryMap;
	CategoryMap	m_catMap;

public:

	bool	Load(const char *filePath);
	bool	IsFilteredByLevel(int id, int myLevel)const;

	bool	IsFilteredByID(int id)const;
	bool	CanFilterID(int id)const;
	void	OnItemBuyed(int id);
	void	ClearBuyedItem();

	enum	CategoryID
	{
		CID_REFINE,				//	
		CID_QSHOP_FASHION,		//	Ǭʱװ
		CID_BACKSHOP_FASHION,	//	̳ʱװ
	};
	bool	FindCategory(int idCategory, int &mainType, int &subType)const;

	static CECQShopConfig & Instance();
};
