// File		: EC_QuickBuyPopPolicy.h
// Creator	: Xu Wenbin
// Date		: 2013/12/19

#pragma once

#include <ABaseDef.h>

//	ƷԣƷʾʲôϢǷҪȷϡɹ
class CECShopBase;
class CECShopSearchPolicyBase;
class CECQuickBuyPopBuyItemPolicy
{
	int		m_recommendMessage;	//	ƼʱʾϢ
	int		m_recommendItem;	//	ƼƷ
	bool	m_needConfirm;		//	ʱǷҪٴȷ
	bool	m_needFlash;		//	Ƿ˸ʾ

public:
	CECQuickBuyPopBuyItemPolicy(int recommendMessage, int recommendItem, bool needConfirm, bool needFlash);
	virtual ~CECQuickBuyPopBuyItemPolicy();

	int  GetItemID()const;
	void GetItem(int &recommendMessage, int &recommendItem, bool &needConfirm, bool &needFlash)const;
	
	virtual CECShopBase * GetShopData();
	virtual CECShopSearchPolicyBase * GetShopSearchPolicy(int itemID);
};

//	ԣʱ
class AIniFile;
class CECQuickBuyPopTriggerPolicy
{
	bool		m_bTriggered;
	bool		m_bItemGained;
	int			m_chkHideTime;				//	ϴε Chk_Hide ķʱ
	DWORD		m_dwNextTriggerTime;		//	ȴƣ Tick ʱֻʹʱ䣩
	char *		m_szHideReason;				//	ԭںԿ

protected:
	CECQuickBuyPopBuyItemPolicy *m_pBuyItemPolicy;

protected:
	virtual bool CanTriggerCheckMore()const=0;	//	ӵĴ
	virtual const char *GetConfigName()const=0;	//	
	virtual void RestartMore(){}
	virtual void OnShowMore(){}
	virtual void OnHideMore(){}
	virtual void OnNoItemMore(){}
	virtual void OnNoPopDialogMore(){}
	virtual bool CanHideMore(const char *&szHideReason)const{ return false; }
	virtual void OnItemAppearInPackMore(){}
	virtual void SaveConfigMore(AIniFile &){}	//	ãҵҪ첻ٵ
	virtual void LoadConfigMore(AIniFile &){}	//	

	const char * GetHideReason()const{ return m_szHideReason; }

public:
	CECQuickBuyPopTriggerPolicy(CECQuickBuyPopBuyItemPolicy *pBuyItemPolicy);
	virtual ~CECQuickBuyPopTriggerPolicy(){}

	void Restart();							//	ã¿ʼ
	void OnShow();							//	
	void OnHide();							//	أʧܡɹȡ
	void OnNoItem();						//	ʱҲҪƷ̳ƷƷǰ״̬õȣ
	void OnNoPopDialog();					//	ʱҲõ׽

	bool CanTrigger()const;					//	ܷ񴥷

	bool CanHide(const char *&szHideReason)const;//	أҵҪ첻ٵƷѾõ
	virtual bool NeedCheckHide()const=0;	//	ǷƵѡ
	void OnCheckHide();						//	ҵƵؼ

	void OnItemAppearInPack(int itemID, int iSlot);	//	Ʒڰг

	void SetHideReason(const char *szReason);

	void SaveConfig(AIniFile &);			//	ãҵҪ첻ٵ
	void LoadConfig(AIniFile &);			//	
};

//	Իδʱزԣʱءϲ
class AUIDialog;
class CECQuickBuyPopHidePolicy
{
public:
	virtual ~CECQuickBuyPopHidePolicy(){}
	
	virtual void Restart()=0;
	virtual void TickOnShow(AUIDialog *pDlg)=0;
	virtual bool CanHide(const char *&szHideReason)=0;
};

//	ԻʾԣСĸԻʲôҪض
class AUIDialog;
class CECQuickBuyPopAlignPolicy
{
public:
	virtual ~CECQuickBuyPopAlignPolicy(){}	
	virtual void OnShow(AUIDialog *pDlg){}
};

//	ṩĳԵĶӿ
class AUIDialog;
class AString;
enum QuickBuyPopConfigID
{
	QUICK_BUY_POP_INVALID,		//	Ч
	QUICK_BUY_POP_SAFE_LIFE,	//	
	QUICK_BUY_POP_ACTIVITY,		//	ǰص
};
class CECQuickBuyPopPolicies 
{
	QuickBuyPopConfigID			id;
	CECQuickBuyPopBuyItemPolicy	*pBuyItemPolicy;
	CECQuickBuyPopTriggerPolicy *pTriggerPolicy;
	CECQuickBuyPopHidePolicy	*pHidePolicy;
	CECQuickBuyPopAlignPolicy	*pAlignPolicy;
	
	const char * GetConfigFileDir();
	AString GetConfigFilePath(int playerID);
	void SaveConfigs();
	void LoadConfigs();

public:
	CECQuickBuyPopPolicies()
		: id(QUICK_BUY_POP_INVALID)
		, pBuyItemPolicy(0)
		, pTriggerPolicy(0)
		, pHidePolicy(0)
		, pAlignPolicy(0){
	}
	CECQuickBuyPopPolicies(QuickBuyPopConfigID ID, CECQuickBuyPopBuyItemPolicy *buy, CECQuickBuyPopTriggerPolicy *trigger, CECQuickBuyPopHidePolicy *hide, CECQuickBuyPopAlignPolicy *align)
		: id(ID)
		, pBuyItemPolicy(buy)
		, pTriggerPolicy(trigger)
		, pHidePolicy(hide)
		, pAlignPolicy(align){
		LoadConfigs();
	}

	bool IsValid()const{
		return id != QUICK_BUY_POP_INVALID
			&& pBuyItemPolicy != 0
			&& pTriggerPolicy != 0
			&& pHidePolicy != 0
			&& pAlignPolicy != 0;
	}

	void Release(){
		delete pBuyItemPolicy;
		pBuyItemPolicy = 0;

		delete pTriggerPolicy;
		pTriggerPolicy = 0;

		delete pHidePolicy;
		pHidePolicy = 0;

		delete pAlignPolicy;
		pAlignPolicy = 0;

		id = QUICK_BUY_POP_INVALID;
	}
	
	QuickBuyPopConfigID GetID()const{ return id; }
	bool GetItem(int &recommendMessage, int &recommendItem, bool &needConfirm, bool &needFlash){
		bool bGet(false);
		if (pBuyItemPolicy){
			pBuyItemPolicy->GetItem(recommendMessage, recommendItem, needConfirm, needFlash);
			bGet = true;
		}
		return bGet;
	}
	CECShopBase * GetShopData(){
		return pBuyItemPolicy ? pBuyItemPolicy->GetShopData() : 0;
	}
	CECShopSearchPolicyBase * GetShopSearchPolicy(int itemID){
		return pBuyItemPolicy ? pBuyItemPolicy->GetShopSearchPolicy(itemID) : 0;
	}
	bool NeedCheckHide()const{
		return pTriggerPolicy ? pTriggerPolicy->NeedCheckHide() : false;
	}
	bool CanTrigger()const{
		return pTriggerPolicy ? pTriggerPolicy->CanTrigger() : false;
	}
	bool CanHide(const char *&szHideReason)const{
		return pHidePolicy && pHidePolicy->CanHide(szHideReason)
			|| pTriggerPolicy && pTriggerPolicy->CanHide(szHideReason);
	}
	void SetHideReason(const char *szHideReason){
		if (pTriggerPolicy) pTriggerPolicy->SetHideReason(szHideReason);
	}
	void Restart(){
		if (pTriggerPolicy) pTriggerPolicy->Restart();
		if (pHidePolicy)	pHidePolicy->Restart();
	}
	void OnShow(AUIDialog *pDlg){
		if (pTriggerPolicy) pTriggerPolicy->OnShow();
		if (pAlignPolicy)	pAlignPolicy->OnShow(pDlg);
	}
	void OnHide(){
		if (pTriggerPolicy) pTriggerPolicy->OnHide();
		SaveConfigs();
	}
	void OnNoItem(){
		if (pTriggerPolicy) pTriggerPolicy->OnNoItem();
	}
	void OnNoPopDialog(){
		if (pTriggerPolicy) pTriggerPolicy->OnNoPopDialog();
	}
	void TickOnShow(AUIDialog *pDlg){
		if (pHidePolicy)	pHidePolicy->TickOnShow(pDlg);
	}
	void OnCheckHide(){
		if (pTriggerPolicy) pTriggerPolicy->OnCheckHide();
	}
	void OnItemAppearInPack(int itemID, int iSlot){
		if (pTriggerPolicy) pTriggerPolicy->OnItemAppearInPack(itemID, iSlot);
	}
};