// Filename	: EC_PetWords.h
// Creator	: Xu Wenbin
// Date		: 2010/11/04

#pragma once

#include <AAssist.h>
#include <ABaseDef.h>
#include <hashmap.h>
#include <AWScriptFile.h>

//
//	л˵ͻΪ
//
class CECPetWords
{
public:

	CECPetWords();

	//	˵
	enum TYPE_WORDS
	{
		TW_SUMMON,			//	ٻʱ
		TW_REST,			//	ж
		TW_PASSIVE,			//	ģʽΪֶģʽ
		TW_DEFENSIVE,		//	ģʽΪģʽ
		TW_OFFENSIVE,		//	ģʽΪģʽ
		TW_STOP,			//	ƶģʽΪԭش
		TW_FOLLOW,			//	ƶģ͸Ϊ
		TW_FIGHT,			//	ս
		TW_RECALL,			//	ٻ
		TW_DEAD,			//	ɱʱ
		TW_DISAPPEAR,		//	Ҫʧʱʱ޵ȣ
		TW_SACRIFICE,		//	ʹöתƼʱ
		TW_MAX
	};

	//	³ʼ
	void Reset();

	//	س˵
	bool LoadWords(const char *szFile);

	//	ѯ˵ݣ޷NULL
	const ACHAR * GetWords(int idPet, TYPE_WORDS type);

private:

	bool ReadType(AWScriptFile &ScriptFile);
	bool ReadContent(AWScriptFile &ScriptFile);

	struct WordsID
	{
		int			id;			//	ID
		TYPE_WORDS	type;		//	˵ʱ

		bool operator == (const WordsID &rhs)const { return this->id == rhs.id && this->type == rhs.type; }
	};

	struct _words_hash_function
	{
		unsigned long operator()(const WordsID &rhs)const{ return rhs.id; }
	};

	enum {MAX_WORDSCOUNT = 3};			//	ͬһͬһ龰˵ֵ
	typedef abase::vector<ACString>	Words;
	typedef abase::hash_map<WordsID, Words, _words_hash_function> WordsMap;
	WordsMap	m_words;				//	гĺ龰

	float		m_wordsProp[TW_MAX];	//	龰ºĸ
};