/*
 * FILE: EC_MCDownload.h
 *
 * DESCRIPTION: 
 *
 * CREATED BY: Shizhenhua, 2013/7/15
 *
 * HISTORY: 
 *
 * Copyright (c) 2011 ACE Studio, All Rights Reserved.
 */


#pragma once

#include <windows.h>
#include <AChar.h>
#include <AAssist.h>
#include <list>
#include "EC_Counter.h"


///////////////////////////////////////////////////////////////////////////
//	
//	Define and Macro
//	
///////////////////////////////////////////////////////////////////////////

#define PIPEDATA_MAXSIZE 256

//  ӽ֪ͨͻйܵݵ
#define WM_SENDPIPEDATA (WM_USER + 8905)

#define APP_PIPE_NAME _AL("\\\\.\\pipe\\PWDownloader")


///////////////////////////////////////////////////////////////////////////
//	
//	Types and Global variables
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Declare of Global functions
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Class CECMCDownload
//	
///////////////////////////////////////////////////////////////////////////

class CECMCDownload
{
public:

	// ӽ̵
	enum
	{
		OUT_DOWNLOAD,		// ʼ
		OUT_INSTALL,		// ʼװ
		OUT_QUIT,			// ˳Ϸ
		OUT_GETTASKINFO,	// ȡϢ
		OUT_GETDOWNLOADOK,	// Ƿ
		OUT_SWITCHGAME,		// Ϸ

		OUT_NUM,
	};

	// յӽ̵
	enum
	{
		IN_DOWNLOAD_OK,		// 
		IN_TASKINFO,		// յǰϢ

		IN_NUM,
	};

#pragma pack(1)

	struct CMD_HEAD
	{
		int id;
	};

	struct TASK_INFO
	{
		bool isdownloading;	// Ƿ
		float down_speed;	// ٶ
		float up_speed;		// ϴٶ
		float progress;		// ؽ
	};

	struct START_DOWNLOAD
	{
		int dspeed;			// ٶ
		int uspeed;			// ϴٶ
	};

#pragma pack()

	///////////////////////////////////////////////////////////////////////

	// ݶ
	struct SENDDATA
	{
		char* pBuf;
		int iSize;
	};

	typedef std::list<SENDDATA> SendDataQueue;

public:
	virtual ~CECMCDownload();

	// 
	bool StartDownloader();

	// µǰ״̬
	void Tick(DWORD dwDeltaTime);

	// ӦܵϢĵ
	void OnPipeData(int iSize);

	// ȥѾԷӦ
	void OnSendedDataProcessed();

	// ӽ̵Ĵھ
	void SetDownloaderHWnd(HWND hWnd) { m_hWndDownloader = hWnd; }

	// Ϣ
	void SendGetTaskInfo();
	// ֪ͨӽ˳
	void SendQuit();
	// ֪ͨӽ̿ʼװ
	void SendInstall();
	// Ƿ
	bool SendGetDownloadOK();
	// ֪ͨʼ
	bool SendDownload(int dspeed, int uspeed);
	// ֪ͨӽ̽Ϸ
	bool SendSwitchGame(bool bEnter);

	// ȡǰؽ
	float GetCurProgress() const { return m_TaskInfo.progress; }

	// ȡ
	static CECMCDownload& GetInstance();

protected:
	CECCounter m_cntTick;
	HANDLE m_hPipe;

	volatile HWND m_hWndDownloader;	// ӽ̵Ĵھ
	volatile int m_iSendedSize;		// ѾͳȥȴԷݴС
	volatile int m_iPipeDataSize;	// ѾյݴС

	CRITICAL_SECTION m_csQueue;	// м
	SendDataQueue m_SendQueue;	// Ͷ

	TASK_INFO m_TaskInfo;	// ǰ
	bool m_bDownloadOK;		// Ƿ
	bool m_bQuitSended;		// Ѿ˰װ
	CECCounter m_cntStart;

protected:
	CECMCDownload();

	// ӷݵ
	bool AddSendDataToQueue(void* pBuf, int iSize, bool bFront = false);
	// Ͷ
	void ProcessSendData();
	// ӽ̷
	bool SendData(void* pBuf, int iSize);
	// Ӧݷȥ
	void OnDataSended(const SENDDATA& data);

	// ܵݵĴСǷȷ
	bool CheckValid(BYTE* pBuf, int iSize);
	// ܵ
	void ProcessPipeData();

	// ӦɵĲ
	void OnDownloadOK();

	// ٹڵܵ
	void DestroyOldPipe();
};

///////////////////////////////////////////////////////////////////////////
//	
//	Inline functions
//	
///////////////////////////////////////////////////////////////////////////
