/*
 * FILE: EC_HostGoblin.h
 *
 * DESCRIPTION: Goblin follow the hostplayer
 *
 * CREATED BY: Sunxuewei, 2008/11/06
 *
 */
#ifndef _EC_HOSTGOBLIN_H_
#define _EC_HOSTGOBLIN_H_

#include "A3DTypes.h"
#include "EC_Counter.h"
#include "EC_MsgDef.h"
#include "EC_Goblin.h"
///////////////////////////////////////////////////////////////////////////
//	
//	Define and Macro
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Types and Global variables
//	
///////////////////////////////////////////////////////////////////////////

class CECModel;
class CECPlayer;
class CECViewport;
class CECInventory;
class CECSkill;
class CECIvtrGoblinEquip;
class CECObject;

///////////////////////////////////////////////////////////////////////////
//	
//	Declare of Global functions
//	
///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////
//	
//	Class CECHostGoblin
//	
///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////
// 
// 
//
///////////////////////////////////////////////////////////////////////////
class CECHostGoblin : public CECGoblin
{
public:
	enum
	{
		MAX_SKILLNUM = 8,
	};
private:
	int				m_iSecurityState;	// С鰲ȫ״̬ 0: ȫ״̬>0ת״̬Ϊתϵʱ㣬-1:ɽ״̬ 
	unsigned int	m_iExp;				// ֵ	
	int				m_iLevel;			// ȼ	

	int				m_iTotalStatusPt;	// Ե
	int				m_iStrength;		// 
	int				m_iAgility;			// 
	int				m_iVitality;		// 
	int				m_iEnergy;			// 

	int				m_iStrEnhance;		// Buffӵ
	int				m_iAgiEnhance;		// Buffӵ
	int				m_iVitEnhance;		// Buffӵ
	int				m_iEngEnhance;		// Buffӵ
	

	int				m_iTotalGeniusPt;	// 츳
	int				m_aGenius[5];		// ѷĽľˮ5츳

	int				m_iVigor;			// ǰԪֵ
	int				m_iMaxVigor;		// Ԫ
	float			m_fVigorGen;		// Ԫظ

	int				m_iStamina;			// ֵ
	int				m_iGrowDegree;		// ɳ
	int				m_iMaxRandomPt;		// ǰܻȡֵ

	int				m_iCurrMaxSkillNum;	// ǰܹѧϰļܵ
	
	CECInventory*	m_pEquipPack;		// װ

	CECSkill*		m_aSkills[MAX_SKILLNUM];	// б
public:		//	Constructor and Destructor
	
	CECHostGoblin();
	virtual ~CECHostGoblin();

public:		//	Operations
	//	Initialize object
	virtual bool Init(int tid, CECIvtrGoblin* pIvtrGoblin, CECPlayer* pPlayer);
	//	Release object
	virtual void Release();

	//	Tick routine
	virtual bool Tick(DWORD dwDeltaTime);
	//	Render routine
	virtual bool Render(CECViewport* pViewport);
	//	Process message
	virtual bool ProcessMessage(const ECMSG& Msg);

	unsigned int GetExp() const				{ return m_iExp; }
	void SetExp(unsigned int iExp)			{ m_iExp = iExp; }

	void SetLevel(int iLevel)				{ m_iLevel = iLevel; }
	int GetLevel() const					{ return m_iLevel; }		

	//  Ե
	int GetStatusPt()						{ return m_iTotalStatusPt; }
	int GetStrength()						{ return m_iStrength; }
	int GetVitality()						{ return m_iVitality; }
	int GetAgility()						{ return m_iAgility; }
	int GetEnergy()							{ return m_iEnergy; }

	int GetStrengthEnhance()				{ return m_iStrEnhance; }
	int GetVitalityEnhance()				{ return m_iVitEnhance; }
	int GetAgilityEnhance()					{ return m_iAgiEnhance; }
	int GetEnergyEnhance()					{ return m_iEngEnhance; }

	//  츳
	int GetGeniusPt()						{ return m_iTotalGeniusPt; }
	//  ľˮԵ㣬bAddEquipΪtrueʾװ
	int GetGenius(int index, bool bAddEquip = true);

	//  С˵
	const wchar_t* GetBasicDescText();
	//  С鰲ȫ״̬ 0: ȫ״̬>0ת״̬תϵʱ㣬-1:ɽ״̬ 
	int GetSecurityState()					{ return m_iSecurityState;}

	//  Ԫ
	int GetAP()								{ return m_iVigor; }
	//  Ԫ
	int GetMaxAP()							{ return m_iMaxVigor; }
	//  Ԫָٶ
	float GetAPGen()						{ return m_fVigorGen; }
	//  
	int GetStamina()						{ return m_iStamina; }
	//  ɳ
	int GetGrowDegree()						{ return m_iGrowDegree; }

	//  ʱٶ
	float GetMPCost();

	//  ǰȡԵ
	int GetRandomStatusPt()					{ return m_iTotalStatusPt - (m_iLevel - 1); }
	//  ǰܻȡԵ
	int GetMaxRandomStatusPt()				{ return m_iMaxRandomPt; }

	//  ȡװ
	CECInventory* GetEquipment()			{ return m_pEquipPack; }

	//  ȡ
	CECSkill* GetSkill(int index)			{ ASSERT(index >=0 && index < GetSkillNum()); return m_aSkills[index]; }
	//	ȡѧϰļ
	int GetSkillNum();
	//  ȡǰܹѧϰļܵ
	int GetCurrMaxSkillNum()				{ return m_iCurrMaxSkillNum; }
	
	//	ȡidָļ
	CECSkill* GetSkillByID(int id);	
	
	//  ǷԽף
	bool CanTrade()							{ return (m_iSecurityState<0) ? true : false; }

	//	жСǷͷָļ
	//  0:ɹ            1:ְҵƥ        2:mp
	//  3:AP		  4:츳㲻		  5:ID
	//  6:δѡĿ      7:С鼼      8:Сȼ
	int CheckSkillCastCondition(CECSkill* pSkill);

	//  װ
	bool DestroyEquip(int iSlot);

	//  Сʵʻȡľֵ iExpΪľֵ
	//  iLevelΪĵȼ > 0 ˵Ӿע룬Ϊ0ΪǾֵ
	unsigned int InjectExp(unsigned int iExp, int iLevel = 0);
	
	//  ʹС龭ֵָĵȼΪiLevelľеľֵ
	unsigned int NeedPillExp(unsigned int goblin_exp, int iLevel);

	//  ʹС龭ֵָǾֵ
	unsigned int NeedPlayerExp(unsigned int goblin_exp);
		
	//  СԵҪĵ
	int NeedStatusPt(int iBase, int iNum);

	//  С鵱ǰδʹõԵ
	int UnusedStatusPt();	
	
	//  С鵱ǰδʹõ츳
	int UnusedGeniusPt();

	//	Сͷż
	//  iIndexΪСѧļ
	bool CastSkill(int iIndex, int idTarget, bool bForceAttack);

	//  Ϣ
	void OnMsgGoblinVigor(const ECMSG& Msg);
	void OnMsgGoblinEnhance(const ECMSG& Msg);
	void OnMsgGoblinStamina(const ECMSG& Msg);
	void OnMsgGoblinExp(const ECMSG& Msg);
};
///////////////////////////////////////////////////////////////////////////
//	
//	Inline functions
//	
///////////////////////////////////////////////////////////////////////////

#endif//_EC_HOSTGOBLIN_H_