// Filename	: EC_GameTalk.cpp
// Creator	: Xu Wenbin
// Date		: 2011/01/28

#include "EC_GameTalk.h"
#include "EC_Global.h"
#include "EC_Game.h"
#include "EC_GameRun.h"
#include "EC_HostPlayer.h"

CECGameTalk CECGameTalk::s_instance;

CECGameTalk & CECGameTalk::Instance()
{
	return s_instance;
}

CECGameTalk::CECGameTalk()
{
}

void CECGameTalk::Set(int id, GNET::PRIVATE_CHANNEL channel)
{
	Record & r = m_records[id];
	r.channel = channel;
}

void CECGameTalk::Del(int id)
{
	m_records.erase(id);
}

void CECGameTalk::Clear()
{
	m_records.clear();
}

bool CECGameTalk::Get(int id, GNET::PRIVATE_CHANNEL &channel)const
{
	bool bRet = false;
	RecordList::const_iterator it = m_records.find(id);
	if (it != m_records.end())
	{
		channel = it->second.channel;
		bRet = true;
	}
	return bRet;
}

GNET::PRIVATE_CHANNEL CECGameTalk::GetChannelToSend(int id, bool bForAutoReply, bool bFriendWhisper)const
{
	//	ݷƵ¼ӦĸƵͣԶظϢ
	//	id:	Է id
	//	bForAutoReply:	Ϊ true ʱѯԶظƵһηϢƵ CHANNEL_FRIEND ʱϷͻԶظƵӦ CHANNEL_FRIEND_RE
	//								 bForAutoReply Ϊ true޷ѯ֮ǰķƵ򱨴ĬƵ
	//	bFriendWhisper:	Ϊ true ʱʾϣԿͻ˵ĺҲϢ CHANNEL_NORMAL ǺϢ CHANNEL_FRIENDȡڷͺϢĽ
	//								Win_ChatWin_WhisperChat ԷϷͻ˺ѼǺƵGTͻϢ
	//								Win_FriendChat ԷϷͻ˺ϢGTͻϢҲǺѷϢGTͻϢ
	//

	GNET::PRIVATE_CHANNEL channel = CHANNEL_NORMAL;		//	ĬϷͻ˷Ϣ

	while (true)
	{
		GNET::PRIVATE_CHANNEL lastChannel = CHANNEL_NORMAL;
		if (Get(id, lastChannel))
		{
			//	ܹѯһƵӦĳͻˣ

			if (bForAutoReply)
			{
				//	ѯԶظ
				//	ԣϸִжӦϵ״̬
				//				 CHANNEL_FRIEND ظ CHANNEL_FRIEND_RE
				//				CHANNEL_NORMAL ظ CHANNEL_NORMALRE
				//				CHANNEL_GAMETALK ظ CHANNEL_GAMETALK
				channel = GetChannelToAutoReply(lastChannel);
				break;
			}
			else
			{
				//	ѯǷԶظ
				//	ԣԺѣϴͻȻߣ˿ͻ죻
				//								ͻߣȼͻˣ
				//								ȫҲظϴοͻˣԷʱյϢ
				//								ϲɷжϣȷ⡣ͻֻݽ漰ϴƵжϣάϷͻ
				//				ԷǺѣ޷ѯ״̬˽ֱӻظϴͻ
				
				//	ĬʹϴƵ
				channel = DirectReplyChannel(lastChannel);

				FRIEND *pFriend = GetFriend(id);
				if (pFriend)
				{
					//	ǺѣӦúѲ

					if ((channel == CHANNEL_NORMAL || channel == CHANNEL_FRIEND))
					{
						//	ϴδ Win_Chat ȷͺδ Win_FriendChat ͼ෴
						channel = bFriendWhisper ? CHANNEL_NORMAL : CHANNEL_FRIEND;
					}
					//	ʹĬϴ
				}
				else
				{
					if (channel == CHANNEL_FRIEND)
					{
						//	ѻظƵ޸
						channel = CHANNEL_NORMAL;
					}
				}
				break;
			}
			//	Ѵܹѯͻ˵
		}

		if (bForAutoReply)
		{
			//	ԶظӦܹ鵽ϴƵϢ
			ASSERT(false);
		}

		//	޷ѯһͻ
		//	ԣɷ״̬ת
		FRIEND *pFriend = GetFriend(id);
		if (pFriend)
		{
			channel = bFriendWhisper ? CHANNEL_GT_NORMAL : CHANNEL_GT_FRIEND;
			break;
		}
		else
		{
			channel = CHANNEL_GT_NORMAL;
		}
		break;
	}
	
	return channel;
}

GNET::PRIVATE_CHANNEL CECGameTalk::GetChannelToSend(const ACString &strName, bool bForAutoReply, bool bFriendWhisper, int &id)const
{
	//	strName:	Է
	//	bForAutoReplybFriendWhisper ͬ
	//	id:	ͨ strName ҵ idCHANNEL_GAMETALK ƵϢҪ֪׼ȷ id˴ id ͨ CECGameRun::GetPlayerID Ҳ

	//	Ȳ id
	id = 0;

	//	ںбвңϷͻ˻ֻߺѣ
	FRIEND *pFriend = GetFriend(strName);
	if (pFriend)
	{
		//	ɹ鵽
		id = pFriend->id;
	}

	//	бδ鵽ģϷͻв
	if (!id)
	{
		CECGameRun *pGameRun = g_pGame->GetGameRun();
		if (pGameRun)
			id = pGameRun->GetPlayerID(strName);
	}

	//	 id Ƿ id һظƵ
	return GetChannelToSend(id, bForAutoReply, bFriendWhisper);
}

CECGameTalk::FRIEND * CECGameTalk::GetFriend(int id)
{
	CECFriendMan::FRIEND *pFriend = NULL;
	
	while (true)
	{
		CECGameRun *pGameRun = g_pGame->GetGameRun();
		if (!pGameRun)
			break;

		CECHostPlayer *pHost = pGameRun->GetHostPlayer();
		if (!pHost)
			break;

		CECFriendMan *pFriendMan = pHost->GetFriendMan();
		if (!pFriendMan)
			break;

		pFriend = pFriendMan->GetFriendByID(id);
		break;
	}

	return pFriend;
}

CECGameTalk::FRIEND * CECGameTalk::GetFriend(const ACString &name)
{
	CECFriendMan::FRIEND *pFriend = NULL;
	
	while (true)
	{
		CECGameRun *pGameRun = g_pGame->GetGameRun();
		if (!pGameRun)
			break;

		CECHostPlayer *pHost = pGameRun->GetHostPlayer();
		if (!pHost)
			break;

		CECFriendMan *pFriendMan = pHost->GetFriendMan();
		if (!pFriendMan)
			break;

		pFriend = pFriendMan->GetFriendByName(name);
		break;
	}

	return pFriend;
}

GNET::PRIVATE_CHANNEL CECGameTalk::GetChannelToAutoReply(GNET::PRIVATE_CHANNEL lastChannel)
{
	//	ϴƵѯӦʹĸƵԶظ
	//
	GNET::PRIVATE_CHANNEL autoReplyChannel = lastChannel;
	while (true)
	{
		if (lastChannel == CHANNEL_NORMAL || lastChannel == CHANNEL_NORMALRE)
		{
			//	עlastChannel Ϊ CHANNEL_NORMALRE ʱӦԶظҲӦвѯ˺Ҫ
			//			߼Ȼص CHANNEL_NORMALRE Ƶ
			if (lastChannel == CHANNEL_NORMALRE)
				ASSERT(false);
			
			autoReplyChannel = CHANNEL_NORMALRE;
			break;
		}
		
		if (lastChannel == CHANNEL_FRIEND || lastChannel == CHANNEL_FRIEND_RE || lastChannel == CHANNEL_USERINFO)
		{
			//	עlastChannel Ϊ CHANNEL_FRIEND_RE ʱӦԶظҲӦвѯ˺Ҫ
			//			߼Ȼص CHANNEL_FRIEND_RE Ƶ
			//	עlastChannel Ϊ CHANNEL_USERINFO ʱҲӦԶظ
			if (lastChannel == CHANNEL_FRIEND_RE || lastChannel == CHANNEL_USERINFO)
				ASSERT(false);
			
			autoReplyChannel = CHANNEL_FRIEND_RE;
			break;
		}
		
		//	עƵʱӦԶظΪԶظӦʹõƵԱԶظѭ
		//			߼ȻԭƵ
		ASSERT(false);
		break;
	}
	return autoReplyChannel;
}

GNET::PRIVATE_CHANNEL CECGameTalk::DirectReplyChannel(GNET::PRIVATE_CHANNEL lastChannel)
{
	//	ϴƵתΪظʱӦʹõƵ
	//
	GNET::PRIVATE_CHANNEL replyChannel = lastChannel;
	while (true)
	{
		if (lastChannel == CHANNEL_NORMAL || lastChannel == CHANNEL_NORMALRE)
		{
			//	ͨƵ̸Ƶ
			replyChannel = CHANNEL_NORMAL;
			break;
		}
		
		if (lastChannel == CHANNEL_FRIEND || lastChannel == CHANNEL_FRIEND_RE || lastChannel == CHANNEL_USERINFO)
		{
			//	CHANNEL_USERINFO ƵϢ£Ӧü¼ϴƵ
			if (lastChannel == CHANNEL_USERINFO)
				ASSERT(false);

			//	ͨƵ̸غƵ
			replyChannel = CHANNEL_FRIEND;
			break;
		}

		//	Ƶ GT ʱʹԭƵظ
		replyChannel = lastChannel;
		break;
	}
	return replyChannel;
}