// Filename	: DlgWorldMap.h
// Creator	: Tom Zhou
// Date		: October 16, 2005

#pragma once

#include "hashmap.h"
#include "DlgBase.h"
#include "AUIImagePicture.h"


// 
#define MAJOR_MAP 1
// ħ
#define GOOD_EVIL_MAP(id)	(id == 121 || id == 122)
// ս
#define GUILD_WAR_MAP(id)	(id >= 230 && id <= 235)
// 
#define PENGLAI_MAP(id)		(id == 137)

#define IS_MAP_MARKABLE(mapID) \
		( MAJOR_MAP == mapID || GOOD_EVIL_MAP(mapID) || \
		GUILD_WAR_MAP(mapID) || PENGLAI_MAP(mapID) )	\
//

class A3DTexture;
struct NPC_TRANSMIT_SERVICE;
struct NPC_ESSENCE;
class CDlgWorldMap : public CDlgDynamicControl  
{
	AUI_DECLARE_EVENT_MAP();
	AUI_DECLARE_COMMAND_MAP()

public:
	CDlgWorldMap();
	virtual ~CDlgWorldMap();
	virtual void OnTick();
	virtual bool Render(void);

	void OnCommand_makemark(const char * szCommand);
	void OnCommand_edit(const char * szCommand);
	void OnCommand_delete(const char * szCommand);
	void OnCommand_deleteall(const char * szCommand);
	void OnCommand_radar(const char * szCommand);
	void OnCommand_arrow(const char * szCommand);
	void OnCommand_inc(const char * szCommand);
	void OnCommand_dec(const char * szCommand);
	void OnCommand_guildmap(const char * szCommand);
	void OnCommand_CANCEL(const char * szCommand);
	void OnCommand_SwitchTaskShow(const char * szCommand);

	void OnEventLButtonUp_Flag(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventLButtonDblClk_Flag(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventMouseMove_World(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventMouseMove_Control(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventLButtonUp_World(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventRButtonUp_World(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventMouseMove_Detail(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventLButtonDown_Detail(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventLButtonDblClk_Detail(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventLButtonUp_Detail(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventRButtonUp_Detail(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventMouseMove_Travel(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventLButtonUp_Travel(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventRButtonUp_Travel(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventLButtonUp_Sign(WPARAM wParam, LPARAM lParam, AUIObject *pObj);

	void BuildTravelMap(DWORD dataType, void* pData, int mapID = 0);
	int GetTravelWorldID();
	void AddAutoMoveButton(const ACString& hint, const char* image, const A3DVECTOR3& pos, DWORD data = 0);
	enum {
		TASK_TYPE_ONE = -1,
		TASK_TYPE_NONE,
		TASK_TYPE_FINISHED,
		TASK_TYPE_UNFINISHED,
		TASK_TYPE_ALL,
		TASK_TYPE_TODO,
		TASK_TYPE_NUM,
	};
	void SetTaskShowType(int type) { m_iTaskShowType = type; }

protected:
	PAUIIMAGEPICTURE m_pImgHint;
	int				 m_iTaskShowType;
	const NPC_ESSENCE *m_pCurNPCEssence;		//	ͷʱʱĴ NPC
	const NPC_ESSENCE *GetCurNPCEssence(){ return m_pCurNPCEssence; }

	void BringUpTools();
	bool UpdateWorldMap();
	bool UpdateWorldMapDetail();
	bool UpdateWorldMapTravel();
	bool UpdateRandomMap(int iInst);

	virtual bool OnInitDialog();
	virtual void OnShowDialog();
	virtual void OnHideDialog();

	void OnFlagSelected();
	void UpdateDetailMapControlPos();
	void UpdateTaskControl();

	void RenderFactionPVPIcon(const void *posConverter
		, A2DSprite *pA2DSpriteMineBase, A2DSprite *pA2DSpriteMineBaseForMyFaction
		, A2DSprite *pA2DSpriteMine, A2DSprite *pA2DSpriteMineForMyFaction);

	int tempMapId;
};

class CECNPCTransmitCache;
class CECMapDlgsMgr
{
public:
	CECMapDlgsMgr();
	~CECMapDlgsMgr();

	bool Init();

	// resize a dialog
	void ResizeFullScreenDialog(PAUIDIALOG pDlg, int iWidth, int iHeight);
	// resize all the map dialogs
	void ResizeWorldMap(A3DRECT *prc = NULL);

	// refresh flags on all map dialogs
	void RefreshWorldMapFlags(bool bCloseAll);

	// init detail map by specific position
	bool InitDetailMap(float fX, float fZ);
	// refresh texture in detail map 
	void RefreshDetailMap();
	// clear texture on detail map
	void ClearDetailMap();

	// convert position between screen and game world
	A3DPOINT2 GetPixelsByPos(float x, float y, int worldid);
	APointF GetPosByPixels(int x, int y, int worldid);
	struct PosConvertParam
	{
		int a;      // Ļϵĵͼa飬b
		int b;
		float ox;   // ͼĵӦΪ(ox,oy)
		float oy;
		int w;      // ͼʵռ÷ֱ w*h
		int h;
	};
	void GetPosConvertParam(int worldid, PosConvertParam& param);
	bool IsMapCanShowHostPos(int worldid);
	struct PosConvertor
	{
		// convert map logic position to screen pixel
		virtual A3DPOINT2 operator()(const A3DVECTOR3& vecPos) const = 0;
		// convert screen pixel to map logic position
		virtual A3DVECTOR3 operator()(const A3DPOINT2& ret) const = 0;
	};
	// draw team member mark 
	void DrawTeamMark(const PosConvertor&);

	// draw players way-points and travel lines
	void DrawWayPoints(const NPC_ESSENCE *pNPC, const A3DPOINT2& ptCenter, int iWorldID, bool bDrawLines);

	// draw host player mark
	void DrawHostMark(const PosConvertor& conv);

	// draw the auto move flag
	void DrawAutoMoveFlag(const PosConvertor& conv);

	// update player way-points
	void UpdateWayPoints(WORD* pData, int iSize, bool bClear);

	// find world within NPC_TRANSMIT_SERVICE
	int FindTransmitWorldID(NPC_TRANSMIT_SERVICE* pData);
	int FindTransmitWorldID(int idTarget);

	// get current mode
	bool GetWorldMapMode() const { return m_WideMode; }

	// load world map (may change the WorldMapMode)
	enum MAP_TYPE { MAP_TYPE_NORMAL, MAP_TYPE_TRANSMIT, MAP_TYPE_SCROLL, };
	bool LoadMapTexture(A3DDevice* pDevice, PAUIIMAGEPICTURE pImage, MAP_TYPE type);
	bool LoadMapTexture2(A3DDevice* pDevice, PAUIIMAGEPICTURE pImage, int instanceID);
	AString GetMapTexture(MAP_TYPE type);
	AString GetMapTexture2(int idInstance);

	bool IsWorldMapShown();
	void ShowWorldMap(bool bShow);
	void SwitchWorldMapShow();

	// get proper pos convertor for current map
	PosConvertor* GetCurConvertor();


public:
	struct TRANS_POINT
	{
		int id;
		int worldid;
		ACString strName;
		A3DVECTOR3 vecPos;
	};
	typedef APtrList<TRANS_POINT*>	TransWayPoints;

	class TransWay
	{
	public:
		enum TransMode
		{
			TM_INVALID = 0,
			TM_TRANSMITSCROLL = 1,				//	ͨ;ᴫ
			TM_NPC_TRANSMIT_NORMAL = 2,	//	ͨ NPC ͷǰ NPC ӵ㴫
			TM_NPC_TRANSMIT_DIRECT = 3,	//	ͨ NPC ͷǰ NPC ɴֱӴ
		};
		TransMode			mode;			//	ʹЭʱӦʹõĴģʽTM_NPC_TRANSMIT_NORMAL =2  wayPoints 1ͬʱ
		int							nCost;			//	Ҫ
		int							nLevel;			//	ĵȼ
		TransWayPoints	wayPoints;	//	·ߣ㡢յ㣩ģʽ¾ʾTM_NPC_TRANSMIT_DIRECT ģʽ²ſЭ飩

		TransWay(){ Reset(); }

		void Reset()
		{
			mode = TM_INVALID;
			nCost = 0;
			nLevel = 0;
			wayPoints.RemoveAll();
		}

		bool IsValid()const{ return mode != TM_INVALID; }

		static bool HasDirectTransmitItem();
	};

	typedef abase::vector<TRANS_POINT> Points;
	typedef abase::hash_map<int, TRANS_POINT> PointMap;

	enum
	{
		WAYPOINT_ME = 0,
		WAYPOINT_TARGET
	};

	enum
	{
		MINIMAP_UL = 0,
		MINIMAP_UR,
		MINIMAP_LL,
		MINIMAP_LR,
		MINIMAP_MAX
	};

protected:
	A3DPOINT2 m_idxCorner[MINIMAP_MAX];

	int m_nCurFlagIndex;
	bool m_bMarking;
	bool m_bMapDragging;
	A2DSprite *m_pA2DSpriteWaypoint;
	A2DSprite *m_pA2DSpriteProfession;
	Points m_vecTeamMate;
	PointMap m_transPoints;
	abase::hash_map<AString, A3DTexture *> m_MapMap;
	typedef abase::hash_map<int, PosConvertParam*> MAP_PARAM;
	MAP_PARAM m_MapParam;

	int m_nMinSize;
	bool m_WideMode;

	CECNPCTransmitCache* m_pTransCache;

	TransWay			m_transWay;		//	ǰڴ͵Ĵ·
	struct DefaultData
	{
		POINT p;
		SIZE s;
		int FontSize;

		DefaultData(POINT pp, SIZE ss, int fontsize):p(pp), s(ss), FontSize(fontsize){}
	};
	typedef abase::hash_map<PAUIDIALOG, abase::vector<DefaultData> > DlgDefault;
	DlgDefault m_DefaultPosAndSize;
	const abase::vector<DefaultData>& GetDlgDefaultData(PAUIDIALOG pDlg);
	void ResizeDlgKeepingMapRadio(PAUIDIALOG pDlg, PAUIOBJECT pMap, int iDlgWid, int iDlgHt, int iTargetW, int iTargetH, int iOffsetX, int iOffsetY);

	void RefreshDetailMapTexture();

	// set current mode
	void SetWorldMapMode(bool isWide);

	bool UpdateTransWayWithinNPC(const NPC_ESSENCE *pNPC, int idTarget);

public: // handle properties

	int GetCurMark();
	PAUIIMAGEPICTURE GetCurFlagImage();
	void SetCurFlagIndex(int val);
	
	bool IsMarking() const { return m_bMarking; }
	void SetMarking(bool val) { m_bMarking = val; }
	
	bool IsDraging() const { return m_bMapDragging; }
	void SetDraging(bool val) { m_bMapDragging = val; }

	const Points& GetTeamMate() const { return m_vecTeamMate; }
	const PointMap& GetTransPoint() const { return m_transPoints; }
	const A3DPOINT2& GetCorner(int index) { return m_idxCorner[index]; }
	const CECNPCTransmitCache& GetCache() const { return *m_pTransCache; }

	//	transmit way
	bool UpdateTransWay(const NPC_ESSENCE *pNPC, int idTarget);
	void ResetTransWay(){m_transWay.Reset();}
	const TransWay & GetTransWay(){return m_transWay;}
	
	// draw the inner way points
	void DrawTransWay(const A3DPOINT2& ptCenter);

	// adjust the size of a map texture
	void AdjustMapTexture(PAUIIMAGEPICTURE pImage, int defaultWidth, const SIZE& bgSize, const POINT& offset);
};
