// Filename	: DlgWedding.h
// Creator	: Xu Wenbin
// Date		: 2010/07/06

#pragma once

#include "DlgBase.h"
#include "AUILabel.h"
#include "AUIListBox.h"
#include "AUIImagePicture.h"
#include "AUIStillImageButton.h"

class CECIvtrItem;
class CECPlayer;

class CDlgWedding : public CDlgBase  
{
	AUI_DECLARE_EVENT_MAP();
	AUI_DECLARE_COMMAND_MAP()
	
public:
	CDlgWedding();
	
	void OnCommand_PrevMonth(const char *szCommand);
	void OnCommand_NextMonth(const char *szCommand);
	void OnCommand_Rdo(const char *szCommand);
	void OnCommand_Book(const char *szCommand);
	void OnCommand_CancelBook(const char *szCommand);
	void OnCommand_Cancel(const char *szCommand);
	
	void OnEventLButtonDown_Img(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventRButtonUP_Img(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventLButtonDown_Txt(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	void OnEventLButtonDown_List1(WPARAM wParam, LPARAM lParam, AUIObject *pObj);

	void SetItem(int iSlot = -1);

	void OnWeddingBookList(void *pData);
	void OnWeddingBookSuccess(void *pData);

	void CancelBook(bool bConfirm);
	
	enum {GENERAL_BOOKCARD_ID = 28452};	//	ͨƾ֤

	virtual void OnItemDragDrop(CECIvtrItem* pIvtrSrc, int iSrc, PAUIOBJECT pObjSrc, PAUIOBJECT pObjOver);
		
protected:
	virtual bool OnInitDialog();
	virtual void OnShowDialog();
	virtual void OnTick();
	virtual bool Release();


	PAUIIMAGEPICTURE m_pImg_Week[6][7];
	PAUILABEL m_pLab_Week[6][7];
	PAUILISTBOX m_pTxt_List1;	//	ڡʱԤб
	PAUILABEL m_pTxt_Title;		//	ǰ
	PAUIIMAGEPICTURE m_pImg_Special;	//	ƾ֤Ʒ

	PAUISTILLIMAGEBUTTON m_pBtn_PrevMonth;
	PAUISTILLIMAGEBUTTON m_pBtn_NextMonth;
	PAUISTILLIMAGEBUTTON m_pBtn_Book;
	PAUISTILLIMAGEBUTTON m_pBtn_CancelBook;

private:

	//	ԤԼб仯
	void OnBookListChange();

	//	ѡȡ·ݷ仯ʼΪѡ񣬻ʵڱ仯ǰѡ񲻺Ϸ
	void OnMonthSelectChange();

	//	ѡӷ仯ʼΪѡ񣬻ʵڱ仯ǰѡ񲻺Ϸ
	void OnDaySelectChange();

	//	ĳѡ仯ʼΪѡ
	void OnWeddingSceneSelectChange();

	//	񳡴ѡ仯ʼΪѡ
	void OnWeddingSessionSelectChange();

	//	µǰѡµֵȣ
	void UpdateCalendar();

	//	µǰеͼƬ״̬ѡСԤ
	void UpdateCalendarColor();

	//	յǰʱ䣬㵱ǰѡ·һѡе
	int	 GetFirstSelectDay();

	//	ҵǰɹѡĵһ
	int  GetFirstScene();

	//	ݵǰжǷ·ʾ
	bool CanShowMonth(int year, int month);

	//	ݵǰжϸʾ
	bool CanShowDay(int year, int month, int day);

	//	жϵǰǷпʾԤб
	bool HaveSessionDay(int year, int month, int day);

	//	жϸǷ
	bool IsSpecialDay(int year, int month, int day);

	//	жǷиڵƷϽΪ׼
	bool HaveSpecialDayItem(int year, int month, int day);

	//	ҵǰƷӦ
	bool GetCurSpecialDay(int &year, int &month, int &day);

	//	ҵǰѡеĳΣԤ򷵻-1
	int	GetSelectedSession();

	//	жָǷԤ
	bool CanBookSession(int nSession);

	//	жָǷȡԤ
	bool CanCancelBookSession(int nSession);

	//	жԤԼƾ֤ǷϷ
	bool IsImageItemValid(int iSlot);

	//	ѯԤб
	void GetWeddingBookListFromServer();

	//	ɵǰڡԤб
	void RebuildSessionList();
	
	//	Ԥбʾ
	void UpdateSessionListHint(int nItem);

	//	ҵƸ½
	void UpdatePlayerNames();

	//	ֻСʱӵĳַ
	ACString GetSessionTimeString(int t);
	
	//	գԱ´ʾʱ¿ʼ
	void Reset();

	//	
	bool CheckTeamCondition(bool bBook);
	CECPlayer * GetTeamOtherPlayer();

	//	ť״̬
	bool CanGoPrevMonth();
	bool CanGoNextMonth();
	bool CanBook();
	bool CanCancelBook();

	//	
	bool IsContinuousMonth(int year1, int month1, int year2, int month2);
	void GetPrevMonth(int year, int month, int &prevMonthYear, int &prevMonth);
	void GetNextMonth(int year, int month, int &nextMonthYear, int &nextMonth);

	//	ʱѯͼ
	void GetCurServerTime(int &year, int &month, int &day, char &hour, char &minute, char &second);
	tm	 GetServerLocalTime(int t);
	void GetServerLocalTime(int t, int &year, int &month, int &day);
	void GetYearMonthDay(const tm &t1, int &year, int &month, int &day);

	//	Ա
	int m_curYear;	//	ǰ
	int m_curMonth;	//	ǰ·
	int m_curDay;	//	ǰ

	int m_selYear;	//	ѡеݣĬΪǰݣûѡǰʱ䣩
	int m_selMonth;	//	ѡе·ݣͬϣ
	int m_selDay;	//	ѡеӣͬϣ

	int m_selScene;	//	ѡеĻ񳡾
	int m_iSlot;	//	ԤԼƾ֤±

	struct wedding_book 
	{
		int start_time;
		int end_time;
		int groom;
		int bride;
		int scene;
		char status;
		char special;
	};
	typedef abase::vector<wedding_book> wedding_book_list;
	wedding_book_list m_bookList;

	//	жϰǷضڵƾ֤
	bool HaveInviteCard(const wedding_book &session);

	A2DSprite * m_pSprite_Icon1;
	A2DSprite * m_pSprite_Icon2;
	bool		m_bSpriteInited;
	void SetIcon(PAUIIMAGEPICTURE pImage, bool bWithSessionList);
	A2DSprite * LoadSprite(AString strFile);
};