// Filename	: DlgSkillAction.h
// Creator	: zhangyitian
// Date		: 2014/6/24

#ifndef _ELEMENTCLIENT_DIALOGSKILLACTION_H_
#define _ELEMENTCLIENT_DIALOGSKILLACTION_H_

#include "DlgBase.h"

class CDlgSkillSubList;
class CDlgSkillSubTree;
class AUIRadioButton;
class AUISubDialog;
class AUILabel;
class AUICheckBox;

class CDlgSkillAction : public CDlgBase {

	AUI_DECLARE_COMMAND_MAP();

public:
	CDlgSkillAction();
	
	void OnCommand_Evil(const char* szCommand);		// ħ
	void OnCommand_God(const char* szCommand);		// ɡ
	void OnCommand_Skill(const char* szCommand);		// ܡ
	void OnCommand_Action(const char* szCommand);		// 
	void OnCommand_Pool(const char* szCommand);			// ѧܡ
	void OnCommand_CANCEL(const char* szCommand);
	void OnCommand_ShowSkillCanLearn(const char* szCommand);

	void ShowSkillTree(int skillID);					// Ҳʾ
	void HideSkillTree();								// Ҳļ

	void TryOpenDialog(bool bAction);		// ͨ˵ݼ򿪼ܶԻĲΪǷ򿪶
	void ForceShowDialog();					// 򿪶Ի򣬺жϴ򿪼ܻúⲿ

	bool IsEvil();
	int GetSelectedSkillID();
	void SetSelectedSkillID(int skillID);

	bool IsReceivedNPCGreeting();
	void SetReceivedNPCGreeting(bool bReceived);

	bool IsOnlyShowSkillCanLearn();			// Ƿʾѧļ

protected:
	virtual bool OnInitDialog();
	virtual void OnShowDialog();
	virtual void OnHideDialog();
	virtual bool OnChangeLayoutBegin();
	virtual void OnChangeLayoutEnd(bool bAllDone);
	virtual void OnTick();

private:
	AUIRadioButton* m_radioBtnSkill;		// ܡť
	AUIRadioButton* m_radioBtnAction;		// ť
	AUIRadioButton* m_radioBtnPool;			// ѧܡť
	AUIRadioButton* m_radioBtnEvil;			// ħť
	AUIRadioButton* m_radioBtnGod;			// ɡť
	AUICheckBox*	m_pChkOnlyShowLearn;	//  
	AUILabel*		m_pLblOnlyShowLearn;	//

	// ӶԻؼָ
	AUISubDialog* m_subDlgSkill;
	AUISubDialog* m_subDlgAction;
	AUISubDialog* m_subDlgPool;
	AUISubDialog* m_subDlgTreeEvil;
	AUISubDialog* m_subDlgTreeGod;
	AUISubDialog* m_subDlgTreeBase;
	AUISubDialog* m_subDlgOtherSkill;
	AUILabel* m_labelSp;

	bool m_bFirstShow;

	// Ƿ򿪶
	bool m_bOpenAction;

	int m_selectedSkill;	// ѡеļ
	bool m_bEvil;			// Ƿħ״̬falseΪ

	bool m_bReceivedNCPGreeting;	// ǷյNPCGreeting
};

#endif