// Filename	: DlgTitleChallenge.h
// Creator	: Han Guanghui
// Date		: 2013/6/13

#ifndef _DLGSIGN_IN_H_ 
#define _DLGSIGN_IN_H_

#include "DlgBase.h"

const int AWARD_LIST_SIZE = 7;
const int MONTH_COUNT_IN_YEAR = 12;
const int MAX_LATE_SIGN_IN_COUNT = 4;

struct SIGN_AWARD_CONFIG;
class AUIStillImageButton;
class AUIImagePicture;

class CDlgSignIn : public CDlgBase
{
	AUI_DECLARE_COMMAND_MAP()
	AUI_DECLARE_EVENT_MAP()

public:

	CDlgSignIn();
	virtual ~CDlgSignIn();

	void				OnCommandSignIn(const char* szCommand);
	void				OnCommandGetYearReward(const char* szCommand);
	void				OnCommandGetDailyReward(const char* szCommand);

	void				OnCommandMoveLeft(const char* szCommand);
	void				OnCommandMoveRight(const char* szCommand);

	void				OnEventMouseDownDateImg(WPARAM wParam, LPARAM lParam, AUIObject *pObj);
	
	void				Update(int iServerTime);


private:

	int		GetCurMonth();			// ȡǰ
	int		GetCurDay();			// ȡǰ
	int		GetSignedInCount();		// ȡǩ
	int		GetRecvAwardCount();	// ȡ콱
	int		GetCanLateSignInCount();// ȡ¿ɲǩ
	int		GetDaysInMonth();		// ȡһµ
	bool	HasSignedInToday();		// Ƿǩ

	void	ShowMonth(int iMonth);									// ʾǰ·
	void	ShowSignedInDaysCount(int iSignedInDaysCount);			// ʾǰǩ
	void	ShowCanLateSignDaysCount(int iCanLateSignDaysCount);	// ʾǰɲǩ
	void	ShowAwardListDayRange();	// ʾ콱бķΧ
	void	ResetAwardListDayRange();	// 콱бΧ콱IDб
	void	SetListMoveBtnEnable();		// бƶťǷ
	void	ShowAwardListItemsView();	// ʾǰĽƷ
	bool	IsSignInEnoughThisMonth();	// Ƿǩδǩ3
	bool	IsSignInCompeleteThisMonth();// Ƿȫڣδǩ0

	void	SetAwardBtn(int awardDay, AUIStillImageButton* pBtn, int signedInDays, int recvAwardDays, int curDay);
	void	SetAwardImg(AUIImagePicture* pImg, int itemID, int itemCount);

	void	GetAwardItemInfo(int month, int day, int &itemID, int &itemCount);

protected:

	virtual void		OnShowDialog();
	virtual bool		OnInitDialog();
	bool				SumUpMonthState(int year_state, int state);
	
	enum{
		IMG_MONTH_FRAME_ABSENT_MORE_THAN_3,
		IMG_MONTH_FRAME_ABSENT_LESS_OR_EQUAL_THAN_3,
		IMG_MONTH_FRAME_COMPLETE,
	};
	enum{
		IMG_DATE_FRAME_TODAY,
		IMG_DATE_FRAME_SIGNED_IN,
		IMG_DATE_FRAME_ABSENT,
		IMG_DATE_FRAME_FUTURE,
	};
	int					m_iCurrentSelection;
	int					m_iServerUpdateTime;
	int					m_iAwardListFirstDay;
	int					m_iAwardListLastDay;
	int					m_iEmptySlotsCount;
	SIGN_AWARD_CONFIG*	m_signAwardConfigs[MONTH_COUNT_IN_YEAR];
};

#endif // _DLGSIGN_IN_H_

