/*
 * FILE: ELOutlineTexture.h
 *
 * DESCRIPTION: 
 *
 * CREATED BY: Wangkuiwu, 2005/6/28
 *
 * HISTORY: 
 *
 * Copyright (c) 2005 Archosaur Studio, All Rights Reserved.
 */
#ifndef  _EL_OUTLINETEXTURE_H_
#define  _EL_OUTLINETEXTURE_H_

#include <A3DTypes.h>
#include <A3DVertex.h>
#include <ARect.h>
#include <AString.h>

class A3DDevice;
class A3DTexture;
class A3DStream;
class A3DViewport;

class CELTerrainOutline2;
class CELOutlineQuadTree;

#define OUTLINE_TEX_CACHE_SIZE   24

#define OUTLINE_DIFFUSE    0xffffffff
#define OUTLINE_SPECULAR   0xff000000
//////////////////////////////////////////////////////////////////////////
//debug
//#define OUTLINE_DIFFUSE_VIEW   0xffff0000
#define OUTLINE_DIFFUSE_VIEW   OUTLINE_DIFFUSE
//////////////////////////////////////////////////////////////////////////


#define OUTLINE_TILE_WIDTH       1024
#define OUTLINE_TILE_HEIGHT       1024
#define OUTLINE_TILE_GRID_LEN     2

#define   OUTLINE_TILE_MAGIC    (DWORD)(('o'<<24)| ('l'<<16)|('k'<<8)|('w'))
#define   OUTLINE_TILE_VERSION  (DWORD)(0x00000002)


class TerrainBlockInfo{
		private:
			int r,c;
			bool bLoad;
			int  iLod;
		public:
			TerrainBlockInfo(){
				r = c = iLod = -1;
				bLoad = false;
			}
			TerrainBlockInfo& operator= (const TerrainBlockInfo& rhs){
				if (this == &rhs) {
					return *this;
				}	
				r = rhs.r;
				c = rhs.c;
				bLoad = rhs.bLoad;
				iLod = rhs.iLod;
				return (*this);
			}
			bool operator== (const TerrainBlockInfo& rhs) const{
				return Equal(rhs.r, rhs.c, rhs.bLoad, rhs.iLod);
			}
			bool operator != (const TerrainBlockInfo& rhs) const{
				return ( r != rhs.r || c != rhs.c 
					  || bLoad != rhs.bLoad || iLod != rhs.iLod);
			}
			bool Equal(int _r, int _c, bool _bLoad) const {
				return (r == _r && c == _c && bLoad == _bLoad);
			}
			bool Equal(int _r, int _c, bool _bLoad, int _iLod) const {
				return (r == _r && c == _c && bLoad == _bLoad && iLod == _iLod);
			}
			void Set(int _r, int _c, bool _bLoad, int _iLod){
				r = _r;
				c= _c;
				bLoad = _bLoad;
				iLod  = _iLod;
			}
};

enum
{
	EL_OTL_SMOOTH_NONE = 0,
	EL_OTL_SMOOTH_DAY_LEFT = 1,
    EL_OTL_SMOOTH_DAY_TOP = (1<<1),
	EL_OTL_SMOOTH_NIGHT_LEFT = (1<<2),
	EL_OTL_SMOOTH_NIGHT_TOP = (1<<3)
};

class CELOutlineTexture  
{
	friend class CELOutlineTextureCache;
	friend class CELOutlineQuadTree;
private:
	A3DDevice *		m_pA3DDevice;
	A3DTexture *	m_pDayTexture;	         //the day texture
	A3DTexture *    m_pNightTexture;         // the night texture
	
	ARectF          m_RectWorld;		 //the area occupied in the world space

	CELTerrainOutline2 * m_pOutline;

	
	AString         m_szName;            //texture file name
	int             m_iLevel;            //mipmap level
	int             m_iSubIndex;         //sub index in the level


	float           m_vTexScale;         //texture scale, texel per square meter
	
	DWORD           m_dwFrameStamp;      //frame stamp 
	
	//A3DAABB         m_BoundBox;
	A3DVECTOR3       m_vBBMins;  
	A3DVECTOR3       m_vBBMaxs;


	int                  m_iTiles[4][4]; //max level is 2

	bool               m_bLoadOk;

	DWORD				m_dwSmoothFlag;
public:
	CELOutlineTexture();
	virtual ~CELOutlineTexture();

	bool Init(CELTerrainOutline2 * pOutline, int iLevel, int iSubIndex);
	void Release(); 
	
	void  Render(DWORD dwFrame, A3DCameraBase * pCamera);
	
	void SetFrame(DWORD dwFrame){ 
		m_dwFrameStamp = dwFrame;
	};

	void Stitch(DWORD dwFrame, A3DTerrain2::ACTBLOCKS * pActBlocks, const ARectF& rcSeam);
	void CreateView(const ARectI& rcSeam, const A3DVECTOR3& origin, float radius,  DWORD dwFrame);

	
	void RenderReplaceTerrain(const A3DVECTOR3 * pVerts, int nVerts, const WORD * pIndices, int nIndices);


private:

	bool _LoadTex(CELTerrainOutline2 * pOutline);

};


class CELOutlineTextureCache
{
public:
	CELOutlineTextureCache();
	virtual ~CELOutlineTextureCache();
	bool Init(CELTerrainOutline2 * pOutline);
	void Release();
	void  ActivateTile(const A3DVECTOR3& origin, float radius, DWORD dwFrame);
	

	CELOutlineTexture * FindTex(int iLevel, int iSubIndex);
	CELOutlineTexture * AddTex(int iLevel, int iSubIndex);
	void ReplaceTex(CELOutlineTexture * pTex);

	void Stitch(DWORD dwFrame, A3DTerrain2::ACTBLOCKS * pActBlocks);

	void CreateView(DWORD dwFrame, const A3DVECTOR3& origin, float radius);

	void Render(DWORD dwFrame, A3DCameraBase * pCamera);
	/*
	 *	get the iLevel-1 children
	 *  @return the  count of children
	 *  @note: assume the iLevel tex is generated by 2*2 iLevel-1 tex 
	 *		   iChild[i] = -1, means the child is invalid 
	 */
	static	int  GetChildTex(int iLevel, int iSubIndex, int iChild[]);
	static  int  GetParentTex(int iLevel, int iSubIndex);

	bool IsActive(DWORD dwFrame, int iLevel, int iSubIndex);

	int GetActiveTexCount(DWORD dwFrame, int iLevel);
	int GetCacheSize(){
		return m_nSize;
	}
	static bool RcOverlapCircle(const ARectF& rc, float radius, float cx, float cz);
	static bool RcOverlapRc(const ARectF& rc1, const ARectF& rc2);
	static bool RcOverlapRc(const ARectI& rc1, const ARectI& rc2);

	void PrePareFakeTerrain(DWORD dwFrame, int iLevel, int nVerts, int nFaces);
	void FlushFakeTerrain(DWORD dwFrame, int iLevel);
	void AddFakeTerrainBlock(DWORD dwFrame, int iLevel, const A3DVECTOR3& center, const A3DVECTOR3 * pAround, int nAround);

	void AddReplaceTerrain(DWORD dwFrame, int iLevel, const A3DVECTOR3 * pVerts, int nVerts, const WORD * pIndices, int nIndices);
	void RenderReplaceTerrain(DWORD dwFrame, int iLevel, const A3DVECTOR3 * pVerts, int nVerts, const WORD * pIndices, int nIndices);
	

	inline int GetTexSubIndex(int iLevel, float x, float z);

	CELOutlineQuadTree * GetTile(CELOutlineTexture * pTex, int iSubIndex);
	bool                 ReleaseTile(CELOutlineTexture * pTex, int iSubIndex);
	bool                 ActivateTile(CELOutlineTexture * pTex, int iSubIndex);

	void     SmoothTex(CELOutlineTexture * pTex);
	CELOutlineTexture  * GetNeighborTex(CELOutlineTexture * pTex, DWORD dwDir);
private:
	CELOutlineTexture * m_pCache[OUTLINE_TEX_CACHE_SIZE];
	int        m_nSize;    //real size of the cache

	CELTerrainOutline2 * m_pOutline;
	
	CELOutlineQuadTree * m_pTiles[88];


	void _CreateView(DWORD dwFrame, const  ARectI& rcView, const ARectF& rcViewWorld, const A3DVECTOR3& vOrigin, float fViewDist);

	bool _CompactCache(DWORD dwFrame);

	int  _GetMinFrameTex(DWORD dwFrame = 0xffffffff); // the oldest texture
	void _RemoveTex(int index); 
	
	
	bool _SmoothTex(CELOutlineTexture * pTex1, DWORD dwDir, CELOutlineTexture * pTex2);
	bool _SmoothTex(A3DDevice * pDevice, A3DTexture * pTex1, DWORD dwDir, A3DTexture * pTex2);
	
};

extern int OUTLINE_TEX_LEVEL[];

#endif 
