/*
 * FILE: EC_WorldFile.h
 *
 * DESCRIPTION: 
 *
 * CREATED BY: Duyuxin, 2004/10/14
 *
 * HISTORY: 
 *
 * Copyright (c) 2004 Archosaur Studio, All Rights Reserved.
 */

#pragma once

#include "ABaseDef.h"

/*	Element world file format:

	Version 1:
	
		ECWDFILEHEADER					| file header
		--------------------------------|
		iNumBlock * DWORD				| each block data's offset in file
		--------------------------------|
		TRN2FILEBLOCK #0				| Data of each block.
		block #0 data					| Note: Don't assume block data is ordered
		...								|   by their indices.
		TRN2FILEBLOCK #n				|
		block #n data					|
		--------------------------------|
		Tree type data					|
		--------------------------------|
		Grass type data					|
		--------------------------------|
*/

///////////////////////////////////////////////////////////////////////////
//	
//	Define and Macro
//	
///////////////////////////////////////////////////////////////////////////

//	Identity and version of element client world file
#define	ECWDFILE_IDENTIFY	(('E'<<24) | ('C'<<16) | ('W'<<8) | 'D')
#define ECWDFILE_VERSION	12

//	Identity and version of element client world block shared data file
#define	ECBSDFILE_IDENTIFY	(('B'<<24) | ('S'<<16) | ('D'<<8) | 'F')
#define ECBSDFILE_VERSION	12

//	Version of element client world mass data file
#define ECWDDTFILE_VERSION	2

//	World file flags
enum
{
	ECWFFLAG_EDITOREXP = 0,		//	File was generated by ElementEditor
	ECWFFLAG_HOMEEXP,			//	File was generated by in-game Home editor
};

///////////////////////////////////////////////////////////////////////////
//	
//	Types and Global variables
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Declare of Global functions
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	World file structures
//	
///////////////////////////////////////////////////////////////////////////

//	File header
struct ECWDFILEHEADER
{
	DWORD	dwIdentify;		//	Identity, must be ECWDFILE_IDENTIFY
	DWORD	dwVersion;		//	Version, must be ECWDFILE_VERSION
	float	fWorldWid;		//	World width in meters
	float	fWorldLen;		//	World length in meters
	float	fBlockSize;		//	Block size in meters
	int		iBlockGrid;		//	Block grid row and column number, each block has (grid x grid) terrain grids
	int		iNumBlock;		//	Number of block
	int		iWorldBlkRow;	//	Block row number in whole world
	int		iWorldBlkCol;	//	Block column number in whole world
	DWORD	dwTreeOff;		//	Tree type data offset
	DWORD	dwGrassOff;		//	Grass type data offset
	int		iNumTreeType;	//	Number of tree type
	int		iNumGrassType;	//	Number of grass type
	DWORD	dwFlags;		//	World file flags
	BYTE	aReserved[60];	//	Reserved
};

//	Block information when ECWDFILE_VERSION <= 3
struct ECWDFILEBLOCK
{
	WORD	iRowInWorld;	//	Row of this block in whole world
	WORD	iColInWorld;	//	Column of this block in whole world
	int		iNumTree;		//	Number of tree
	int		iNumWater;		//	Number of water
	int		iNumGrass;		//	Number of grass type
	int		iNumOrnament;	//	Number of ornament objects
	int		iNumBoxArea;	//	Number of box area
};

//	Block information when 4 <= ECWDFILE_VERSION < 7
struct ECWDFILEBLOCK4
{
	WORD	iRowInWorld;	//	Row of this block in whole world
	WORD	iColInWorld;	//	Column of this block in whole world
	int		iNumTree;		//	Number of tree
	int		iNumWater;		//	Number of water
	int		iNumGrass;		//	Number of grass type
	int		iNumOrnament;	//	Number of ornament objects
	int		iNumBoxArea;	//	Number of box area
	int		iNumEffect;		//	Number of GFX effect
	int		iNumECModel;	//	Number of EC model
	int		iNumCritter;	//	Number of Critter group
};

//	Block information when 7 <= ECWDFILE_VERSION < 9
struct ECWDFILEBLOCK7
{
	WORD	iRowInWorld;	//	Row of this block in whole world
	WORD	iColInWorld;	//	Column of this block in whole world
	int		iNumTree;		//	Number of tree
	int		iNumWater;		//	Number of water
	int		iNumGrass;		//	Number of grass type
	int		iNumOrnament;	//	Number of ornament objects
	int		iNumBoxArea;	//	Number of box area
	int		iNumEffect;		//	Number of GFX effect
	int		iNumECModel;	//	Number of EC model
	int		iNumCritter;	//	Number of Critter group
	int		iNumBezier;		//	Number of bezier route
};

//	Block information when ECWDFILE_VERSION >= 9
struct ECWDFILEBLOCK9
{
	WORD	iRowInWorld;	//	Row of this block in whole world
	WORD	iColInWorld;	//	Column of this block in whole world
	int		iNumTree;		//	Number of tree
	int		iNumWater;		//	Number of water
	int		iNumGrass;		//	Number of grass type
	int		iNumOrnament;	//	Number of ornament objects
	int		iNumBoxArea;	//	Number of box area
	int		iNumEffect;		//	Number of GFX effect
	int		iNumECModel;	//	Number of EC model
	int		iNumCritter;	//	Number of Critter group
	int		iNumBezier;		//	Number of bezier route
	int		iNumSound;		//	Number of sound object
};

//	Tree information when ECWDFILE_VERSION < 5
struct ECWDFILETREE
{
	DWORD	dwType;			//	Tree type ID
	float	vPos[2];		//	Tree position on x and z axis
};

//	Tree information when ECWDFILE_VERSION >= 5
struct ECWDFILETREE5
{
	DWORD	dwType;			//	Tree type ID
	float	vPos[3];		//	Tree position on x and z axis
};

//	Reference to data in BSD file
struct ECWDFILEDATAREF
{
	DWORD	dwExportID;		//	Object export ID
	DWORD	dwOffset;		//	Data offset in BSD file
};

//	Ornament information when ECWDFILE_VERSION <= 3
struct ECWDFILEORNAMENT
{
	DWORD	dwExportID;		//	Export ID
	float	vPos[3];		//	Position
	float	vDir[3];		//	Orientation
	float	vUp[3];			//	Up direction
	bool	bReflect;		//	Reflect flag
	bool	bRefract;		//	Refract flag
};

//	Grass type data in world file
struct ECWDFILEGRASSTYPE
{
	bool	bAlphaBlend;	//	Flag indicates whether this kind of grass use alpha blend
	int		iAlphaRef;		//	If not using alpha blend, we use alpha compare, this is the reference alpha value (0~255)
	float	fSize;			//	Size scale of this type of grass
	float	fSizeVar;		//	Size varation (0.0~1.0)
	float	fSoftness;		//	Softness for wind effect 0.0 means very hard to blow, 2.0 means too soft to blow (0.0~2.0)
	float	fSightRange;	//	Sight range of this kind of grass
};

//	Effect data in world file, when ECWDFILE_VERSION < 6
struct ECWDFILEEFFECT
{
	DWORD	dwExportID;		//	Export ID
	float	fScale;			//	GFX scale
	float	vPos[3];		//	Position
	float	vDir[3];		//	Orientation
	float	vUp[3];			//	Up direction
};

//	Effect data in world file, when 6 <= ECWDFILE_VERSION < 8
struct ECWDFILEEFFECT6
{
	DWORD	dwExportID;		//	Export ID
	float	fScale;			//	GFX scale
	float	vPos[3];		//	Position
	float	vDir[3];		//	Orientation
	float	vUp[3];			//	Up direction
	float	fSpeed;			//	Play speed
};

//	Effect data in world file, when 8 <= ECWDFILE_VERSION < 12
struct ECWDFILEEFFECT8
{
	DWORD	dwExportID;		//	Export ID
	float	fScale;			//	GFX scale
	float	vPos[3];		//	Position
	float	vDir[3];		//	Orientation
	float	vUp[3];			//	Up direction
	float	fSpeed;			//	Play speed
	int		iValidTime;		//	0-in daylight; 1-in night; 2: 24-hour
};

//	Effect data in world file, when ECWDFILE_VERSION >= 12
struct ECWDFILEEFFECT12
{
	DWORD	dwExportID;		//	Export ID
	float	fScale;			//	GFX scale
	float	vPos[3];		//	Position
	float	vDir[3];		//	Orientation
	float	vUp[3];			//	Up direction
	float	fSpeed;			//	Play speed
	int		iValidTime;		//	0-in daylight; 1-in night; 2: 24-hour
	float	fAlpha;			//	Alpha value
	bool	bAttenuation;	//	Attenuation flag
};

//	Static EC model data in world file
struct ECWDFILEECMODEL
{
	DWORD	dwExportID;		//	Export ID
	float	vPos[3];		//	Position
	float	vDir[3];		//	Orientation
	float	vUp[3];			//	Up direction
};

//	Sound object data in world file, when ECWDFILE_VERSION < 10
struct ECWDFILESOUND
{
	DWORD	dwExportID;		//	Export ID
	float	vPos[3];		//	Position
	float	fMinDist;		//	Minimum and maximum distance
	float	fMaxDist;
	int		iGroup;			//	Sound group
};

//	Sound object data in world file, when ECWDFILE_VERSION >= 10
struct ECWDFILESOUND10
{
	DWORD	dwExportID;		//	Export ID
	float	vPos[3];		//	Position
	float	fMinDist;		//	Minimum and maximum distance
	float	fMaxDist;
	int		iGroup;			//	Sound group
	int		iValidTime;		//	0-in daylight; 1-in night; 2: 24-hour
};

///////////////////////////////////////////////////////////////////////////
//	
//	World block shared data file structures
//	
///////////////////////////////////////////////////////////////////////////

//	World block share data file header
struct ECBSDFILEHEADER
{
	DWORD	dwIdentify;		//	Identity, must be ECWTFILE_IDENTIFY
	DWORD	dwVersion;		//	Version, must be ECWTFILE_VERSION
	int		iNumSubTrn;		//	Number of sub-terrain
	BYTE	aReserved[60];	//	Reserved
};

//	Box area information in BSD file. when ECBSDFILE_VERSION < 6
struct ECBSDFILEBOXAREA
{
	int		iDefArea;		//	non-zero, is default area
	float	vPos[3];		//	Area position
	float	vExt[3];		//	Area half extents
	float	vAxisX[3];		//	Area normalized x axis
	float	vAxisY[3];		//	Area normalized y axis
	float	vAxisZ[3];		//	Area normalized z axis
	float   fFogStart;		//	Fog start distance
	float   fFogEnd;		//	Fog end distance
	float   fFogDensity;	//	Fog density
	DWORD   dwFogColor;		//	Fog color
	float   fUWFogStart;	//	Under water fog start
	float   fUWFogEnd;		//	Under water fog end
	float   fUWFogDensity;	//	Under water fog density
	DWORD   dwUWFogCol;		//	Under water fog color
	DWORD	dwAmbient;		//	Ambient color
	DWORD	dwDirLtCol;		//	Directional light color
	float	vSkySpeed[2];	//	Sky moving speed on 2 axises
	DWORD	dwTrnLtScale;	//	Terrain light scale
	DWORD	dwTransTime;	//	Transform time
};

//	Box area information in BSD file. when 6 <= ECBSDFILE_VERSION < 8
struct ECBSDFILEBOXAREA6
{
	int		iDefArea;		//	non-zero, is default area
	DWORD	dwAreaFlags;	//	Area flags
	float	vPos[3];		//	Area position
	float	vExt[3];		//	Area half extents
	float	vAxisX[3];		//	Area normalized x axis
	float	vAxisY[3];		//	Area normalized y axis
	float	vAxisZ[3];		//	Area normalized z axis

	float   fFogStart;		//	Fog start distance in daylight
	float   fFogEnd;		//	Fog end distance in daylight
	float   fFogDensity;	//	Fog density in daylight
	DWORD   dwFogColor;		//	Fog color in daylight
	float   fUWFogStart;	//	Under water fog start
	float   fUWFogEnd;		//	Under water fog end
	float   fUWFogDensity;	//	Under water fog density
	DWORD   dwUWFogCol;		//	Under water fog color
	float	fFogStart_n;	//	Fog start distance in night
	float	fFogEnd_n;		//	Fog end distance in night
	float	fFogDensity_n;	//	Fog density in night
	DWORD	dwFogColor_n;	//	Fog color in night

	float	vLightDir[3];	//	Directional light's direction
	DWORD	dwAmbient;		//	Ambient color in daylight
	DWORD	dwDirLtCol;		//	Directional light color in daylight
	DWORD	dwAmbient_n;	//	Ambient color in night
	DWORD	dwDirLtCol_n;	//	Directional light color in night

	float	vSkySpeed[2];	//	Sky moving speed on 2 axises
	DWORD	dwTrnLtScale;	//	Terrain light scale
	DWORD	dwTransTime;	//	Transform time

	int     iRainSpeed;		//	Rain properties
	float   fRainSize;
	DWORD   dwRainCol;
	int     iSnowSpeed;		//	Snow properties
	float   fSnowSize;
	DWORD   dwSnowCol;
};

//	Box area information in BSD file. when ECBSDFILE_VERSION == 8
struct ECBSDFILEBOXAREA8
{
	int		iDefArea;		//	non-zero, is default area
	DWORD	dwAreaFlags;	//	Area flags
	float	vPos[3];		//	Area position
	float	vExt[3];		//	Area half extents
	float	vAxisX[3];		//	Area normalized x axis
	float	vAxisY[3];		//	Area normalized y axis
	float	vAxisZ[3];		//	Area normalized z axis

	float   fFogStart;		//	Fog start distance in daylight
	float   fFogEnd;		//	Fog end distance in daylight
	float   fFogDensity;	//	Fog density in daylight
	DWORD   dwFogColor;		//	Fog color in daylight
	float   fUWFogStart;	//	Under water fog start
	float   fUWFogEnd;		//	Under water fog end
	float   fUWFogDensity;	//	Under water fog density
	DWORD   dwUWFogCol;		//	Under water fog color
	float	fFogStart_n;	//	Fog start distance in night
	float	fFogEnd_n;		//	Fog end distance in night
	float	fFogDensity_n;	//	Fog density in night
	DWORD	dwFogColor_n;	//	Fog color in night

	float	vLightDir[3];	//	Directional light's direction
	DWORD	dwAmbient;		//	Ambient color in daylight
	DWORD	dwDirLtCol;		//	Directional light color in daylight
	DWORD	dwAmbient_n;	//	Ambient color in night
	DWORD	dwDirLtCol_n;	//	Directional light color in night

	float	vSkySpeed[2];	//	Sky moving speed on 2 axises
	DWORD	dwTrnLtScale;	//	Terrain light scale
	DWORD	dwTransTime;	//	Transform time

	int     iRainSpeed;		//	Rain properties
	float   fRainSize;
	DWORD   dwRainCol;
	int     iSnowSpeed;		//	Snow properties
	float   fSnowSize;
	DWORD   dwSnowCol;

	float	fSunPower;		//	Sun power
	float	fSunPower_n;
};

//	Box area information in BSD file. when ECBSDFILE_VERSION == 9
struct ECBSDFILEBOXAREA9
{
	int		iDefArea;		//	non-zero, is default area
	DWORD	dwAreaFlags;	//	Area flags
	float	vPos[3];		//	Area position
	float	vExt[3];		//	Area half extents
	float	vAxisX[3];		//	Area normalized x axis
	float	vAxisY[3];		//	Area normalized y axis
	float	vAxisZ[3];		//	Area normalized z axis

	float   fFogStart;		//	Fog start distance in daylight
	float   fFogEnd;		//	Fog end distance in daylight
	float   fFogDensity;	//	Fog density in daylight
	DWORD   dwFogColor;		//	Fog color in daylight
	float   fUWFogStart;	//	Under water fog start
	float   fUWFogEnd;		//	Under water fog end
	float   fUWFogDensity;	//	Under water fog density
	DWORD   dwUWFogCol;		//	Under water fog color
	float	fFogStart_n;	//	Fog start distance in night
	float	fFogEnd_n;		//	Fog end distance in night
	float	fFogDensity_n;	//	Fog density in night
	DWORD	dwFogColor_n;	//	Fog color in night

	float	vLightDir[3];	//	Directional light's direction
	DWORD	dwAmbient;		//	Ambient color in daylight
	DWORD	dwDirLtCol;		//	Directional light color in daylight
	DWORD	dwAmbient_n;	//	Ambient color in night
	DWORD	dwDirLtCol_n;	//	Directional light color in night

	float	vSkySpeed[2];	//	Sky moving speed on 2 axises
	DWORD	dwTrnLtScale;	//	Terrain light scale
	DWORD	dwTransTime;	//	Transform time

	int     iRainSpeed;		//	Rain properties
	float   fRainSize;
	DWORD   dwRainCol;
	int     iSnowSpeed;		//	Snow properties
	float   fSnowSize;
	DWORD   dwSnowCol;

	float	fSunPower;		//	Sun power
	float	fSunPower_n;
	DWORD	dwCloudAmb;		//	Clound ambient color
	DWORD	dwCloudDir;		//	Clound direction light color
};

//	Box area information in BSD file. when ECBSDFILE_VERSION == 10
struct ECBSDFILEBOXAREA10
{
	int		iDefArea;		//	non-zero, is default area
	DWORD	dwAreaFlags;	//	Area flags
	float	vPos[3];		//	Area position
	float	vExt[3];		//	Area half extents
	float	vAxisX[3];		//	Area normalized x axis
	float	vAxisY[3];		//	Area normalized y axis
	float	vAxisZ[3];		//	Area normalized z axis

	float   fFogStart;		//	Fog start distance in daylight
	float   fFogEnd;		//	Fog end distance in daylight
	float   fFogDensity;	//	Fog density in daylight
	DWORD   dwFogColor;		//	Fog color in daylight
	float   fUWFogStart;	//	Under water fog start
	float   fUWFogEnd;		//	Under water fog end
	float   fUWFogDensity;	//	Under water fog density
	DWORD   dwUWFogCol;		//	Under water fog color
	float	fFogStart_n;	//	Fog start distance in night
	float	fFogEnd_n;		//	Fog end distance in night
	float	fFogDensity_n;	//	Fog density in night
	DWORD	dwFogColor_n;	//	Fog color in night

	float	vLightDir[3];	//	Directional light's direction
	DWORD	dwAmbient;		//	Ambient color in daylight
	DWORD	dwDirLtCol;		//	Directional light color in daylight
	DWORD	dwAmbient_n;	//	Ambient color in night
	DWORD	dwDirLtCol_n;	//	Directional light color in night

	float	vSkySpeed[2];	//	Sky moving speed on 2 axises
	DWORD	dwTrnLtScale;	//	Terrain light scale
	DWORD	dwTransTime;	//	Transform time

	int     iRainSpeed;		//	Rain properties
	float   fRainSize;
	DWORD   dwRainCol;
	int     iSnowSpeed;		//	Snow properties
	float   fSnowSize;
	DWORD   dwSnowCol;

	float	fSunPower;		//	Sun power
	float	fSunPower_n;
	DWORD	dwCloudAmb;		//	Clound ambient color in daylight
	DWORD	dwCloudDir;		//	Clound direction light color in daylight
	DWORD	dwCloudAmb_n;	//	Clound ambient color in night
	DWORD	dwCloudDir_n;	//	Clound direction light color in night
};

//	Box area information in BSD file. when ECBSDFILE_VERSION == 11
struct ECBSDFILEBOXAREA11
{
	int		iDefArea;		//	non-zero, is default area
	DWORD	dwAreaFlags;	//	Area flags
	float	vPos[3];		//	Area position
	float	vExt[3];		//	Area half extents
	float	vAxisX[3];		//	Area normalized x axis
	float	vAxisY[3];		//	Area normalized y axis
	float	vAxisZ[3];		//	Area normalized z axis

	float   fFogStart;		//	Fog start distance in daylight
	float   fFogEnd;		//	Fog end distance in daylight
	float   fFogDensity;	//	Fog density in daylight
	DWORD   dwFogColor;		//	Fog color in daylight
	float   fUWFogStart;	//	Under water fog start in daylight
	float   fUWFogEnd;		//	Under water fog end in daylight
	float   fUWFogDensity;	//	Under water fog density in daylight
	DWORD   dwUWFogCol;		//	Under water fog color in daylight
	float	fFogStart_n;	//	Fog start distance in night
	float	fFogEnd_n;		//	Fog end distance in night
	float	fFogDensity_n;	//	Fog density in night
	DWORD	dwFogColor_n;	//	Fog color in night

	float	vLightDir[3];	//	Directional light's direction
	DWORD	dwAmbient;		//	Ambient color in daylight
	DWORD	dwDirLtCol;		//	Directional light color in daylight
	DWORD	dwAmbient_n;	//	Ambient color in night
	DWORD	dwDirLtCol_n;	//	Directional light color in night

	float	vSkySpeed[2];	//	Sky moving speed on 2 axises
	DWORD	dwTrnLtScale;	//	Terrain light scale
	DWORD	dwTransTime;	//	Transform time

	int     iRainSpeed;		//	Rain properties
	float   fRainSize;
	DWORD   dwRainCol;
	int     iSnowSpeed;		//	Snow properties
	float   fSnowSize;
	DWORD   dwSnowCol;

	float	fSunPower;		//	Sun power
	float	fSunPower_n;
	DWORD	dwCloudAmb;		//	Clound ambient color in daylight
	DWORD	dwCloudDir;		//	Clound direction light color in daylight
	DWORD	dwCloudAmb_n;	//	Clound ambient color in night
	DWORD	dwCloudDir_n;	//	Clound direction light color in night
	float   fUWFogStart_n;	//	Under water fog start in night
	float   fUWFogEnd_n;	//	Under water fog end in night
	float   fUWFogDensity_n;//	Under water fog density in night
	DWORD   dwUWFogCol_n;	//	Under water fog color in night
};

//	Grass area information in BSD file. ECBSDFILE_VERSION < 7
struct ECBSDFILEGRASS
{
	DWORD	dwTypeID;		//	Grass type ID
	float	vPos[3];		//	Grass area center
	float	fGridSize;		//	Grid size
	int		iGridCol;		//	Grid column number
	int		iGridRow;		//	Grid row number
};

//	Grass area information in BSD file. ECBSDFILE_VERSION >= 7
struct ECBSDFILEGRASS7
{
	DWORD	dwTypeID;		//	Grass type ID
	float	vPos[3];		//	Grass area center
	float	fGridSize;		//	Grid size
	int		iGridCol;		//	Grid column number
	int		iGridRow;		//	Grid row number
	int		iSubTerrain;	//	Index of sub-terrain
	int		iDataIndex;		//	Index in sub-terrain's data file
};

//	Water area information in BSD file. ECBSDFILE_VERSION >= 7
struct ECBSDFILEWATER
{
	int		iSubTerrain;	//	Index of sub-terrain
	int		iDataIndex;		//	Index in sub-terrain's data file
};

//	Critter group information in BSD file. 4 <= ECBSDFILE_VERSION < 5
struct ECBSDFILECRITTER
{
	int		iCritterType;	//	Critter type
	float	vPos[3];		//	Action area center
	float	fRadius;		//	Action radious
	int		iCount;			//	Number of critter
	int		iBehaviour;		//	Behaviour type
};

//	Critter group information in BSD file. ECBSDFILE_VERSION >= 5
struct ECBSDFILECRITTER5
{
	int		iCritterType;	//	Critter type
	float	vPos[3];		//	Action area center
	float	fRadius;		//	Action radious
	int		iCount;			//	Number of critter
	int		iBehaviour;		//	Behaviour type
	DWORD	dwBezier;		//	ID of bezier route
	float	fSpeed;			//	Moving speed
};

//	Ornament information in BSD file. ECBSDFILE_VERSION >= 4
struct ECBSDFILEORNAMENT
{
	float	vPos[3];		//	Position
	float	vDir[3];		//	Orientation
	float	vUp[3];			//	Up direction
	bool	bReflect;		//	Reflect flag
	bool	bRefract;		//	Refract flag
};

///////////////////////////////////////////////////////////////////////////
//	
//	World mass data file structures
//	
///////////////////////////////////////////////////////////////////////////

//	File header
struct ECWDDTFILEHEADER
{
	DWORD	dwVersion;		//	Version, must be ECWTFILE_VERSION
	bool	bCompress;		//	Compress flag
};

//	Data chunk description
struct ECWDDTFILECHUNK
{
	DWORD	dwCompSize;		//	Data size after compressed
	DWORD	dwOriginSize;	//	Original data size
};

