/*
 * FILE: Patch.h
 *
 * DESCRIPTION: a class defines a planar patch of a convex polytope
 *				In fact,it is a polygon or a triangle.
 *
 * CREATED BY: He wenfeng, 2004/9/20
 *
 * HISTORY:
 *
 * Copyright (c) 2001 Archosaur Studio, All Rights Reserved.	
 */

#ifndef	_PATCH_H_
#define _PATCH_H_


#include "halfspace.h"
#include <AArray.h>
#include <A3DVector.h>

namespace CHBasedCD
{



class CPatch;
class CConvexPolytope;


/////////////////////////////////////////////////////////////////
//  A struct describes the vertex and its' corresponding patches
//		 of a patch in the polytopes
//	Created by: He wenfeng, 2004-9-20
/////////////////////////////////////////////////////////////////
struct VPNeighbor
{
//public members:
	int vid;						//polytopeȫid
	CPatch* pNeighborPatch;			//Ӧ öһ㹹ɵıߵڽƽƬ

	VPNeighbor() {pNeighborPatch=NULL;}
};

class CPatch : public CHalfSpace  
{
public:
	CPatch(CConvexPolytope* pCP);
	virtual ~CPatch();
	//overload
	const CPatch& operator=(const CPatch& patch);		//дֵ
	CPatch(const CPatch& patch);						//дƹ캯

	void DecreVDegree();
	void IncreVDegree();	

	bool InNeighbors(CPatch* pPatch);

	bool Removed();							//汻Ӷɾ
	void UpdateRemovedError();				//¸ƽƬɾ
	void Neighbor(CPatch* pPatch);			//жpPatchǷǵǰpatchڽpatchǣ뵽Ӧλ
	

//set && get operations
	//öĸ
	int GetVNum() { return m_arrNeighbors.GetSize();}		//ö
	//õvid
	A3DVECTOR3 GetVertex(int vid);

	int GetNeighborCount() { return m_arrNeighbors.GetSize();}
	//һʽ
	AArray<VPNeighbor,VPNeighbor>& GetNeighbors(){	return m_arrNeighbors; }
	float GetRemovedError() { return m_fRemovedError;}

	void GetEdge(int id,A3DVECTOR3& v1,A3DVECTOR3& v2);
	
	int GetVID(int i) { return m_arrNeighbors[i].vid; }
	
protected:
	// жPatchesIntersectVǷѾཻһƬPIntersectV
	int HasPIntersectVExist(AArray<int,int>* pPIntersectV,const AArray<AArray<int,int>*,AArray<int,int>*>& PatchesIntersectV);
	bool IsVAdjacent(AArray<int,int>* pArr1, AArray<int,int>* pArr2);						
	bool InArray(int pid, AArray<int,int>* pArr);		//pidǷڶ̬pArr
	bool VInPatch(int vid);								//ж϶vidǷΪǰƬһ

	bool Processed(int n[3], AArray<AArray<int,int>*,AArray<int,int>*>& CoSolutionList);
	bool Solve3NPIntersection(int n[3], A3DVECTOR3& vIntersection);
	
	//صi򶥵һȫidӶ뵱ǰ㹹һڱߣ
	int GetNextV(int i) { return ((i+1<m_arrNeighbors.GetSize())?m_arrNeighbors[i+1].vid:m_arrNeighbors[0].vid);}
	int GetNext(int i) {return ((i+1<m_arrNeighbors.GetSize())?i+1:0);}
	int GetPre(int i) {return (i-1<0?m_arrNeighbors.GetSize()-1:i-1);}


//Attributes
private:
	float m_fRemovedError;								//ƳƬӶƳ
	AArray<VPNeighbor,VPNeighbor> m_arrNeighbors;		//㼰ڵƬ
	CConvexPolytope* m_pConvexPolytope;					//ƬĶָ룻
};

}	// end namespace

#endif // _PATCH_H_
