/////////////////////////////////////////////////
//	created by He wenfeng
//  2004-8-17
//  A class describes the half 3D space devided by the plane
/////////////////////////////////////////////////

#ifndef	_HALFSPACE_H_
#define _HALFSPACE_H_

#include <A3DVector.h>
#include <A3DMatrix.h>
#define HS_DEFAULT_DISTTHRESH 0.000001f				//ֵΪжڰռڲor߽
#define ABS(x) (((x)<0)?(-(x)):(x))


namespace CHBasedCD
{

////////////////////////////////////////////////////////////////////////////
// 
// ƽ淽̵ĶΪN.X=DڱеʽΪ m_vNormal.X=m_d
// ע⣺һƽ淽Ax+By+Cz+D=0һD
// 
////////////////////////////////////////////////////////////////////////////

class CHalfSpace
{
	static float DistThresh;		//ռһ㵽halfspaceƽľֵΪжڰռڲⲿor ߽
									//ֵĳһ˶Ϊ̬Ա
public:

	//㹹ƽ漰ռ
	CHalfSpace(const A3DVECTOR3& v1, const A3DVECTOR3& v2, const A3DVECTOR3& v3) { Set(v1,v2,v3); }
	//㹹ƽZƽ漰ռ
	CHalfSpace(const A3DVECTOR3& v1, const A3DVECTOR3& v2) { Set(v1,v2); }
	CHalfSpace(){}

	CHalfSpace(const CHalfSpace& hs):m_vNormal(hs.m_vNormal) { m_d=hs.m_d; }

	~CHalfSpace() {}

	// ԾHalfspaceƽб任任ΪmtxTrans
	virtual void Transform(const A3DMATRIX4& mtxTrans);

	void Translate(float Delta) { m_d+= Delta;}				//ط߷һƽ
	void Inverse() { m_d=-m_d;m_vNormal=-m_vNormal;}		//תռ

	//vռ䶨ƽľ룬˾ţ
	inline float DistV2Plane(const A3DVECTOR3& v)const;				

	//߶
	int IntersectLineSeg(const A3DVECTOR3& v1,const A3DVECTOR3& v2,A3DVECTOR3& vIntersection) const;

	////////////////////////////////////////////////////////////
	// жһάǷڰռڲ˵ƽһ
	// עhalfspaceOutSide,Inside巽ʽ
	//				   /\
	//		          /||\
	//				   ||
	//				   || normal    (Outside)
	//------------------------------------------Plane
	//								(Inside)
	//
	inline bool Inside(const A3DVECTOR3& v) const;
	inline bool Outside(const A3DVECTOR3& v) const;
	inline bool OnPlane(const A3DVECTOR3& v) const;

//set && get operations
	static void SetDistThresh(float DThresh=HS_DEFAULT_DISTTHRESH)		//趨һȱʡֵ
	{
		DistThresh=DThresh;
	}
	
	const A3DVECTOR3& GetNormal() const {return m_vNormal;}
	float GetDist() const { return m_d;}
	
	void Set(const A3DVECTOR3& v1, const A3DVECTOR3& v2);
	void Set(const A3DVECTOR3& v1, const A3DVECTOR3& v2, const A3DVECTOR3& v3);
	
	//ֱ÷
	void SetNormal(const A3DVECTOR3& n) { m_vNormal=n;m_vNormal.Normalize();}
	//ֱþd
	void SetD(float d) { m_d=d;}

	//㷨ʽ
	void SetNV(const A3DVECTOR3& n, const A3DVECTOR3& v);
	
	// get the projected position in the plane
	void ProjectPos2Plane(A3DVECTOR3& v)
	{
		v -  DistV2Plane(v) * m_vNormal;
	}

	A3DVECTOR3 GetPorjectPos(const A3DVECTOR3& v)
	{
		return v - DistV2Plane(v) * m_vNormal;
	}

//Attributes
public:
	A3DVECTOR3 m_vNormal;
	float m_d;

};

//ڸðռڲ
inline bool CHalfSpace::Inside(const A3DVECTOR3& v) const
{
	float d=DotProduct(v,m_vNormal);
	bool bInside=(m_d-d>DistThresh);
	return (bInside);
}

//ڸðռⲿ
inline bool CHalfSpace::Outside(const A3DVECTOR3& v) const
{
	float d=DotProduct(v,m_vNormal);
	bool bOutside=(d-m_d>DistThresh);
	return (bOutside);
}

//ڸðռķֽƽ
inline bool CHalfSpace::OnPlane(const A3DVECTOR3& v) const
{
	float d=DotProduct(v,m_vNormal);
	bool bOnPlane=(ABS(m_d-d)<=DistThresh);
	return bOnPlane;
}

///////////////////////////////////////////////////////////////////
// vƽľ
// vƽڲʱ˾Ϊ-
// vƽⲿʱ˾Ϊ+
///////////////////////////////////////////////////////////////////
inline float CHalfSpace::DistV2Plane(const A3DVECTOR3& v)const
{
	float d=DotProduct(v,m_vNormal);
	return (d-m_d);
}

//----------------------------------------------------------------
// some extra utilities...

// compute the best-fit plane via an array of vertices, return true if all vertices's 
// distances to plane is less than MaxDistError.
#if 1
bool BestFitPlane(const A3DVECTOR3* Verts, int VNum, CHalfSpace& hsPlane, float MaxDistError);
#endif

}	// end namespace

#endif	//	_HALFSPACE_H_