/*
 * FILE: ConvexPolytope.h
 *
 * DESCRIPTION: a class defines a convex polytope
 *
 * CREATED BY: He wenfeng, 2004/9/20
 *
 * HISTORY:
 *
 * Copyright (c) 2001 Archosaur Studio, All Rights Reserved.	
 */

#ifndef	_CONVEXPOLYTOPE_H_
#define _CONVEXPOLYTOPE_H_

#include "Patch.h"
#include <AList2.h>
#include <AList.h>
#include <A3DFlatCollector.h>

namespace CHBasedCD
{

class CConvexHullData;

/////////////////////////////////////////////////////////////////
//  A struct describes the information of a vertex in Convex Polytope
//	Created by: He wenfeng, 2004-8-17
/////////////////////////////////////////////////////////////////
struct VertexInfo
{

//public members:

	bool bValid;					//ǷΪЧ㣬Ч㲻ӦڶκһƬ֮
	char cDegree;					//Ķ־жٸƬ˶㣬öڽӣ
	AList* pNeighborPatches;		//˶Ƭбʱʹã

	VertexInfo() 
	{
		bValid=true;				//ȱʡģʼʱЧ
		cDegree=0;					//ʼΪ0ʾһЧĶֵڴ˻1
		pNeighborPatches=NULL;		//ݲʹ
	}
};

class CGiftWrap;
class C2DGiftWrap;


class CConvexPolytope  
{
	static float Hull2D_Half_Thickness;		//2D Convex HullConvexPolytopeʱһ

public:
	A3DAABB GetAABB();

	CPatch* IsVertexOnPatch(A3DVECTOR3 v, float fInflateRadius);
	bool IsVertexInside(A3DVECTOR3 v,float fInflateRadius);
	bool IsVertexOutside(A3DVECTOR3 v,float fInflateRadius=0.0f);
	CConvexPolytope();
	virtual ~CConvexPolytope();
	
	static void SetHull2DThickness(float fThickness) { Hull2D_Half_Thickness=fThickness*0.5f;}

	bool Init(const CGiftWrap& gw);		//˷ΪCGiftWrapһԪ
	
	bool Init(const CGiftWrap& gw,float fErrorBase)
	{
		//һInitķ˳
		SetErrorBase(fErrorBase);
		return Init(gw);
	}

	void Goto(float fError=0.1f);	//ֱfErrorָļ򻯲ΣȱʡΪ10%
	bool Goto(int LeftPatchesNum);

	void UndoRemove();				//ǰָĲ
	void RedoRemove();				//󣬼ݵǰĲ
	
	void ReduceAll();					//ɾɾƬ򻯵ͷ

	bool RedoAll();					//ָͷ
	bool UndoAll();					//ͷ

	//for render
	void Render(A3DFlatCollector* pFC, A3DMATRIX4& tMatrix,DWORD dwColor,CPatch* pSpecialPatch);
	void RenderLEPatchSpecial(A3DFlatCollector *pFC,A3DMATRIX4& tMatrix, DWORD dwColor);	
	
	//жǷ쳣
	bool ExceptionOccur() { return m_bExceptionOccur;}
	void ThrowException() { m_bExceptionOccur=true;}

	//һ
	void AddV(A3DVECTOR3 &v,VertexInfo &vInfo){ m_arrVertecies.Add(v);m_arrVertexInfo.Add(vInfo);}

	//ݵCConvexHullData
	void ExportCHData(CConvexHullData* pCHData);	

	bool IntersectPlanesProj2XOZ(CHalfSpace* Planes,int PlaneNum,C2DGiftWrap& gw2d,bool b2ParallelPlanes=false);
	
//set && get operations
	A3DVECTOR3 GetCentroid() { return m_vCentroid;}
	
	void SetErrorBase(float fErrorBase) { m_fErrorBase=fErrorBase;}
	float GetErrorBase() { return m_fErrorBase;}

	int GetVNum() { return m_arrVertecies.GetSize();}
	VertexInfo& GetVInfo(int vid) { return m_arrVertexInfo[vid];}
	A3DVECTOR3 GetV(int vid) { return m_arrVertecies[vid];}

	int GetPatchesNum() { return m_listPatches.GetCount(); }			//ǰƬ
	int GetOriginPatchNum() { return m_nOriginPatchNum;}
	int GetMinPatchNum() { return m_nMinPatchNum;}

	float GetCurLeastError() 
	{ 
		if(m_pCurLeastErrorPatch) return m_pCurLeastErrorPatch->GetRemovedError();
		else return -1.0f;		//һЧֵ
	}

	AList2<CPatch*,CPatch*>& GetPatchesList() { return m_listPatches;}
	
	
protected:
	CPatch* SearchLeastErrorPatch();
	bool RemovePatch(CPatch* pPatch);		//ɾһƬ
	bool RemoveLeastErrorPatch();
	int GetLPNByError(float fError);
	
	void ComputePatchNeighbors();						//ƬƬ˽УӦInit()
	void Reset();										//еԴΪʼ״̬

// Attributes
protected:
	A3DVECTOR3	m_vCentroid;							//㼯
	
	AArray<A3DVECTOR3,A3DVECTOR3> m_arrVertecies;		//бֻ¼ϢӶ
	AArray<VertexInfo,VertexInfo> m_arrVertexInfo;		//ϢбӦͶбһ
	AList2<CPatch*,CPatch*> m_listPatches;				//еƬбṹ洢ɾ
	
	int m_nOriginPatchNum;
	int m_nMinPatchNum;									//򻯵ͷʱƬʵ֤һΪ4һCube涼޷ˣˣƬΪ6
	
	int m_nCurVNum;										//ǰЧĶÿɾһʱӶ㣬ñ¼˵ǰʱĶ

	WORD* m_pIndices;									//ʱηεĶid!
	WORD* m_pLEPIndices;								//ƵǰСƬζid
	WORD* m_pLEPNIndices;								//ƵǰСƬƬζid

	A3DVECTOR3* m_pVerticesForRender;					//任õĶֱ꣬ڻ
	
	CPatch* m_pCurLeastErrorPatch;						//¼ǰɾСƬ

	float			m_fErrorBase;						//ɾתΪķĸ
	float*			m_fArrRemovedError;					//ɾ飬¼ÿһεɾ

	bool			m_bExceptionOccur;		//򻯳쳣ղܼ򻯳͹4壡

	//һЩǶ׽ṹ࣬Ϊ˽Уֻڱڲʹ
	
	//ɾƬ򱸷ݽṹ
	struct NeighborBak
	{
		/*
		CPatch* pBeforeRemoved;			//ɾǰָ
		CPatch* pAfterRemoved;			//ºָ
		*/
		CPatch* pPatchCur;				//ǰm_listPatchesָ
		CPatch* pPatchBak;				//ָݵһ
		NeighborBak(CPatch* pCur,CPatch* pBak) { pPatchCur=pCur; pPatchBak=pBak;}
		NeighborBak() {pPatchCur=NULL;pPatchBak=NULL;}
	};

	struct RemoveOperatorRecord				//һɾ¼Ϣ
	{
		CPatch* pRemoved;									//ɾƬָ
		AArray<NeighborBak,NeighborBak> arrNeighborBak;		//Ϣ
		int VNumAdded;										//ӵĶ
	};

	//ֱʹþֲʱָܻ
	AArray<RemoveOperatorRecord*,RemoveOperatorRecord*> m_arrRemoveOperatorRecords;	//¼ɾ飬ӶɳȲ
	int m_nCurOperator;				//ǰλ
};

//ȫֺ
int FindInArray(int id,const AArray<int,int>& arr);
void AddDifferentV(AArray<A3DVECTOR3,A3DVECTOR3>& Vertices, A3DVECTOR3& v);

}	// end namespace

#endif // _CONVEXPOLYTOPE_H_
