  //////////////////////////////////////////////////////////////////////
//	Created by He wenfeng
//  2004-11-25
//  A class describes a ConvexHullData which is used for Collision Detection
//  It consists a set of Vertices by order and a set of CFaces
//////////////////////////////////////////////////////////////////////

#ifndef	_CONVEXHULLDATA_H_
#define _CONVEXHULLDATA_H_

#include <A3DVector.h>
#include <A3DGeometry.h>
#include "Face.h"

#define DW_BITWISE_NOT(x) (0xFFFFFFFF ^ (x))	   //bitwise not!

// a set of DWORD flags
#define	CHDATA_BAD_FIT				0x00000001		//־͹ģ͵ĽЧãҪһģײCHEditorõ
#define CHDATA_NPC_CANNOT_PASS		0x00000002		//Ŀǰڵα༭У־͹Ƿnpcͨ
#define CHDATA_SKIP_COLLISION		0x00000004		//־ǷײкԴ͹
#define CHDATA_SKIP_RAYTRACE		0x00000008		//־Ƿ߸кԴ͹

class A3DFlatCollector;
class AFile;
class A3DOBB;

namespace CHBasedCD
{

class CConvexHullData  
{
public:
	
	CConvexHullData();
	virtual ~CConvexHullData();

	const CConvexHullData& operator=(const CConvexHullData& CHData);		//һֵ
	CConvexHullData(const CConvexHullData& CHData);									//һ캯

	//////////////////////////////////////////////////
	// Test if two convex hull overlap.
	// Return value:
	//		0: no overlap
	//		1: overlap partly
	//		2: this CH is fully inside Another CH
	//		3: Another CH is fully inside this CH
	//////////////////////////////////////////////////
	int ConvexHullOverlapTest(const CConvexHullData& AnotherCH) const;

	// Generate convex hull from OBB directly
	void Import(const A3DOBB* pOBB, bool bImportVertices = true );		// OBBCHDATA
	
	// Generate convex hull from a triangle directly
	bool Import(const A3DVECTOR3 Vertices[3], float fThickness = 0.01f);

	// ÿfaceĶ߽halfspace!
	void ComputeFaceExtraHS();

	// ConvexHullData任任ΪmtxTrans
	// עܴ任ֻǴͬscaleֵĸԱ任
	virtual void Transform(const A3DMATRIX4& mtxTrans);

	//ƵpFC,УָpSpecialFace,ʾ
	void Render(A3DFlatCollector* pFC, bool bRenderV=false, CFace* pSpecialFace=NULL, DWORD dwVColor=0xffff0000, DWORD dwFColor=0xa0ffff00, const A3DVECTOR3& vRayDir=A3DVECTOR3(1.0f,1.0f,1.0f), const A3DMATRIX4* pTransMatrix=NULL);

	//ãնƬ
	void Reset() 
	{
		m_arrVertices.RemoveAll();
		for(int i=0;i<m_arrFaces.GetSize();i++)
			delete m_arrFaces[i];
		m_arrFaces.RemoveAll();
	}

	//ӦһļAFile
	virtual bool LoadBinaryData(AFile* InFile, bool bLoadVertices = true);
	virtual bool SaveBinaryData(AFile* OutFile) const;

	//ӦһļFILE
	virtual bool LoadFromStream(FILE* InFile);
	virtual bool SaveToStream(FILE* OutFile) const;

	/************************************************************************
	// Removed by wenfeng, 05-3-28
	// гstd::fstreamĿ⣬ҪVC֧֣

	//Ӧһļ
	virtual bool LoadFromStream(std::ifstream& InFile);
	virtual bool SaveToStream(std::ofstream& OutFile) const;
	
	//Ӧһļ
	virtual bool LoadFromFile(const char* szFileName);
	virtual bool SaveToFile(const char* szFileName) const;
	
	/************************************************************************/

	bool HaveVertexDataLoaded()
	{
		return ( m_arrVertices.GetSize()==0 && m_arrFaces.GetSize() >0 );
	}

	int GetVertexNum() const { return m_arrVertices.GetSize(); }
	int GetFaceNum() const { return m_arrFaces.GetSize();}
	bool IsEmpty() { return GetFaceNum() == 0 || GetVertexNum() < 2; }

	A3DVECTOR3 GetVertex(int vid) const { return m_arrVertices[vid];}
	CFace& GetFace(int fid) const { return *(m_arrFaces[fid]);	}
	CFace* GetFacePtr(int fid)  const { return m_arrFaces[fid];}

	// build the aabb at runtime.
	bool GetAABB(A3DAABB& aabb)
	{
		if ( GetVertexNum() < 2 ) return false;

		aabb.Build( m_arrVertices.GetData(), m_arrVertices.GetSize());
		return true;
	}
	
	// get the aabb we precomputed.
	A3DAABB GetAABB() const
	{
		return m_aabb;
	}

	void AddVertex(const A3DVECTOR3& v) { m_arrVertices.Add(v); }
	void AddFace(const CFace& f) 
	{	
		CFace* pFace = new CFace(f);
		pFace->SetCHData(this);
		m_arrFaces.Add(pFace);
	}

	void AddFace(const CFace* pF)
	{
		CFace *pFace = new CFace(*pF);
		pFace->SetCHData(this);
		m_arrFaces.Add(pFace);
	}

	// ־úͻȡ
	void SetFlags(DWORD flags) { m_dwFlags=flags;}
	DWORD GetFlags() { return m_dwFlags; }

	void SetBadFitFlag(bool bBadFit=true) 
	{ 
		if(bBadFit)
			m_dwFlags|=CHDATA_BAD_FIT;
		else
			m_dwFlags&=DW_BITWISE_NOT(CHDATA_BAD_FIT);
	}
	bool IsBadFit() { return (m_dwFlags & CHDATA_BAD_FIT);}
	//is convexhull validate? ȷзǷ͹Լ
	bool IsValidte() const;

protected:
	virtual int ComputeBufSize() const;					//㱣浽AFileĻС
	virtual bool WriteToBuf(char* buf) const;		  //ȫд뵽bufУǰbufѾ
	virtual bool ReadFromBuf(char* buf);				//bufж

	void BuildAABB();
	
protected:
	static float m_fMax; //used by IsValidte(); vertex should between (-m_fMax, m_fMax)
	DWORD		m_dwFlags;
	AArray<A3DVECTOR3,const A3DVECTOR3&> m_arrVertices;		//б
	AArray<CFace*, CFace*> m_arrFaces;						//бֻṩֶμ
	int m_iVer;			// 汾Ϣڴȡ

	// Added by wenfeng, 05-11-21
	A3DAABB m_aabb;		// keep record of convex hull's AABB.
};

}	// end namespace

#endif // _CONVEXHULLDATA_H_
