/*
* FILE: A3DGFXECMLoader.cpp
*
* DESCRIPTION: 
*
* CREATED BY: Zhangyachuan, 2010/03/01
*
* HISTORY: 
*
* Copyright (c) 2009 Archosaur Studio, All Rights Reserved.
*/

#include "stdafx.h"
#include "A3DGFXECMLoader.h"
#include "A3DGFXECModel.h"
#include "A3DGFXECMInterface.h"

///////////////////////////////////////////////////////////////////////////
//	
//	Define and Macro
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Reference to External variables and functions
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Local Types and Variables and Global variables
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Local functions
//	
///////////////////////////////////////////////////////////////////////////

static bool Call_LoadCustomSkin(GFX_LOAD_ECM_PARAM* pParam)
{
	IGFXECMInterface* pGFXLoadECM = AfxGetGFXExMan()->GetGfxECMInterface();
	if (pGFXLoadECM)
	{
		return pGFXLoadECM->OnLoadCustomSkin(pParam);
	}

	if (!AfxGetGFXExMan()->GetGfxLoadSkinByID())
	{
		a_LogOutput(1, "Error in Call_LoadCustomSkin, unable to call back client because neither the IGFXLoadECM interface"
			"or the ON_GFX_LOAD_ECM_BY_ID is set");
		return false;
	}

	if (!(*AfxGetGFXExMan()->GetGfxLoadSkinByID())(pParam))
	{
		a_LogOutput(1, "Error in Call_LoadCustomSkin, failed to load skin by id %I64d and user cmd %s.", pParam->nId, pParam->strUserCmd);
		return false;
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////
//	
//	Implement ECMLoader
//	
///////////////////////////////////////////////////////////////////////////

ECMLoader::ECMLoader(A3DGFXECModel* pECMEle)
: m_pECMEle(pECMEle)
{
	ASSERT(m_pECMEle);
}

ECMLoader* ECMLoader::Create(int iLdType, A3DGFXECModel* pECMEle)
{
	switch ( iLdType )
	{
	case TYPE_NORMAL:
		return new NormalLoader(pECMEle);
	case TYPE_CUSTOM_SKIN:
		return new CustomSkinLoader(pECMEle);
	case TYPE_CUSTOM_ECM:
		return new CustomECMLoader(pECMEle);
	default:
		ASSERT(FALSE && "Unexpected error happened.");
		return new NormalLoader(pECMEle);
	}
}

void ECMLoader::Destroy(ECMLoader* pLoader)
{
	delete pLoader;
}

bool ECMLoader::OnInit(CECModel* pModel)
{
	if (!pModel)
		return false;

	TransferProperties(pModel);
	return true;
}

void ECMLoader::TransferProperties(CECModel* pModel)
{
	A3DGFXEx* pGFX = m_pECMEle->m_pGfx;
	if (!pGFX)
		return;

	pModel->SetCreatedByGfx(true);
	pModel->SetGfxUseLOD(pGFX->GetUseLOD(), false);
	pModel->SetDisableCamShake(pGFX->IsDisableCamShake());
	pModel->SetId(pGFX->GetId());
}

///////////////////////////////////////////////////////////////////////////
//	
//	Implement NormalLoader
//	
///////////////////////////////////////////////////////////////////////////


NormalLoader::NormalLoader(A3DGFXECModel* pECMEle)
: ECMLoader(pECMEle)
{
	m_iECMLoaderType = ECMLoader::TYPE_NORMAL;
}

ECMLoader* NormalLoader::Clone(A3DGFXECModel* pECMEle) const
{
	return new NormalLoader(pECMEle);
}

bool NormalLoader::OnInit(CECModel* pModel)
{
	if (!ECMLoader::OnInit(pModel))
		return false;

#ifdef GFX_EDITOR
	const bool bLoadAdditionalSkin = true;
#else
	const bool bLoadAdditionalSkin = false;
#endif

	if (!pModel->Load(m_pECMEle->GetECMFileName(), true, A3DSkinModel::LSF_DEFAULT, true, bLoadAdditionalSkin, false))
	{
		a_LogOutput(1, "NormalLoader::OnInit, failed to load ecmodel file %s.", m_pECMEle->m_strECMFilename);
		return false;
	}

	return true;
}

bool NormalLoader::OnPlay(CECModel* pModel)
{
	TransferProperties(pModel);
	return true;
}

///////////////////////////////////////////////////////////////////////////
//	
//	Implement CustomECMLoader
//	
///////////////////////////////////////////////////////////////////////////

CustomECMLoader::CustomECMLoader(A3DGFXECModel* pECMEle)
: ECMLoader(pECMEle)
{
	m_iECMLoaderType = ECMLoader::TYPE_CUSTOM_ECM;
}

ECMLoader* CustomECMLoader::Clone(A3DGFXECModel* pECMEle) const
{
	return new CustomECMLoader(pECMEle);
}

bool CustomECMLoader::OnInit(CECModel* pModel)
{
	if (!ECMLoader::OnInit(pModel))
		return false;

#ifdef GFX_EDITOR	// In GFXEDITOR

	const bool bLoadAdditionalSkin = true;

	if (!pModel->Load(m_pECMEle->GetECMFileName(), true, A3DSkinModel::LSF_DEFAULT, true, bLoadAdditionalSkin, false))
	{
		a_LogOutput(1, "CustomECMLoader::OnInit, failed to load ecmodel file %s.", m_pECMEle->m_strECMFilename);
		return false;
	}

#endif

	return true;
}

bool CustomECMLoader::OnPlay(CECModel* pModel)
{
	ASSERT(pModel);

	IGFXECMInterface* pGfxLoadECM = AfxGetGFXExMan()->GetGfxECMInterface();
#ifdef GFX_EDITOR
	
	// ˴ #ifdef / #endif 
	// ϣGFX༭пԿӵĬECMļECM༭пԿûЧ  ͬΪ
	// GFX༭аѸýӿΪNULLOnInitмģͣڴֱӷأԿĬϵģ
	// ECM༭иýӿòΪNULLصģͣͻ˵߼ƣֻж
	if (!pGfxLoadECM)
		return true;
	
#else 

	if (!pGfxLoadECM)
	{
		a_LogOutput(1, "CustomECMLoader::OnPlay, Set IGFXECMInterface by A3DGFXExMan::SetGfxECMInterface");
		return false;
	}

#endif

	ASSERT(pGfxLoadECM);

	//	Transfer properties each time plays
	TransferProperties(pModel);

	A3DGFXEx* pGFX = m_pECMEle->m_pGfx;
	ASSERT(pGFX);
	GFX_LOAD_ECM_PARAM param;
	param.nId = pGFX->GetId();
	param.pECModel = pModel;
	param.strUserCmd = m_pECMEle->GetUserCmd();

	return pGfxLoadECM->OnLoadCustomECModel(&param);
}

///////////////////////////////////////////////////////////////////////////
//	
//	Implement CustomSkinLoader
//	
///////////////////////////////////////////////////////////////////////////

CustomSkinLoader::CustomSkinLoader(A3DGFXECModel* pECMEle)
: ECMLoader(pECMEle)
{
	m_iECMLoaderType = ECMLoader::TYPE_CUSTOM_SKIN;
}

ECMLoader* CustomSkinLoader::Clone(A3DGFXECModel* pECMEle) const
{
	return new CustomSkinLoader(pECMEle);
}
	
bool CustomSkinLoader::OnInit(CECModel* pModel)
{
	if (!ECMLoader::OnInit(pModel))
		return false;

#ifdef GFX_EDITOR
	const bool bLoadAdditionalSkin = true;
#else
	const bool bLoadAdditionalSkin = false;
#endif

#ifdef _ANGELICA21

	if (!pModel->Load(m_pECMEle->GetECMFileName(), true, A3DSkinModel::LSF_NOSKIN, false, bLoadAdditionalSkin, false))
	{
		a_LogOutput(1, "CustomSkinLoader::OnInit, failed to load ecmodel file %s.", m_pECMEle->m_strECMFilename);
		return false;
	}

#else

	if (!pModel->Load(m_pECMEle->GetECMFileName(), true, A3DSkinModel::LSF_DEFAULT, true, bLoadAdditionalSkin, false))
	{
		a_LogOutput(1, "CustomSkinLoader::OnInit, failed to load ecmodel file %s.", m_pECMEle->m_strECMFilename);
		return false;
	}

#endif
		
	return true;
}

bool CustomSkinLoader::OnPlay(CECModel* pModel)
{
	//	Transfer properties each time plays
	TransferProperties(pModel);

	A3DGFXEx* pGFX = m_pECMEle->m_pGfx;
	ASSERT(pGFX);
	GFX_LOAD_ECM_PARAM param;
	param.nId = pGFX->GetId();
	param.pECModel = pModel;
	param.strUserCmd = m_pECMEle->GetUserCmd();

	return Call_LoadCustomSkin(&param);
}
