// RightPrism.cpp: implementation of the CRightPrism class.
//
//////////////////////////////////////////////////////////////////////

#include "RightPrism.h"
#include "2DGiftWrap.h"
#include "2DObstruct.h"

#include <vector.h>
using namespace abase;

namespace CHBasedCD
{


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CRightPrism::CRightPrism()
{

}

CRightPrism::~CRightPrism()
{

}

bool CRightPrism::InitBase(const C2DGiftWrap& gw2D,float fHeight)
{
	if (gw2D.m_bExceptionOccur)
		return false;
	AArray<int,int>* pCHVs=gw2D.GetCHVertecies();

	if (!pCHVs) 
		return false;

	m_vCentroid=gw2D.m_vCentroid;
	
	m_nCurVNum=2*pCHVs->GetSize();		//ǰΪ2D͹Ķ2

	VertexInfo vInfo;
	vInfo.cDegree=3;			//ֱжΪ3

	//춥㼰Ϣ
	int i(0);
	for(i=0;i<pCHVs->GetSize();i++)
	{
		//ͬʱӵͶһ
		A3DVECTOR3 v=gw2D.m_pVertexes[pCHVs->GetAt(i)];
		v.y=0.0f;
		m_arrVertecies.Add(v);
		
		v.y=fHeight;
		m_arrVertecies.Add(v);

		m_arrVertexInfo.Add(vInfo);
		m_arrVertexInfo.Add(vInfo);
	}
	
	//ʼƽƬ

	//
	//ȡǰ㹹ƽ漸Ϣ
	A3DVECTOR3 v1(gw2D.m_pVertexes[pCHVs->GetAt(0)]),v2(gw2D.m_pVertexes[pCHVs->GetAt(1)]),v3(gw2D.m_pVertexes[pCHVs->GetAt(2)]);
	CPatch* pPatch=new CPatch(this);
	pPatch->Set(v1,v2,v3);			//Ϣ			
	
	//NeighborsԪ
	VPNeighbor vpn;
	AArray<VPNeighbor,VPNeighbor>& arrNeighbors1=pPatch->GetNeighbors();
	for(i=0;i<pCHVs->GetSize();i++)
	{
		vpn.vid=2*i;			
		arrNeighbors1.Add(vpn);
	}
	//ӵ
	m_listPatches.AddTail(pPatch);	
	
	//
	//ȡǰ㣬ƽ漸Ϣ
	v1=m_arrVertecies[1];
	v2=m_arrVertecies[3];
	v3=m_arrVertecies[5];

	pPatch=new CPatch(this);
	pPatch->Set(v3,v2,v1);			//Ϣ			
	
	//NeighborsԪ
	AArray<VPNeighbor,VPNeighbor>& arrNeighbors2=pPatch->GetNeighbors();
	//水
	for(i=pCHVs->GetSize()-1;i>=0;i--)
	{
		vpn.vid=2*i+1;			
		arrNeighbors2.Add(vpn);
	}
	//ӵ
	m_listPatches.AddTail(pPatch);	
	
	//ʼӸ
	for(i=0;i<pCHVs->GetSize();i++)
	{
		pPatch=new CPatch(this);		
		AArray<VPNeighbor,VPNeighbor>& arrNeighbors=pPatch->GetNeighbors();
		
		//ÿ涼һ
		if(i<pCHVs->GetSize()-1)
		{
			v1=m_arrVertecies[2*i+2];
			v2=m_arrVertecies[2*i];
			v3=m_arrVertecies[2*i+1];
			pPatch->Set(v1,v2,v3);
			
			vpn.vid=2*i;
			arrNeighbors.Add(vpn);

			vpn.vid=2*i+1;
			arrNeighbors.Add(vpn);

			vpn.vid=2*i+3;
			arrNeighbors.Add(vpn);

			vpn.vid=2*i+2;
			arrNeighbors.Add(vpn);
			
		}
		else		
		{
			//һεȽ
			v1=m_arrVertecies[0];
			v2=m_arrVertecies[2*i];
			v3=m_arrVertecies[2*i+1];
			pPatch->Set(v1,v2,v3);
			
			vpn.vid=2*i;
			arrNeighbors.Add(vpn);

			vpn.vid=2*i+1;
			arrNeighbors.Add(vpn);

			vpn.vid=1;
			arrNeighbors.Add(vpn);

			vpn.vid=0;
			arrNeighbors.Add(vpn);			
		}
		m_listPatches.AddTail(pPatch);
	}	

	m_nOriginPatchNum = m_listPatches.GetCount();
	
	//*
	//ʼɾ

	//ӦǽĻΪľ룡

	if(m_fArrRemovedError)
		delete[] m_fArrRemovedError;
	m_fArrRemovedError=new float[m_nOriginPatchNum+1];
	for(i=0;i<4;i++)
		m_fArrRemovedError[i]=-1.0f;			//0,1,2,3ΪЧֵ

	m_bExceptionOccur=false;
	//*/

	//ÿpatchpatch
	ComputePatchNeighbors();

	//ѰСɾӦƬ
	SearchLeastErrorPatch();	
	
	//ҪĴ룡
	//ReduceAll();
	//Goto(9);

	return true;
}

void CRightPrism::Export2DObstruct(C2DObstruct* p2DObstruct)
{
	//ڱּ֧򻯲ЧݽΪƬĶ
	//ڳʼʱƬΪm_listPatchesĵһƬ
	ALISTPOSITION CurPatchPos=m_listPatches.GetHeadPosition();
	CPatch *pCurPatch=m_listPatches.GetNext(CurPatchPos);
	vector<A3DVECTOR3> Vertices(pCurPatch->GetVNum(), A3DVECTOR3(0.0f, 0.0f, 0.0f));
	for(int i=0;i<pCurPatch->GetVNum();i++)
		Vertices[i]=pCurPatch->GetVertex(i);

	p2DObstruct->Init(Vertices);
		
}


}	// end namespace