      // GiftWrap.cpp: implementation of the CGiftWrap class.
//
//////////////////////////////////////////////////////////////////////

#include "GiftWrap.h"
#include "halfspace.h"

//#include <fstream>


#define ABS(x) (((x)<0)?(-(x)):(x))

#define CH_FLT_EPSILON 2.0e-7F			// ֵСĸ
#define CH_VALID_TOLERANCE  0.03f

#define CH_IDENTICAL_POS_ERROR	0.01f	// if two position's x/y/z components are different under this error, we regard them as the same one!

namespace CHBasedCD
{

int RemoveCloseVertices(A3DVECTOR3* Vertices, int iVertexNum, float fDistThresh)
{

	if(!Vertices || iVertexNum < 2) return iVertexNum;


	int iCurUniqueVertex = 1;
	
	for(int i=1; i<iVertexNum; i++)
	{
		bool bSameVert = false;

		for(int j =0; j<iCurUniqueVertex; j++)
		{
			if((Vertices[j]-Vertices[i]).Magnitude() < fDistThresh)
			{
				// yes, i is same with j...
				bSameVert = true;
				break;
			}
		}

		if(!bSameVert)
		{
			Vertices[iCurUniqueVertex++] = Vertices[i];
		}
		

	}


	return iCurUniqueVertex;
}	


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CGiftWrap::CGiftWrap()
{
	m_fInitHSDistThresh=0.01f;			
	m_nHullType=HULL_3D;				//ȱʡģ͹Ϊ3D
}

CGiftWrap::~CGiftWrap()
{

}

CGiftWrap::CGiftWrap(A3DVECTOR3* pVertexes,int vNum)
{
	//öϢ
	SetVertexes(pVertexes,vNum);

	m_bExceptionOccur=false;
	
	m_fInitHSDistThresh=0.01f;
	m_nHullType=HULL_3D;				//ȱʡģ͹Ϊ3D
}

void CGiftWrap::ComputeConvexHull()
{
	for (m_fIdenticalPosErr = CH_IDENTICAL_POS_ERROR; m_fIdenticalPosErr >= 1e-5f; m_fIdenticalPosErr *= 0.1f)
	{
		InternalComputeConvexHull();
		if (!ExceptionOccur())
			break;
	}
}

void CGiftWrap::InternalComputeConvexHull()
{
	//------------------------------------------------------------------------
	// Revised by wenfeng, Aug.17, 2011
	// review convex-hull generation algorithm after 7 years
	// the major challenge lies in co-planar vertices, try to handle this case.

	CHalfSpace hsFitPlane;
	A3DVECTOR3 vFitNormal(0.0f);
	bool bFit = BestFitPlane(m_pVertexes, m_nVNum, hsFitPlane, m_fIdenticalPosErr);
	if(bFit)
	{
		// tune the vertices's position to make the convex-hull generation more accurately...
		for(int i=0; i<m_nVNum; i++)
		{
			hsFitPlane.ProjectPos2Plane(m_pVertexes[i]);
		}
	}

	vFitNormal = hsFitPlane.GetNormal();
	if(vFitNormal.IsZero())
		vFitNormal.Set(0.0f, 1.0f, 0.0f);

	//////////////////////////////////////////////////////////////////////////
	// Noted by wenfeng, 05-01-31
	// ͹Ĺһ̶CHalfSpaceľֵ
	// ｫ跨ҵһԵõȷľֵ
	// һҪܷ͹ֵǵĹϵֵԽԽС
	// һԵõʵϣֵһ΢СŶܵ쳣ֻ͹
	// Ŀǰûҳ֮ıȻϵ͹ɡ
	// ˣĿǰֵ趨˿ȵĳԷ˵£
	// ȳһֵhsDistThreshBaseȻֵΪhsDistThreshBase0.1
	// ֱֵ<CH_FLT_EPSILON
	// еֵԲҪhsDistThreshBase-0.1*hsDistThreshBase
	// Ȼѭ
	// ɿķķ
	//////////////////////////////////////////////////////////////////////////
	

	float hsDistThreshBase=m_fInitHSDistThresh*10.0f;	//ÿεݼѭĻȷŴ10
	float hsDistThreshBaseStep=m_fInitHSDistThresh;		//ݼ
	float hsDistThresh;			//ǰֵ
	
	//֤û쳣͹
	//˫ѭ
	do{
	
		hsDistThresh=hsDistThreshBase;
		do{
			
			m_nHullType=HULL_3D;						//¼ʱʼΪ3D͹

			hsDistThresh*=0.1f;								//Сֵ10

			CHalfSpace::SetDistThresh(hsDistThresh);	//ֵ
			
			//ȵøຯӶղ
			CConvexHullAlgorithm::ComputeConvexHull();
			ResetSameVertices();

			Edge e=SearchFirstEdge(vFitNormal);

			//by yx, August 29, 2011
			if (!ValidateCHPlane(CHalfSpace(m_pVertexes[e.start], m_pVertexes[e.end], m_pVertexes[e.start] + vFitNormal)))
			{
				A3DVECTOR3 vAxis[3] = { A3DVECTOR3(1, 0, 0), A3DVECTOR3(0, 1, 0), A3DVECTOR3(0, 0, 1) };
				for (int i = 0; i < 3; i++)
				{
					if (fabsf(DotProduct(vFitNormal, vAxis[i])) > 0.9f)
						continue;
					
					A3DVECTOR3 vN = CrossProduct(vFitNormal, vAxis[i]);
					Edge e1 = SearchFirstEdge(vN);
					if (ValidateCHPlane(CHalfSpace(m_pVertexes[e1.start], m_pVertexes[e1.end], m_pVertexes[e1.start] + vN)))
					{
						e = e1;
						break;
					}
				}
			}

			m_eFirst=e;
			m_EdgeStack.Push(e);
			m_EdgeStack.Push(e);			//ע⣬ӦpushΣӶ֤whileеĵһ߱ջУ
			
			while(!m_EdgeStack.IsEmpty() && !m_bExceptionOccur && m_nHullType==HULL_3D)
			{
				e=m_EdgeStack.Pop();
				DealE(e);
			}
			
		}while( ExceptionOccur()  && hsDistThresh>CH_FLT_EPSILON);
		
		hsDistThreshBase-=hsDistThreshBaseStep;		//ѭٽһŶ

	}while( ExceptionOccur() && hsDistThreshBase>0.0f);

	if(hsDistThreshBase<=0.0f)
	{
		//˵ѾֵΧ쳣
		//˵ȷʵģ͵͹Ǽ쳣
		m_bExceptionOccur=true;
	}

	//hsDistThresh*=0.01f;	
	//CHalfSpace::SetDistThresh(hsDistThresh);  //ָȱʡֵ
	
	CHalfSpace::SetDistThresh();  //ָȱʡֵ
}

/////////////////////////////////////////////////////////
// added by wenfeng,2004.8.20
// SearchV()ĸĽʹԴ㹲
/////////////////////////////////////////////////////////
bool CGiftWrap::DealE(Edge e)
{
	int i;
	for(i=0;i==(int)e.start || i==(int)e.end || IsFaceInCH(Face(e.start,e.end,i)) || m_pbVInvalid[i];i++);

	//e͸õɵİռ䣬ʱhsضЧΪ֤˲
	CHalfSpace hs(m_pVertexes[e.start],m_pVertexes[e.end],m_pVertexes[i]);

	AArray<int,int>* pCoPlanarVertexes=new AArray<int,int>;	//һйб
	AArray<int,int>& CoPlanarVertexes=*pCoPlanarVertexes;
	CoPlanarVertexes.Add(i);			//ӵǰһԪ
	//ʼѭעѭʼһԪؿʼ
	for(i++;i<m_nVNum;i++)
	{
		//e˵㣬ûпҲڰռڲ
		if(i!=(int)e.start && i!=(int)e.end && !m_pbVInvalid[i] && !IsFaceInCH(Face(e.start,e.end,i)) && ! hs.Inside(m_pVertexes[i]))	
		{
			if(hs.OnPlane(m_pVertexes[i]))
			{
				//ڰռı߽ϣӵб
				CoPlanarVertexes.Add(i);			//ӵǰ
				
			}
			else
			{

				//˵õ㲻ڲõΪµĿ㣬عռ
				hs.Set(m_pVertexes[e.start],m_pVertexes[e.end],m_pVertexes[i]);

				//ͬʱչбõб
				CoPlanarVertexes.RemoveAll();
				CoPlanarVertexes.Add(i);			//ӵǰ

				//ע⣬͹ǵʣﲻͷʼ

			}
		}

	}
	
	//ѭCoPlanarVertexesоʹ洢ɵǰeҵһ͹ϵе

	//жǷ2D͹
	m_nHullType=HULL_2D;
	for(i=0;i<m_nVNum;i++)			//ж
	{
		if(i!=(int)e.start && i!=(int)e.end && !m_pbVInvalid[i])	//eĶ˵㣬Ч
		{
			if(!IsVInVSets(i,pCoPlanarVertexes))	// ǰ㲻ٹ漯У
			{
				// Added by wenfeng, 05-5-9
				// һжϣӶʹý
				CHalfSpace hs(m_pVertexes[e.start], m_pVertexes[e.end], m_pVertexes[CoPlanarVertexes[0]]);
				if(hs.OnPlane(m_pVertexes[i]))
					CoPlanarVertexes.Add(i);
				else
				{
					m_nHullType=HULL_3D;
					break;
				}
			}
		}
	}


	//濪ʼдｫԭComputeConvexHullѭеĴ
	if(CoPlanarVertexes.GetSize()==1)		
	{
		//򵥵ûй
		
		int v3=CoPlanarVertexes[0];
		//ѹջ
		Edge e1(e.start,v3),e2(v3,e.end);
		SelectivePushStack(e1);	//m_EdgeStack.CheckPush(e1);
		SelectivePushStack(e2);	//m_EdgeStack.CheckPush(e2);

		//Ƭ
		m_Faces.Add(Face(e.start,e.end,v3));
		//ͬʱƬΪ͹ǵExtremeVertex!
		m_pbExtremeVertex[e.start]=true;
		m_pbExtremeVertex[e.end]=true;
		m_pbExtremeVertex[v3]=true;

		if(m_nHullType==HULL_2D)			// ͹Ϊһε
		{
			CoPlanarVertexes.Add(e.start);
			CoPlanarVertexes.Add(e.end);
			m_Planes.Add(pCoPlanarVertexes);
		}
		else
			delete pCoPlanarVertexes;				//ûж㹲

	}
	else		//㹲
	{
		//e.start,e.endCoPlanarVertexes[0]ɵƽ͹
		DealCoPlanarV(e,CoPlanarVertexes);

	}


	return true;
}

/////////////////////////////////////////////////////////
// added by wenfeng,2004.8.20
// úڱeҵĿǶ㹲
// ע⣬еCoPlanarVertexesĵӦ>1
/////////////////////////////////////////////////////////
void CGiftWrap::DealCoPlanarV(Edge e, AArray<int,int> & CoPlanarVertexes)
{
	/*
	//÷ʱʹãwenfeng 04-12-02
	
	 //Revised by He wenfeng, 2004-11-29
	//㣺v1,v2,v3Ķλý
	//ʹͶӰv1,v2,v3ɵƽϣ
	
	CHalfSpace Plane(m_pVertexes[e.start],m_pVertexes[e.end],m_pVertexes[CoPlanarVertexes[0]]);
	for(int j=1;j<CoPlanarVertexes.GetSize();j++)
	{
		A3DVECTOR3 vDiff=m_pVertexes[CoPlanarVertexes[j]]-m_pVertexes[e.start];
		vDiff=DotProduct(vDiff,Plane.GetNormal())*Plane.GetNormal();
		m_pVertexes[CoPlanarVertexes[j]]-=vDiff;
	}
	//*/
	
	AArray<int,int> *parrCoPlanarVertexes=&CoPlanarVertexes;

	//ָñߵЧֱӷ
	if(m_pbVInvalid[e.start]||m_pbVInvalid[e.end])
	{
		//쳣˳ʱһҪͷڴ
		delete parrCoPlanarVertexes;
		return;
	}

	//ʼhalfspace
	//ע⹹ķhalfspaceķָe.endCoPlanarVertexes[0]ͬʱƽڷ
	CHalfSpace hs;
	
	AArray<int,int> ExtremeVertexes;				//ƽе͹ǵ㼯洢

	AArray<int,int> CoLinearVertexes;				//ߵһ㼯ʾ
	//CoLinearVertexes.Add(CoPlanarVertexes[0]);

	//e.starte.endҲCoPlanarVertexes
	CoPlanarVertexes.Add(e.start);
	CoPlanarVertexes.Add(e.end);
	


	
	//µ㷨УÿeѾ쵽ˣÿ
	//ܽ
	//޸2004-8-25

	int vidNotCL=CoPlanarVertexes[0];		
	//CoPlanarVertexes[0]һeߵ
	//vidNotCLƽķ
	A3DVECTOR3 normal=CrossProduct(m_pVertexes[e.end]-m_pVertexes[e.start],m_pVertexes[vidNotCL]-m_pVertexes[e.start]);
	normal.Normalize();

	Edge curE(e.end,vidNotCL);						//ǰı

	//΢04-10-19
	//whileܻѭ˱ж
	int vSize=CoPlanarVertexes.GetSize();

	//main loop
	while(curE.start!=e.start)				//ҵe.startһʱҵе㴦͹ϵĵ
	{
		//ʼhs
		hs.Set(m_pVertexes[curE.start],m_pVertexes[curE.end],m_pVertexes[curE.start]+normal);
		
		CoLinearVertexes.RemoveAll();
		CoLinearVertexes.Add(curE.end);		//ǰߵ㼯

		//Ѱ㵱ǰcurEĿ
		int i;
		for(i=0;i<CoPlanarVertexes.GetSize();i++)
		{
			int id=CoPlanarVertexes[i];
			if(id!=(int)curE.start &&
				id!=(int)curE.end &&
				!m_pbVInvalid[id] &&			//ΪЧ㣡
				!hs.Inside(m_pVertexes[id]))
			{
				//жǷ棬ʵΪǷ
				if(hs.OnPlane(m_pVertexes[CoPlanarVertexes[i]]))
				{
					//eߵ
					//if(CoPlanarVertexes[i]!=e.start && CoPlanarVertexes[i]!=e.end)
						//&& DotProduct(m_pVertexes[curE.end]-m_pVertexes[curE.start],m_pVertexes[CoPlanarVertexes[i]]-))
					CoLinearVertexes.Add(CoPlanarVertexes[i]);
				}
				else
				{
					//ĵǰ
					curE.end=CoPlanarVertexes[i];
					//¼halfspace
					hs.Set(m_pVertexes[curE.start],m_pVertexes[curE.end],m_pVertexes[curE.start]+normal);

					//գ¼㹲ߵ㼯
					CoLinearVertexes.RemoveAll();
					CoLinearVertexes.Add(CoPlanarVertexes[i]);

				}
			}
		}
		//ѭɣʱӦѾҵһһ㼯
		if(CoLinearVertexes.GetSize()==1)
		{
			//һ
			//͹Ǳ߽㼯
			ExtremeVertexes.Add(CoLinearVertexes[0]);
			//ҵĵΪǰߵ
			curE.start=CoLinearVertexes[0];

			//һΪcurE.end
			int i;
			for(i=0;i<CoPlanarVertexes.GetSize() && CoPlanarVertexes[i]==(int)curE.start;i++);	//ܵstart!
			curE.end=CoPlanarVertexes[i];

			vSize--;
			if(vSize<0)
			{
				this->m_bExceptionOccur=true;		//쳣ˣ˳
				
				//쳣˳ʱһҪͷڴ
				delete parrCoPlanarVertexes;

				return;
			}

		}
		else
		{
			//04-10-30
			//ֻԶ㣬ûҪһ
			
			//㼯
			//㵽curE.startŷϾԶ򣬴ӽԶ
			SortByDist(curE.start,CoLinearVertexes);



			//ΪԶ
			curE.start=CoLinearVertexes[CoLinearVertexes.GetSize()-1];
			//Զ㣡
			ExtremeVertexes.Add(curE.start);

			//һΪcurE.end
			for(i=0;i<CoPlanarVertexes.GetSize() && (CoPlanarVertexes[i]==(int)curE.start || m_pbVInvalid[CoPlanarVertexes[i]]);i++);	//ܵstart!
			assert(i<CoPlanarVertexes.GetSize());
			curE.end=CoPlanarVertexes[i];			

			vSize--;
			if(vSize<0)
			{
				this->m_bExceptionOccur=true;		//쳣ˣ˳
				//쳣˳ʱһҪͷڴ
				delete parrCoPlanarVertexes;

				return;
			}

		}

	} // end of main loop

	//ע⣬ǰѭExtremeVertexesһԪӦþe.start
	//assert(ExtremeVertexes.GetSize()>1);
	if(ExtremeVertexes.GetSize()<=1)
	{
		m_bExceptionOccur=true;		//˵쳣˳
		//쳣˳ʱһҪͷڴ
		delete parrCoPlanarVertexes;
		return;
	}

	//ʱѾõһ鰴˳Ķ㣬߶ջб
	Edge ep(ExtremeVertexes[0],e.end);
	SelectivePushStack(ep);	//m_EdgeStack.CheckPush(ep);
	m_Faces.Add(Face(e.start,e.end,ExtremeVertexes[0],true)); //潫ʷ
	
	int i;
	for(i=0;i<ExtremeVertexes.GetSize()-2;i++)
	{
		//ӱߵջһҪע˳
		ep.Set(ExtremeVertexes[i+1],ExtremeVertexes[i]);		//Ӧ÷
		SelectivePushStack(ep);	//m_EdgeStack.CheckPush(ep);
		m_Faces.Add(Face(e.start,ExtremeVertexes[i],ExtremeVertexes[i+1],true));
		
	}
	//һ
	//ע⣺ԸñߵĴӦֱʹm_EdgeStack.CheckPush
	//ΪǰѾ˰ñߵ棬
	//ʹSelectivePushStackΪñѾ
	//ӵбУӶ©ߣ
	//ᵼ͹ȱһ棡
	ep.Set(ExtremeVertexes[i+1],ExtremeVertexes[i]);
	m_EdgeStack.CheckPush(ep);

	//й㶼ΪЧ
	for(i=0;i<CoPlanarVertexes.GetSize();i++)
		m_pbVInvalid[CoPlanarVertexes[i]]=true;

	//CoPlanarVertexesʹ߽
	CoPlanarVertexes.RemoveAll();	
	//e.end뵽ExtremeVertexes
	ExtremeVertexes.Add(e.end);
	//Ȼб߽ΪЧ
	for(i=0;i<ExtremeVertexes.GetSize();i++)
	{
		m_pbVInvalid[ExtremeVertexes[i]]=false;
		m_pbExtremeVertex[ExtremeVertexes[i]]=true;
		CoPlanarVertexes.Add(ExtremeVertexes[i]);
	}
	
	//ʱٽCoPlanarVertexes뵽m_Planes
	//е㹹ɵƽm_Planes
	m_Planes.Add(&CoPlanarVertexes);


}

/////////////////////////////////////////////////////////
// added by wenfeng,2004.8.20
// յvԶvListеĵ㣬
/////////////////////////////////////////////////////////
void CGiftWrap::SortByDist(int v, AArray<int,int> & vList)
{
	if(vList.GetSize()<2) return;

	//ȼ
	float* pDist=new float[vList.GetSize()];
	int i;
	for(i=0;i<vList.GetSize();i++)
		pDist[i]=(m_pVertexes[vList[i]]-m_pVertexes[v]).SquaredMagnitude();

	int minDistID;
	int tmp;			//
	//ݾ
	for(i=0;i<vList.GetSize();i++)
	{
		minDistID=i;
		for(int j=i+1;j<vList.GetSize();j++)
			if(pDist[j]<pDist[minDistID])
				minDistID=j;
		//ѭɨһ飬ҵiGetSize()оСĵ

		//ʼ
		tmp=vList[i];
		vList[i]=vList[minDistID];
		vList[minDistID]=tmp;
		
		//ͬʱ
		pDist[minDistID]=pDist[i];

	}

	delete [] pDist;
}

//жϿռǷ
bool CGiftWrap::IsTriVsCoLinear(int v1, int v2, int v3)
{
	A3DVECTOR3 vd1=m_pVertexes[v2]-m_pVertexes[v1],vd2=m_pVertexes[v3]-m_pVertexes[v1];
	vd1.Normalize();
	vd2.Normalize();

	if(1- ABS(DotProduct(vd1,vd2)) < 0.00006f)
		return true;
	else return false;

	
}

//жϱe͵v֮Ĺϵ
//ֵ£
//0:ve⣡
//1:vֱeϣ߶e࣬e.start
//2:vֱeϣ߶eҲ࣬e.end
//3:v߶e
//-1:ve.startغ
//-2:ve.endغ
int CGiftWrap::EVRelation(const Edge& e, int v)
{
	if(v==(int)e.start) return -1;
	if(v==(int)e.end) return -2;

	if(!IsTriVsCoLinear(e.start,e.end,v)) return 0;

	A3DVECTOR3 de=m_pVertexes[e.end]-m_pVertexes[e.start];		//߶εķ
	A3DVECTOR3 vd1=m_pVertexes[v]-m_pVertexes[e.start];
	A3DVECTOR3 vd2=m_pVertexes[v]-m_pVertexes[e.end];

	if(DotProduct(vd1,vd2)<0.0f) return 3;		//߶e

	if(DotProduct(vd1,de)>0.0f) return 2;

	return 1;

}

//Ѱҵһߣ
Edge CGiftWrap::SearchFirstEdge(const A3DVECTOR3& vRefNormal)
{
	Edge e;
	//ѰyȡֵСһ
	AArray<int,int> LowestVertexes;
	float yMin=m_pVertexes[0].y;
	LowestVertexes.Add(0);
	int i;
	for(i=1;i<m_nVNum;i++)
	{
		if(yMin-m_pVertexes[i].y>m_fIdenticalPosErr)	// ˵yMinС
		{
			yMin=m_pVertexes[i].y;
			LowestVertexes.RemoveAll();
			LowestVertexes.Add(i);
		}
		else if( ABS(yMin-m_pVertexes[i].y)<m_fIdenticalPosErr)
		{
			//
			LowestVertexes.Add(i);
		}

	}

	//ѭɺLowestVertexesyֵСһ㼯
	if(LowestVertexes.GetSize()==1) //һ
	{
		e.start=LowestVertexes[0];

		//Ѱҵ2㣬ΪXOYƽѰң
		for(i=0;i==(int)e.start;i++);
		
		// vRefNormalƽ...
		CHalfSpace hs(m_pVertexes[e.start],m_pVertexes[i], m_pVertexes[e.start] + vRefNormal);

		AArray<int,int> CoPlanarVertexes;
		CoPlanarVertexes.Add(i);			//ӵǰһԪ		
		for(i++;i<m_nVNum;i++)
			if(i!=(int)e.start && !hs.Inside(m_pVertexes[i]))
			{
                if(hs.OnPlane(m_pVertexes[i]))
					CoPlanarVertexes.Add(i);			//ӵǰ
				else
				{
					//˵õ㲻ڲõΪµĿ㣬عռ
					hs.Set(m_pVertexes[e.start],m_pVertexes[i], m_pVertexes[e.start] + vRefNormal);

					//ͬʱչбõб
					CoPlanarVertexes.RemoveAll();
					CoPlanarVertexes.Add(i);			//ӵǰ

				}
            }
		
		if(CoPlanarVertexes.GetSize()==1)
		{
			//һ㣬õ㼴Ϊe.end
			e.end=CoPlanarVertexes[0];
			return e;
		}
		else
		{
			//жһ㹲
			A3DVECTOR3 vd3=hs.GetNormal();
			//ʼhalfspace
			hs.Set(m_pVertexes[e.start],m_pVertexes[CoPlanarVertexes[0]],m_pVertexes[e.start]+vd3);
			AArray<int,int> CoLinearVertexes;
			CoLinearVertexes.Add(CoPlanarVertexes[0]);
			for(i=1;i<CoPlanarVertexes.GetSize();i++)
				if(!hs.Inside(m_pVertexes[CoPlanarVertexes[i]]))
				{
                    if(hs.OnPlane(m_pVertexes[CoPlanarVertexes[i]]))
						CoLinearVertexes.Add(CoPlanarVertexes[i]);
					else
					{

						//¼halfspace
						hs.Set(m_pVertexes[e.start],m_pVertexes[CoPlanarVertexes[i]],m_pVertexes[e.start]+vd3);

						//գ¼㹲ߵ㼯
						CoLinearVertexes.RemoveAll();
						CoLinearVertexes.Add(CoPlanarVertexes[i]);
					}
                }
			//ѭ
			if(CoLinearVertexes.GetSize()==1)
			{
				//һߵ㣬õ㼴Ϊһ˵
				e.end = CoLinearVertexes[0];
				return e;
			}
			else
			{
				//Թߵ㼯о
				SortByDist(e.start,CoLinearVertexes);

				//ԶΪeһ˵㣬ΪЧ
				for(int i=0;i<CoLinearVertexes.GetSize()-1;i++)
					m_pbVInvalid[CoLinearVertexes[i]]=true;

				e.end=CoLinearVertexes[CoLinearVertexes.GetSize()-1];
				return e;
			}
		}


	}
	else
	{
		//yȡСֵһ
		//ֻXOZƽϿǼ
		if(LowestVertexes.GetSize()==2)		//㣬ֱӷ
		{
			e.start=LowestVertexes[0];
			e.end=LowestVertexes[1];
			return e;
		}
		//zֵȡСĵ㼯
		AArray<int,int> ZMinVertexes;
		float ZMin=m_pVertexes[LowestVertexes[0]].z;
		ZMinVertexes.Add(LowestVertexes[0]);
		for(i=1;i<LowestVertexes.GetSize();i++)
		{
			if(ZMin-m_pVertexes[LowestVertexes[i]].z>m_fIdenticalPosErr)	// ˵yMinС
			{
				ZMin=m_pVertexes[LowestVertexes[i]].z;
				ZMinVertexes.RemoveAll();
				ZMinVertexes.Add(LowestVertexes[i]);
			}
			else if( ABS(ZMin-m_pVertexes[LowestVertexes[i]].z)<m_fIdenticalPosErr)
			{
				//
				ZMinVertexes.Add(LowestVertexes[i]);
			}

		}
		
		if(ZMinVertexes.GetSize()==1)		
		{
			//õͱΪһ
			e.start=ZMinVertexes[0];
			AArray<int,int> CoLinearVertexes;
			
			//LowestVertexesпʼѰһ
			for(i=0;LowestVertexes[i]==(int)e.start;i++);
			CoLinearVertexes.Add(LowestVertexes[i]);
			A3DVECTOR3 vd3=A3DVECTOR3(0.0f,-1.0f,0.0f);
			CHalfSpace hs(m_pVertexes[e.start],m_pVertexes[LowestVertexes[i]],m_pVertexes[e.start]+vd3);

			for(i++;i<LowestVertexes.GetSize();i++)
				if(LowestVertexes[i]!=(int)e.start && !hs.Inside(m_pVertexes[LowestVertexes[i]]))
				{
                    if(hs.OnPlane(m_pVertexes[LowestVertexes[i]]))
						CoLinearVertexes.Add(LowestVertexes[i]);
					else
					{

						//¼halfspace
						hs.Set(m_pVertexes[e.start],m_pVertexes[LowestVertexes[i]],m_pVertexes[e.start]+vd3);

						//գ¼㹲ߵ㼯
						CoLinearVertexes.RemoveAll();
						CoLinearVertexes.Add(LowestVertexes[i]);
					}
                }
			
			//ѭ
			if(CoLinearVertexes.GetSize()==1)
			{
				//һߵ㣬õ㼴Ϊһ˵
				e.end = CoLinearVertexes[0];
				return e;
			}
			else
			{
				//Թߵ㼯о
				SortByDist(e.start,CoLinearVertexes);

				//ԶΪeһ˵㣬ΪЧ
				for(i=0;i<CoLinearVertexes.GetSize()-1;i++)
					m_pbVInvalid[CoLinearVertexes[i]]=true;

				e.end=CoLinearVertexes[CoLinearVertexes.GetSize()-1];
				return e;
			}			
		}
		else
		{
			//ж㶼ȡzС
			//ҳxС
			int xminID=ZMinVertexes[0],xmaxID=ZMinVertexes[0];
			float XMin=m_pVertexes[ZMinVertexes[0]].x;
			float XMax=m_pVertexes[ZMinVertexes[0]].x;
			for(i=1;i<ZMinVertexes.GetSize();i++)
			{
				if(XMin-m_pVertexes[ZMinVertexes[i]].x>m_fIdenticalPosErr)	// ˵xMinС
				{
					XMin=m_pVertexes[ZMinVertexes[i]].x;
					xminID=ZMinVertexes[i];
				}
				if(m_pVertexes[ZMinVertexes[i]].x-XMax>m_fIdenticalPosErr)	// ˵xMinС
				{
					XMax=m_pVertexes[ZMinVertexes[i]].x;
					xmaxID=ZMinVertexes[i];
				}
			}

			//ZMinVertexesеΪЧ
			for(i=0;i<ZMinVertexes.GetSize();i++)
				m_pbVInvalid[ZMinVertexes[i]]=true;
			
			m_pbVInvalid[xmaxID]=false;
			m_pbVInvalid[xminID]=false;
			m_pbExtremeVertex[xmaxID]=true;
			m_pbExtremeVertex[xminID]=true;

			e.start=xminID;
			e.end=xmaxID;
			return e;
		}

	}

}


// some interface for outer step-by-step call
bool CGiftWrap::IsOver() const
{
	return m_EdgeStack.IsEmpty();
}



void CGiftWrap::GoOneStep()
{
	Edge e;
	e=m_EdgeStack.Pop();
	DealE(e);	
}

void CGiftWrap::Start()
{
		//ȵøຯӶղ
	CConvexHullAlgorithm::ComputeConvexHull();
	Edge e=SearchFirstEdge();
	m_EdgeStack.Push(e);
	m_EdgeStack.Push(e);			//ע⣬ӦpushΣӶ֤whileеĵһ߱ջУ

	m_eFirst=e;
}

void CGiftWrap::Reset()
{
	CConvexHullAlgorithm::Reset();
	m_EdgeStack.Clear();
	m_bExceptionOccur=false;
}

void CGiftWrap::ResetSameVertices()
{
	CConvexHullAlgorithm::Reset();
	m_EdgeStack.Clear();
	m_bExceptionOccur=false;

	//ʼ͹Ǳ߽㼯״̬
	m_pbVInvalid=new bool[m_nVNum];
	m_pbExtremeVertex=new bool[m_nVNum];

	for(int i=0;i<m_nVNum;i++)
	{
		m_pbVInvalid[i]=false;
		m_pbExtremeVertex[i]=false;
	}

	//*m_pnIDsNum=0;		//ͷʼ
}

//ѡѹջ
//eǷѾˣ
//ǷѾѹջ
//ѹջ
//򣬽ѭ
void CGiftWrap::SelectivePushStack(const Edge& e)
{
	if(m_EdgeStack.CheckPush(e))
	{
		//ѹջɹѹջǰջûe
		//ʱӦжϸñǷѾ
		if(IsEdgeInCH(e))
		{
			//£㷨һ3
			//ʵˣ쳣
			m_bExceptionOccur=true;		//˵쳣
			
			m_EdgeStack.Pop();		//new interface!
		}

	}
}

//㱣浽ļ
bool CGiftWrap::SaveVerticesToFile(const char *szFileName)
{
	FILE* OutFile = fopen(szFileName, "wt");;

	if(!OutFile)
		return false;

	fprintf(OutFile, "%d\n", m_nVNum);		//
	for(int i=0;i<m_nVNum;i++)
		fprintf(OutFile, "%f %f %f\n", m_pVertexes[i].x, m_pVertexes[i].y, m_pVertexes[i].z);
	
	fclose(OutFile);
	return true;
}

//ļжȡϢ
bool LoadVerticesFromFile(const char *szFileName,int& nVNum,A3DVECTOR3* & pVertices )
{
	FILE* InFile = fopen(szFileName, "rt");;
	if(!InFile)
		return false;

	fscanf(InFile, "%d\n", nVNum);
	pVertices=new A3DVECTOR3[nVNum];
	for(int i=0;i<nVNum;i++)
		fscanf(InFile,"%f %f %f\n",&pVertices[i].x,&pVertices[i].y,&pVertices[i].z);
	
	fclose(InFile);
	return true;

}

bool CGiftWrap::ValidConvexHull()
{
	// 鹲ĶǷֶ㵽ƽľ볬ֵ
	CHalfSpace hs;
	for(int i=0; i<m_Planes.GetSize(); i++ )
	{
		if (m_Planes[i]->GetSize() < 3)
			continue;

		hs.Set(m_pVertexes[m_Planes[i]->GetAt(0)], m_pVertexes[m_Planes[i]->GetAt(1)], m_pVertexes[m_Planes[i]->GetAt(2)]);

		for(int j=3; j<m_Planes[i]->GetSize(); j++)
		{
			if(fabs(hs.DistV2Plane(m_pVertexes[m_Planes[i]->GetAt(j)]) ) > CH_VALID_TOLERANCE )
				return false;
		}
	}

	return true;
}

//check if is validate convex hull plane, yx Aug. 29, 2011 
bool CGiftWrap::ValidateCHPlane(const CHalfSpace& hs)
{
	for (int i = 0; i < m_nVNum; i++)
	{
		if (!hs.Inside(m_pVertexes[i]) && !hs.OnPlane(m_pVertexes[i]))
			return false;
	}
	return true;
}

}	// end namespace


