//////////////////////////////////////////////////////////////////////
//	Created by He wenfeng
//  2005-01-10
//  A class derived from the class CConvexHullData 
//  It is used for Collision Detection and Path finding in 2 2D environment.
//  It uses the form of CConvexHullData, while, in fact it only represents a 2D obstruct
//  To note is that it is not  convex when it describes the Terrain obstruct or water area!
//////////////////////////////////////////////////////////////////////

#ifndef _2DOBSTRUCT_H_
#define _2DOBSTRUCT_H_

#include "convexhulldata.h"

#include <vector.h>
using namespace abase;

//extern ALog g_Log;

namespace CHBasedCD
{

class C2DObstruct : public CConvexHullData  
{
	//
	enum 
	{
		CLOCKWISE=1,
		ANTICLOCKWISE
	};

public:

	C2DObstruct();
	virtual ~C2DObstruct();
	
	//ݽб任
	virtual void Transform(const A3DMATRIX4& mtxTrans);

	//////////////////////////////////////////////////////////////////////////
	// ļװ
	// ˳Աm_arrInflateVecs븲ǻķ
	//////////////////////////////////////////////////////////////////////////
	//ӦһļFILE
	virtual bool LoadFromStream(FILE* InFile);
	virtual bool SaveToStream(FILE* OutFile) const;

	/************************************************************************
	// Removed by wenfeng, 05-3-28
	// гstd::fstreamĿ⣬ҪVC֧֣

	//Ӧһļ
	virtual bool LoadFromStream(std::ifstream& InFile);
	virtual bool SaveToStream(std::ofstream& OutFile) const;
	/************************************************************************/

	// жĳһǷΪ㣡
	bool IsVertexConcave(int vid);

	//һ㼯ʼ㼯άʽЧĽΪx,z
	void Init(const vector<A3DVECTOR3>& Vertices, float fHeight=1.0f);

	///////////////////////////////////////////////////
	// ײƶ
	///////////////////////////////////////////////////

	//ײӦϢһм̵
	void GetCRInfo(CFace* pCDFace,const A3DVECTOR3& Dir,int& RotateDir,int& RelayVID,int CurRotateDir=0);

	
	//ݷҳһid
	inline int GetNextVID(int CurVID,int RotateDir);

	//ƷҵvidڽӵFace
	//vidӦǵϵidӦΪż
	inline CFace* GetFaceByVID(int vid, int RotateDir);

	A3DVECTOR3 GetInflateVector(int vid) {  return m_arrInflateVecs[vid]; }
	
	//Զһ
	A3DVECTOR3 GetInflateVertex(int vid, float fInflateSize)
	{
		return (m_arrVertices[vid]+fInflateSize*m_arrInflateVecs[vid>>1]);
	}

protected:
	//ǻķ
	virtual int ComputeBufSize() const;					//㱣浽AFileĻС
	virtual bool WriteToBuf(char* buf) const;		  //ȫд뵽bufУǰbufѾ
	virtual bool ReadFromBuf(char* buf);				//bufж

protected:
	
	//бӦÿһ2D㡣ײƶжԶ
	//ӦvΪvInflate,ڰ뾶Ϊr壬ö㽫v+r*vInflate
	AArray<A3DVECTOR3,const A3DVECTOR3&> m_arrInflateVecs;		

};

inline int C2DObstruct::GetNextVID(int CurVID,int RotateDir)
{
	if(RotateDir==ANTICLOCKWISE) 
	{
		return (CurVID+2)%GetVertexNum();
	}
	else if(RotateDir==CLOCKWISE )
	{
		return (CurVID+GetVertexNum()-2)%GetVertexNum();
	}
	return -1;			//һЧֵ
}

inline CFace* C2DObstruct::GetFaceByVID(int vid, int RotateDir)
{
	int fid;
	if(RotateDir==CLOCKWISE )
		fid=GetNextVID(vid,RotateDir);
	else
		fid=vid;
	fid=(fid>>1)+2;			//һҪעȼ >>!

	if(fid<0 || fid>GetFaceNum()-1)
		return NULL;
	
	//ע⣡Ӧʹ&m_arrFaces[i]
	return m_arrFaces[fid];
	
}

}	// end namespace

#endif // _2DOBSTRUCT_H_
