#pragma once

#include "TreeCtrlEx.h"

class CTreeBar : public CBCGPDockingControlBar
{
public:
	CTreeBar(void);
	virtual ~CTreeBar(void);
protected:
	//{{AFX_MSG(CTreeBar)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnPaint();
	afx_msg void OnTimer(UINT_PTR nIDEvent);
	virtual afx_msg void OnTreeSelectChanged(NMHDR* pNMHDR, LRESULT* pResult);
	virtual afx_msg void OnTreeRClick(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTreeEndLabelEdit(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnTreeBeginDrag(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnNewFolder();
	afx_msg void OnNewFile();
	afx_msg void OnDelete();	
	afx_msg void OnRename();
	afx_msg void OnContextMenu(CWnd* /*pWnd*/, CPoint /*point*/);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
protected:
	void				OnTreeLButtonDown(UINT nFlags, CPoint point);
	virtual void		OnTreeLButtonUp(UINT nFlags, CPoint point);
	void				OnTreeMouseMove(UINT nFlags, CPoint point);
	virtual BOOL		PreTranslateMessage(MSG* pMsg);	
protected:
	CTreeCtrlEx			m_wndTree;
	UINT				m_TimerTicks;		// Ķʱʱ
	UINT_PTR			m_nScrollTimerID;	// Ķʱ
	CPoint				m_HoverPoint;		// λ
	UINT_PTR			m_nHoverTimerID;	// жʱ
	DWORD				m_dwDragStart;		// һ̵ʱ
	bool				m_bDragging;		// ʶǷ϶
	CImageList*			m_pDragImage;		// ϶ʱʾͼб
	HTREEITEM			m_hItemDragSrc;		// ϶ıǩ
	HTREEITEM			m_hItemDragDest;	// ϶ıǩ
protected:
	CImageList			m_ImageList;
public:
	CTreeCtrlEx*		GetTree() { return &m_wndTree; }
	virtual BOOL		SetItemText(HTREEITEM hItem, LPCTSTR lpszText);
};
