#ifndef NX_PHYSICS_NXFIXEDJOINTDESC
#define NX_PHYSICS_NXFIXEDJOINTDESC
/*----------------------------------------------------------------------------*\
|
|					Public Interface to NVIDIA PhysX Technology
|
|							     www.nvidia.com
|
\*----------------------------------------------------------------------------*/
/** \addtogroup physics
  @{
*/

#include "Nxp.h"
#include "NxJointDesc.h"
/**
\brief Desc class for fixed joint.


<b>Platform:</b>
\li PC SW: Yes
\li GPU  : Yes [SW]
\li PS3  : Yes
\li XB360: Yes
\li WII	 : Yes

@see NxFixedJoint NxScene.createJoint()
*/
class NxFixedJointDesc : public NxJointDesc
	{
	public:
	/**
	\brief Constructor sets to default.
	*/
	NX_INLINE NxFixedJointDesc();	
	/**
	\brief (re)sets the structure to the default.	
	*/
	NX_INLINE void setToDefault();
	/**
	\brief Return true if the descriptor is valid.

	\return true if the current settings are valid
	*/
	NX_INLINE bool isValid() const { return !checkValid(); }
	/**
	\brief returns 0 if the current settings are valid
	*/
	NX_INLINE NxU32 checkValid() const;

	};

NX_INLINE NxFixedJointDesc::NxFixedJointDesc() : NxJointDesc(NX_JOINT_FIXED)	//constructor sets to default
	{
	setToDefault();
	}

NX_INLINE void NxFixedJointDesc::setToDefault()
	{
	NxJointDesc::setToDefault();
	}

NX_INLINE NxU32 NxFixedJointDesc::checkValid() const
	{
	return NxJointDesc::checkValid();
	}

/** @} */
#endif
//NVIDIACOPYRIGHTBEGIN
///////////////////////////////////////////////////////////////////////////
// Copyright (c) 2010 NVIDIA Corporation
// All rights reserved. www.nvidia.com
///////////////////////////////////////////////////////////////////////////
//NVIDIACOPYRIGHTEND
