/*
 * FILE: InterfaceWrapper.cpp
 *
 * DESCRIPTION:
 *
 * CREATED BY: duyuxin, 2006/7/11
 *
 * HISTORY:
 *
 * Copyright (c) 2006 Archosaur Studio, All Rights Reserved.
 */

#include "StdAfx.h"
#include "InterfaceWrapper.h"

///////////////////////////////////////////////////////////////////////////
//
//	Define and Macro
//
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//
//	Reference to External variables and functions
//
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//
//	Local Types and Variables and Global variables
//
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//
//	Local functions
//
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//
//	Implement CSkeletonWrapper
//
///////////////////////////////////////////////////////////////////////////

//	Initialize object
bool CSkeletonWrapper::Init()
{
	A3DSkeleton::Init();
	return true;
}

//	Release object
void CSkeletonWrapper::Release()
{
	A3DSkeleton::Release();
}

//	Load skeleton data form file
bool CSkeletonWrapper::Load(const char* szFile)
{
	return A3DSkeleton::Load(szFile);
}

///////////////////////////////////////////////////////////////////////////
//
//	Implement CSkinWrapper
//
///////////////////////////////////////////////////////////////////////////

	//	Initialize object
bool CSkinWrapper::Init(A3DEngine* pA3DEngine)
{
	A3DSkin::Init(pA3DEngine);
	return true;
}

//	Release object
void CSkinWrapper::Release()
{
	A3DSkin::Release();
}

///////////////////////////////////////////////////////////////////////////
//
//	Implement CTrackSetWrapper
//
///////////////////////////////////////////////////////////////////////////

//	Create a empty bone track
CTrackSetWrapper::BONETRACK* CTrackSetWrapper::CreateBoneTrack(int id)
{
	//	Ensure track id collision
	BONETRACK* pTrack = GetBoneTrack(id);
	if (pTrack)
	{
		ASSERT(!pTrack);
		return false;
	}

	if (!(pTrack = new BONETRACK))
		return false;

	memset(pTrack, 0, sizeof (BONETRACK));

	//	Add track to table
	m_TrackTab.put(id, pTrack);
	
	return pTrack;
}
