/*
 * FILE: PT_Sector.h
 *
 * DESCRIPTION: Sector routines
 *
 * CREATED BY: Duyuxin, 2003/6/12
 *
 * HISTORY:
 *
 * Copyright (c) 2001 Archosaur Studio, All Rights Reserved.	
 */

#ifndef	_PT_SECTOR_H_
#define _PT_SECTOR_H_

#include "PT_Internal.h"

/////////////////////////////////////////////////////////////////////////
//
//	Constants and Macros
//
/////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////
//
//	Types and Global variables
//
/////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////
//
//	Global functions
//
/////////////////////////////////////////////////////////////////////////

namespace PORTAL
{
	s_PTSECTOR* CreateSector(A3DVECTOR3* aVerts, WORD* aIndices, int iNumFace);
	s_PTPORTAL* CreatePortal(A3DVECTOR3* aVerts, int iNumVert, int iFront, int iBack, int iType);
	void ReleaseSector(s_PTSECTOR* pSector);
	void ReleasePortal(s_PTPORTAL* pPortal);
	bool LinkSectors();
	bool DispatchDrawSurfaces();
	bool PartSectors();
}

/////////////////////////////////////////////////////////////////////////
//
//	Inline functions
//
/////////////////////////////////////////////////////////////////////////


#endif	//	_PT_SECTOR_H_


