/*
 * FILE: Camera.h
 *
 * DESCRIPTION: Camera control
 *
 * CREATED BY: Duyuxin, 2004/4/19
 *
 * HISTORY:
 *
 * Copyright (c) 2001 Archosaur Studio, All Rights Reserved.	
 */

#ifndef _CAMERA_H_
#define _CAMERA_H_

///////////////////////////////////////////////////////////////////////////
//
//	Define and Macro
//
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//
//	Types and Global variables
//
///////////////////////////////////////////////////////////////////////////

class A3DCamera;

///////////////////////////////////////////////////////////////////////////
//
//	Declare of Global functions
//
///////////////////////////////////////////////////////////////////////////

bool Camera_Init(const char* szScriptFile);
void Camera_Release();

int Camera_AddTrackKey(A3DCamera* pA3DCamera);
bool Camera_SaveTrackToFile(const char* szFile);
void Camera_ResetTrack();

void Camera_BeginTrack(int iTrack);
bool Camera_UpdateTrack(int iDeltaTime, A3DCamera* pA3DCamera);

void Camera_BeginActions();
bool Camera_UpdateActions(int iDeltaTime, A3DCamera* pA3DCamera);

///////////////////////////////////////////////////////////////////////////
//
//	Inline functions
//
///////////////////////////////////////////////////////////////////////////


#endif	//	_CAMERA_H_
