#include "callid.hxx"

#ifdef WIN32
#include <winsock2.h>
#include "gnproto.h"
#include "gncompress.h"
#else
#include "protocol.h"
#include "binder.h"
#endif

namespace GNET
{

static GNET::Protocol::Type _state_GFactionServer[] = 
{
	PROTOCOL_ANNOUNCEZONEID,
	PROTOCOL_ANNOUNCEPROVIDERID,
	PROTOCOL_FACTIONCREATE,
	PROTOCOL_PLAYERSTATUSANNOUNCE,
	PROTOCOL_PLAYERFACTIONINFO,
	RPC_ANNOUNCEFACTIONROLEDEL,
	PROTOCOL_GETFACTIONBASEINFO,
	PROTOCOL_GETPLAYERFACTIONINFO,
	PROTOCOL_FACTIONOPREQUEST,
	PROTOCOL_FACTIONACCEPTJOIN,
	RPC_FACTIONINVITEJOIN,
	PROTOCOL_FACTIONLISTONLINE,
	PROTOCOL_BATTLECHALLENGEMAP_RE,
	PROTOCOL_CHATBROADCAST,
	PROTOCOL_FACTIONCHAT,
	PROTOCOL_SETCHATEMOTION,
	PROTOCOL_BATTLEFACTIONNOTICE,
	PROTOCOL_NOTIFYFACTIONFORTRESSID,
	PROTOCOL_ANNOUNCECENTRALDELIVERY,
	PROTOCOL_NOTIFYFACTIONPLAYERRENAME,
	RPC_DBFACTIONRENAME,
	PROTOCOL_FACTIONRESOURCEBATTLELIMITNOTICE,
	PROTOCOL_FACTIONUNIQUEIDANNOUNCE,
};

GNET::Protocol::Manager::Session::State state_GFactionServer(_state_GFactionServer,
						sizeof(_state_GFactionServer)/sizeof(GNET::Protocol::Type), 86400);

static GNET::Protocol::Type _state_GProviderFactionServer[] = 
{
	PROTOCOL_KEEPALIVE,
	PROTOCOL_ANNOUNCEPROVIDERID,
	PROTOCOL_FACTIONOPREQUEST,
	PROTOCOL_FACTIONBEGINSYNC_RE,
	PROTOCOL_PLAYERFACTIONINFO,
	PROTOCOL_BATTLEENTER,
	PROTOCOL_SENDBATTLECHALLENGE,
	PROTOCOL_FACTIONCHAT,
	PROTOCOL_CREATEFACTIONFORTRESS,
	PROTOCOL_GETPLAYERFACTIONRELATION,
	PROTOCOL_FACTIONCONGREGATEREQUEST,
	PROTOCOL_PLAYERSENDMASSMAIL,
	PROTOCOL_FACTIONRENAMEGSVERIFY_RE,
};

GNET::Protocol::Manager::Session::State state_GProviderFactionServer(_state_GProviderFactionServer,
						sizeof(_state_GProviderFactionServer)/sizeof(GNET::Protocol::Type), 86400);

static GNET::Protocol::Type _state_GFactionDBClient[] = 
{
	RPC_ADDFACTION,
	RPC_DELFACTION,
	RPC_ADDMEMBER,
	RPC_DELMEMBER,
	RPC_DELMEMBERSCHEDULE,
	RPC_UPDATEUSERFACTION,
	RPC_UPDATEFACTION,
	RPC_DBFACTIONUPGRADE,
	RPC_DBFACTIONPROMOTE,
	RPC_GETFACTIONINFO,
	RPC_GETUSERFACTION,
	RPC_GETFACTIONDETAIL,
	RPC_DBFACTIONALLIANCEAPPLY,
	RPC_DBFACTIONALLIANCEREPLY,
	RPC_DBFACTIONHOSTILEAPPLY,
	RPC_DBFACTIONHOSTILEREPLY,
	RPC_DBFACTIONREMOVERELATIONAPPLY,
	RPC_DBFACTIONREMOVERELATIONREPLY,
	RPC_DBFACTIONRELATIONTIMEOUT,
	RPC_DBFACTIONRELATIONAPPLYTIMEOUT,
};

GNET::Protocol::Manager::Session::State state_GFactionDBClient(_state_GFactionDBClient,
						sizeof(_state_GFactionDBClient)/sizeof(GNET::Protocol::Type), 86400);

static GNET::Protocol::Type _state_UniqueNameClient[] = 
{
	RPC_PRECREATEROLE,
	RPC_POSTCREATEROLE,
	RPC_POSTDELETEROLE,
	RPC_PRECREATEFACTION,
	RPC_POSTCREATEFACTION,
	RPC_POSTDELETEFACTION,
	RPC_PRECREATEFAMILY,
	RPC_POSTCREATEFAMILY,
	RPC_POSTDELETEFAMILY,
	RPC_PREPLAYERRENAME,
	RPC_PREFACTIONRENAME,
};

GNET::Protocol::Manager::Session::State state_UniqueNameClient(_state_UniqueNameClient,
						sizeof(_state_UniqueNameClient)/sizeof(GNET::Protocol::Type), 86400);


};

