
#ifndef __GNET_WEBPOSTCANCEL_HPP
#define __GNET_WEBPOSTCANCEL_HPP

#include "rpcdefs.h"
#include "callid.hxx"
#include "state.hxx"

#include "webpostcancel_re.hpp"

#include "webtrademarket.h"
#include "gwebtradeclient.hpp"

namespace GNET
{

class WebPostCancel : public GNET::Protocol
{
	#include "webpostcancel"

	void Process(Manager *manager, Manager::Session::ID sid)
	{
		// TODO
		DEBUG_PRINT("webpostcancel: receive. roleid=%lld,sn=%lld,ctype=%d\n",roleid,sn,ctype);
/*
WebPostCancel_Re
0.ɹ
1.snڣƽ̨ΪõӴɾõӣط 
2.ظȡۣƽ̨Ϊɹط 
3.ط
4.Ϸʧܣط 
5.Ϸ˸sn鵽roleidڣǽɫѱGMɾصԭgsƽ̨Ըôƽ̨Ϊɹط
6.ƷϷڴڡƽ̨ͬС״̬ϷƷڡƽ̨ͬС״̬ʱٴƽ̨߼ֱӷر룬ֱյƽ̨صReƽ̨յôκδط
7Ϸsn鵽useridƽָ̨useridһ£gsƽ̨Ըôƽ̨Ϊɹط
8Ϸsn鵽roleidƽָ̨roleidһ£gsƽ̨Ըôƽ̨Ϊɹط
-1.Ϸʧܣط
*/
		int retcode = WebTradeMarket::GetInstance().DoWebPostCancel(userid,roleid,sn,ctype,messageid,timestamp);
		if(retcode != ERR_SUCCESS)
		{
			WebPostCancel_Re re;
			re.userid = userid;
			re.roleid = roleid;
			re.sn = sn;
			re.messageid = messageid;
			switch(retcode)
			{
				default:
				case ERR_WT_UNOPEN:
					re.retcode = -1;
					break;
				case ERR_WT_ENTRY_NOT_FOUND:
					re.retcode = 1; 
					break;
				case ERR_WT_ENTRY_IS_BUSY:
					re.retcode = 6;
					break;
				case ERR_WT_TIMESTAMP_MISMATCH:	//ظȡ۵
					re.retcode = 0;
					break;
			}
			GWebTradeClient::GetInstance()->SendProtocol(re);
		}
	}
};

};

#endif
