#ifndef __GNET_TANK_BATTLE_MANAGER_H__
#define __GNET_TANK_BATTLE_MANAGER_H__

#include <vector>
#include <map>
#include <functional>

#include "itimer.h"
#include "tankbattleplayerscoreinfo"

namespace GNET
{

namespace TankBattleConfig
{
const char split_tag = ';';		//configַı
const bool only_one_battle_server = false;	//Ƿֻһսս
const size_t assign_count_each_tick = 10;	//ÿtickҷս,0Ļû
const int player_switch_time_out = 120;		//תͼĳʱʱ
const int server_create_time_out = 30;		//֪ͨgsսĳʱʱ
const int server_error_time_out = 60;		//ʱ
const int battle_man_wait_bonus_time = 600;	//ȴзرյʱ
const int battle_man_wait_bonus_time_out = 120;	//ȴзرյĳʱʱ
const int battle_man_before_close_time = 3600;	//رǰĽ͵ȴʱ
const int battle_close_clear_time = 60;	//ս೤ʱ֮ձսϢ
const int battle_close_time_out = 60;	//ս֮ĳʱʱ
const int max_battle_count = 50;	//ÿܿս
const int rank_show_count = 10;		//ͻʾаǰ
}

class TankBattleManager : public IntervalTimer::Observer
{
private:

	enum SERVER_STAT
	{
		SERVER_STAT_NORMAL,		//״̬Կµս
		SERVER_STAT_CREATE,		//ڿµĸ
		SERVER_STAT_DISCONNECT,	//ѾߣȲµս
		SERVER_STAT_ERROR,		//
		SERVER_STAT_FULL,		//Ѿ
	};
	
	enum BATTLE_MAN_STAT
	{
		BATTLE_MAN_STAT_CLOSE,		//ûп
		BATTLE_MAN_STAT_OPEN,		//ڿ״̬
		BATTLE_MAN_STAT_WAIT_BONUS,	//Ѿȴս֮
		BATTLE_MAN_STAT_BONUS,		//з䶼Ѿʼͷ
		BATTLE_MAN_STAT_WAIT_CLOSE,	//Ѿȴرս׶
	};

	enum BATTLE_STAT
	{
		BATTLE_STAT_CREATE,		//ڴĹ
		BATTLE_STAT_OPEN,		//ڿ״̬
		BATTLE_STAT_WAIT_CLOSE,	//սս
		BATTLE_STAT_CLOSE,		//ڹر״̬
	};

	enum PLAYER_STAT
	{
		PLAYER_STAT_APPLY,		//սȴ
		PLAYER_STAT_SWITCH,		//ת
		PLAYER_STAT_ENTER,		//Ѿս
		PLAYER_STAT_LEAVE,		//뿪ս
	};
	
	struct ServerInfo
	{
		int world_tag;
		int server_id;
		int battle_count;   //ǰ˶ٸս
		int time_stamp;		//serverһʱ
		SERVER_STAT stat;	//ǰĿ״̬

		ServerInfo()
		{
			world_tag = 0;
			server_id = 0;
			battle_count = 0;
			time_stamp = 0;
			stat = SERVER_STAT_NORMAL;
		}
	};
	
	struct BattleInfo
	{
		int battle_id;
		int world_tag;
		int end_time;		//սʱ
		int time_stamp;		//״̬仯ʱ
		BATTLE_STAT status;

		std::vector<int> players;

		BattleInfo()
		{
			battle_id = 0;
			world_tag = 0;
			end_time = 0;
			time_stamp = 0;
			status = BATTLE_STAT_CLOSE;
		}

		inline bool DelPlayer(int roleid)
		{
			std::vector<int>::iterator it = players.begin(),eit=players.end();
			for( ; it != eit; ++it)
			{
				if (*it == roleid)
				{
					players.erase(it);
					return true;
				}
			}
			return false;
		}
	};
	
	struct PlayerApplyEntry
	{
		int gameid;		//ұʱڵgameidͷʱ֤ͼ˲ý
		int model;		//ұʱѡģ
	};
	
	struct PlayerEntry
	{
		int roleid;
		int battle_id;
		time_t time_stamp;
		PLAYER_STAT stat;

		PlayerEntry()
		{
			roleid = 0;
			battle_id = 0;
			time_stamp = 0;
			stat = PLAYER_STAT_APPLY;
		}
	};
	
	struct PlayerBonus
	{
		int roleid;
		int rank;
		int bonus;
	};

	struct BonusEntry
	{
		int rank;
		int count;
	};
	
	typedef std::map<int/*roleid*/, PlayerApplyEntry> PLAYER_APPLY_MAP;
	typedef std::map<int/*world_tag*/, ServerInfo> SERVER_INFO_MAP;
	typedef std::map<int/*battleid*/, BattleInfo> BATTLE_MAP;
	typedef std::map<int/*roleid*/, PlayerEntry> PLAYER_ENTRY_MAP;
	typedef std::map<int/*roleid*/, TankBattlePlayerScoreInfo> PLAYER_SCORE_MAP;
	typedef std::vector<PlayerBonus> PLAYER_BONUS_VEC;
	typedef std::multimap<int/*score*/, TankBattlePlayerScoreInfo * , std::greater<int> > PLAYER_SCORE_RANK_MAP;
	typedef std::vector<const TankBattlePlayerScoreInfo *> TOP_SCORE_VEC;
	typedef std::vector<BonusEntry> BONUS_ENTRY_VEC;

	TankBattleManager():_status(BATTLE_MAN_STAT_CLOSE),_battle_index(1),_start_time(0),_end_time(0),
			_adjust_time(0),_min_time(0),_max_time(0),_max_player(0),_no_new_battle_time(0),_cant_enter_time(0),
			_second_of_day(0),_send_bonus_per_second(0),_calc_bonus(false),_bonus_item_id(0),_bonus_max_count(0),_bonus_proctype(0)
	{
		memset(_open_days,0,sizeof(_open_days));
	}

public:

	static TankBattleManager * GetInstance()
	{
		static TankBattleManager instance;
		return &instance;
	}

	bool Initialize();

	//սϢ
	void ResetBattleMgr();
	
	//õǰʱ
	inline void SetAdjustTime(int t) {_adjust_time = t;}

	//ս,ǰҪ֤Ч
	inline void SetMaxPlayer(int n) {_max_player = n;}

	//սʱʱ,ֻԺ¿սЧ,ǰҪ֤Ч
	inline void SetMinAndMaxTime(int min, int max) {_min_time=min;_max_time=max;}
	
	//սgsעϢ
	void RegisterServerInfo(int world_tag, int server_id);

	//սϢgs븱
	void StartBattle();

	//ս֮gsͷصĻص
	void OnBattleStart(int world_tag, int battleid, int retcode);

	//gs֪ͨս
	void OnBattleEnd(int world_tag, int battleid);

	//gsϿӣںǷս
	void DisableServerInfo(int world_tag);

	//ұμս
	void PlayerApply(int roleid, int model);

	//ҳɹս
	void PlayerEnterBattle(int roleid, int battle_id, int world_tag);

	//뿪ս
	void PlayerLeaveBattle(int roleid, int battle_id, int world_tag);
	
	//һϢ
	void PlayerScoreUpdate(int battle_id, int world_tag, const TankBattlePlayerScoreInfoVector & player_scores);

	//Ҳѯа
	int PlayerGetRank(int roleid, TankBattlePlayerScoreInfo & self_score, 
			TankBattlePlayerScoreInfoVector & player_scores) const;

private:

	bool Update();

	//ͻ˷սĽں߸roleidڲ
	void SendPlayerApplyRe(int roleid, int retcode, unsigned int linksid = 0, unsigned int localsid = 0);

	//ս״̬Ϣ
	void UpdateServerInfo(time_t nowtime);

	//սϢ
	void UpdateBattleInfo(time_t nowtime);

	//Ϣ
	void UpdatePlayerInfo(time_t nowtime);

	//(ȫ¼㣬ٵ)
	void CalcPlayerRank();

	//ҽ
	void CalcAllBonus();

	//㵥ҽ
	int CalcPlayerBonus(int rank);

	//бҷ
	int SendAllBonus();

	//ҷͽ
	void SendPlayerBonus(int roleid, int player_bonus, int rank);

	//ѡȡһпλõս
	BattleInfo * GetMostPlayerAndHaveVacancyBattle();

	//battle_idȡbattle_info
	BattleInfo * GetBattleByBattleID(int battle_id);

	//world_tagȡserver_info
	ServerInfo * GetServerInfoByWorldTag(int world_tag);

	//roleidȡplayer_entry
	PlayerEntry * GetPlayerEntryByRoleID(int roleid);

	//ȡǰʱ
	int GetTime() const;

	//ȡbattle_id
	inline int GetFreeBattleID() { return _battle_index++;}

private:

	BATTLE_MAN_STAT _status;	//ǰ״̬
	int _battle_index;	//ǰս,ֵ
	int _start_time;	//쿪ʼʱ䣬0ʱ
	int _end_time;		//ʱ䣬0ʱ
	int _adjust_time;	//ʱֵ()
	int _min_time;		//һսʱ()
	int _max_time;		//һսʱ()
	int _max_player;	//ս
	int _no_new_battle_time;	//೤ʱ䲻ս()
	int _cant_enter_time;	//ÿս೤ʱ䲻ս()
	int _second_of_day;		//ǰʱǴ0㿪ʼĶ,ÿUpdate
	int _send_bonus_per_second;	//ÿ뷢Ž
	bool _calc_bonus;		//ǷѾ
	unsigned char _open_days[7];	//ÿܼ(0 첻 1쿪)
	int _bonus_item_id;		//Ʒid
	int _bonus_max_count;	//Ʒĵ
	int _bonus_proctype;	//Ʒİ

	BATTLE_MAP _battle_map;
	SERVER_INFO_MAP _server_info_map;
	PLAYER_APPLY_MAP _player_apply_map;
	PLAYER_ENTRY_MAP _player_entry_map;
	PLAYER_SCORE_MAP _player_score_map;
	PLAYER_BONUS_VEC _player_bonus_vec;
	BONUS_ENTRY_VEC _bonus_entry_vec;
	TOP_SCORE_VEC _top_score_vec;
};

}
#endif
