
#ifndef __GNET_SHELF_HPP
#define __GNET_SHELF_HPP

#include "rpcdefs.h"
#include "callid.hxx"
#include "state.hxx"

#include "timeinfo"

namespace GNET
{

class Shelf : public GNET::Protocol
{
	#include "shelf"

	void Process(Manager *manager, Manager::Session::ID sid)
	{
		// TODO
		DEBUG_PRINT("shelf: receive. roleid=%lld,sn=%lld,price=%d,actiontime=%lld,showeriod=%d,sellperiod=%d,buyerroleid=%d\n",roleid,sn,price,time.actiontime,time.showperiod,time.sellperiod,buyerroleid);
/*
Shelf_Re
0.ɹ
1.snڣƽ̨ΪõӴɾõӣط 
2.ظϼ ƽ̨Ϊɹط
3.ط 
4. Ϸʧܣط 
5. Ϸ˸sn鵽roleidڣǽɫѱGMɾصԭgsƽ̨Ըôƽ̨Ϊɹط
6.ƷϷڴڡƽ̨ͬС״̬ ϷƷڡƽ̨ͬС״̬ʱٴƽ̨߼ֱӷر룬ֱյƽ̨صReƽ̨յôκδط
7Ϸsn鵽useridƽָ̨useridһ£ǽɫѱGMɾصԭgsƽ̨Ըôƽ̨Ϊɹط
8Ϸsn鵽roleidƽָ̨roleidһ£ǽɫѱGMɾصԭgsƽ̨Ըôƽ̨Ϊɹط
-1. Ϸʧܣط
*/
		int retcode = WebTradeMarket::GetInstance().DoShelf(userid,roleid,sn,price,time.actiontime,time.showperiod,time.sellperiod,buyerroleid,messageid,timestamp);
		if(retcode != ERR_SUCCESS)
		{
			Shelf_Re re;
			re.userid = re.userid;
			re.roleid = roleid;
			re.sn = sn;
			re.messageid = messageid;
			switch(retcode)
			{
				default:
				case ERR_WT_UNOPEN:
					re.retcode = -1;
					break;
				case ERR_WT_ENTRY_NOT_FOUND:
					re.retcode = 1; 
					break;
				case ERR_WT_ENTRY_IS_BUSY:
					re.retcode = 6;
					break;
				case ERR_WT_TIMESTAMP_MISMATCH:		//ظϼܵ
					re.retcode = 0;
					break;
			}
			GWebTradeClient::GetInstance()->SendProtocol(re);
		}
	}
};

};

#endif
