
#ifndef __GNET_ROLELIST_RE_HPP
#define __GNET_ROLELIST_RE_HPP

#include "rpcdefs.h"
#include "callid.hxx"
#include "state.hxx"
#include "roleinfo"
#include "rolelist.hpp"
#include "conv_charset.h"
#include "selectrole.hpp"

namespace GNET
{
	static char custom_default[][176] = {
{1,112,0,16,122,125,124,0,66,0,66,0,50,122,132,0,44,0,110,128,134,128,128,105,113,102,128,128,123,128,118,128,128,94,128,104,161,128,128,128,128,128,74,0,50,0,92,1,48,0,147,137,128,128,128,99,128,147,137,128,128,128,99,128,45,0,70,0,125,123,143,101,69,163,125,123,143,101,69,163,41,0,58,0,112,128,106,123,57,0,128,100,80,0,77,0,83,0,108,118,115,128,52,0,107,107,128,128,59,0,128,128,31,2,58,1,204,0,186,0,84,2,177,1,181,1,0,0,249,250,251,255,89,97,173,255,58,65,211,255,117,160,222,255,85,91,216,255,121,125,230,255,202,203,236,255,0,0,0,0,0,0,0,0,249,250,251,255,128,128,117,125,120,128,0,0},
{1,112,0,16,162,128,128,0,25,0,25,0,50,142,132,0,5,0,128,128,128,128,128,137,132,131,128,128,123,128,120,128,128,128,128,116,137,128,128,128,128,128,37,0,73,1,54,2,9,0,115,116,119,132,128,125,113,115,116,119,132,128,125,113,7,0,95,1,132,119,136,128,128,128,132,119,136,128,128,128,3,0,16,0,128,128,128,128,15,0,128,126,91,0,88,0,94,0,128,118,128,128,14,0,103,103,125,125,21,0,128,128,28,1,167,1,0,0,0,0,0,0,178,1,180,1,0,0,219,236,246,255,162,156,228,255,77,79,133,255,90,94,183,255,78,100,202,255,108,66,117,255,255,255,255,255,0,0,0,0,0,0,0,0,219,236,246,255,129,127,120,128,125,120,0,0},
{1,112,0,16,151,128,159,0,62,0,62,0,50,128,134,0,44,0,129,118,128,128,128,113,128,131,128,128,128,128,128,128,128,128,128,112,139,128,128,128,115,128,74,0,50,0,49,0,48,0,139,128,128,128,124,128,128,139,128,128,128,124,128,128,45,0,68,0,145,84,147,130,113,178,145,84,147,130,113,178,42,0,58,0,119,140,135,162,57,0,130,166,80,0,77,0,83,0,106,91,129,132,52,0,110,110,128,128,59,0,128,128,161,2,58,1,204,0,186,0,84,2,177,1,181,1,0,0,227,230,237,255,92,92,92,255,74,81,124,255,130,151,224,255,87,97,162,255,54,74,92,255,166,166,166,255,0,0,0,0,0,0,0,0,227,230,237,255,120,110,109,110,117,128,0,0},
{1,112,0,16,146,128,128,0,25,0,25,0,50,142,132,0,5,0,128,128,128,128,128,137,132,131,128,128,123,128,120,128,128,128,128,116,137,128,128,128,128,128,37,0,73,1,54,2,9,0,115,116,118,132,128,125,108,115,116,118,132,128,125,108,7,0,95,1,128,107,128,128,128,128,128,107,128,128,128,128,3,0,16,0,128,128,128,128,15,0,128,126,91,0,88,0,94,0,145,119,128,128,14,0,99,99,120,120,21,0,128,128,188,0,56,1,0,0,0,0,0,0,178,1,180,1,0,0,218,236,246,255,237,207,234,255,37,38,37,255,88,93,196,255,89,102,187,255,226,79,163,255,255,255,255,255,0,0,0,0,0,0,0,0,218,236,246,255,128,128,122,128,128,128,0,0},
{1,112,0,16,131,139,152,0,62,0,62,0,50,143,140,0,88,3,140,134,128,128,128,129,129,128,128,89,131,128,128,128,131,128,128,121,152,180,104,112,104,105,74,0,50,0,49,0,48,0,132,137,123,128,128,128,128,132,137,123,128,128,128,128,45,0,70,0,128,128,128,128,128,128,128,128,128,128,128,128,41,0,58,0,128,128,128,128,57,0,128,128,80,0,77,0,83,0,128,111,128,128,52,0,112,112,128,128,59,0,128,128,169,3,179,3,204,0,186,0,84,2,177,1,181,1,0,0,190,197,205,255,255,255,255,255,222,92,63,255,255,255,255,255,143,81,130,255,48,65,77,255,55,112,79,255,0,0,0,0,1,0,0,0,190,197,205,255,120,126,128,128,128,128,0,0},
{1,112,0,16,134,130,139,0,23,0,23,0,50,128,128,0,92,3,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,118,128,128,128,124,129,91,36,0,1,1,0,1,9,0,128,128,128,128,128,128,128,128,128,128,128,128,128,128,6,0,28,0,128,128,128,128,128,128,128,128,128,128,128,128,3,0,16,0,128,128,128,128,15,0,128,128,89,0,86,0,92,0,128,128,128,128,14,0,110,110,128,128,21,0,128,128,69,3,105,3,0,0,0,0,0,0,178,1,180,1,0,0,216,222,207,255,255,255,255,255,222,92,63,255,255,255,255,255,121,60,211,255,66,94,217,255,55,112,79,255,0,0,0,0,0,0,0,0,216,222,207,255,128,128,128,128,128,128,0,0},
{0},
{1,112,0,16,134,115,123,0,23,0,23,0,50,139,103,0,5,0,113,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,127,119,139,136,128,128,128,128,37,0,11,0,12,0,9,0,89,188,97,140,113,128,146,89,188,97,140,113,128,146,7,0,96,1,91,122,109,139,162,128,91,122,109,139,162,128,1,0,16,0,113,134,175,120,15,0,109,84,89,0,86,0,92,0,167,72,116,141,14,0,65,65,153,153,22,0,110,114,191,0,56,1,0,0,0,0,0,0,178,1,180,1,0,0,100,137,192,255,222,117,138,255,90,94,183,255,77,102,215,255,62,69,212,255,139,73,89,255,255,255,255,255,0,0,0,0,3,0,0,0,100,137,192,255,124,117,110,118,114,106,0,0},
{1,112,0,16,128,128,128,0,117,0,117,0,50,128,128,0,100,0,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,126,0,106,0,105,0,104,0,128,128,128,128,128,128,128,64,76,76,64,64,128,64,101,0,122,0,128,128,128,128,128,128,64,64,128,128,128,128,95,0,111,0,128,128,128,128,108,0,128,128,132,0,129,0,135,0,128,128,128,128,107,0,128,64,64,64,114,0,128,128,0,0,160,61,99,0,0,0,56,255,25,18,13,0,0,0,237,231,243,255,255,255,255,255,222,92,63,255,255,255,255,255,63,220,62,255,48,65,77,255,55,112,79,255,0,0,0,0,1,0,0,0,255,255,255,255,128,128,128,128,128,128,0,0},
{0},
{1,112,0,16,131,139,152,0,62,0,62,0,50,143,140,0,88,3,140,134,128,128,128,129,129,128,128,89,131,128,128,128,131,128,128,121,152,180,104,112,104,105,74,0,50,0,49,0,48,0,132,137,123,128,128,128,128,132,137,123,128,128,128,128,45,0,70,0,128,128,128,128,128,128,128,128,128,128,128,128,41,0,58,0,128,128,128,128,57,0,128,128,80,0,77,0,83,0,128,111,128,128,52,0,112,112,128,128,60,0,128,128,169,3,179,3,204,0,186,0,84,2,177,1,181,1,0,0,190,197,205,255,255,255,255,255,222,92,63,255,255,255,255,255,143,81,130,255,48,65,77,255,55,112,79,255,0,0,0,0,1,0,0,0,190,197,205,255,120,126,128,128,128,128,0,0},
{1,112,0,16,134,130,139,0,23,0,23,0,50,128,128,0,92,3,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,118,128,128,128,124,129,91,36,0,1,1,0,1,9,0,128,128,128,128,128,128,128,128,128,128,128,128,128,128,6,0,28,0,128,128,128,128,128,128,128,128,128,128,128,128,3,0,16,0,128,128,128,128,15,0,128,128,89,0,86,0,92,0,128,128,128,128,14,0,110,110,128,128,21,0,128,128,67,3,103,3,0,0,0,0,0,0,178,1,180,1,0,0,216,222,207,255,255,255,255,255,222,92,63,255,255,255,255,255,121,60,211,255,66,94,217,255,55,112,79,255,0,0,0,0,0,0,0,0,216,222,207,255,128,128,128,128,128,128,0,0},
{1,112,0,16,136,120,126,0,62,0,62,0,50,126,145,0,44,0,148,128,134,128,128,131,129,124,128,128,123,128,118,128,128,94,128,103,147,132,128,128,128,128,73,0,94,1,49,0,48,0,154,175,129,128,115,128,149,154,175,129,128,115,128,149,46,0,67,0,107,96,127,137,128,128,107,96,127,137,128,128,42,0,58,0,122,130,120,140,55,0,128,154,82,0,77,0,84,0,113,89,127,128,52,0,103,103,130,130,60,0,105,128,194,0,58,1,204,0,186,0,84,2,177,1,181,1,0,0,251,248,252,255,157,157,157,255,69,75,114,255,152,173,228,255,89,105,175,255,60,83,102,255,255,255,255,255,0,0,0,0,0,0,0,0,251,248,252,255,124,110,115,110,120,128,0,0},
{1,112,0,16,126,138,129,0,23,0,23,0,50,128,128,0,5,0,128,128,128,128,128,145,140,131,128,128,128,128,120,128,128,128,128,125,148,136,128,128,128,128,37,0,11,0,51,2,9,0,142,120,134,117,128,125,145,142,120,134,117,128,125,145,7,0,95,1,128,120,134,128,128,128,128,120,134,128,128,128,1,0,16,0,130,136,128,145,15,0,128,132,91,0,88,0,94,0,128,105,124,128,14,0,100,100,128,128,21,0,128,128,251,1,56,1,0,0,0,0,0,0,178,1,180,1,0,0,239,228,243,255,230,165,213,255,78,60,94,255,172,152,228,255,137,87,200,255,221,54,188,255,255,255,255,255,0,0,0,0,0,0,0,0,239,228,243,255,122,122,116,123,123,117,0,0},
{1,112,0,16,151,128,159,0,62,0,62,0,50,128,134,0,44,0,129,118,128,128,128,113,128,131,128,128,128,128,128,128,128,128,128,112,139,128,128,128,115,128,74,0,50,0,49,0,48,0,139,128,128,128,124,128,128,139,128,128,128,124,128,128,45,0,68,0,145,84,147,130,113,178,145,84,147,130,113,178,42,0,58,0,119,140,135,162,57,0,130,166,80,0,77,0,83,0,106,91,129,132,52,0,110,110,128,128,60,0,128,128,163,2,58,1,204,0,186,0,84,2,177,1,181,1,0,0,227,230,237,255,92,92,92,255,74,81,124,255,130,151,224,255,87,97,162,255,54,74,92,255,166,166,166,255,0,0,0,0,0,0,0,0,227,230,237,255,121,110,111,110,118,128,0,0},
{1,112,0,16,126,138,129,0,23,0,23,0,50,128,128,0,5,0,128,128,128,128,128,145,140,131,128,128,128,128,120,128,128,128,128,125,148,136,128,128,128,128,37,0,11,0,51,2,9,0,142,120,134,117,128,125,145,142,120,134,117,128,125,145,7,0,95,1,128,120,134,128,128,128,128,120,134,128,128,128,1,0,16,0,130,136,128,145,15,0,128,132,91,0,88,0,94,0,128,105,124,128,14,0,100,100,128,128,21,0,128,128,251,1,56,1,0,0,0,0,0,0,178,1,180,1,0,0,239,228,243,255,230,165,213,255,78,60,94,255,172,152,228,255,137,87,200,255,221,54,188,255,255,255,255,255,0,0,0,0,0,0,0,0,239,228,243,255,122,122,116,123,123,117,0,0},
{1,112,0,16,128,128,128,0,62,0,62,0,50,128,128,0,55,4,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,74,0,50,0,49,0,22,4,132,137,123,128,128,128,128,132,137,123,128,128,128,128,45,0,70,0,128,128,128,128,128,128,128,128,128,128,128,128,41,0,58,0,128,128,128,128,57,0,128,128,80,0,77,0,83,0,128,111,128,128,52,0,112,112,128,128,60,0,128,128,45,4,30,4,204,0,186,0,84,2,177,1,181,1,0,0,250,252,253,255,255,255,255,255,222,92,63,255,255,255,255,255,60,74,211,255,77,150,209,255,55,112,79,255,128,4,0,0,2,0,0,0,250,252,253,255,124,116,115,115,114,128,0,0},
{1,112,0,16,128,128,128,0,24,0,24,0,50,128,128,0,96,4,128,128,128,128,94,115,64,64,114,64,128,128,128,128,135,108,128,64,192,98,104,64,111,91,106,1,1,1,0,1,93,4,139,191,160,128,128,129,166,139,191,160,128,128,129,166,6,0,28,0,128,128,128,128,128,128,128,128,128,128,128,128,3,0,16,0,116,128,127,122,15,0,118,90,90,0,86,0,92,0,89,89,128,128,14,0,110,110,133,133,21,0,128,128,85,4,70,4,0,0,0,0,0,0,178,1,180,1,0,0,237,239,250,255,255,255,255,255,222,92,63,255,255,255,255,255,65,66,213,255,66,150,217,255,55,112,79,255,143,4,0,0,2,0,0,0,237,239,250,255,133,115,126,126,115,125,0,0},
{1,112,0,16,128,128,128,0,62,0,62,0,50,128,128,0,55,4,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,74,0,50,0,49,0,22,4,132,137,123,128,128,128,128,132,137,123,128,128,128,128,45,0,70,0,128,128,128,128,128,128,128,128,128,128,128,128,41,0,58,0,128,128,128,128,57,0,128,128,80,0,77,0,83,0,128,111,128,128,52,0,112,112,128,128,60,0,128,128,45,4,30,4,204,0,186,0,84,2,177,1,181,1,0,0,250,252,253,255,255,255,255,255,222,92,63,255,255,255,255,255,60,74,211,255,77,150,209,255,55,112,79,255,128,4,0,0,2,0,0,0,250,252,253,255,124,116,115,115,114,128,0,0},
{1,112,0,16,128,128,128,0,24,0,24,0,50,128,128,0,96,4,128,128,128,128,94,115,64,64,114,64,128,128,128,128,135,108,128,64,192,98,104,64,111,91,106,1,1,1,0,1,93,4,139,191,160,128,128,129,166,139,191,160,128,128,129,166,6,0,28,0,128,128,128,128,128,128,128,128,128,128,128,128,3,0,16,0,116,128,127,122,15,0,118,90,90,0,86,0,92,0,89,89,128,128,14,0,110,110,133,133,21,0,128,128,85,4,70,4,0,0,0,0,0,0,178,1,180,1,0,0,237,239,250,255,255,255,255,255,222,92,63,255,255,255,255,255,65,66,213,255,66,150,217,255,55,112,79,255,143,4,0,0,2,0,0,0,237,239,250,255,133,115,126,126,115,125,0,0}
};
	
class RoleList_Re : public GNET::Protocol
{
	#include "rolelist_re"
	void Process(Manager *manager, Manager::Session::ID sid)
	{
		// TODO
		if (result==ERR_SUCCESS)
		{
			GLinkClient* cm = (GLinkClient*)manager;
			if (handle!=_HANDLE_END)
			{	
				for(size_t i=0; i<rolelist.size(); i++)
				{
					Octets name_gbk;
					CharsetConverter::conv_charset_u2g(rolelist[i].name,name_gbk);
					DEBUG_PRINT("Recv Protocol RoleList_Re. userid=%d handle=%d roleid=%d name=%.*s level=%d\n",
							userid,handle,rolelist[i].roleid,name_gbk.size(),(char*)name_gbk.begin(),rolelist[i].level);
					cm->SetRole(rolelist[i].roleid);	
				}

				cm->Send(sid,RoleList(userid,localsid,handle));
			}
			else
			{
				if(cm->roleid)
				{
					cm->Send(sid,SelectRole( cm->roleid ));
				}
				else
				{
					RoleInfo info;
					info.occupation = rand()%10;
					if(info.occupation == 4) info.gender = 0;
					else if(info.occupation == 3) info.gender = 1;
					else info.gender = rand()%2;
					info.name.resize(cm->identity.size()*2);
					char * s = (char*)cm->identity.begin();
					char * d = (char*)info.name.begin();
					while(s != cm->identity.end())
					{
						*(d++) = *(s++);
						*(d++) = 0;
					}
					info.custom_data.replace(custom_default[info.occupation*2 + info.gender], sizeof(custom_default[0]));

					cm->Send(sid,CreateRole(cm->userid, 0, info, Octets()));
				}
			}
		}
		return;				
	}
};

};

#endif
