/*
 * FILE: Terrain.h
 *
 * DESCRIPTION: header for terrain class on server side
 *
 * CREATED BY: Hedi, 2004/11/22 
 *
 * HISTORY:
 *
 * Copyright (c) 2004 Archosaur Studio, All Rights Reserved.
 */

#ifndef _TERRAIN_H_
#define _TERRAIN_H_

typedef struct _TERRAINCONFIG
{
	int			nNumAreas;		// ͼһٿѽ
	int			nNumRows;		// ּѽ
	int			nNumCols;		// ּѽ
	int			nAreaWidth;		// ÿĿȣԸ㣩
	int			nAreaHeight;	// ÿĸ߶ȣԸ㣩
	float		vGridSize;		// ÿСĳߴ

	float		vHeightMin;		// 0.0 Ӧĸ߶
	float		vHeightMax;		// 1.0 Ӧĸ߶

	char		szMapPath[256];	// ͼѽҪһбѽ

} TERRAINCONFIG;

class CTerrain
{
private:
	// height map buffer and width height of it
	float *				m_pHeights;			// height map points of this terrain object
	int					m_nNumVertX;		// how many points in one row of this terrain object
	int					m_nNumVertZ;		// how many points in one column of this terrain object

	// range of this terrain object
	float				m_ox;				// origin (left-top point) of this terrain object
	float				m_oz;
	
	float				m_vGridSizeInv;		// value to be multiplied to get grid coords.

	// configuration data
	TERRAINCONFIG		m_config;			// terrain configuration data

public:
	inline float * GetHeights()			{ return m_pHeights; }
	inline int GetNumVertX()			{ return m_nNumVertX; }
	inline int GetNumVertZ()			{ return m_nNumVertZ; }

protected:

public:
	CTerrain();
	~CTerrain();

	bool Init(const TERRAINCONFIG& config, float xmin, float zmin, float xmax, float zmax);
	bool InitPiece(const TERRAINCONFIG& config, int piece_idx);
	bool Init(int row, int col, const int * piece_indexes, CTerrain ** terrain_pieces);
	bool Release();

	float GetHeightAt(float x, float z);
};

#endif//_TERRAIN_H_

