#ifndef _TASKSERVER_H_
#define _TASKSERVER_H_

#include "TaskInterface.h"

#ifndef _TASK_CLIENT

class elementdataman;

// ļ
bool LoadTasksFromPack(elementdataman* pDataMan, const char* szPackPath, const char* szDynPackPath);

// ͷļ
void ReleaseTaskTemplMan();

// ֪ͨӳ
void OnTeamSetup(TaskInterface* pTask);

// ֪ͨӳɢ
void OnTeamDisband(TaskInterface* pTask);

// ֪ͨ¶ӳӳת
void OnTeamTransferCaptain(TaskInterface* pTask);

// ֪ͨӳԱ
void OnTeamAddMember(TaskInterface* pTask, const task_team_member_info* pInfo);

// ֪ͨӳԱ˳
void OnTeamDismissMember(TaskInterface* pTask, unsigned long ulPlayerId);

// ֪ͨԱ˳
void OnTeamMemberLeave(TaskInterface* pTask);

// ֪ͨ
void OnPlayerNotify(TaskInterface* pTask, unsigned long ulPlayerId, const void* pBuf, size_t sz);

// տͻ֪ͨ
void OnClientNotify(TaskInterface* pTask, const void* pBuf, size_t sz);

// ܷ񷢷
bool OnTaskCheckDeliver(TaskInterface* pTask, unsigned long ulTaskId,unsigned long ulStorageId,bool bNotifyErr=true);

// NPCƷ
void OnNPCDeliverTaskItem(TaskInterface* pTask, unsigned long ulNPCId, unsigned long ulTaskId);

// NPCɵ
void OnTaskCheckAward(TaskInterface* pTask, unsigned long ulTasklId, int nChoice);

// ұɱ
void OnTaskPlayerKilled(TaskInterface* pTask);

// ʱϵͳʱн״̬
void OnTaskCheckAllTimeLimits(unsigned long ulCurTime);

// ɱ
void OnTaskKillMonster(TaskInterface* pTask, unsigned long ulTemplId, unsigned long ulLev, float fRand,int dps,int dph);

// ɱ
void OnTaskTeamKillMonster(TaskInterface* pTask, unsigned long ulTemplId, unsigned long ulLev, float fRand);

// 
void OnTaskMining(TaskInterface* pTask, unsigned long ulTaskId);

// ȫ
void TaskQueryGlobalData(
	unsigned long ulTaskId,
	unsigned long ulPlayerId,
	const void* pPreservedData,
	size_t size);

// ȫ
void TaskUpdateGlobalData(
	unsigned long ulTaskId,
	const unsigned char pData[TASK_GLOBAL_DATA_SIZE]);

// ȫ
void OnTaskReceivedGlobalData(
	TaskInterface* pTask,
	unsigned long ulTaskId,
	unsigned char pData[TASK_GLOBAL_DATA_SIZE],
	const void* pPreservedData,
	size_t size);

// 
void OnForgetLivingSkill(TaskInterface* pTask);

// 
void OnTaskPlayerLevelUp(TaskInterface* pTask);

// PQʼ
bool InitPublicQuestSystem();

// PQheartbeat
void OnTaskPublicQuestHeartbeat();

// PQɱֹ׶ȷ
void OnTaskKillPQMonster(TaskInterface* pTask, unsigned long ulTemplId, bool bOwner,float fTeamContrib,int iTeamMemberCnt,float fPersonalContib);

// PQʼlinkϢ
void OnTaskCheckPQEnterWorldInit(TaskInterface* pTask, unsigned long ulTaskId);

// 뿪ʧ
void OnTaskLeaveForce(TaskInterface* pTask);

enum{
	EX_TK_SENDAUMAIL_LEVEL1 = 1,	//	AUٻغʼ1δ¼
	EX_TK_SENDAUMAIL_LEVEL2 = 2,
	EX_TK_SENDAUMAIL_LEVEL3 = 3,
	EX_TK_SENDAUMAIL_EXAWARD = 4,	//	AUٻغʼĿʼĿ
	EX_TK_WELCOMBACK_REWARD	= 5,	//	߻ظٻʼʱյϵͳӭع齱
};
// 
void OnTaskExternEvent(TaskInterface* pTask, int Event);

// ĳЩ񷢷ţ˺Ų
void OnTaskSpecialAwardMask(TaskInterface* pTask,unsigned long ulTaskID);

// ɱ
void OnTaskKillPlayer(TaskInterface* pTask, int iOccupation, bool bGender, int iLevel, int iForce, float fRand);

// ƺ
void OnTaskTitle(TaskInterface* pTask, unsigned long ulTaskID);

// ͨNPC
void OnTaskManualTrig(TaskInterface* pTask,unsigned long ulTaskId, bool bNotifyErr=true);

// е
void ClearAllTowerTask(TaskInterface* pTask);

#endif

#endif
