#include "world.h"
#include "player_imp.h"
#include "pathfinding/pathfinding.h"
#include "playermisc.h"

/*ԭ1	״̬ת
	GROUND-> 
	->GROUND 
	JUMP->FALL	 
	JUMP->FLY    
	FALL->JUMP 	 жϣΪ[1,max-1]
	FLY->JUMP	
	FALL->FLY	
	FLY->FALL   
	ǷGROUND ʹײɣʹô״̬
	*/

/*ԭ2
	JUMP
	ϻ򼸺ϣYֵΪ
	ӵһJUMPʼԾʱ͸߶ۼ,ͬʱjump_count=1
	Ծۼʱ͸߶ȳֵָ,jump_count++,ۼƸ߶Ⱥʱȥֵָ,С0Ϊ0
	jump_countԾ
	*/

/*ԭ3
	
	»򼸺
	ӿʼ俪ʼٶͳƣٶȱ벻󣬲С1/2ɵӰֵ
	jump_count>0 && jump<maxʱӸ״̬
	*/

/*ԭ4
	һε䵽ʱڴʱƫ󣬸жҪ´
 	*/
	
	const A3DVECTOR aExts[USER_CLASS_COUNT*2] =
	{
		A3DVECTOR(0.4f, 0.53f, 0.4f),		//	
		A3DVECTOR(0.3f, 0.5f, 0.3f),

		A3DVECTOR(0.3f, 0.53f, 0.3f),		//	ʦ
		A3DVECTOR(0.3f, 0.5f, 0.3f),

		A3DVECTOR(0.3f, 0.53f, 0.3f),		//  ʦ
		A3DVECTOR(0.3f, 0.5f, 0.3f),	

		A3DVECTOR(0.3f, 0.53f, 0.3f),		//	
		A3DVECTOR(0.3f, 0.5f, 0.3f),	

		A3DVECTOR(0.5f, 0.62f, 0.5f), 	//	
		A3DVECTOR(0.3f, 0.53f, 0.3f),

		A3DVECTOR(0.3f, 0.53f, 0.3f), 	//  ̿
		A3DVECTOR(0.3f, 0.5f, 0.3f),

		A3DVECTOR(0.3f, 0.53f, 0.3f), 	//	â
		A3DVECTOR(0.3f, 0.5f, 0.3f),

		A3DVECTOR(0.3f, 0.53f, 0.3f), 	//	
		A3DVECTOR(0.3f, 0.5f, 0.3f),

		A3DVECTOR(0.3f, 0.53f, 0.3f), 	//	
		A3DVECTOR(0.3f, 0.5f, 0.3f),

		A3DVECTOR(0.3f, 0.53f, 0.3f), 	//	
		A3DVECTOR(0.3f, 0.5f, 0.3f),
		
		A3DVECTOR(0.3f, 0.53f, 0.3f), 	//	ҹӰ
		A3DVECTOR(0.3f, 0.5f, 0.3f),

		A3DVECTOR(0.3f, 0.53f, 0.3f), 	//	
		A3DVECTOR(0.3f, 0.5f, 0.3f),
	};
	const A3DVECTOR aExts2[USER_CLASS_COUNT*2] =
	{
		A3DVECTOR(0.4f, 0.9f, 0.4f),		//	
		A3DVECTOR(0.3f, 0.85f, 0.3f),

		A3DVECTOR(0.3f, 0.9f, 0.3f),		//	ʦ
		A3DVECTOR(0.3f, 0.85f, 0.3f),

		A3DVECTOR(0.3f, 0.9f, 0.3f),		//  ʦ
		A3DVECTOR(0.3f, 0.85f, 0.3f),	

		A3DVECTOR(0.3f, 0.9f, 0.3f),		//	
		A3DVECTOR(0.3f, 0.85f, 0.3f),	

		A3DVECTOR(0.5f, 1.05f, 0.5f), 	//	
		A3DVECTOR(0.3f, 0.9f, 0.3f),

		A3DVECTOR(0.3f, 0.9f, 0.3f), 	//  ̿
		A3DVECTOR(0.3f, 0.85f, 0.3f),

		A3DVECTOR(0.3f, 0.9f, 0.3f), 	//	â
		A3DVECTOR(0.3f, 0.85f, 0.3f),

		A3DVECTOR(0.3f, 0.9f, 0.3f), 	//	
		A3DVECTOR(0.3f, 0.85f, 0.3f),

		A3DVECTOR(0.3f, 0.9f, 0.3f), 	//	
		A3DVECTOR(0.3f, 0.85f, 0.3f),

		A3DVECTOR(0.3f, 0.9f, 0.3f), 	//	
		A3DVECTOR(0.3f, 0.85f, 0.3f),
		
		A3DVECTOR(0.3f, 0.9f, 0.3f), 	//	ҹӰ
		A3DVECTOR(0.3f, 0.85f, 0.3f),

		A3DVECTOR(0.3f, 0.9f, 0.3f), 	//	
		A3DVECTOR(0.3f, 0.85f, 0.3f),
	};
	static const A3DVECTOR off(0,-1.05f,0);

int 
phase_control::PhaseControl(gplayer_imp * pImp, const A3DVECTOR & target, float theight, int mode, int use_time)
{
	trace_manager2 & man = *(pImp->_plane->GetTraceMan());
	if(!man.Valid()) return 0;

	//ȷҵĿǷڿ
	const A3DVECTOR & ext = aExts[(pImp->IsPlayerFemale() ? 2*pImp->GetPlayerClass()+1 : 2*pImp->GetPlayerClass())];
	bool is_ground = true;
	bool is_solid;
	float ratio;
	bool bRst = man.AABBTrace(target, off, ext, is_solid,ratio,&pImp->_plane->w_collision_flags);
	if(bRst && is_solid) return -1;	//ĿǶ˽ ֱӷؼ

	if(target.y >  theight + 0.2f)	//ڵϣײǷյж
	{
		if(!bRst) 
		{
			is_ground = false;
		}
		else
		{
			is_ground = (ratio * -off.y < 0.2f);
		}
	}

	if(is_ground) 
	{
		jump_count = 0;
		state = STATE_GROUND;
		return 0;
	}

	A3DVECTOR offset = target;
	offset -= pImp->_parent->pos;
	
	float water_height = path_finding::GetWaterHeight(pImp->_plane, target.x,target.z);
	if(water_height-target.y >= 2.0f)
	{
		if(state == STATE_WATER)
		{
			float speed_square = offset.y * offset.y * 1000000.f / use_time / use_time;
			float cur_speed_square = (pImp->_cur_prop.swim_speed + 0.2f)*(pImp->_cur_prop.swim_speed + 0.2f);
			if(speed_square > cur_speed_square)	
			{
				if(speed_square > speed_ctrl_factor)
				{
					__PRINTF("ˮгʷٶspeed_square=%f speed_ctrl_factor=%f\n",speed_square,speed_ctrl_factor);
					return -1;	
				}
				__PRINTF("ˮпٶ\n");
				return 2;	
			}
			else
			{
				//ʷϷٶ
				speed_ctrl_factor = cur_speed_square;	
			}
		}
		jump_count = 0;
		state = STATE_WATER;
		return 0;
	}
	else if(water_height >= target.y)
	{
		jump_count = 0;
		state = STATE_GROUND;
		return 0;
	}

	if( ((gactive_object*)pImp->_parent)->IsFlyMode())
	{
		if(state == STATE_FALL)
		{
			if(offset.y > (pImp->_cur_prop.flight_speed + 0.2f) * use_time * 0.001f)
			{
				__PRINTF("start fall-to-fly yϳ\n");
				return -1;	
			}
			//fall-to-fly׶,ʱΪ3s
			fall_to_fly_time = 3000;
		}
		else if(state == STATE_FLY)
		{
			float speed_square = offset.y * offset.y * 1000000.f / use_time / use_time;
			float cur_speed_square = (pImp->_cur_prop.flight_speed + 0.2f)*(pImp->_cur_prop.flight_speed + 0.2f);
			if(speed_square > cur_speed_square)	
			{
				if(fall_to_fly_time > 0)
				{
					//fall-to-fly׶Σֻyϵٶ
					if(offset.y > 0)
					{
						__PRINTF("in fall-to-fly yϳ\n");
						return -1;	
					}
					fall_to_fly_time -= use_time;	
					return 2;
				}
				else
				{
					//fly׶ҪȽʷٶ
					if(speed_square > speed_ctrl_factor)
					{
						__PRINTF("гʷٶspeed_square=%f speed_ctrl_factor=%f\n",speed_square,speed_ctrl_factor);
						return -1;	
					}
					__PRINTF("пٶ\n");
					return 2;	
				}
			}
			else
			{
				//ʷϷٶ
				speed_ctrl_factor = cur_speed_square;	
			}
			if(fall_to_fly_time > 0) fall_to_fly_time -= use_time;	
		}
		else
		{
			fall_to_fly_time = 0;	
		}
		jump_count = 0;
		state = STATE_FLY;
		return 0;
	}

	if(offset.y > 0)
	{
		if(state == STATE_GROUND) 
		{
			//տʼԾ,ʱԼԾ߶
			state = STATE_JUMP;
			jump_distance = offset.y;
			jump_time = use_time;
			jump_count = 1;
		}
		else if(state == STATE_JUMP)
		{
			//Ծ
			float ndis  = jump_distance +  offset.y;
			int ntime = jump_time + use_time;
			if(ndis > max_jump_distance)
			{
				if(ndis > max_jump_distance*2.0f || ++jump_count > MAX_JUMP_COUNT)
				{
					__PRINTF("Ծ볬%f", ndis);
					return -1;
				}
				else
				{
					__PRINTF("Ծ:\n");
					ndis -= max_jump_distance;
					ntime = (ntime>max_jump_time ? ntime-max_jump_time : 0);
				}
			}
			if(ntime > max_jump_time)
			{
				if(++jump_count > MAX_JUMP_COUNT)
				{
					__PRINTF("Ծʱ䳬%d", ntime);
					return -1;
				}
				else
				{
					__PRINTF("Ծʱ:\n");
					ndis = (ndis>max_jump_distance ? ndis-max_jump_distance : 0);
					ntime -= max_jump_time;
				}
			}
			jump_distance = ndis;
			jump_time = ntime;
		}
		else if(state == STATE_FLY)
		{
			//һʱǷУϷһ
			if(offset.y > (pImp->_cur_prop.flight_speed + 0.2f) * use_time * 0.001f)
			{
				__PRINTF("start fly-to-fall yϳ\n");
				return -1;	
			}
			//fly-to-fall׶,ʱΪ3s
			fly_to_fall_time = 3000;
			state = STATE_FALL;
			drop_speed = 0;
			return 2;
		}
		else	//STATE_FALL СSTATE_WATER
		{
			if(jump_count <= 0 || jump_count >= MAX_JUMP_COUNT)
			{	
				if(fly_to_fall_time > 0)
				{
					//fall-to-fly׶ΣϷ	
					if(offset.y > (pImp->_cur_prop.flight_speed + 0.2f) * use_time * 0.001f)
					{
						__PRINTF("in fly-to-fall yϳ\n");
						return -1;	
					}
					fly_to_fall_time -= use_time;
					return 2;				
				}
				__PRINTF("ĵĴ࣬%d\n", jump_count);
				return -1;
			}
			else
			{
				if(offset.y > max_jump_distance)
				{
					__PRINTF("Ծ볬%f", offset.y);
					return -1;
				}
				state = STATE_JUMP;
				++ jump_count;
				jump_distance = offset.y;
				jump_time = use_time;
				__PRINTF(":\n");
			}
		}
		return 0;
	}
	else
	{
		//ǵ
		if(state != STATE_FALL)
		{
			//ԭǵ
			//ʼе
			fly_to_fall_time = 0;
			state = STATE_FALL;
			drop_speed = 0;
		}
		else
		{
			float WORLD_GRAVITY_ACC = (9.8f/2);
			float dis = - offset.y;
			if(dis < drop_speed * (use_time *0.001f))
			{
				__PRINTF("ٶ̫̫\n");
				drop_speed = 0.f; //ǲ©?? ʵʱֵܳ
				return -1;
			}
			drop_speed += WORLD_GRAVITY_ACC * (use_time *0.001f);
			if(drop_speed > 50) drop_speed = 50;
			if(fly_to_fall_time > 0) fly_to_fall_time -= use_time;
		}
	}
	return 0;
}

void phase_control::Initialize(gplayer_imp * pImp)
{
	trace_manager2 & man = *(pImp->_plane->GetTraceMan());
	if(!man.Valid()) 
	{
		state = STATE_GROUND;
		return;
	}
	
	jump_distance = 0;
	jump_time = 0;
	jump_count = 0;
	drop_speed = 0;
	speed_ctrl_factor = 0.f;
	fall_to_fly_time = 0;
	fly_to_fall_time = 0;
	if(world_manager::GetWorldLimit().lowjump)
	{
		max_jump_distance = 2.0f;	//һʵʲ1.2 
		max_jump_time = 1500;		//ʱ䲻׼ȷϸ	
	}
	else
	{
		max_jump_distance = 7.0f;	//һʵʲ5.5 
		max_jump_time = 2000;		//һʵʲ1550 
	}

	if( ((gactive_object*)pImp->_parent)->IsFlyMode())
	{
		state = STATE_FLY;
		return;	
	}
	
	if(pImp->IsUnderWater(2.0f))
	{
		state = STATE_WATER;
		return;
	}
	else if(pImp->IsUnderWater(0.0f))
	{
		state = STATE_GROUND;
		return;	
	}
	
	A3DVECTOR pos(pImp->_parent->pos);
	float height = pImp->_plane->GetHeightAt(pos.x,pos.z);
	if(pos.y < height + 0.2) 
	{
		state = STATE_GROUND;
		return;
	}

	const A3DVECTOR & ext = aExts[(pImp->IsPlayerFemale() ? 2*pImp->GetPlayerClass()+1 : 2*pImp->GetPlayerClass())];
	bool is_solid;
	float ratio;
	bool bRst = man.AABBTrace(pos, off, ext, is_solid,ratio,&pImp->_plane->w_collision_flags);
	if(bRst && is_solid) 
	{
		state = STATE_GROUND;
		return;
	}
	
	if(!bRst) 
	{
		state = STATE_FALL;
	}
	else
	{
		state = (ratio * -off.y < 0.2f)?STATE_GROUND:STATE_FALL;
	}
}

void phase_control::Load(archive & ar)
{
	ar >> state >> jump_distance >> jump_time >> drop_speed >> jump_count >> max_jump_distance >> max_jump_time >> speed_ctrl_factor >> fall_to_fly_time >> fly_to_fall_time;	
}

void phase_control::Save(archive & ar)
{
	ar << state << jump_distance << jump_time << drop_speed << jump_count << max_jump_distance << max_jump_time << speed_ctrl_factor << fall_to_fly_time << fly_to_fall_time;	
}
		
