#include "instance_manager.h"
#include "../world.h"
#include "../player_imp.h"
#include "../usermsg.h"

/*
 *	Ϣ
 */
int
instance_world_message_handler::RecvExternMessage(int msg_tag, const MSG & msg)
{
	//ڸֻܸҵϢ
	if(msg.target.type != GM_TYPE_PLAYER && msg.target.type != GM_TYPE_SERVER ) return 0;
	if(msg_tag != world_manager::GetWorldTag())
	{
		//ĳЩϢ.......
	}

	//ҪҪĳЩϢ
	//ﻹӦֱӴĳЩϢ
	//תҪж

	//ЩϢҪת
	switch(msg.message)
	{
		case GM_MSG_SWITCH_USER_DATA:
			{
			//ѯKEYķʽǺȷ д $$$$$$$$$$
				if(msg.content_length < sizeof(instance_key)) return 0;
				instance_key * key = (instance_key*)msg.content;
				//Ϣͷinstance_key
				//ASSERT(key->target.key_level1 == msg.source.id);
				//ﲻˣҪGMдΪ
				instance_hash_key hkey;
				_manager->TransformInstanceKey(key->target, hkey);
				int index = _manager->GetWorldByKey(hkey);
				if(index < 0) return 0;
				return _manager->GetWorldByIndex(index)->DispatchMessage(msg);
			}

		case GM_MSG_PLANE_SWITCH_REQUEST:
		//ȷл 
		//ֱӷط ҪǷԽ
		{
			//ȼǷԽ磬 managerμǷﵽ
			if(msg.content_length != sizeof(instance_key)) 
			{
				ASSERT(false);
				return 0;
			}
			instance_key * key = (instance_key*)msg.content;
			int rst;
			if((rst = _manager->CheckPlayerSwitchRequest(msg.source,key,msg.pos,msg.param)) == 0)
			{
				//лϢ
				MSG nmsg = msg;
				nmsg.target = msg.source;
				nmsg.source = msg.target;
				nmsg.message = GM_MSG_PLANE_SWITCH_REPLY;
				_manager->SendRemotePlayerMsg(msg.source.id, nmsg);
			}
			else
			{
				MSG nmsg;
				BuildMessage(nmsg,GM_MSG_ERROR_MESSAGE,msg.source,msg.target,msg.pos,rst);
				_manager->SendRemotePlayerMsg(msg.source.id, nmsg);
			}
		}
		return 0;

		default:
		if(msg.target.type == GM_TYPE_PLAYER)
		{
			int index = _manager->GetPlayerWorldIdx(msg.target.id);
			if(index < 0) return 0;
			return _manager->GetWorldByIndex(index)->DispatchMessage(msg);
		}
		//Ϣδ ..........
	}
	return 0;
}


/**ʱûת*/
int 
instance_world_message_handler::PlayerComeIn(instance_world_manager *pManager, world * pPlane,const MSG &msg)
{
	gplayer * pPlayer = pPlane->GetPlayerByID(msg.source.id);
	if(!pPlayer)
	{
		//תѾʱ
		__PRINTF("û,ûѾʱ\n");
		GLog::log(GLOG_ERR, "Time out when player come in. worldtag:%d:roleid:%d", world_manager::GetWorldTag(), msg.source.id);
		return 0;
	}
	spin_autolock keeper(pPlayer->spinlock);
	if(pPlayer->ID != msg.source || !pPlayer->IsActived() || pPlayer->login_state != gplayer::WAITING_SWITCH)
	{
		//player״̬ȷ
		__PRINTF("û,û״̬ȷ\n");
		GLog::log(GLOG_ERR, "Invalid state when player come in. worldtag:%d:roleid:%d", world_manager::GetWorldTag(), msg.source.id);
		return 0;
	}
	ASSERT(pPlayer->imp == NULL);
	g_timer.remove_timer(pPlayer->base_info.faction,(void*)pPlayer->base_info.race);

	//ɾʱtimer

	raw_wrapper wrapper(msg.content,msg.content_length);
	wrapper.SetLimit(raw_wrapper::LOAD_ONLY);
	instance_key ikey;
	int source_tag;
	wrapper >> ikey >> source_tag;
	if(ikey.target.key_level1 != msg.param)
	{
		//keyĻжϲ
		GLog::log(GLOG_ERR,"invalid instance key while switch %d",pPlayer->ID.id);
		pPlane->FreePlayer(pPlayer);
		//ָʧܻ߲ʧ
		ASSERT(false);
		return 0;
	}

	pPlayer->Import(wrapper);
	ASSERT(msg.source == pPlayer->ID);

	int rst = RestoreObject(wrapper,pPlayer,pPlane);
	//µ Ҫɵ
	A3DVECTOR source_pos = pPlayer->pos;

	pManager->SetIncomingPlayerPos(pPlayer,msg.pos,ikey.special_mask);
	
	//Ĵڹϵ
	if(rst < 0 || pPlane->InsertPlayer(pPlayer) <0)
	{       
		pPlane->FreePlayer(pPlayer);
		//ָʧܻ߲ʧ
		//Ҫ־NPC
		//Ҫ PlayerMap,managerplayer worldӦϵȵ
		ASSERT(false);
		return 0;
	} 
	pPlane->InsertPlayerToMan(pPlayer);
	
	//ͼ¸ö
	world_manager::player_cid  cid;
	pManager->GetPlayerCid(cid);
	TrySwapPlayerData(pPlane,cid.cid,pPlayer);

	gplayer_imp * pImp = ((gplayer_imp*)pPlayer->imp);
	PlayerPreEnterServer(pPlayer, pImp,ikey);

	pImp->PlayerEnterServer(source_tag);

	//趨̵ʱ̣ ӿ˴̵ٶ ǰ
//	pImp->_write_timer = abase::Rand(3, 30);
	if(world_manager::GetWorldLimit().clearap)
	{
		pImp->ModifyAP(-100000);
	}

	//תƳɹ
	GMSV::SendSwitchServerSuccess(pPlayer->cs_index,pPlayer->ID.id, pPlayer->cs_sid,world_manager::GetWorldIndex());

	pManager->PlayerAfterSwitch(pImp);
	//øļfilter
	pManager->SetFilterWhenLogin(pImp,&ikey);

	//ý븱һЩ
	pImp->SetInstanceTimer(world_manager::GetWorldTag());
	pImp->SetLastInstancePos(world_manager::GetWorldTag(),pPlayer->pos, pPlane->w_create_timestamp);
	pImp->SetLastInstanceSourcePos(source_tag, source_pos);

	//ԼλϢһ
	dispatcher * runner = pPlayer->imp->_runner;
	runner->notify_pos(pPlayer->pos);
	//·
	runner->begin_transfer();
	runner->enter_world();
	runner->end_transfer();
	runner->server_config_data();

	GLog::log(GLOG_INFO,"û%d(%d,%d)תƵ%d",pPlayer->ID.id, pPlayer->cs_index,pPlayer->cs_sid,world_manager::GetWorldTag());

	timeval tv;
	gettimeofday(&tv,NULL);
	__PRINTF("%dתƷ:%u.%u\n",pPlayer->ID.id,tv.tv_sec,tv.tv_usec);
	return 0;
}

int
instance_world_message_handler::HandleMessage(world * pPlane,const MSG & msg)
{
	//ЩϢܻȽϷʱ䣬ǷԿTaskɣ̵߳ĻҪmsgˡ
	switch(msg.message)
	{
		case GM_MSG_SWITCH_USER_DATA:
			return PlayerComeIn(_manager,pPlane,msg);

		default:
			world_message_handler::HandleMessage(pPlane,msg);
	}
	return 0;
}

