#include "battleground_manager.h"
#include "../world.h"
#include "../player_imp.h"
#include "../usermsg.h"
#include "battleground_ctrl.h"

/*
 *	Ϣ
 */
int
battleground_world_message_handler::RecvExternMessage(int msg_tag, const MSG & msg)
{
	//ڸֻܸҵϢ
	if(msg.target.type != GM_TYPE_PLAYER && msg.target.type != GM_TYPE_SERVER ) return 0;
	if(msg_tag != world_manager::GetWorldTag())
	{
		//ĳЩϢ.......
	}

	//ҪҪĳЩϢ
	//ﻹӦֱӴĳЩϢ
	//תҪж

	//ЩϢҪת
	switch(msg.message)
	{
		case GM_MSG_SWITCH_USER_DATA:
			{
				if(msg.content_length < sizeof(instance_key)) return 0;
				instance_key * key = (instance_key*)msg.content;
				//Ϣͷinstance_key
				//渽
				//ASSERT(key->target.key_level1 == msg.source.id);
				//ﲻˣҪGMдΪ
				instance_hash_key hkey;
				_manager->TransformInstanceKey(key->target, hkey);
				int index = _manager->GetWorldByKey(hkey);
				if(index < 0) return 0;
				return _manager->GetWorldByIndex(index)->DispatchMessage(msg);
			}

		case GM_MSG_PLANE_SWITCH_REQUEST:
		//ȷл 
		//鸱Ƿڣڣȴб?		//Ѿڣˢһ·ʱ־سɹ־
		//Ҫɾ 
		{
			if(msg.content_length != sizeof(instance_key)) 
			{
				ASSERT(false);
				return 0;
			}
			instance_key * key = (instance_key*)msg.content;
			int rst = _manager->CheckPlayerSwitchRequest(msg.source,key,msg.pos,msg.param);
			if(rst == 0)
			{
				//лϢ
				MSG nmsg = msg;
				nmsg.target = msg.source;
				nmsg.source = msg.target;
				nmsg.message = GM_MSG_PLANE_SWITCH_REPLY;
				_manager->SendRemotePlayerMsg(msg.source.id, nmsg);
			}
			else if(rst > 0)
			{
				MSG nmsg;
				BuildMessage(nmsg,GM_MSG_ERROR_MESSAGE,msg.source,msg.target,msg.pos,rst);
				_manager->SendRemotePlayerMsg(msg.source.id, nmsg);
			}
			//rstС0ǰ޷ȷǷܹ磬Ҫȴ Էʲô
		}
		return 0;

		case GM_MSG_CREATE_BATTLEGROUND:
		{
			battle_ground_param &param = *(battle_ground_param*) msg.content;
			_manager->CreateBattleGround(param);
		}
		return 0;

		default:
		if(msg.target.type == GM_TYPE_PLAYER)
		{
			int index = _manager->GetPlayerWorldIdx(msg.target.id);
			if(index < 0) return 0;
			return _manager->GetWorldByIndex(index)->DispatchMessage(msg);
		}
		//Ϣδ ..........
	}
	return 0;
}

void 
battleground_world_message_handler::PlayerPreEnterServer(gplayer * pPlayer, gplayer_imp * pImp,instance_key & ikey)
{	
	world * pPlane = pImp->_plane;
	
	//ҵİ趨ط
	//Ĳ ҵEnterServer
	battleground_ctrl * pCtrl = (battleground_ctrl*)(pPlane->w_ctrl);

	int id = pPlayer->id_mafia;
	if(id)
	{
		if(id == pCtrl->_data.faction_attacker)
		{
			//
			pPlayer->SetBattleOffense();
			// עplayer_battlePlayerLeaveWorld
			if(!pCtrl->AddAttacker())
			{
				//,İ
				ikey.target.key_level3 = -1;

				//սı־()
				pPlayer->ClrBattleMode();
			}
		}
		else
		if(id == pCtrl->_data.faction_defender)
		{	
			//ط
			pPlayer->SetBattleDefence();
			// עplayer_battlePlayerLeaveWorld
			if(!pCtrl->AddDefender())
			{
				//,İ
				ikey.target.key_level3 = -1;

				//սı־()
				pPlayer->ClrBattleMode();
			}
		}
	}
}

int
battleground_world_message_handler::HandleMessage(world * pPlane,const MSG & msg)
{
	//ЩϢܻȽϷʱ䣬ǷԿTaskɣ̵߳ĻҪmsgˡ

	switch(msg.message)
	{
		case GM_MSG_SWITCH_USER_DATA:
			return PlayerComeIn(_manager,pPlane,msg);

		default:
			world_message_handler::HandleMessage(pPlane,msg);
	}
	return 0;
}

