#ifndef __ONLINEGAME_COMMON_MESSAGE_H__
#define __ONLINEGAME_COMMON_MESSAGE_H__

#include <stdlib.h>
#include "ASSERT.h"
#include <amemory.h>
struct MSG 
{
	int 	message;	//Ϣ
	struct XID target;	//ϢĿ꣬ǷңƷNPC
	struct XID source;	//﷢ģܵidһ
	A3DVECTOR pos;		//ϢʱλãеϢλò
	int	ttl;		//time to live,ֵС0ôͲٴת
	int	param;		//һãôʹ
	size_t 	content_length;	//Ϣľݳ
	const void * content;	//Ϣľ ϴʱֶЧ
private:
	enum {FAST_ALLOC_LEN = 128};
	friend void * SerializeMessage(const MSG &);
	friend void FreeMessage(MSG *);
};

inline void * SerializeMessage(const MSG & msg)
{
	void * buf;
	size_t length = msg.content_length;
	if(length <= MSG::FAST_ALLOC_LEN)
	{
	//	printf("%d %dalloced\n",sizeof(MSG) + length,msg.message);
		buf = abase::fast_allocator::align_alloc(sizeof(MSG) + length);		//룬Ƕmsg
		memcpy(buf,&msg,sizeof(MSG));
		if(length)
		{
			memcpy((char*)buf + sizeof(MSG),msg.content,length);
		}
	}
	else
	{
		buf = abase::fast_allocator::raw_alloc(sizeof(MSG) + length);
		memcpy(buf,&msg,sizeof(MSG));
		memcpy((char*)buf + sizeof(MSG),msg.content,msg.content_length);
	}
	return buf;
}

inline MSG * DupeMessage(const MSG & msg)
{
	MSG * pMsg = (MSG*)SerializeMessage(msg);
	pMsg->content = ((char*)pMsg) + sizeof(MSG);
	return pMsg;
}

inline void FreeMessage(MSG * pMsg)
{
	ASSERT(pMsg->content == ((char*)pMsg) + sizeof(MSG));
	size_t length = pMsg->content_length;
	if(length <= MSG::FAST_ALLOC_LEN)
	{
		abase::fast_allocator::align_free(pMsg, sizeof(MSG) + length);
	}
	else
	{
		abase::fast_allocator::raw_free(pMsg);
	}
}
inline void BuildMessage(MSG & msg, int message, const XID &target, const XID & source,
			const A3DVECTOR & pos,int param = 0,
			const void * content = NULL,size_t content_length = 0)
{
	msg.message = message;
	msg.target = target;
	msg.source = source;
	msg.pos = pos;
	msg.ttl = 2;
	msg.param = param;
	msg.content_length = content_length;
	msg.content = content;
}

enum
{
//	normal message
	GM_MSG_NULL,				//Ϣ
	GM_MSG_FORWARD_USERBC,			//תû㲥
	GM_MSG_FORWARD,				//תϢӦΪһµϢ
	GM_MSG_FORWARD_BROADCAST,		//תϢ㲥Ϣ,contentһϢ
	GM_MSG_USER_GET_INFO,			//ûȡñҪ

//5
	GM_MSG_IDENTIFICATION,			//֪Լ,ԭͱserveridķ
	GM_MSG_SWITCH_GET,			//ȡû,лȡû param tag,contentkey
	GM_MSG_SWITCH_USER_DATA,		//û,SWITCH_GETĻӦ
	GM_MSG_SWITCH_NPC,			//NPCл
	GM_MSG_USER_MOVE_OUTSIDE,		//ûڱ߽ƶ

//10	
	GM_MSG_USER_NPC_OUTSIDE,		//NPCڱ߽紦ƶ֮ͬNPCҪȡ¿Ķ
	GM_MSG_ENTER_WORLD,			//controllerģʾûѾ
	GM_MSG_ATTACK,				//ĿԴǸ
	GM_MSG_SKILL,				//ĿԴǸ
	GM_MSG_PICKUP,				//Ʒ,ĿһƷ

//15
	GM_MSG_FORCE_PICKUP,			//ǿƼƷУIDID
	GM_MSG_PICKUP_MONEY,			//Ʒ֪ͨûǮ paramǮ  content˭
	GM_MSG_PICKUP_TEAM_MONEY,		//Ʒ֪ͨӳǮ paramǮ  content˭
	GM_MSG_RECEIVE_MONEY,			//֪ͨҵõǮ)
	GM_MSG_PICKUP_ITEM,			//Ʒ֪ͨûƷ param palyer_id | 0x80000000(ӣ

//20
	GM_MSG_ERROR_MESSAGE,			//playerһerror message
	GM_MSG_NPC_SVR_UPDATE,			//NPC˷лϢֻ״̬ԭNPC
	GM_MSG_EXT_NPC_DEAD,			//ⲿNPCϢ(ɾ)Ϣֻ״̬ԭNPC
	GM_MSG_EXT_NPC_HEARTBEAT,		//ⲿNPCжǷʱ 
	GM_MSG_WATCHING_YOU,			//ＤϢ,һnpcһwatching_tĽṹ

//25
//	AGGRO  message 
	GM_MSG_GEN_AGGRO,			//aggro渽һaggro_info_tĽṹ
	GM_MSG_TRANSFER_AGGRO,			//aggroĴ Ŀǰֻ͵һλ contentһXID,XIDidΪ-1    ճб paramǸ˳ֵ
	GM_MSG_AGGRO_ALARM,			//aggroܵʱᷢͣ渽һaggro_alarm_tδʹ
	GM_MSG_AGGRO_WAKEUP,			//aggroߵĹﾪ,渽һaggro_alarm_tδʹ
	GM_MSG_AGGRO_TEST,			//aggro,ֻеaggroбУŻµaggro渽һaggro_info_tδʹ
	
//30
	GM_MSG_OBJ_SESSION_END,			//session
	GM_MSG_OBJ_SESSION_REPEAT,		//ʾsessionҪִ 
	GM_MSG_OBJ_ZOMBIE_END,			//ʾҪʬ״̬
	GM_MSG_EXPERIENCE,			//õֵ	content һmsg_exp_t
	GM_MSG_GROUP_EXPERIENCE,		//õӾֵ conennt Ƕmsg_grp_exp_t , param ɵ˺
	
//35
	GM_MSG_TEAM_EXPERIENCE,			//õӾֵ conennt msg_exp_t 뾭ֵᱻ param ɱnpcid ?Ǳɱ
	GM_MSG_QUERY_OBJ_INFO00,		//ȡöinfo00 paramǷߵsid ,contentһintcs_index
	GM_MSG_HEARTBEAT,			//ԼϢ  Heartbeat
	GM_MSG_HATE_YOU,
	GM_MSG_TEAM_INVITE,			//ĳ˼paramteamseq, contentһint ʾpickup_flag

//40	
	GM_MSG_TEAM_AGREE_INVITE,		//ͬ contentһint(ʾְҵ)+ team_mutable_prop
	GM_MSG_TEAM_REJECT_INVITE,		//ܾ
	GM_MSG_JOIN_TEAM,			//ӳͬĳ˼ paramλǼȡʽ paramλǶԱcontentmember_entryı 
	GM_MSG_JOIN_TEAM_FAILED,		//޷飬ӦôӶȥ
	GM_MSG_MEMBER_NOTIFY_DATA,		//ӳԱ֪ͨԼĻϢ content һteam_mutable_prop

//45	
	GM_MSG_NEW_MEMBER,			//leader֪ͨ³Ա룬contentһmember_entry list param
	GM_MSG_LEAVE_PARTY_REQUEST,
	GM_MSG_LEADER_CANCEL_PARTY,
	GM_MSG_MEMBER_NOT_IN_TEAM,
	GM_MSG_LEADER_KICK_MEMBER,

//50	
	GM_MSG_MEMBER_LEAVE,
	GM_MSG_LEADER_UPDATE_MEMBER,
	GM_MSG_GET_MEMBER_POS,			//Ҫѷλ paramǷߵsid ,contentһintcs_index
	GM_MSG_QUERY_PLAYER_EQUIPMENT,		//ȡضҵݣҪƽһΧ֮paramǷߵsid ,contentһintcs_index
	GM_MSG_TEAM_PICKUP,			//ѷ䵽Ʒ param  type, content count

//55	
	GM_MSG_TEAM_CHAT,			// param channel, content 
	GM_MSG_SERVICE_REQUEST,			//playerҪϢ param Ƿ content Ǿ ?	
	GM_MSG_SERVICE_DATA,			//ݵ param Ƿ  content  
	GM_MSG_SERVICE_HELLO,			//player ʺ  param  playerԼfaction
	GM_MSG_SERVICE_GREETING,		//̽лػ Ҫ淵طб$$$$(δ)

//60	
	GM_MSG_SERVICE_QUIERY_CONTENT,		//ȡ÷ 	 param Ƿ, contentɿpair<cs_index,sid>
	GM_MSG_EXTERN_OBJECT_APPEAR,		//content extern_object_manager::object_appear
	GM_MSG_EXTERN_OBJECT_DISAPPEAR,		//ʧ
	GM_MSG_EXTERN_OBJECT_REFRESH,		//λúѪֵparamбѪֵ 
	GM_MSG_USER_APPEAR_OUTSIDE,		//û֣ҪͱҪݸңcontent sid,paramlinkd id

//65
	GM_MSG_FORWARD_BROADCAST_SPHERE,	//תϢ㲥Ϣ,contentһϢ
	GM_MSG_FORWARD_BROADCAST_CYLINDER,	//תϢ㲥Ϣ,contentһϢ
	GM_MSG_FORWARD_BROADCAST_TAPER,		//תϢ㲥Ϣ,contentһϢ
	GM_MSG_ENCHANT,				//ʹøħ
	GM_MSG_ENCHANT_ZOMBIE,			//ʹøħ,רŸõ

//70
	GM_MSG_OBJ_SESSION_REPEAT_FORCE,	//ʾsessionҪrepeat 漴ʹҲҪִ
	GM_MSG_NPC_BE_KILLED,			//Ϣɱnpcңparam ʾɱnpc contentNPCļ
	GM_MSG_NPC_CRY_FOR_HELP,		//npc Ȳ
	GM_MSG_PLAYER_TASK_TRANSFER,		//player֮дͺͨѶĺ
	GM_MSG_PLAYER_BECOME_INVADER,		//Ϊ msg.param ӵʱ

//75
	GM_MSG_PLAYER_BECOME_PARIAH,		//Ϊ 
	GM_MSG_FORWARD_CHAT_MSG,		//תûϢ,paramrlevel,sourceXID(-channel,self_id)
	GM_MSG_QUERY_SELECT_TARGET,		//ȡöѡĶ
	GM_MSG_NOTIFY_SELECT_TARGET,		//ȡöѡĶ
	GM_MSG_SUBSCIBE_TARGET,			//Ҫһ

//80
	GM_MSG_UNSUBSCIBE_TARGET,		//Ҫһ
	GM_MSG_SUBSCIBE_CONFIRM,		//ȷ϶Ƿ
	GM_MSG_PRODUCE_MONEY,			//֪ͨϵͳǮ Դߣparamid contentǮ
	GM_MSG_PRODUCE_MONSTER_DROP,		//֪ͨϵͳƷͽǮ Դߣparammoney content  struct { int team_id; int team_seq;int npc_id;int item_count; int item[];}
	GM_MSG_GATHER_REQUEST,			//ռԭϣ  param ҵfaction, content ֱҼ𡢲ɼߺID

//85
	GM_MSG_GATHER_REPLY,			//֪ͨԽвɼ  param ǲɼҪʱ
	GM_MSG_GATHER_CANCEL,			//ȡɼ
	GM_MSG_GATHER,				//вɼҪȡƷ
	GM_MSG_GATHER_RESULT,			//ɼɣparam ǲɼƷid, content ͿܸӵID
	GM_MSG_HP_STEAL,				//յѪĽ

//90
	GM_MSG_INSTANCE_SWITCH_GET,		//ȡû,лȡû ڸл paramkey
	GM_MSG_INSTANCE_SWITCH_USER_DATA,	//û,SWITCH_SWITCH_GETĻӦ
	GM_MSG_EXT_AGGRO_FORWARD,		//֪ͨԭnpcгת param rageС contentǲ޵id
	GM_MSG_TEAM_APPLY_PARTY,		//ѡ
	GM_MSG_TEAM_APPLY_REPLY,		//ɹظ еparamseq	

//95
	GM_MSG_QUERY_INFO_1,			//ѯINFO1ԷһNPC,paramcs_index,contentsid
	GM_MSG_CON_EMOTE_REQUEST,		//Эͬ param  action
	GM_MSG_CON_EMOTE_REPLY,			//ЭͬĻӦ param actionֽͬڵ
	GM_MSG_TEAM_CHANGE_TO_LEADER,		//֪ͨҪΪleader
	GM_MSG_TEAM_LEADER_CHANGED,		//֪ͨѶӳĸı

//100
	GM_MSG_OBJ_ZOMBIE_SESSION_END,		//sessionĲsessionһ
	GM_MSG_QUERY_PERSONAL_MARKET_NAME,	//ȡð̯֣paramǷߵsid ,contentһintcs_index
	GM_MSG_HURT,				//˺ content msg_hurt_extra_info_t
	GM_MSG_DEATH,				//ǿö,param=0=1=2(paramplayerЧ) 
	GM_MSG_PLANE_SWITCH_REQUEST,		//ʼͣcontentkeyдͣ򷵻 SWITCH_REPLAY

//105
	GM_MSG_PLANE_SWITCH_REPLY,		//ȷϣcontentkey
	GM_MSG_SCROLL_RESURRECT,		//Ḵ  paramʾǷpvpģʽ1ʾ
	GM_MSG_LEAVE_COSMETIC_MODE,		//״̬
	GM_MSG_DBSAVE_ERROR,			//ݿⱣ
	GM_MSG_SPAWN_DISAPPEAR,			//֪ͨNPCƷʧ paramcondition

//110
	GM_MSG_PET_CTRL_CMD,			//ҷĿϢϢ
	GM_MSG_ENABLE_PVP_DURATION,		//PVP״̬
	GM_MSG_PLAYER_KILLED_BY_NPC,		//ұNPCɱNPC߼
	GM_MSG_PLAYER_DUEL_REQUEST,             //ҷҪduel
	GM_MSG_PLAYER_DUEL_REPLY,               //һӦduelparamǷӦduel

//115
	GM_MSG_PLAYER_DUEL_PREPARE,      	//׼ʼ 3뵹ʱʼ
	GM_MSG_PLAYER_DUEL_START,               //ʼ 
	GM_MSG_PLAYER_DUEL_CANCEL,		//ֹͣ
	GM_MSG_PLAYER_DUEL_STOP,		//
	GM_MSG_DUEL_HURT,			//PVP˺content 

//120
	GM_MSG_PLAYER_BIND_REQUEST,		//ڱ
	GM_MSG_PLAYER_BIND_INVITE,		//Լ
	GM_MSG_PLAYER_BIND_REQUEST_REPLY,	//ĻӦ
	GM_MSG_PLAYER_BIND_INVITE_REPLY,	//ĻӦ
	GM_MSG_PLAYER_BIND_PREPARE,		//׼ʼ

//125
	GM_MSG_PLAYER_BIND_LINK,		//ӿʼ
	GM_MSG_PLAYER_BIND_STOP,		//ֹͣ
	GM_MSG_PLAYER_BIND_FOLLOW,		//ҪҸ
	GM_MSG_QUERY_EQUIP_DETAIL,		//param Ϊfaction, content Ϊcs_index cs_sid
	GM_MSG_PLAYER_RECALL_PET,		//ǿٻ״̬

//130
	GM_MSG_CREATE_BATTLEGROUND,		//ҪսһսϢҪڲ
	GM_MSG_BECOME_TURRET_MASTER,		//Ϊǳmaster,paramtid, content faction
	GM_MSG_REMOVE_ITEM,			//ɾһƷϢڹǳƺƷ paramtid
	GM_MSG_NPC_TRANSFORM,			//NPCЧcontentﱣ м״̬мʱ м־ ״̬
	GM_MSG_NPC_TRANSFORM2,			//NPCЧ2param ĿID ͺĿIDһˣôͲ

//135
	GM_MSG_TURRET_NOTIFY_LEADER,		//ǳ֪ͨleaderԼڣ޷ٴνٻ
	GM_MSG_PET_RELOCATE_POS,		//Ҫ¶λ
	GM_MSG_PET_CHANGE_POS,			//޸˳
	GM_MSG_PET_DISAPPEAR,			//ݲȷ,,Ҫʧ
	GM_MSG_PET_NOTIFY_HP,			//֪ͨˣ֪ԼѪ param  stamp,content float hp ratio

//140
	GM_MSG_PET_NOTIFY_DEATH,		//֪ͨԼ
	GM_MSG_PET_MASTER_INFO,			//֪ͨԼ
	GM_MSG_PET_LEVEL_UP,			//֪ͨ ,content level
	GM_MSG_PET_HONOR_MODIFY,		//֪ͨҳ϶ȷ仯
	GM_MSG_MASTER_ASK_HELP,			//Ҫ

//145	
	GM_MSG_PET_SET_COOLDOWN,		//֪ͨȴʱ msg.param cooldown id, content  msec
	GM_MSG_MOB_BE_TRAINED,			//ﱻѱͳﵰʩ
	GM_MSG_PET_AUTO_ATTACK,			//֪ͨԶ msg.param force attack, contentĿ
	GM_MSG_PET_SKILL_LIST,			//֪ͨµļб
	GM_MSG_SWITCH_FAILED,			//֪ͨ˵ʧ

//150	
	GM_MSG_PET_ANTI_CHEAT,
	GM_MSG_QUERY_PROPERTY,			//ѯ˵ԣparamǲѯڰ
	GM_MSG_QUERY_PROPERTY_REPLY,	//ѯ˵Էأparamǲѯڰcontent
	GM_MSG_TRY_CLEAR_AGGRO,			//ȼnpcȼnpcԼĳޣparamԼȼ
	GM_MSG_NOTIFY_INVISIBLE_DATA,	//֪ͨ,ó

//155
	GM_MSG_NOTIFY_CLEAR_INVISIBLE,	//֪ͨˣҲ
	GM_MSG_CONTRIBUTION_TO_KILL_NPC,//ɱnpcnpc͸ҵϢparamnpc world_tag contentǽṹmsg_contribution_t
	GM_MSG_GROUP_CONTRIBUTION_TO_KILL_NPC,//ɱnpcnpc͸ҵϢparamnpc world_tag contentǽṹmsg_group_contribution_t
	GM_MSG_REBUILD_TEAM_INSTANCE_KEY_REQ,	//ԱӳؽӸkey,paramworldtag,contentؽǰteam_instance_key
	GM_MSG_REBUILD_TEAM_INSTANCE_KEY,		//ӳԱؽӸkey,paramworldtag,contentǾɵĺµteam_instance_key

//160
	GM_MSG_TRANSFER_FILTER_DATA,		//filterתƣparamfiltercontentfilter
	GM_MSG_PLANT_PET_NOTIFY_DEATH,		//ֲ֪ͨpet_stamp
	GM_MSG_PLANT_PET_NOTIFY_HP,			//ֲ֪ͨϢpet_stampdatamsg_plant_pet_hp_notify
	GM_MSG_PLANT_PET_NOTIFY_DISAPPEAR,	//ֲ֪ͨʧpet_stamp
	GM_MSG_PLANT_PET_SUICIDE,			//ֲ֪ͨʹԱpet_stamp

//165
	GM_MSG_MASTER_NOTIFY_LAYER,		//֪ͨlayer,petstamp datachar layer
	GM_MSG_INJECT_HP_MP,			//Ŀhpmp,datamsg_hp_mp_t
	GM_MSG_DRAIN_HP_MP,				//ʹĿhpmp,datamsg_hp_mp_t
	GM_MSG_CONGREGATE_REQUEST,		//, param data:msg_congregate_req_t
	GM_MSG_REJECT_CONGREGATE,		//ܾ, param

//170
	GM_MSG_NPC_BE_KILLED_BY_OWNER,	//NPCɱ,paramnpc tid,contentmsg_dps_dph_t
	GM_MSG_EXCHANGE_POS,			//֮佻λãͬʱ
	GM_MSG_EXTERN_HEAL,				//ĳĳѪϢ
	GM_MSG_QUERY_INVENTORY_DETAIL,	//ѯҰϸ
	GM_MSG_TURRET_OUT_OF_CONTROL,	//ǳĿ

//175
	GM_MSG_TRANSFER_FILTER_GET,		//filterת, paramfilter_mask contentתƵ
	GM_MSG_PET_TEST_SANCTUARY,		//֪ͨ˰ȫ
	GM_MSG_PLAYER_KILLED_BY_PLAYER,	//ұɱparammsg_player_killed_info_t
	GM_MSG_CREATE_COUNTRYBATTLE,	//ҪսսһսϢҪڲ
	GM_MSG_COUNTRYBATTLE_HURT_RESULT,	//ս֪ͨʵɵ˺paramΪ˺ֵcontentܹ߻(player)0(npc)
	
//180
	GM_MSG_LONGJUMP,				//˲ƣparamworldtag, contentpos
	GM_MSG_TRICKBATTLE_PLAYER_KILLED,
	GM_MSG_COUNTRYBATTLE_PLAYER_KILLED,	//ս
	GM_MSG_MAFIA_PVP_AWARD, //pvp
	GM_MSG_MAFIA_PVP_STATUS, //pvp ״̬֪ͨ
//185	
	GM_MSG_MAFIA_PVP_ELEMENT,// pvp 
	GM_MSG_PUNISH_ME,	// ԷԼenchant
	GM_MSG_REDUCE_CD,	// Ŀ꽵cd
	GM_MSG_DELIVER_TASK, // Ŀ
	GM_MSG_OBJ_ACTION_END,			//action
//190	
	GM_MSG_OBJ_ACTION_REPEAT,		//ʾactionҪִ 
	GM_MSG_SUBSCIBE_SUBTARGET,			//ҪһμĿ
	GM_MSG_UNSUBSCIBE_SUBTARGET,		//ҪȡһμĿ
	GM_MSG_SUBSCIBE_SUBTARGET_CONFIRM, // ȷϴμĿ궩Ƿ
	GM_MSG_NOTIFY_SELECT_SUBTARGET,	   // ֪ͨߴμ߸ı
//195
	GM_MSG_ATTACK_CRIT_FEEDBACK,
	GM_MSG_DELIVER_STORAGE_TASK,       // 
    GM_MSG_CHANGE_GENDER_LOGOUT,       // ɫԳɹ
	GM_MSG_CLEAR_TOWER_TASK,           // ˸
	GM_MSG_CREATE_MNFACTION,	//ҪսһսϢҪڲ
//200
    GM_MSG_LOOKUP_ENEMY,
    GM_MSG_LOOKUP_ENEMY_REPLY,

//GMõϢ	
	GM_MSG_GM_GETPOS=600,			//ȡָҵ param  cs_index, content sid
	GM_MSG_GM_MQUERY_MOVE_POS,		//GMҪѯ һתҴ 
	GM_MSG_GM_MQUERY_MOVE_POS_REPLY,	//GMҪѯĻӦ,GMת contentǵǰinstance key
	GM_MSG_GM_RECALL,			//GMҪת
	GM_MSG_GM_CHANGE_EXP,			//GMexp sp , param  exp , content sp
	GM_MSG_GM_ENDUE_ITEM,			//GMƷ param item id, content Ŀ 
	GM_MSG_GM_ENDUE_SELL_ITEM,		//GM̵Ʒͬ
	GM_MSG_GM_REMOVE_ITEM,			//GMҪɾĳЩƷparam item id, content Ŀ
	GM_MSG_GM_ENDUE_MONEY,			//GMӻ߼ٽǮ
	GM_MSG_GM_RESURRECT,			//GMҪ󸴻
	GM_MSG_GM_OFFLINE,			//GMҪ 
	GM_MSG_GM_DEBUG_COMMAND,		//GMҪ 
	GM_MSG_GM_RESET_PP,			//GMϴ
	GM_MSG_GM_QUERY_SPEC_ITEM,	//GMѯǷָƷ
	GM_MSG_GM_REMOVE_SPEC_ITEM,	//GMɾָƷ

	GM_MSG_MAX,

};

struct msg_usermove_t	//ûƶҿԽ߽Ϣ
{
	int cs_index;
	int cs_sid;
	int user_id;
	A3DVECTOR newpos;	//Ϣoldpos
	size_t leave_data_size;	//뿪͵ϢСϢں)
	size_t enter_data_size;	//뿪͵ϢСϢں)
};

struct msg_aggro_info_t
{
	XID source;		//˭Щ
	int aggro;		//޵ĴС
	int aggro_type;		//޵
	int faction;		//Էϵ
	int level;		//Էļ
};

struct msg_watching_t
{
	int level;		//Դļ
	int faction;		//Դϵ
	int invisible_degree;//Դ
};

struct msg_aggro_list_t
{
	int count;
	struct 
	{
		XID id;
		int aggro;
	}list[1];
};

struct msg_cry_for_help_t
{
	XID attacker;
	int lamb_faction;
	int helper_faction;
};

struct msg_aggro_alarm_t
{
	XID attacker;	//
	int rage;	
	int faction;	//ߵϵ
	int target_faction;	//ĿĽ
};

struct team_exp_entry
{
	int exp;
	int sp;
	XID who;
};

struct msg_exp_t
{
	int level;
	int exp;
	int sp;
};

struct msg_grp_exp_t
{
	int level;
	int exp;
	int sp;
	float rand;
};

struct msg_grpexp_t
{
	XID who;
	int damage;
	int reserve;
	/*
		ӵݽ϶
		ӵľɶ˵˺
		Ը˵˺б,
		бĵһԪطֱwho.type,who.id damageﱣ ֵ level/sp Ͷteam_seq
		who.idĸ16λΪ𣬵16λΪspĿ
		ṹnpc.cppڲĶΪTempDmgNode()

		Ǹö˺бĵڶԪرɱĹƺͼ
		who.type npc tid,who.id һ,ʹôһ

		ڶԪصdamage ʼձtagǷö˺
	*/
};

struct gather_reply
{
	int can_be_interrupted;
	int eliminate_tool;	//ĹߵID
	unsigned short gather_time_min;
	unsigned short gather_time_max;
};

struct gather_result
{
	int amount;
	int task_id;
	int eliminate_tool;		//ɾƷ򸽼ӴID
	int mine_tid;
	int life;		//ɼƷ
	char mine_type;	//
};

struct msg_pickup_t
{
	XID who;
	int team_seq;
};

struct msg_gen_money
{
	int team_id;
	int team_seq;
};

struct msg_npc_transform
{
	int id_in_build;
	int time_use;
	int flag;
	int id_buildup;
	enum 
	{
		FLAG_DOUBLE_DMG_IN_BUILD = 1,
	};
};

struct msg_pet_pos_t
{
	A3DVECTOR pos;
	char inhabit_mode;
};

struct msg_pet_hp_notify
{
	float hp_ratio;
	int   cur_hp;
	char  aggro_state;		//ֳ״̬  0  1  2 
	char  stay_mode;		//ָ淽ʽ: 0 棬1ͣ
	char  combat_state;		//Ƿս
	char  attack_monster;	//Ƿ񹥻
	float mp_ratio;
	int   cur_mp;
};

struct msg_invisible_data
{
	int invisible_degree;
	int anti_invisible_degree;
};

struct msg_contribution_t
{
	int npc_id;				//npcģid
	bool is_owner;			//Ƿǹжͬɱ
	float team_contribution;//鹱ףҲڶΪ˹
	int team_member_count;	//ҲڶΪ1
	float personal_contribution;	//˹׶
};

struct msg_group_contribution_t
{
	int npc_id;				//npcģid
	bool is_owner;			//Ƿǹжͬɱ
	int count;
	struct _list{
		XID xid;	
		float contribution;
	}list[];
};

struct msg_plant_pet_hp_notify
{
	float hp_ratio;
	int   cur_hp;
	float mp_ratio;
	int   cur_mp;
};

struct msg_hp_mp_t
{
	int hp;
	int mp;
};

struct msg_query_spec_item_t
{
	int type;
	int cs_index;
	int cs_sid;
};

struct msg_remove_spec_item_t
{
	int type;
	unsigned char where;
	unsigned char index;
	size_t count;
	int cs_index;
	int cs_sid;
};

struct msg_congregate_req_t
{
	int world_tag;
	int level_req;
	int sec_level_req;
    int reincarnation_times_req;
};

struct msg_dps_dph_t
{
	int level;
	int dps;
	int dph;
	bool update_rank;
};

struct msg_player_t
{
	int id;
	int cs_index;
	int cs_sid;
};

struct msg_player_killed_info_t
{
	int cls;
	bool gender;
	int level;
	int force_id;
};

struct msg_hurt_extra_info_t
{
	bool orange_name;
	char attacker_mode;
};

struct msg_mafia_pvp_award_t
{
	int mafia_id;
	int domain_id;
};

struct msg_punish_me_t
{
	int skill_id;
	int skill_lvl;
};

struct msg_reduce_cd_t
{
	int skill_id;
	int msec;
};

#endif

