#ifndef __NUMA_LIB_H__
#define __NUMA_LIB_H__

namespace Numa
{
	enum {
		POLICY_LOCAL,		//ط(ڵǰCPUӦNODEϷ)
		POLICY_PREFERRED,	//ʹĳNODE, ʧܣѡNODE
		POLICY_INTERLEAVE,	//桢
		POLICY_BIND,		//ϸ󶨵NODEϷ䣬ʧܣʧ
	};

	enum{
		MAX_CPU = 128,		//мٶCPU
		MAX_NODE = 32,		//ٶNODE
	};

	/**********ϵͳصĺ *********/
	namespace System {
		/**
		 * @brief ϵͳеCPU
		 *
		 * @return ȡCPU
		 * @note   CPUΪ0,1,...N-1
		 */
		int GetCpuNum();

		/**
		 * @brief ȡϵͳеNODE
		 *
		 * @return node
		 * @note ڷNUMAṹϵͳNode1.
		 *	 ض1ʱnode0,1,..N-1
		 */
		int GetNodeNum();

		/**
		 * @brief ȡĳNODECPU
		 *
		 * @param node   Numaڴ
		 * @param cpu	ڽcpuŵʼַ
		 * @param maxcpu Խܶٸcpu
		 *
		 * @return 	cpuĿ, maxcpu
		 */
		int GetCpuOnNode(int node, int *cpu, int maxcpu); //ʹͬһnodecpuб

		/**
		 * @brief ĳNUMAϢ
		 *
		 * @param node  Numa
		 * @param total ڽսܹСָ
		 * @param free  ڽսпռָ
		 */
		void GetNodeSize(int node, size_t *total, size_t *free); //nodeĴС
		/**
		 * @brief ĳNUMAϢ64λ
		 *
		 * @param node  Numa
		 * @param total ڽսܹСָ
		 * @param free  ڽսпռָ
		 */
		void GetNodeSize64(int node, long long *total, long long *free); //nodeĴС
	};

	/*********ǰ߳صĺ ********/
	namespace Thread
	{
		//õǰ߳ĸCPU, δʵ
		int GetCurrentCpu();

		/**
		 * @brief õǰ߳ڶٸCPU
		 * 	  SetAffinity()ӰĿ
		 * @return cpu
		 */
		int GetCpuNum();

		/**
		 * @brief ǰ߳ЩCPU
		 *
		 * @param cpu 	  ڽcpuĻַ
		 * @param maxcpu  ɽCPUĸ
		 *
		 * @return 	cpuĿ, maxcpu
		 */
		int GetAffinity(int *cpu, int maxcpu);

		/**
		 * @brief  ЩCPU
		 *
		 * @param cpu	   cpuŵĻʼַ
		 * @param cpu_num  cpu
		 *
		 * @return  0 -- success  <0 -- failed
		 * @note  ܻ,߳ǨƵһCPU
		 */
		int SetAffinity(int *cpu, int cpu_num);	//sched_setaffinity

		/**
		 * @brief   ĸNODECPU
		 *
		 * @param node	  Numaڴ
		 * @return  0 -- success <0 --failed
		 * @note  ϵͳֻһnodeʱ󶨵CPUϡ
		 */
		int SetAffinityByNode(int node);

		/**
		 * @brief ǰ߳ʹõNODE
		 *
		 * @return node, ڵ1
		 * @note ʹĬpolicy localģϵͳеNode
		 */
		int GetNodeNum();

		/**
		 * @brief 	ȡ߳ʹõNODEб
		 *
		 * @param nodes		ڴnodeĻַ
		 * @param maxnode	ŵnode
		 *
		 * @return 	Node.   nodesнnode.
		 * @note	ǰ߳POLICY local,򷵻ϵͳн
		 */
		int GetNode(int *nodes, int maxnode);
		/** 
		 * @brief ȡǰ̵߳NUMA
		 * 
		 * @param policy  ԴNUMAڴ, ΪPOLICY_LOCAL, POLICY_PREFERRED,
				  POLICY_INTERLEAVE, POLICY_BIND
		 * @param nodes		ڴnodeĻַ
		 * @param maxnode	ŵnode
		 * 
		 * @return 	node<=0ʱʾʧ
				policyнԡnodesбnode
		 */
		int GetPolicy(int *policy, int *nodes, int maxnode) ; //get_mempolicy

		/** 
		 * @brief õǰ̵߳NUMA
		 * 
		 * @param policy  NUMAڴ, ΪPOLICY_LOCAL, POLICY_PREFERRED,
				  POLICY_INTERLEAVE, POLICY_BIND
		 * @param nodes		󶨵nodes
		 * @param node_num	󶨵nodepolicyΪlocalʱnodes,nodes_num
		 * 
		 * @return  0 -- success <0 --failed
		 */
		int SetPolicy(int policy, int *nodes, int node_num); //set_mempolicy

		/** 
		 * @brief õǰ̵߳NUMA
		 * 
		 * @param policy  NUMAڴ, ΪPOLICY_LOCAL, POLICY_PREFERRED,
				  POLICY_INTERLEAVE, POLICY_BIND
		 * @param node		󶨵node
		 * 
		 * @return  0 -- success <0 --failed
		 */
		int SetPolicy(int policy, int node);
	};

	/**********ڴصĺ *********/
	namespace Memory
	{
		/** 
		 * @brief 	ȡǰУĳڴַʹõNUMA
		 * 
		 * @param policy   ڴpolicyָ
		 * @param node		ڴnodeĵַ
		 * @param maxnode	node
		 * @param mem		Ҫڴַ
		 * 
		 * @return 	node<=0ʾʧ
		 */
		int GetPolicy(int *policy, int *node, int maxnode, const void *mem);

		/** 
		 * @brief ĳڴNUMA
		 * 
		 * @param policy  NUMAڴ, ΪPOLICY_LOCAL, POLICY_PREFERRED,
				  POLICY_INTERLEAVE, POLICY_BIND
		 * @param nodes		󶨵nodes
		 * @param node_num	󶨵nodepolicyΪlocalʱnodes,nodes_num
		 * @param mem		ڴʼַ
		 * @param size		ڴ泤
		 * 
		 * @return  0 -- success <0 --failed
		 */
		int SetPolicy(int policy, const int *node, int nodenum, void *mem, size_t size);

		/** 
		 * @brief 	ĳضNODEϷһСڴ
		 * 
		 * @param node	Numaڵ
		 * @param size  ڴС
		 * 
		 * @return 	ڴ档NULLʱʧ
		 * @note	һ£ҪʹӿڣķʵmmapһڴȻ
				󶨵node.
				ڴFree(void *mem, size_t size)ͷ
		 */
		void *Alloc(int node, size_t size);

		/** 
		 * @brief ͷAllocڴ
		 * 
		 * @param mem	Allocڴַ
		 * @param size	
		 */
		void Free(void *mem, size_t size);
	};
};

#endif
