/*
 * Decompiled with CFR 0.152.
 */
package expr;

import expr.Analyzer;
import expr.AnalyzerException;
import expr.BoolWrapper;
import expr.ExprParser;
import expr.OGException;
import expr.OGParser;
import expr.ObjectGraph;
import expr.Scanner;
import expr.SyntaxErrorException;
import expr.SyntaxTree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class CodeGen {
    private String code;
    private Scanner scanner;
    private String token_name;
    private int token;
    private SyntaxTree st;
    private int last_token = -1;
    private String addon;
    private boolean blGetNext;
    private static String ogfilename;
    private static String start_point;
    private static ObjectGraph og;
    private static OGParser ogparser;
    private static final int _CONTEXTSTATE_SD_VAR = 0;
    private static final int _CONTEXTSTATE_OGD_VAR = 1;

    public CodeGen() {
        this.code = new String();
    }

    public CodeGen(String _ogfn) {
        try {
            this.code = new String();
            ogfilename = new String(_ogfn);
            og = new ObjectGraph();
            ogparser = new OGParser(ogfilename);
            CodeGen.GenObjectGraph();
        }
        catch (FileNotFoundException e) {
            System.out.println("File " + ogfilename + " not found.");
        }
    }

    public CodeGen(InputStream _is) {
        this.code = new String();
        ogfilename = null;
        og = new ObjectGraph();
        ogparser = new OGParser(_is);
        CodeGen.GenObjectGraph();
    }

    private static void GenObjectGraph() {
        try {
            ogparser.Parse(og);
            System.out.println("Read ObjectGraph successfully.");
        }
        catch (OGException e) {
            System.out.println("catch object graph exception in main.");
        }
    }

    private void GenSyntaxTree(String source) throws SyntaxErrorException {
        this.st = new SyntaxTree();
        try {
            ExprParser expr_parser = new ExprParser(source, 2);
            expr_parser.Parse(this.st, og);
        }
        catch (SyntaxErrorException e) {
            throw e;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void AnalyzeSyntaxTree() throws AnalyzerException {
        Analyzer.Analyze(this.st, og, start_point);
    }

    private String UcFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }

    private boolean isType(String IDName) {
        return og.GetTypeID(IDName) != 0;
    }

    private int judgeContext(String IDName) {
        if (this.st.symtab.Lookup(IDName) != null) {
            return 0;
        }
        return 1;
    }

    private String contextSDHandler(BoolWrapper need_right_bracket) {
        String code = new String();
        switch (this.token) {
            case 15: {
                code = code.concat("(");
                code = code.concat(this.HandleClause());
                code = code.concat(")");
                this.last_token = 16;
                this.token = this.scanner.getToken();
                this.token_name = this.scanner.getTokenName();
                this.blGetNext = false;
                break;
            }
            case 16: {
                break;
            }
            case 21: {
                code = code.concat("[");
                code = code.concat(this.HandleClause());
                code = code.concat("]");
                this.last_token = 22;
                this.token = this.scanner.getToken();
                this.token_name = this.scanner.getTokenName();
                this.blGetNext = false;
                break;
            }
            case 17: {
                if (need_right_bracket.getValue()) {
                    code = code.concat(")");
                    need_right_bracket.setValue(false);
                }
                code = code.concat(this.token_name);
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                code = code.concat(this.token_name + " ");
                break;
            }
            default: {
                code = code.concat(this.token_name);
            }
        }
        return code;
    }

    private String contextOGHandler(BoolWrapper need_right_bracket) {
        String code = new String();
        switch (this.token) {
            case 15: {
                code = code.concat("(");
                code = code.concat(this.HandleClause());
                code = code.concat(")");
                this.last_token = 16;
                this.token = this.scanner.getToken();
                this.token_name = this.scanner.getTokenName();
                this.blGetNext = false;
                break;
            }
            case 16: {
                break;
            }
            case 2: 
            case 51: {
                if (this.isType(this.token_name.toLowerCase())) {
                    code = code.concat(this.token_name);
                    if (this.token != 2) break;
                    code = code.concat(" ");
                    break;
                }
                if (this.last_token != 20) {
                    code = code.concat(this.addon);
                }
                String id_name = this.UcFirst(new String(this.token_name));
                this.token = this.scanner.getToken();
                this.token_name = this.scanner.getTokenName();
                if (this.token == 5) {
                    code = code.concat("Set" + id_name + "(");
                    need_right_bracket.setValue(true);
                    this.blGetNext = true;
                    this.last_token = this.token;
                    break;
                }
                if (this.token == 21) {
                    code = code.concat("Get" + id_name + "()->");
                    String index = this.HandleClause();
                    this.token = this.scanner.getToken();
                    this.token_name = this.scanner.getTokenName();
                    if (this.token == 5) {
                        code = code.concat("SetValue(" + index + ",");
                        need_right_bracket.setValue(true);
                        this.blGetNext = true;
                        this.last_token = this.token;
                        break;
                    }
                    code = code.concat("GetValue(" + index + ")");
                    this.blGetNext = false;
                    this.last_token = 22;
                    break;
                }
                if (this.token == 15) {
                    this.last_token = 15;
                    code = code.concat("Get" + id_name + "(");
                    code = code.concat(this.HandleClause());
                    code = code.concat(")");
                    this.last_token = 16;
                    this.token = this.scanner.getToken();
                    this.token_name = this.scanner.getTokenName();
                    this.blGetNext = false;
                    break;
                }
                code = code.concat("Get" + id_name + "()");
                this.blGetNext = false;
                this.last_token = this.token;
                break;
            }
            case 5: 
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 20: {
                code = code.concat("->");
                break;
            }
            case 17: {
                if (need_right_bracket.getValue()) {
                    code = code.concat(")");
                    need_right_bracket.setValue(false);
                }
                code = code.concat(this.token_name);
                break;
            }
            case 25: {
                code = code.concat(" && ");
                break;
            }
            case 26: {
                code = code.concat(" || ");
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                code = code.concat(this.token_name + " ");
                break;
            }
            default: {
                code = code.concat(this.token_name);
            }
        }
        return code;
    }

    private String HandleClause() {
        String code = new String();
        BoolWrapper need_right_bracket = new BoolWrapper(false);
        this.token = this.scanner.getToken();
        this.token_name = this.scanner.getTokenName();
        int context_state = this.judgeContext(this.token_name);
        while (this.token != 0 && this.token != 22 && this.token != 16) {
            this.blGetNext = true;
            if (context_state == 0) {
                code = code.concat(this.contextSDHandler(need_right_bracket));
            } else if (context_state == 1) {
                code = code.concat(this.contextOGHandler(need_right_bracket));
            }
            if (this.blGetNext) {
                this.last_token = this.token;
                this.token = this.scanner.getToken();
                this.token_name = this.scanner.getTokenName();
            }
            if (this.token != 2 || this.last_token == 20) continue;
            context_state = this.judgeContext(this.token_name);
        }
        if (need_right_bracket.getValue()) {
            code = code.concat(")");
            need_right_bracket.setValue(false);
        }
        return code;
    }

    private String GenerateCode(BufferedReader source) {
        this.scanner = new Scanner(source);
        this.last_token = -1;
        return this.HandleClause();
    }

    private String GenerateCode(String source) {
        this.scanner = new Scanner(source);
        this.last_token = -1;
        return this.HandleClause();
    }

    public void SyntaxCheck(String source, String env_class) throws SyntaxErrorException, AnalyzerException {
        try {
            if (env_class == null) {
                env_class = new String("Skill");
            }
            start_point = new String(env_class);
            this.GenSyntaxTree(source);
            this.AnalyzeSyntaxTree();
        }
        catch (SyntaxErrorException e) {
            throw e;
        }
        catch (AnalyzerException e) {
            throw e;
        }
    }

    public String GenExpr(String source, String env_class, String _addon) throws SyntaxErrorException, AnalyzerException {
        try {
            start_point = new String(env_class);
            this.GenSyntaxTree(source);
            this.AnalyzeSyntaxTree();
            this.code = "";
            this.addon = new String(_addon);
            return this.GenerateCode(source);
        }
        catch (SyntaxErrorException e) {
            throw e;
        }
        catch (AnalyzerException e) {
            throw e;
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("usage: CodeGen <*.og> <env_class> <source file>");
        }
        try {
            CodeGen codegen = new CodeGen(new FileInputStream(new File(args[0])));
            System.out.println(codegen.GenExpr(args[2], args[1], "skill->"));
        }
        catch (FileNotFoundException e) {
            System.out.println("File " + args[0] + " not found.");
        }
        catch (SyntaxErrorException e) {
            System.out.println("catch Syntax error exception.");
        }
        catch (AnalyzerException e) {
            System.out.println("catch Analyzer exception.");
        }
        catch (IOException e) {
            System.out.println("read expr file exception.");
        }
    }

    static {
        start_point = new String();
        og = new ObjectGraph();
    }
}

