/*
 * Decompiled with CFR 0.152.
 */
package expr;

import expr.AnalyzerException;
import expr.ObjectGraph;
import expr.SyntaxTree;
import expr.TreeNode;

public class Analyzer {
    private static ObjectGraph og;
    private static TreeNode current_treenode;
    private static int current_type;
    static Analyzer instance;
    private static SyntaxTree st;
    private static int context_state;

    private Analyzer() {
    }

    private void TypeCheck(int type1, int type2) throws AnalyzerException {
        this.TypeCheck(type1, type2, true);
    }

    private void TypeCheck(int type1, int type2, boolean strict) throws AnalyzerException {
        if (type1 == 51 || type2 == 51) {
            return;
        }
        if (strict) {
            if (type1 == type2) {
                return;
            }
            throw new AnalyzerException("Type mismatch.", Analyzer.current_treenode.lineno);
        }
        if (type1 == type2) {
            return;
        }
        if (ObjectGraph.reserved_type.containsValue(new Integer(type1)) && ObjectGraph.reserved_type.containsValue(new Integer(type2))) {
            if (type1 >= type2 || Analyzer.current_treenode.nodekind != 1 || Analyzer.current_treenode.kind != 1 || Analyzer.current_treenode.op == 5) {
                // empty if block
            }
            return;
        }
        throw new AnalyzerException("Type mismatch.", Analyzer.current_treenode.lineno);
    }

    private int OGCheck(int parent_type, int child_name) {
        return og.FindMemberNode(parent_type, child_name);
    }

    private void StmtCheck(TreeNode t) throws AnalyzerException {
        if (t == null) {
            return;
        }
        current_treenode = t;
        for (int i = 0; i < t.child.size(); ++i) {
            this.StmtCheck((TreeNode)t.child.get(i));
        }
        current_treenode = t;
        if (t.nodekind == 0) {
            switch (t.kind) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    if (t.child.get(0) != null) break;
                    throw new AnalyzerException("Invalid announcement statement.", Analyzer.current_treenode.lineno);
                }
            }
        } else if (t.nodekind == 1) {
            block4 : switch (t.kind) {
                case 2: {
                    t.type = og.GetIdentifier("int");
                    if (t.type != 0) break;
                    throw new AnalyzerException("Cannot find 'int' type in OG.", Analyzer.current_treenode.lineno);
                }
                case 3: {
                    t.type = og.GetIdentifier("float");
                    if (t.type != 0) break;
                    throw new AnalyzerException("Cannot find 'float' type in OG.", Analyzer.current_treenode.lineno);
                }
                case 4: {
                    if (context_state == 0) {
                        throw new AnalyzerException("Cannot define const array without Announcement.", Analyzer.current_treenode.lineno);
                    }
                    if (t.child.get(0) == null) {
                        throw new AnalyzerException("Invalid array definition.", Analyzer.current_treenode.lineno);
                    }
                    t.type = ((TreeNode)t.child.get((int)0)).type;
                    break;
                }
                case 5: {
                    if (t.child.size() != 0) {
                        t.type = this.OGCheck(((TreeNode)t.child.get((int)0)).type, og.GetIdentifier(t.name));
                        if (t.type != 0) break;
                        throw new AnalyzerException("Invalid membership.", Analyzer.current_treenode.lineno);
                    }
                    t.type = this.OGCheck(current_type, og.GetIdentifier(t.name));
                    if (t.type != 0) break;
                    TreeNode var_node = Analyzer.st.symtab.Lookup(t.name);
                    if (var_node != null) {
                        t.type = var_node.type;
                        t.struct_type = var_node.struct_type;
                        break;
                    }
                    throw new AnalyzerException("Invalid membership.", Analyzer.current_treenode.lineno);
                }
                case 1: {
                    switch (t.op) {
                        case 5: {
                            if (t.child.size() != 2) {
                                throw new AnalyzerException("Invalid assignment node.", Analyzer.current_treenode.lineno);
                            }
                            this.TypeCheck(((TreeNode)t.child.get((int)0)).type, ((TreeNode)t.child.get((int)1)).type, false);
                            t.type = ((TreeNode)t.child.get((int)0)).type;
                            break block4;
                        }
                        case 18: {
                            if (t.child.size() != 3) {
                                throw new AnalyzerException("Invalid select structure.", Analyzer.current_treenode.lineno);
                            }
                            this.TypeCheck(((TreeNode)t.child.get((int)0)).type, og.GetIdentifier("bool"));
                            int type1 = ((TreeNode)t.child.get((int)1)).type;
                            int type2 = ((TreeNode)t.child.get((int)2)).type;
                            if (type1 < type2) {
                                int tmp = type2;
                                type2 = type1;
                                type1 = tmp;
                            }
                            this.TypeCheck(type1, type2, false);
                            t.type = type1;
                            break block4;
                        }
                        case 20: {
                            if (t.child.size() == 0) {
                                throw new AnalyzerException("Invalid member(parent.child) structure.", Analyzer.current_treenode.lineno);
                            }
                            t.type = ((TreeNode)t.child.get((int)0)).type;
                            break block4;
                        }
                        case 21: {
                            if (t.child.size() != 2) {
                                throw new AnalyzerException("Invalid index(expr[*]) structure.", Analyzer.current_treenode.lineno);
                            }
                            this.TypeCheck(((TreeNode)t.child.get((int)1)).type, og.GetIdentifier("int"));
                            t.type = ((TreeNode)t.child.get((int)0)).type;
                            TreeNode var_node = Analyzer.st.symtab.Lookup(((TreeNode)t.child.get((int)0)).name);
                            if (var_node == null) {
                                if (context_state == 0) {
                                    t.type = og.FindMemberNode(((TreeNode)t.child.get((int)0)).type, og.GetIdentifier("value"));
                                    if (t.type != 0) break block4;
                                    throw new AnalyzerException("Invalid array object. No 'value' field in OG file.", Analyzer.current_treenode.lineno);
                                }
                                if (context_state != 1) break block4;
                                throw new AnalyzerException("Cannot define array of class that defined in OG.", Analyzer.current_treenode.lineno);
                            }
                            if (context_state == 0) {
                                if (var_node.struct_type == 1) break block4;
                                throw new AnalyzerException("Cann't do '[]' operation on non-array variable.", Analyzer.current_treenode.lineno);
                            }
                            if (context_state != 1) break block4;
                            if (t.type > 30) {
                                throw new AnalyzerException("cannnot create array of class which is defined in OG file.", Analyzer.current_treenode.lineno);
                            }
                            if (((TreeNode)t.child.get((int)1)).nodekind != 1 || ((TreeNode)t.child.get((int)1)).kind != 2) {
                                throw new AnalyzerException("Array maybe un-initialed.", Analyzer.current_treenode.lineno);
                            }
                            var_node.struct_type = 1;
                            break block4;
                        }
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 29: {
                            if (t.child.size() != 2) {
                                throw new AnalyzerException("Invalid logic operator structure.", Analyzer.current_treenode.lineno);
                            }
                            this.TypeCheck(((TreeNode)t.child.get((int)0)).type, ((TreeNode)t.child.get((int)1)).type, false);
                            t.type = og.GetIdentifier("bool");
                            break block4;
                        }
                        case 25: 
                        case 26: {
                            if (t.child.size() != 2) {
                                throw new AnalyzerException("Invalid logic operator structure.", Analyzer.current_treenode.lineno);
                            }
                            this.TypeCheck(((TreeNode)t.child.get((int)0)).type, ((TreeNode)t.child.get((int)1)).type, false);
                            t.type = og.GetIdentifier("bool");
                            break block4;
                        }
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 28: {
                            if (t.child.size() != 2) {
                                throw new AnalyzerException("Invalid arithmetic operator structure.", Analyzer.current_treenode.lineno);
                            }
                            int type1 = ((TreeNode)t.child.get((int)0)).type;
                            int type2 = ((TreeNode)t.child.get((int)1)).type;
                            if (t.op == 28) {
                                this.TypeCheck(type1, og.GetIdentifier("int"));
                                this.TypeCheck(type2, og.GetIdentifier("int"));
                            } else {
                                if (type1 < type2) {
                                    int tmp = type2;
                                    type2 = type1;
                                    type1 = tmp;
                                }
                                this.TypeCheck(type1, type2, false);
                            }
                            t.type = type1;
                            break block4;
                        }
                    }
                    throw new AnalyzerException("Invalid node kind.", Analyzer.current_treenode.lineno);
                }
            }
        } else {
            throw new AnalyzerException("Invalid node kind.", Analyzer.current_treenode.lineno);
        }
    }

    public static Analyzer GetInstance() {
        return instance;
    }

    static void Analyze(SyntaxTree _st, ObjectGraph _og, String start_point_type) throws AnalyzerException {
        og = _og;
        st = _st;
        if (_og == null) {
            return;
        }
        try {
            TreeNode t = _st.GetRoot();
            if (null == t) {
                throw new AnalyzerException("Syntax tree is empty.", 0);
            }
            current_type = og.GetIdentifier(start_point_type);
            if (current_type == 0) {
                throw new AnalyzerException("Current type (" + start_point_type + ") is invalid.", 0);
            }
            while (t != null) {
                current_treenode = t;
                if (t.nodekind == 0) {
                    switch (t.kind) {
                        case 5: {
                            if (og.GetIdentifier(t.name) != 0) {
                                throw new AnalyzerException("Variable " + t.name + " has be defined in OG file.", t.lineno);
                            }
                            if (!Analyzer.st.symtab.Insert(t)) {
                                throw new AnalyzerException("Variable " + t.name + " has be defined before.", t.lineno);
                            }
                            context_state = 1;
                            break;
                        }
                        default: {
                            context_state = 0;
                            break;
                        }
                    }
                } else {
                    context_state = 0;
                }
                Analyzer.GetInstance().StmtCheck(t);
                t = t.sibling;
            }
        }
        catch (AnalyzerException e) {
            System.out.println("Error: " + e.getMessage() + " at line " + e.getLineno());
            if (current_treenode != null) {
                SyntaxTree.DisplayWholeTree(current_treenode, 4);
            }
            e.printStackTrace();
            throw e;
        }
    }

    static {
        instance = new Analyzer();
    }
}

