/*
 * Decompiled with CFR 0.152.
 */
package Cpp;

import Cpp.CppBlock;
import Cpp.CppComponent;
import Cpp.CppParameterList;
import Cpp.CppWriter;
import java.io.PrintStream;

public class CppMethod
implements CppWriter,
CppComponent {
    protected String type;
    protected String name;
    protected boolean isStatic;
    protected boolean isConst;
    protected int scope;
    protected CppParameterList parameterList;
    protected CppBlock block;

    CppMethod(String type, String name, boolean isStatic, boolean isConst, int scope) {
        this.type = type;
        this.name = name;
        this.isStatic = isStatic;
        this.isConst = isConst;
        this.scope = scope;
    }

    public CppComponent add(CppComponent component) {
        if (component instanceof CppParameterList) {
            this.parameterList = (CppParameterList)component;
        }
        if (component instanceof CppBlock) {
            this.block = (CppBlock)component;
        }
        return this;
    }

    public void write(PrintStream ps) {
        if (this.scope == 1) {
            ps.println("#ifdef _SKILL_SERVER");
        } else if (this.scope == 2) {
            ps.println("#ifdef _SKILL_CLIENT");
        }
        if (this.isStatic) {
            ps.print("static ");
        }
        ps.print(this.type + " " + this.name);
        this.parameterList.write(ps);
        if (this.isConst) {
            ps.print(" const");
        }
        this.block.write(ps);
        if (this.scope != 0) {
            ps.println("#endif");
        }
    }
}

