/*
 * Decompiled with CFR 0.152.
 */
package Cpp;

import Cpp.CppComponent;
import Cpp.CppConstructor;
import Cpp.CppDefineScope;
import Cpp.CppDestructor;
import Cpp.CppField;
import Cpp.CppMethod;
import Cpp.CppWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CppClass
implements CppWriter,
CppComponent {
    protected String name;
    protected ArrayList parents = new ArrayList();
    protected ArrayList nestclass = new ArrayList();
    protected ArrayList fields = new ArrayList();
    protected ArrayList constructors = new ArrayList();
    protected ArrayList methods = new ArrayList();
    protected ArrayList scopes = new ArrayList();
    protected CppDestructor destructor;
    protected boolean isOnlyServer;

    public CppClass(String name) {
        this.name = name;
    }

    public CppClass(String name, String parent) {
        this.name = name;
        this.parents.add(parent);
    }

    public CppClass(String name, String parent, boolean isOnlyServer) {
        this.name = name;
        this.parents.add(parent);
        this.isOnlyServer = isOnlyServer;
    }

    public CppClass(String name, List parent) {
        this.name = name;
        this.parents.addAll(parent);
    }

    public String getName() {
        return this.name;
    }

    public void write(PrintStream ps) {
        if (this.isOnlyServer) {
            ps.println("#ifdef _SKILL_SERVER");
        }
        ps.print("class " + this.name);
        boolean first = true;
        Iterator it = this.parents.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
                ps.print(":");
            } else {
                ps.print(",");
            }
            String parent = (String)it.next();
            ps.print("public " + parent);
        }
        ps.println();
        ps.println("{");
        ps.println("public:");
        it = this.nestclass.iterator();
        while (it.hasNext()) {
            ((CppClass)it.next()).write(ps);
        }
        it = this.fields.iterator();
        while (it.hasNext()) {
            ((CppField)it.next()).write(ps);
        }
        it = this.constructors.iterator();
        while (it.hasNext()) {
            ((CppConstructor)it.next()).write(ps);
        }
        if (this.destructor != null) {
            this.destructor.write(ps);
        }
        it = this.methods.iterator();
        while (it.hasNext()) {
            ((CppMethod)it.next()).write(ps);
        }
        it = this.scopes.iterator();
        while (it.hasNext()) {
            ((CppDefineScope)it.next()).write(ps);
        }
        ps.println("};");
        if (this.isOnlyServer) {
            ps.println("#endif");
        }
    }

    public CppComponent add(CppComponent component) {
        if (component instanceof CppClass) {
            this.nestclass.add(component);
        } else if (component instanceof CppConstructor) {
            this.constructors.add(component);
        } else if (component instanceof CppDestructor) {
            this.destructor = (CppDestructor)component;
        } else if (component instanceof CppField) {
            this.fields.add(component);
        } else if (component instanceof CppMethod) {
            this.methods.add(component);
        } else if (component instanceof CppDefineScope) {
            this.scopes.add(component);
        }
        return this;
    }
}

