// Filename	: EC_PetWords.cpp
// Creator	: Xu Wenbin
// Date		: 2010/11/04

#include "EC_PetWords.h"
#include <AFI.h>
#include <limits.h>
#include <ALog.h>
#include <AChar.h>

CECPetWords::CECPetWords()
{
	Reset();
}

void CECPetWords::Reset()
{
	//	Ĭϸ¶˵Ϊ1
	for (int i = 0; i < TW_MAX; ++ i)
		m_wordsProp[i] = 1.0f;

	//	г
	m_words.clear();
}

bool CECPetWords::LoadWords(const char *szFile)
{
	//	سҪ˵Ļ

	bool bRet(false);

	//	
	Reset();
	
	AWScriptFile ScriptFile;
	while (af_IsFileExist(szFile))
	{
		if (!ScriptFile.Open(szFile))
		{
			a_LogOutput(1, "CECPetWords::LoadWords(), Failed to open file %s", szFile);
			break;
		}

		if (!ReadType(ScriptFile))
			break;

		if (!ReadContent(ScriptFile))
			break;

		bRet = true;
		break;
	}
	ScriptFile.Close();

	return bRet;
}

const ACHAR * CECPetWords::GetWords(int idPet, TYPE_WORDS type)
{
	//	龰ͳIDѯǷлҪ˵NULLʾûУβ˵ʿƣ

	const ACHAR *szRet = NULL;

	WordsID w;
	w.id = idPet;
	w.type = type;
	
	WordsMap::iterator it = m_words.find(w);
	if (it != m_words.end())
	{
		//	л˵

		//	ʣжǷ˵
		float f = a_Random(0.0f, 1.0f);
		if (f <= m_wordsProp[type])
		{
			//	˵ѡһ仰
			int i = a_Random() % it->second.size();
			szRet = it->second[i];
		}
	}

	return szRet;
}

typedef abase::hash_map<ACString, CECPetWords::TYPE_WORDS> TypeMaps;	//	ļе summon תΪ TW_SUMMON ͵ӳ
void InitTypeMaps(TypeMaps &typeMaps)
{
	//	תӳ

	typeMaps.clear();

	typeMaps[_AL("summon")]		= CECPetWords::TW_SUMMON;
	typeMaps[_AL("rest")]		= CECPetWords::TW_REST;
	typeMaps[_AL("passive")]	= CECPetWords::TW_PASSIVE;
	typeMaps[_AL("defensive")]	= CECPetWords::TW_DEFENSIVE;
	typeMaps[_AL("offensive")]	= CECPetWords::TW_OFFENSIVE;
	typeMaps[_AL("stop")]		= CECPetWords::TW_STOP;
	typeMaps[_AL("follow")]		= CECPetWords::TW_FOLLOW;
	typeMaps[_AL("fight")]		= CECPetWords::TW_FIGHT;
	typeMaps[_AL("recall")]		= CECPetWords::TW_RECALL;
	typeMaps[_AL("dead")]		= CECPetWords::TW_DEAD;
	typeMaps[_AL("disappear")]	= CECPetWords::TW_DISAPPEAR;	
	typeMaps[_AL("sacrifice")]	= CECPetWords::TW_SACRIFICE;
}

bool CECPetWords::ReadType(AWScriptFile &ScriptFile)
{
	//	ȡݣʱ˵ĳ仰ĸгһ
	//

	bool bRet(false);
	
	while (true)
	{
		//	ȡͷ
		wchar_t * szTypeHead = L"[TYPE]";
		wchar_t * szListHead = L"[LIST]";

		if (!ScriptFile.MatchToken(szTypeHead, true))
		{
			AString strTemp = AC2AS(szTypeHead);
			a_LogOutput(1, "CECPetWords::LoadWords(), File Format error, type head mark \"%s\" missed", strTemp);
			break;
		}

		//	ʼת飬ļе summon תΪ TW_SUMMON ͵ӳ
		TypeMaps typeMaps;
		InitTypeMaps(typeMaps);
		
		//	ȡ
		while (ScriptFile.PeekNextToken(true))
		{
			//	˵бΪֹʹ Peek  Get
			if (!a_strcmp(ScriptFile.m_szToken, szListHead))
				break;

			//	ȡǷΪЧַ
			ScriptFile.GetNextToken(true);

			TypeMaps::iterator it = typeMaps.find(ScriptFile.m_szToken);
			if (it == typeMaps.end())
			{
				//	ЧУעͻУӴ
				ScriptFile.SkipLine();
				continue;
			}

			//	Դӱкַȡ
			float fVal = 0.0f;
			if (!ScriptFile.GetNextToken(false) ||
				swscanf(ScriptFile.m_szToken, L"%f", &fVal) != 1 ||
				fVal < 0.0f || fVal > 1.0f)
			{
				//	ûַڷǷ
				a_LogOutput(1, "CECPetWords::LoadWords(), File Format error, invalid probability at line %d", ScriptFile.GetCurLine());

				//	ӱУеķ
				ScriptFile.SkipLine();
				continue;
			}

			//	ɹӸ
			m_wordsProp[it->second] = fVal;

			//	ӱ˵
			ScriptFile.SkipLine();

			//	һ
		}

		bRet = true;
		break;

	}
	return bRet;
}

bool CECPetWords::ReadContent(AWScriptFile &ScriptFile)
{
	bool bRet(false);

	while (true)
	{
		//	ȡͷ
		wchar_t * szListHead = L"[LIST]";
		
		if (!ScriptFile.MatchToken(szListHead, true))
		{
			a_LogOutput(1, "CECPetWords::LoadWords(), File Format error, \"%s\" missed", szListHead);
			break;
		}

		//	ʼת飬ļе summon תΪ TW_SUMMON ͵ӳ
		TypeMaps typeMaps;
		InitTypeMaps(typeMaps);

		WordsID w;

		//	ȡ
		while (ScriptFile.GetNextToken(true))
		{
			//	ȻȡID
			int idPet(0);
			if (swscanf(ScriptFile.m_szToken, L"%d", &idPet) != 1)
			{
				//	עл
				ScriptFile.SkipLine();
				continue;
			}
			if (idPet <= 0)
			{
				//	IDǷЧ
				a_LogOutput(1, "CECPetWords::LoadWords(), File Content error, invalid pet id(%d) at line %d", idPet, ScriptFile.GetCurLine());

				//	ӱУеķ
				ScriptFile.SkipLine();
				continue;
			}

			//	ٻȡкĺʱ
			if (!ScriptFile.GetNextToken(false))
			{
				//	޷ȡ˵ʱЧ
				a_LogOutput(1, "CECPetWords::LoadWords(), File Format error, incomplete format at line %d", ScriptFile.GetCurLine());

				//	ӱУеķ
				ScriptFile.SkipLine();
				continue;
			}
			
			TypeMaps::iterator it = typeMaps.find(ScriptFile.m_szToken);
			if (it == typeMaps.end())
			{
				//	ͲʶЧ
				AString strToken = AC2AS(ScriptFile.m_szToken);
				a_LogOutput(1, "CECPetWords::LoadWords(), File Format error, Unknown words type string \"%s\" at line %d", strToken, ScriptFile.GetCurLine());

				//	ӱУеķ
				ScriptFile.SkipLine();
				continue;
			}

			//	ȡĺ
			if (!ScriptFile.GetNextToken(false))
			{
				//	ûкݣЧ
				a_LogOutput(1, "CECPetWords::LoadWords(), File Format error, pet said NO words at line %d", ScriptFile.GetCurLine());

				//	ӱУеķ
				ScriptFile.SkipLine();
				continue;
			}

			//	Խӵ
			w.id = idPet;
			w.type = it->second;
			WordsMap::iterator it2 = m_words.find(w);
			if (it2 != m_words.end())
			{
				//	ͬһIDͬһͣж仰ó MAX_WORDSCOUNT
				if (it2->second.size() >= MAX_WORDSCOUNT)
				{
					//	޶
					a_LogOutput(1, "CECPetWords::LoadWords(), The pet already has enough words to say, Words ignored (id = %d) at line %d", idPet, ScriptFile.GetCurLine());
					
					//	ӱУеķ
					ScriptFile.SkipLine();
					continue;
				}
			}
			m_words[w].push_back(ScriptFile.m_szToken);

			//	ӱݣеĻ
			ScriptFile.SkipLine();

			//	һ
		}

		bRet = true;
		break;
	}
	return bRet;
}