/*
 * FILE: EC_MemSimplify.h
 *
 * DESCRIPTION: 
 *
 * CREATED BY: Shizhenhua, 2013/4/3
 *
 * HISTORY: 
 *
 * Copyright (c) 2011 ACE Studio, All Rights Reserved.
 */

#pragma once

#include <ABaseDef.h>
#include <AArray.h>
#include <AAssist.h>
#include <vector>
#include <hashmap.h>
#include "EC_Counter.h"


///////////////////////////////////////////////////////////////////////////
//	
//	Define and Macro
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Types and Global variables
//	
///////////////////////////////////////////////////////////////////////////

class CECPlayer;
class CECElsePlayer;

///////////////////////////////////////////////////////////////////////////
//	
//	Declare of Global functions
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Class CECMemSimplify
//	
///////////////////////////////////////////////////////////////////////////

class CECMemSimplify
{
public:

	//  Memory usage
	enum
	{
		MEMUSAGE_NORMAL,
		MEMUSAGE_NOFACE,
		MEMUSAGE_SIMPLEMODEL,
		MEMUSAGE_NOMODEL_UNIMPORTANT,
		MEMUSAGE_NOMODEL,
		
		MEMUSAGE_NUM,
	};

	typedef void (CECMemSimplify::*FN_TRANSFER_USAGE) (CECElsePlayer* pPlayer);

	struct PlayerQueueNode{
		CECElsePlayer * m_pPlayer;
		DWORD			m_dwMask;
		PlayerQueueNode()
			: m_pPlayer(NULL)
			, m_dwMask(0)
		{}
		PlayerQueueNode(CECElsePlayer *pPlayer)
			: m_pPlayer(pPlayer)
			, m_dwMask(0)
		{
		}
		bool operator == (const CECElsePlayer *rhs)const{
			return m_pPlayer == rhs;
		}
		bool operator == (const PlayerQueueNode &rhs)const{
			return m_pPlayer == rhs.m_pPlayer;
		}
		void Mask(DWORD newMask){
			m_dwMask |= newMask;
		}
		void Unmask(DWORD newMask){
			m_dwMask &= ~newMask;
		}
		bool HasMask(DWORD dwMask)const{
			return (m_dwMask & dwMask) != 0;
		}
	};
	typedef std::vector<PlayerQueueNode> PlayerQueue;
	struct PlayerSorter
	{
		// ڸҰȼȼߵȽģ;
		bool operator () (const PlayerQueueNode & lhs, const PlayerQueueNode & rhs) const;

		// ȡҵҪȼ
		int GetImportantLevel(const CECElsePlayer* pPlayer) const;
	};

public:
	CECMemSimplify();

	void Tick(DWORD dwDeltaTime);

	// ҽ
	void OnPlayerEnter(CECElsePlayer* pPlayer);

	// 뿪
	void OnPlayerLeave(CECElsePlayer* pPlayer);

	// Ϸ״̬ʱ
	void OnEndGameState();

	// ͬһлָSTATE
	void TransferUsageAll(int iNewState);

	// ȡǰڴС
	DWORD GetMemSize() const { return m_dwMemSize; }

	// ǰȫڴʹ
	int GetGlobalMemUsage() const { return m_iMemUsage; }

	// ǲҪ
	bool IsImportant(const CECPlayer* pPlayer ) const;
	bool IsMostImportant(const CECPlayer* pPlayer)const;

	// ԶŻڴ
	void SetAutoOptimize(bool bAuto) { m_bAutoOptimize = bAuto; }

	// ǷԶŻ
	bool IsAutoOptimize() const { return m_bAutoOptimize; }

protected:
	DWORD m_dwMemSize;		// ǰڴС
	CECCounter m_cntCheckMem;	// ÿʱһڴ״
	PlayerQueue m_PlayerQueue[MEMUSAGE_NUM];	// ڴ״̬µ
	int m_iMemUsage;		// ǰڴʹ״
	bool m_bAutoOptimize;	// ǷԶŻ
	DWORD m_dwMemLow;		// ڴֵỹԭ򻯵ģ
	DWORD m_dwMemHigh;		// ڴֵᰴȼģ

protected:

	// תڴ״̬
	void TransferUsage(CECElsePlayer* pPlayer, int iNewUsage);

	// ıFACEģʽ
	void ToggleFaceMode(CECElsePlayer* pPlayer);

	// лMODELģʽ
	void ToggleSimpleModel(CECElsePlayer* pPlayer);

	// лҪģģʽ
	void ToggleNoModelNoImportant(CECElsePlayer* pPlayer);

	// лģģʽ
	void ToggleNoModel(CECElsePlayer* pPlayer);

	// ģ״̬
	void UpdatePlayerModels();
	typedef bool (CECMemSimplify::*ImportanceFunction)(const CECPlayer* pPlayer)const;
	void LoadUnloadByImportance(int queueIndex, DWORD dwReloadingMask, ImportanceFunction isImportant);
};

///////////////////////////////////////////////////////////////////////////
//	
//	Inline functions
//	
///////////////////////////////////////////////////////////////////////////
