/*
 * FILE: EC_IvtrEquipMatter.cpp
 *
 * DESCRIPTION: 
 *
 * CREATED BY: Hedi, 2006/8/3
 *
 * HISTORY: 
 *
 * Copyright (c) 2006 Archosaur Studio, All Rights Reserved.
 */


#include "EC_Global.h"
#include "EC_IvtrEquipMatter.h"
#include "EC_Game.h"
#include "EC_FixedMsg.h"
#include "EC_GameRun.h"
#include "EC_HostPlayer.h"
#include "EC_RTDebug.h"
#include "elementdataman.h"
#include "EC_Configs.h"
#include "EC_ForceMgr.h"
#include "EC_Skill.h"
#include "EC_Inventory.h"
#include "../CElementSkill/ElementSkill.h"

///////////////////////////////////////////////////////////////////////////
//	
//	Define and Macro
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Reference to External variables and functions
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Local Types and Variables and Global variables
//	
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
//	
//	Local functions
//	
///////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////
//	
//	Implement CECIvtrBible
//	
///////////////////////////////////////////////////////////////////////////

CECIvtrBible::CECIvtrBible(int tid, int expire_date) : CECIvtrEquip(tid, expire_date)
{
	m_iCID	= ICID_BIBLE;

	//	Get database data
	elementdataman* pDB = g_pGame->GetElementDataMan();
	DATA_TYPE DataType;
	m_pDBEssence = (BIBLE_ESSENCE*)pDB->get_data_ptr(tid, ID_SPACE_ESSENCE, DataType);

	m_iPileLimit	= m_pDBEssence->pile_num_max;
	m_iPrice		= m_pDBEssence->price;
	m_iShopPrice	= m_pDBEssence->shop_price;
	m_iProcType		= m_pDBEssence->proc_type;
	m_i64EquipMask	= EQUIP_MASK64_BIBLE;

	m_iCurEndurance = 100;
	m_iMaxEndurance = 100;

	m_bNeedUpdate	= false;
}

CECIvtrBible::CECIvtrBible(const CECIvtrBible& s) : CECIvtrEquip(s)
{
	m_pDBEssence	= s.m_pDBEssence;
}

CECIvtrBible::~CECIvtrBible()
{
}

//	Set item detail information
bool CECIvtrBible::SetItemInfo(BYTE* pInfoData, int iDataLen)
{
	CECIvtrItem::SetItemInfo(pInfoData, iDataLen);
	return true;
}

//	Get item icon file name
const char* CECIvtrBible::GetIconFile()
{
	return m_pDBEssence->file_icon;
}

//	Get item name
const wchar_t* CECIvtrBible::GetName()
{
	return m_pDBEssence->name;
}

//	Get item description text
const wchar_t* CECIvtrBible::GetNormalDesc(bool bRepair)
{
	if (m_bNeedUpdate)
		return NULL;

	m_strDesc = _AL("");

	//	Try to build item description
	CECStringTab* pDescTab = g_pGame->GetItemDesc();
	CECHostPlayer* pHost = g_pGame->GetGameRun()->GetHostPlayer();
	
	int white = ITEMDESC_COL_WHITE;
	int namecol = DecideNameCol();

	if (m_iCount > 1)
		AddDescText(namecol, true, pDescTab->GetWideString(ITEMDESC_NAMENUMBER), GetName(), m_iCount);
	else
		AddDescText(namecol, true, pDescTab->GetWideString(ITEMDESC_NAME), GetName());

	AddIDDescText();
	
	AddBindDescText();
	
	//  Is destroying?
	AddDestroyingDesc(m_pDBEssence->id_drop_after_damaged, m_pDBEssence->num_drop_after_damaged);

	AddExpireTimeDesc();

	//	Price
	AddPriceDesc(white, bRepair);

	//	Suite description
//	AddSuiteDesc();
	
	//	Extend description
	AddExtDescText();

	return m_strDesc;
}

//	Get drop model for shown
const char * CECIvtrBible::GetDropModel()
{
	return m_pDBEssence->file_matter;
}

//	Add deadly strike rate provided by this equipment 
//	bSuite: true, get deadly strike generated by suite
//  By Sunxuewei 2008/9/3
int CECIvtrBible::GetDeadlyStrikeRate(bool bSuiteGen)
{
	if (bSuiteGen)
		return CECIvtrEquip::GetDeadlyStrikeRate(bSuiteGen);
	
	int iVal = 0;

	//	Get database data
	elementdataman* pDataMan = g_pGame->GetElementDataMan();
	CECGame::ItemExtPropTable& PropTab = g_pGame->GetItemExtPropTable();

	for(int i=0; i < 10; i++)
	{
		int idProp = (int)m_pDBEssence->id_addons[i];	

		CECGame::ItemExtPropTable::pair_type Pair = PropTab.get(idProp);
		BYTE byPropType = Pair.second ? *Pair.first : 0xff;

		if (byPropType == 45)	//	Deadly strike
		{
			DATA_TYPE DataType = DT_INVALID;
			const void* pData = pDataMan->get_data_ptr(idProp, ID_SPACE_ADDON, DataType);
			if (DataType != DT_EQUIPMENT_ADDON)
			{
				ASSERT(DataType == DT_EQUIPMENT_ADDON);
				return 0;
			}
			
			const EQUIPMENT_ADDON* pAddon = (const EQUIPMENT_ADDON*)pData;						
			float* fTemp = (float*)&pAddon->param1;			
			iVal += (int)(*fTemp*100 + 0.001f);
		}
	}

	return iVal;
}
///////////////////////////////////////////////////////////////////////////
//	
//	Implement CECIvtrSpeaker
//	
///////////////////////////////////////////////////////////////////////////

CECIvtrSpeaker::CECIvtrSpeaker(int tid, int expire_date) : CECIvtrEquip(tid, expire_date)
{
	m_iCID	= ICID_SPEAKER;

	//	Get database data
	elementdataman* pDB = g_pGame->GetElementDataMan();
	DATA_TYPE DataType;
	m_pDBEssence = (SPEAKER_ESSENCE*)pDB->get_data_ptr(tid, ID_SPACE_ESSENCE, DataType);

	m_iPileLimit	= m_pDBEssence->pile_num_max;
	m_iPrice		= m_pDBEssence->price;
	m_iShopPrice	= m_pDBEssence->shop_price;
	m_iProcType		= m_pDBEssence->proc_type;
	m_i64EquipMask	= EQUIP_MASK64_SPEAKER;

	m_iCurEndurance = 100;
	m_iMaxEndurance = 100;

	m_bNeedUpdate	= false;
}

CECIvtrSpeaker::CECIvtrSpeaker(const CECIvtrSpeaker& s) : CECIvtrEquip(s)
{
	m_pDBEssence	= s.m_pDBEssence;
}

CECIvtrSpeaker::~CECIvtrSpeaker()
{
}

//	Set item detail information
bool CECIvtrSpeaker::SetItemInfo(BYTE* pInfoData, int iDataLen)
{
	CECIvtrItem::SetItemInfo(pInfoData, iDataLen);
	return true;
}

//	Get item icon file name
const char* CECIvtrSpeaker::GetIconFile()
{
	return m_pDBEssence->file_icon;
}

//	Get item name
const wchar_t* CECIvtrSpeaker::GetName()
{
	return m_pDBEssence->name;
}

//	Get item description text
const wchar_t* CECIvtrSpeaker::GetNormalDesc(bool bRepair)
{
	if (m_bNeedUpdate)
		return NULL;

	m_strDesc = _AL("");

	//	Try to build item description
	CECStringTab* pDescTab = g_pGame->GetItemDesc();
	CECHostPlayer* pHost = g_pGame->GetGameRun()->GetHostPlayer();
	
	int white = ITEMDESC_COL_WHITE;
	int red = ITEMDESC_COL_RED;

	if (m_iCount > 1)
		AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_NAMENUMBER), GetName(), m_iCount);
	else
		AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_NAME), GetName());

	AddIDDescText();

	AddBindDescText();

	AddExpireTimeDesc();

	//	Price
	AddPriceDesc(white, bRepair);

	//	Suite description
	AddSuiteDesc();
	
	//	Extend description
	AddExtDescText();
	
	return m_strDesc;
}

//	Get drop model for shown
const char * CECIvtrSpeaker::GetDropModel()
{
	return m_pDBEssence->file_matter;
}


///////////////////////////////////////////////////////////////////////////
//	
//	Implement CECIvtrAutoHP
//	
///////////////////////////////////////////////////////////////////////////

CECIvtrAutoHP::CECIvtrAutoHP(int tid, int expire_date) : CECIvtrEquip(tid, expire_date)
{
	m_iCID	= ICID_AUTOHP;

	//	Get database data
	elementdataman* pDB = g_pGame->GetElementDataMan();
	DATA_TYPE DataType;
	m_pDBEssence = (AUTOHP_ESSENCE*)pDB->get_data_ptr(tid, ID_SPACE_ESSENCE, DataType);

	m_iPileLimit	= m_pDBEssence->pile_num_max;
	m_iPrice		= m_pDBEssence->price;
	m_iShopPrice	= m_pDBEssence->shop_price;
	m_iProcType		= m_pDBEssence->proc_type;
	m_i64EquipMask	= EQUIP_MASK64_AUTOHP;

	m_iCurEndurance = 100;
	m_iMaxEndurance = 100;
}

CECIvtrAutoHP::CECIvtrAutoHP(const CECIvtrAutoHP& s) : CECIvtrEquip(s)
{
	m_pDBEssence	= s.m_pDBEssence;
	m_Essence		= s.m_Essence;
}

CECIvtrAutoHP::~CECIvtrAutoHP()
{
}

//	Set item detail information
bool CECIvtrAutoHP::SetItemInfo(BYTE* pInfoData, int iDataLen)
{
	CECIvtrItem::SetItemInfo(pInfoData, iDataLen);

	if (!pInfoData || !iDataLen)
		return true;
	
	try
	{
		CECDataReader dr(pInfoData, iDataLen);

		m_Essence = *(IVTR_ESSENCE_AUTOHP*)dr.Read_Data(sizeof (IVTR_ESSENCE_AUTOHP));
	}
	catch (CECException& e)
	{
		ASSERT(0);
		a_LogOutput(1, "CECIvtrAutoHP::SetItemInfo, data read error (%d)", e.GetType());
		return false;
	}

	return true;
}

//	Get item icon file name
const char* CECIvtrAutoHP::GetIconFile()
{
	return m_pDBEssence->file_icon;
}

//	Get item name
const wchar_t* CECIvtrAutoHP::GetName()
{
	return m_pDBEssence->name;
}

//	Get item description text
const wchar_t* CECIvtrAutoHP::GetNormalDesc(bool bRepair)
{
	if (m_bNeedUpdate)
		return NULL;

	m_strDesc = _AL("");

	//	Try to build item description
	CECStringTab* pDescTab = g_pGame->GetItemDesc();
	CECHostPlayer* pHost = g_pGame->GetGameRun()->GetHostPlayer();
	
	int white = ITEMDESC_COL_WHITE;
	int red = ITEMDESC_COL_RED;

	if (m_iCount > 1)
		AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_NAMENUMBER), GetName(), m_iCount);
	else
		AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_NAME), GetName());

	AddIDDescText();

	AddBindDescText();

	AddExpireTimeDesc();

	AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_AUTOHP1), m_Essence.hp_left, m_pDBEssence->total_hp);
	AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_AUTOHP2), int(m_pDBEssence->trigger_amount * 100.0f + 0.5f));
	AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_COOLTIME), m_pDBEssence->cool_time / 1000);

	//	Price
	AddPriceDesc(white, bRepair);

	//	Suite description
	AddSuiteDesc();
	
	//	Extend description
	AddExtDescText();
	
	return m_strDesc;
}

//	Get drop model for shown
const char * CECIvtrAutoHP::GetDropModel()
{
	return m_pDBEssence->file_matter;
}

//	Get item cool time
int CECIvtrAutoHP::GetCoolTime(int* piMax)
{
	CECHostPlayer* pHost = g_pGame->GetGameRun()->GetHostPlayer();
	return pHost ? pHost->GetCoolTime(GP_CT_AUTOHP, piMax) : 0;
}


///////////////////////////////////////////////////////////////////////////
//	
//	Implement CECIvtrAutoMP
//	
///////////////////////////////////////////////////////////////////////////

CECIvtrAutoMP::CECIvtrAutoMP(int tid, int expire_date) : CECIvtrEquip(tid, expire_date)
{
	m_iCID	= ICID_AUTOMP;

	//	Get database data
	elementdataman* pDB = g_pGame->GetElementDataMan();
	DATA_TYPE DataType;
	m_pDBEssence = (AUTOMP_ESSENCE*)pDB->get_data_ptr(tid, ID_SPACE_ESSENCE, DataType);

	m_iPileLimit	= m_pDBEssence->pile_num_max;
	m_iPrice		= m_pDBEssence->price;
	m_iShopPrice	= m_pDBEssence->shop_price;
	m_iProcType		= m_pDBEssence->proc_type;
	m_i64EquipMask	= EQUIP_MASK64_AUTOMP;

	m_iCurEndurance = 100;
	m_iMaxEndurance = 100;
}

CECIvtrAutoMP::CECIvtrAutoMP(const CECIvtrAutoMP& s) : CECIvtrEquip(s)
{
	m_pDBEssence	= s.m_pDBEssence;
	m_Essence		= s.m_Essence;
}

CECIvtrAutoMP::~CECIvtrAutoMP()
{
}

//	Set item detail information
bool CECIvtrAutoMP::SetItemInfo(BYTE* pInfoData, int iDataLen)
{
	CECIvtrItem::SetItemInfo(pInfoData, iDataLen);

	if (!pInfoData || !iDataLen)
		return true;

	try
	{
		CECDataReader dr(pInfoData, iDataLen);

		m_Essence = *(IVTR_ESSENCE_AUTOMP*)dr.Read_Data(sizeof (IVTR_ESSENCE_AUTOMP));
	}
	catch (CECException& e)
	{
		ASSERT(0);
		a_LogOutput(1, "CECIvtrAutoHP::SetItemInfo, data read error (%d)", e.GetType());
		return false;
	}

	return true;
}

//	Get item icon file name
const char* CECIvtrAutoMP::GetIconFile()
{
	return m_pDBEssence->file_icon;
}

//	Get item name
const wchar_t* CECIvtrAutoMP::GetName()
{
	return m_pDBEssence->name;
}

//	Get item description text
const wchar_t* CECIvtrAutoMP::GetNormalDesc(bool bRepair)
{
	if (m_bNeedUpdate)
		return NULL;

	m_strDesc = _AL("");

	//	Try to build item description
	CECStringTab* pDescTab = g_pGame->GetItemDesc();
	CECHostPlayer* pHost = g_pGame->GetGameRun()->GetHostPlayer();
	
	int white = ITEMDESC_COL_WHITE;
	int red = ITEMDESC_COL_RED;

	if (m_iCount > 1)
		AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_NAMENUMBER), GetName(), m_iCount);
	else
		AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_NAME), GetName());

	AddIDDescText();

	AddBindDescText();

	AddExpireTimeDesc();

	AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_AUTOMP1), m_Essence.mp_left, m_pDBEssence->total_mp);
	AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_AUTOMP2), int(m_pDBEssence->trigger_amount * 100.0f + 0.5f));
	AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_COOLTIME), m_pDBEssence->cool_time / 1000);
	
	//	Price
	AddPriceDesc(white, bRepair);

	//	Suite description
	AddSuiteDesc();
	
	//	Extend description
	AddExtDescText();
	
	return m_strDesc;
}

//	Get drop model for shown
const char * CECIvtrAutoMP::GetDropModel()
{
	return m_pDBEssence->file_matter;
}

//	Get item cool time
int CECIvtrAutoMP::GetCoolTime(int* piMax)
{
	CECHostPlayer* pHost = g_pGame->GetGameRun()->GetHostPlayer();
	return pHost ? pHost->GetCoolTime(GP_CT_AUTOMP, piMax) : 0;
}



///////////////////////////////////////////////////////////////////////////
//	
//	Implement CECIvtrCertificate
//	
///////////////////////////////////////////////////////////////////////////

CECIvtrCertificate::CECIvtrCertificate(int tid, int expire_date) : CECIvtrEquip(tid, expire_date)
{
	m_iCID	= ICID_CERTIFICATE;

	//	Get database data
	elementdataman* pDB = g_pGame->GetElementDataMan();
	DATA_TYPE DataType;
	m_pDBEssence	= (SELL_CERTIFICATE_ESSENCE*)pDB->get_data_ptr(tid, ID_SPACE_ESSENCE, DataType);

	m_iSellColNum	= m_pDBEssence->num_sell_item;
	m_iBuyColNum	= m_pDBEssence->num_buy_item;
	m_iBoothNameLength	= m_pDBEssence->max_name_length;
	m_iPrice	=	m_pDBEssence->price;
	m_i64EquipMask = EQUIP_MASK64_CERTIFICATE;

	m_iCurEndurance = 100;
	m_iMaxEndurance = 100;

	m_bNeedUpdate	= false;
}

CECIvtrCertificate::CECIvtrCertificate(const CECIvtrCertificate& s) : CECIvtrEquip(s)
{
	m_pDBEssence	= s.m_pDBEssence;

	m_iSellColNum	= s.m_pDBEssence->num_sell_item;
	m_iBuyColNum	= s.m_pDBEssence->num_buy_item;
	m_iBoothNameLength	= s.m_pDBEssence->max_name_length;
	m_iPrice = s.m_pDBEssence->price;
}
CECIvtrCertificate::~CECIvtrCertificate()
{
}

//	Set item detail information
bool CECIvtrCertificate::SetItemInfo(BYTE* pInfoData, int iDataLen)
{
	CECIvtrItem::SetItemInfo(pInfoData, iDataLen);
	return true;
}

//	Get item icon file name
const char* CECIvtrCertificate::GetIconFile()
{
	return m_pDBEssence->file_icon;
}
//	Get item name
const wchar_t* CECIvtrCertificate::GetName()
{
	return m_pDBEssence->name;
}
//	Get drop model for shown
const char * CECIvtrCertificate::GetDropModel()
{
	return m_pDBEssence->file_matter;
}
//  Get booth model id
const char * CECIvtrCertificate::GetBoothModelID()
{
	return m_pDBEssence->show_model;
}

const char* CECIvtrCertificate::GetBoothBarFile()
{
	char* imageFile = m_pDBEssence->name_image;
	if (*imageFile){
		imageFile += 9;
	}else{
		imageFile = "";
	}
	return imageFile;
}

//	Get item description text
const wchar_t* CECIvtrCertificate::GetNormalDesc(bool bRepair)
{
	if (m_bNeedUpdate)
		return NULL;

	m_strDesc = _AL("");
	//	Try to build item description
	CECStringTab* pDescTab = g_pGame->GetItemDesc();
 	int white = ITEMDESC_COL_WHITE;
 	int namecol = DecideNameCol();

 	//  Item name
 	AddDescText(namecol, true, pDescTab->GetWideString(ITEMDESC_NAME), m_pDBEssence->name);

	AddIDDescText();

	AddExpireTimeDesc();
	
	//  Sell column number
	AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_SELL_COL_NUM), m_iSellColNum);

	//  Buy column number
	AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_BUY_COL_NUM), m_iBuyColNum);

	//  Max booth name length
	AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_MAX_BOOTH_NAME), m_iBoothNameLength);

	//	Price
	AddPriceDesc(white, bRepair);

	//  Extend desc
	AddExtDescText();

	return m_strDesc;
}

///////////////////////////////////////////////////////////////////////////
//	
//	Implement CECIvtrForceToken
//	
///////////////////////////////////////////////////////////////////////////

CECIvtrForceToken::CECIvtrForceToken(int tid, int expire_date) : CECIvtrEquip(tid, expire_date)
{
	m_iCID	= ICID_FORCETOKEN;

	//	Get database data
	elementdataman* pDB = g_pGame->GetElementDataMan();
	DATA_TYPE DataType;
	m_pDBEssence = (FORCE_TOKEN_ESSENCE*)pDB->get_data_ptr(tid, ID_SPACE_ESSENCE, DataType);

	m_iPileLimit	= m_pDBEssence->pile_num_max;
	m_iPrice		= m_pDBEssence->price;
	m_iShopPrice	= m_pDBEssence->shop_price;
	m_iProcType		= m_pDBEssence->proc_type;
	m_i64EquipMask	= EQUIP_MASK64_FORCE_TICKET;

	m_iCurEndurance = 100;
	m_iMaxEndurance = 100;
}

CECIvtrForceToken::CECIvtrForceToken(const CECIvtrForceToken& s) : CECIvtrEquip(s)
{
	m_pDBEssence	= s.m_pDBEssence;
	m_Essence		= s.m_Essence;
}

CECIvtrForceToken::~CECIvtrForceToken()
{
}

//	Set item detail information
bool CECIvtrForceToken::SetItemInfo(BYTE* pInfoData, int iDataLen)
{
	CECIvtrItem::SetItemInfo(pInfoData, iDataLen);

	if (!pInfoData || !iDataLen)
		return true;

	try
	{
		CECDataReader dr(pInfoData, iDataLen);

		m_Essence = *(IVTR_ESSENCE_FORCE_TOKEN*)dr.Read_Data(sizeof (IVTR_ESSENCE_FORCE_TOKEN));
	}
	catch (CECException& e)
	{
		ASSERT(0);
		a_LogOutput(1, "CECIvtrForceToken::SetItemInfo, data read error (%d)", e.GetType());
		return false;
	}

	return true;
}

//	Get item icon file name
const char* CECIvtrForceToken::GetIconFile()
{
	return m_pDBEssence->file_icon;
}

//	Get item name
const wchar_t* CECIvtrForceToken::GetName()
{
	return m_pDBEssence->name;
}

//	Get item description text
const wchar_t* CECIvtrForceToken::GetNormalDesc(bool bRepair)
{
	if (m_bNeedUpdate)
		return NULL;

	m_strDesc = _AL("");

	//	Try to build item description
	CECStringTab* pDescTab = g_pGame->GetItemDesc();
	CECHostPlayer* pHost = g_pGame->GetGameRun()->GetHostPlayer();

	int white = ITEMDESC_COL_WHITE;

	int namecol = DecideNameCol();
	if (m_iCount > 1)
		AddDescText(namecol, true, pDescTab->GetWideString(ITEMDESC_NAMENUMBER), GetName(), m_iCount);
	else
		AddDescText(namecol, true, pDescTab->GetWideString(ITEMDESC_NAME), GetName());

	AddIDDescText();

	AddBindDescText();

	AddExpireTimeDesc();

	// detailed information
	const FORCE_CONFIG* pConfig = !m_Essence.require_force ? NULL:CECForceMgr::GetForceData(m_Essence.require_force);
	if(pConfig)
		AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_FORCE_REQUIRE), pConfig->name);

	if(m_pDBEssence->reputation_add)
		AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_FORCE_REPU_TOTAL), m_Essence.repu_total, m_pDBEssence->reputation_add);

	AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_FORCE_REPU_INC_RATIO), max(0, min(100, m_Essence.repu_inc_ratio)));

	//	Price
	AddPriceDesc(white, bRepair);

	//	Suite description
	AddSuiteDesc();

	//	Extend description
	AddExtDescText();

	return m_strDesc;
}

//	Get drop model for shown
const char * CECIvtrForceToken::GetDropModel()
{
	return m_pDBEssence->file_matter;
}


///////////////////////////////////////////////////////////////////////////
//	
//	Implement CECIvtrDynSkillEquip
//	
///////////////////////////////////////////////////////////////////////////

CECIvtrDynSkillEquip::CECIvtrDynSkillEquip(int tid, int expire_date) : CECIvtrEquip(tid, expire_date)
{
	m_iCID	= ICID_DYNSKILLEQUIP;

	//	Get database data
	elementdataman* pDB = g_pGame->GetElementDataMan();
	DATA_TYPE DataType;
	m_pDBEssence = (DYNSKILLEQUIP_ESSENCE*)pDB->get_data_ptr(tid, ID_SPACE_ESSENCE, DataType);

	if (m_pDBEssence)
	{
		for (int i(0); i < ARRAY_SIZE(m_pDBEssence->id_skill); ++ i)
		{
			int idSkill = m_pDBEssence->id_skill[i];
			if (idSkill){
				GNET::ElementSkill* pSkill = GNET::ElementSkill::Create(idSkill, 1);
				if (pSkill)
				{
					pSkill->Destroy();
					pSkill = NULL;
					m_pSkills.push_back(new CECSkill(idSkill, 1));
				}
			}
		}
	}

	m_iPileLimit	= m_pDBEssence->pile_num_max;
	m_iPrice		= m_pDBEssence->price;
	m_iShopPrice	= m_pDBEssence->shop_price;
	m_iProcType		= m_pDBEssence->proc_type;
	m_i64EquipMask	= EQUIP_MASK64_DYNSKILLEQUIP1 | EQUIP_MASK64_DYNSKILLEQUIP2;

	m_iCurEndurance = 100;
	m_iMaxEndurance = 100;

	m_bNeedUpdate	= false;
}

CECIvtrDynSkillEquip::CECIvtrDynSkillEquip(const CECIvtrDynSkillEquip& s) : CECIvtrEquip(s)
{
	m_pDBEssence	= s.m_pDBEssence;
	for (int i(0); i < s.GetSkillCount(); ++ i)
	{
		CECSkill *pSkill = s.GetSkill(i);
		m_pSkills.push_back(new CECSkill(pSkill->GetSkillID(), pSkill->GetSkillLevel()));
	}
}

CECIvtrDynSkillEquip::~CECIvtrDynSkillEquip()
{
	ClearSkills();
}

void CECIvtrDynSkillEquip::ClearSkills()
{
	for (int i(0); i < GetSkillCount(); ++ i)
	{
		delete GetSkill(i);
	}
	m_pSkills.clear();
}

//	Get item name
const wchar_t* CECIvtrDynSkillEquip::GetName()
{
	return m_pDBEssence->name;
}

//	Get item icon file name
const char* CECIvtrDynSkillEquip::GetIconFile()
{
	return m_pDBEssence->file_icon;
}

//	Get drop model for shown
const char * CECIvtrDynSkillEquip::GetDropModel()
{
	return m_pDBEssence->file_matter;
}

bool CECIvtrDynSkillEquip::SetItemInfo(BYTE* pInfoData, int iDataLen)
{
	CECIvtrItem::SetItemInfo(pInfoData, iDataLen);
	return true;
}

//	Get item description text
const wchar_t* CECIvtrDynSkillEquip::GetNormalDesc(bool bRepair)
{
	if (m_bNeedUpdate)
		return NULL;

	m_strDesc = _AL("");

	//	Try to build item description
	CECStringTab* pDescTab = g_pGame->GetItemDesc();	

	int white = ITEMDESC_COL_WHITE;

	int namecol = DecideNameCol();
	if (m_iCount > 1)
		AddDescText(namecol, true, pDescTab->GetWideString(ITEMDESC_NAMENUMBER), GetName(), m_iCount);
	else
		AddDescText(namecol, true, pDescTab->GetWideString(ITEMDESC_NAME), GetName());

	AddIDDescText();

	AddBindDescText();

	AddExpireTimeDesc();

	//	Price
	AddPriceDesc(white, bRepair);

	//	Suite description
	AddSuiteDesc();

	//	Extend description
	AddExtDescText();

	return m_strDesc;
}
///////////////////////////////////////////////////////////////////////////
//	
//	Implement CECIvtrGeneralCard
//	
///////////////////////////////////////////////////////////////////////////

CECIvtrGeneralCard::CECIvtrGeneralCard(int tid, int expire_date) : CECIvtrEquip(tid, expire_date)
{
	m_iCID	= ICID_GENERALCARD;

	memset(&m_Essence, 0, sizeof (m_Essence));
	//	Get database data
	elementdataman* pDB = g_pGame->GetElementDataMan();
	DATA_TYPE DataType;
	m_pDBEssence = (POKER_ESSENCE*)pDB->get_data_ptr(tid, ID_SPACE_ESSENCE, DataType);
	m_pDBSubEssence = (POKER_SUB_TYPE*)pDB->get_data_ptr(m_pDBEssence->id_sub_type, ID_SPACE_ESSENCE, DataType);

	m_iPileLimit	= m_pDBEssence->pile_num_max;
	m_iPrice		= m_pDBEssence->price;
	m_iShopPrice	= m_pDBEssence->shop_price;
	m_iProcType		= m_pDBEssence->proc_type;
	m_i64EquipMask	= m_pDBSubEssence->equip_mask;
	m_iLevelReq		= m_pDBEssence->require_level;

	m_iCurEndurance = 100;
	m_iMaxEndurance = 100;

	m_bNeedUpdate	= true;
}

CECIvtrGeneralCard::CECIvtrGeneralCard(const CECIvtrGeneralCard& s) : CECIvtrEquip(s)
{
	m_Essence		= s.m_Essence;
	m_pDBEssence	= s.m_pDBEssence;
	m_pDBSubEssence = s.m_pDBSubEssence;
}

CECIvtrGeneralCard::~CECIvtrGeneralCard()
{
}

//	Get item name
const wchar_t* CECIvtrGeneralCard::GetName()
{
	return m_pDBEssence->name;
}

//	Get item icon file name
const char* CECIvtrGeneralCard::GetIconFile()
{
	return m_pDBEssence->file_icon;
}

//	Get drop model for shown
const char * CECIvtrGeneralCard::GetDropModel()
{
	return m_pDBEssence->file_matter;
}

bool CECIvtrGeneralCard::SetItemInfo(BYTE* pInfoData, int iDataLen)
{
	CECIvtrItem::SetItemInfo(pInfoData, iDataLen);
	
	if (!pInfoData || !iDataLen)
		return true;
	
	try
	{
		CECDataReader dr(pInfoData, iDataLen);
		
		m_Essence = *(IVTR_ESSENCE_GENERALCARD*)dr.Read_Data(sizeof (IVTR_ESSENCE_GENERALCARD));
		// 븽˵
		{
			//	Get database data
			elementdataman* pDataMan = g_pGame->GetElementDataMan();
			CECGame::ItemExtPropTable& PropTab = g_pGame->GetItemExtPropTable();
			
			int addon_count = sizeof(m_pDBEssence->addon) / sizeof(m_pDBEssence->addon[0]);
			int i, iSize = 0;
			for(i = 0;i < addon_count;i++) {
				if(m_pDBEssence->addon[i] != 0)
					iSize ++;
			}
			
			if(iSize > 0 && m_aProps.GetSize() == 0) {
				m_aProps.SetSize(iSize, 5);
				for(i = 0; i < addon_count; i++) {
					if(m_pDBEssence->addon[i] != 0) {
						PROPERTY& Prop = m_aProps[i];
						Prop.iType = m_pDBEssence->addon[i];
						Prop.bEmbed = false;
						Prop.bSuite = false;
						Prop.bEngraved = false;
						Prop.bLocal = false;
						
						CECGame::ItemExtPropTable::pair_type Pair = PropTab.get(Prop.iType);
						BYTE bType = Pair.second ? *Pair.first : 0xff;
						bool bConvertFloat = false;
						switch(bType){
						case 45:
							bConvertFloat = true;
							break;
						default:
							break;
						}
						
						DATA_TYPE DataType = DT_INVALID;
						const void* pData = pDataMan->get_data_ptr(m_pDBEssence->addon[i], ID_SPACE_ADDON, DataType);
						if (DataType != DT_EQUIPMENT_ADDON)	{
							ASSERT(DataType == DT_EQUIPMENT_ADDON);
							return 0;
						}
						
						const EQUIPMENT_ADDON* pAddon = (const EQUIPMENT_ADDON*)pData;
						Prop.iNumParam = pAddon->num_params;						
						
						for(int j=0; j < Prop.iNumParam; j++)
						{
							if(j==0)
								Prop.aParams[0] = bConvertFloat ? VisualizeFloatPercent(pAddon->param1) : pAddon->param1;
							else if(j==1)
								Prop.aParams[1] = pAddon->param2;
							else if(j==2)
								Prop.aParams[2] = pAddon->param3;
						}
					}
				}
			}
		}
	}
	catch (CECException& e)
	{
		ASSERT(0);
		a_LogOutput(1, "CECIvtrGeneralCard::SetItemInfo, data read error (%d)", e.GetType());
		return false;
	}
	
	return true;
}
int CECIvtrGeneralCard::CalcGeneralCardProp(int prop_base, int prop_grow)
{
	float ratio_suite = GetSuiteRatio();
	float ratio_profession = GetProfessionRatio();
	float ratio_rebirth = GetRebirthRatio();
	return int((prop_base + a_Max(0, m_Essence.level - 1) * prop_grow) * ratio_suite * ratio_profession * ratio_rebirth + .5f);
}
float CECIvtrGeneralCard::GetProfessionRatio()
{
	float ret(1.f);
	CECHostPlayer* pHostPlayer = g_pGame->GetGameRun()->GetHostPlayer();
	const CHARRACTER_CLASS_CONFIG* pConfig = pHostPlayer->GetCharacterClassConfig();
	int index = m_Essence.type;	
	a_Clamp<int>(index, 0, ELEMENTDATA_NUM_POKER_TYPE);
	if (pConfig) ret = pConfig->poker_adjust[index];
	return ret;
}
float CECIvtrGeneralCard::GetSuiteRatio()
{
	float ret(1.f);
	DATA_TYPE DataType = DT_INVALID;
	elementdataman* pDataMan = g_pGame->GetElementDataMan();
	CECHostPlayer* pHostPlayer = g_pGame->GetGameRun()->GetHostPlayer();
	int idSuite = GetSuiteID();
	if (idSuite && pHostPlayer->GetEquipment()->FindTheVerySameItem(this)) {
		//	Get suite info
		const void* pData = pDataMan->get_data_ptr(idSuite, ID_SPACE_ESSENCE, DataType);
		if (DataType == DT_POKER_SUITE_ESSENCE) {
			const POKER_SUITE_ESSENCE* pSuiteEss = (const POKER_SUITE_ESSENCE*)pData;
			int max_equips(0);
			for (int i=0; i < SIZE_GENERALCARD_EQUIPIVTR; i++)
				if (pSuiteEss->list[i]) max_equips++;
				int iItemCnt, aEquipped[SIZE_GENERALCARD_EQUIPIVTR];
				iItemCnt = pHostPlayer->GetEquippedSuiteItem(idSuite, aEquipped);
				if (iItemCnt == max_equips) ret = 1.f + pSuiteEss->promote_ratio;
		}
	}
	return ret;
}
float CECIvtrGeneralCard::GetRebirthRatio()
{
	float ret(1.f);
	switch(m_Essence.rebirth_times) {
	case 1: ret = 1.3f; break;
	case 2: ret = 1.6f; break;
	default: ret = 1.f; break;
	}
	return ret;
}
float CECIvtrGeneralCard::GetRankRatio()
{
	float ret(1.f);
	switch(m_Essence.rank) {
	case 0: ret = 0.f; break;
	case 1: ret = .65f; break;
	case 2: ret = 1.f; break;
	case 3: ret = 1.35f; break;
	case 4: ret = 1.7f; break;
	default: break;
	}
	return ret;
}
void CECIvtrGeneralCard::AddSuiteDesc()
{
	int idSuite = GetSuiteID();
	if (!idSuite)
		return;	//	This equipment isn't one of any suite

	//	Get suite info
	DATA_TYPE DataType = DT_INVALID;
	elementdataman* pDataMan = g_pGame->GetElementDataMan();
	const void* pData = pDataMan->get_data_ptr(idSuite, ID_SPACE_ESSENCE, DataType);
	if (DataType != DT_POKER_SUITE_ESSENCE) {
		ASSERT(DataType == DT_POKER_SUITE_ESSENCE);
		return;
	}

	const POKER_SUITE_ESSENCE* pSuiteEss = (const POKER_SUITE_ESSENCE*)pData;
	CECHostPlayer* pHostPlayer = g_pGame->GetGameRun()->GetHostPlayer();

	int max_equips(0);
	int i, j;
	for (i=0; i < SIZE_GENERALCARD_EQUIPIVTR; i++)
		if (pSuiteEss->list[i]) max_equips++;	

	//	Colors
	int iNameCol = DecideNameCol();
	int lblue = ITEMDESC_COL_LIGHTBLUE;
	int green = ITEMDESC_COL_GREEN;
	int gray = ITEMDESC_COL_GRAY;
	int white = ITEMDESC_COL_WHITE;
	int yellow = ITEMDESC_COL_YELLOW;

	//	Save current description
	AWString strCurDesc = m_strDesc;
	bool bShowDetail = true;

	if (m_pDescIvtr != pHostPlayer->GetEquipment())
		bShowDetail = false;
	else
	{
		//	Check whether this equipment is in host's equipment pack
		for (i=0; i < m_pDescIvtr->GetSize(); i++)
		{
			if (this == m_pDescIvtr->GetItem(i))
				break;
		}

		if (i == m_pDescIvtr->GetSize())
			bShowDetail = false;
	}

	if (!bShowDetail)
	{
		//	Isn't equipment inventory, only add total suite number info.
		m_strDesc = _AL("\\r\\r");
		AddDescText(iNameCol, false, _AL("%s (%d)"), pSuiteEss->name, max_equips);
		m_strDesc = strCurDesc + m_strDesc;
		return;
	}

	struct SUITEITEM
	{
		bool bEnable;
		int tid;
		wchar_t szName[32];

	} aSuiteItems[SIZE_GENERALCARD_EQUIPIVTR];

	//	Fill suite item array
	for (i=0; i < max_equips; i++)
	{
		SUITEITEM& item = aSuiteItems[i];
		item.bEnable = false;
		item.tid = (int)pSuiteEss->list[i];
		item.szName[0] = '\0';

		//	Get item name
		CECIvtrItem* pEquipItem = CECIvtrItem::CreateItem(item.tid, 0, 1);
		if (pEquipItem)
		{
			a_strcpy(item.szName, pEquipItem->GetName());
			delete pEquipItem;
		}
		else
		{
			ASSERT(0);
			item.tid = 0;
		}
	}

	//	Get equipped suite item list
	int iItemCnt, aEquipped[SIZE_GENERALCARD_EQUIPIVTR];
	iItemCnt = pHostPlayer->GetEquippedSuiteItem(idSuite, aEquipped);
	if (!iItemCnt)
		return;

	m_strDesc = _AL("\\r\\r");

	//	Update suite item status
	for (i=0; i < SIZE_GENERALCARD_EQUIPIVTR; i++)
	{
		SUITEITEM& item = aSuiteItems[i];

		for (j=0; j < iItemCnt; j++)
		{
			if (item.tid == aEquipped[j])
			{
				item.bEnable = true;
				break;
			}
		}
	}

	AddDescText(max_equips <= iItemCnt ? lblue : gray, true, 
		g_pGame->GetItemDesc()->GetWideString(ITEMDESC_GENERALCARD_SUITE_PROPRADIO), 
		pSuiteEss->promote_ratio * 100.f);
	
	//	Add suite name
	AddDescText(yellow/*iNameCol*/, true, _AL("%s (%d / %d)"), pSuiteEss->name, iItemCnt, max_equips);
	
	//	List suite item names
	for (i=0; i < max_equips; i++)
	{
		SUITEITEM& item = aSuiteItems[i];
		if (!item.tid)
			continue;

		int col = item.bEnable ? green : gray;
		bool bRet = (i == max_equips-1) ? false : true;

		//	Add item name
		AddDescText(col, bRet, _AL("  %s"), item.szName);
	}

	m_strDesc = strCurDesc + m_strDesc;
}
//	Get item description text
const wchar_t* CECIvtrGeneralCard::GetNormalDesc(bool bRepair)
{
	if (m_bNeedUpdate)
		return NULL;
	//	Build addon and refine properties and save it
	int aPEEVals[MAX_PEEINDEX];
	int aRefines[MAX_REFINEINDEX];
	memset(aPEEVals, 0, sizeof (aPEEVals));
	memset(aRefines, 0, sizeof (aRefines));
	
	m_strDesc = _AL("");
	BuildAddOnPropDesc(aPEEVals, aRefines);
	AWString strAddon = m_strDesc;

	m_strDesc = _AL("");

	//	Try to build item description
	CECStringTab* pDescTab = g_pGame->GetItemDesc();
	CECHostPlayer* pHost = g_pGame->GetGameRun()->GetHostPlayer();

	int lblue = ITEMDESC_COL_LIGHTBLUE;
	int white = ITEMDESC_COL_WHITE;
	int red = ITEMDESC_COL_RED;
	int namecol = DecideNameCol();
	int col = ITEMDESC_COL_WHITE;
	//	Get property effect essence flags
	DWORD dwPEE = PropEffectEssence();

	AddDescText(namecol, true, pDescTab->GetWideString(ITEMDESC_NAME), GetName());
	AddIDDescText();
	// Ʒ
	ACString strText;
	switch(m_Essence.rank) {
	case 0: strText = _AL("C"); break;
	case 1: strText = _AL("B"); break;
	case 2: strText = _AL("A"); break;
	case 3: strText = _AL("S"); break;
	case 4: strText = _AL("S+"); break;
	default: break;
	}
	AddDescText(white, false, pDescTab->GetWideString(ITEMDESC_GENERALCARD_RANK));
	AddDescText(white, true, _AL(" %s"), strText);

	AddBindDescText();

	AddExpireTimeDesc();

	// 
	AddDescText(white, false, pDescTab->GetWideString(ITEMDESC_TYPE));
	m_strDesc += _AL(" ");
	AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_GENERALCARD_TYPE1 + m_Essence.type));	
	// ȼ
	AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_GENERALCARD_LEVEL), m_Essence.level, m_Essence.max_level);	
	// ƾ
	int levelup_exp = GetLevelUpExp(m_Essence.level);
	AddDescText(white, true, pDescTab->GetWideString(ITEMDESC_GENERALCARD_EXP), m_Essence.exp, levelup_exp);	
	// hp
	if (m_pDBEssence->hp) {
		AddDescText(white, false, pDescTab->GetWideString(ITEMDESC_ADDHP));
		AddDescText(white, true, _AL(" %+d"), CalcGeneralCardProp(m_pDBEssence->hp, m_pDBEssence->inc_hp));
	}
	// ﹥
	if (m_pDBEssence->damage) {
		AddDescText(white, false, pDescTab->GetWideString(ITEMDESC_PHYDAMAGE));
		AddDescText(white, true, _AL(" %+d"), CalcGeneralCardProp(m_pDBEssence->damage, m_pDBEssence->inc_damage));
	}
	// 
	if (m_pDBEssence->magic_damage) {
		AddDescText(white, false, pDescTab->GetWideString(ITEMDESC_MAGICDAMAGE));
		AddDescText(white, true, _AL(" %+d"), CalcGeneralCardProp(m_pDBEssence->magic_damage, m_pDBEssence->inc_magic_damage));
	}
	// 
	if (m_pDBEssence->defence) {
		AddDescText(white, false, pDescTab->GetWideString(ITEMDESC_PHYDEFENCE));
		AddDescText(white, true, _AL(" %+d"), CalcGeneralCardProp(m_pDBEssence->defence, m_pDBEssence->inc_defence));
	}
	// 
	for (int i = 0; i < 5; ++i) {
		if (m_pDBEssence->magic_defence[i]) {
			AddDescText(white, false, pDescTab->GetWideString(ITEMDESC_GOLDDEFENCE + i));
			AddDescText(white, true, _AL(" %+d"), CalcGeneralCardProp(m_pDBEssence->magic_defence[i], m_pDBEssence->inc_magic_defence[i]));
		}
	}
	// 
	if (m_pDBEssence->vigour) {
		AddDescText(white, false, pDescTab->GetWideString(ITEMDESC_VIGOUR));
		AddDescText(white, true, _AL(" %+d"), CalcGeneralCardProp(m_pDBEssence->vigour, m_pDBEssence->inc_vigour));
	}
	// 
	if (strAddon.GetLength())
		m_strDesc += strAddon;

	// ǰְҵ
	AddDescText(white, false, pDescTab->GetWideString(ITEMDESC_CURRENT_PROFESSION));
	m_strDesc += _AL(" ");
	AddDescText(white, true, g_pGame->GetGameRun()->GetProfName(pHost->GetProfession()));

	//	Level requirement
	if (m_iLevelReq) {
		col = pHost->GetMaxLevelSofar() >= m_iLevelReq ? white : red;
		AddDescText(col, true, pDescTab->GetWideString(ITEMDESC_LEVELREQ), m_iLevelReq);
	}
	
	// ͳҪ
	if (IsDataFromLocal()){
		int p0 = m_pDBEssence->require_control_point[0];
		int p1 = m_pDBEssence->require_control_point[1];
		if (p0 > 0 || p1 > 0){
			col = pHost->CanEquipCard(this) ? white : red;
			AddDescText(col, false, pDescTab->GetWideString(ITEMDESC_LEADERSHIP));
			if (p0 != p1){
				AddDescText(col, true, _AL(" %d~%d"), p0, p1);
			}else{
				AddDescText(col, true, _AL(" %d"), p0);
			}
		}
	}else if (m_Essence.require_leadership) {
		col = pHost->CanEquipCard(this) ? white : red;
		AddDescText(col, false, pDescTab->GetWideString(ITEMDESC_LEADERSHIP));
		AddDescText(col, true, _AL(" %d"), m_Essence.require_leadership);
	}
	// ת
	if (m_Essence.rebirth_times) {
		AddDescText(white, false, pDescTab->GetWideString(ITEMDESC_GENERALCARD_REINCARNATION_COUNT));
		AddDescText(white, true, _AL(" %d"), m_Essence.rebirth_times);
	}
	// ɺṩֵ
	if (m_pDBEssence->swallow_exp) {
		AddDescText(white, false, pDescTab->GetWideString(ITEMDESC_GENERALCARD_EXP_CANGIVE));
		AddDescText(white, true, _AL(" %d"), GetSwallowExp());
	}
	// Ʊ
//	AddDescText(white, false, pDescTab->GetWideString(ITEMDESC_GENERALCARD_SHOWORDER));
//	AddDescText(white, true, _AL(" %d"), m_pDBEssence->show_order);
	//	Price
	AddPriceDesc(white, bRepair);
	//	Suite description
	AddSuiteDesc();
	//	Extend description
	AddExtDescText();
	return m_strDesc;
}
int CECIvtrGeneralCard::GetSwallowExp()
{
	int ret(m_pDBEssence->swallow_exp);
	// תĵľ
	if (m_Essence.rebirth_times > 0) {
		int rebirth_exp(0);
		for (int i = 1; i < m_Essence.max_level; ++i) 
			rebirth_exp += GetLevelUpExp(i);
		ret += rebirth_exp * m_Essence.rebirth_times;
	}
	// 㵱ǰȼĵľ
	for (int i = 1; i < m_Essence.level; ++i)
		ret += GetLevelUpExp(i);
	// ǰ
	ret += m_Essence.exp;
	return ret;
}
int CECIvtrGeneralCard::GetLevelUpExp(int level)
{
	static const POKER_LEVELEXP_CONFIG* pConfig = NULL;
	int ret(0);
	if (level < 1 || level >= m_Essence.max_level 
		|| m_Essence.rank < 0 || m_Essence.rank > ELEMENTDATA_NUM_POKER_RANK)
		return 0;
	if (NULL == pConfig) {
		elementdataman *pDataMan = g_pGame->GetElementDataMan();
		DATA_TYPE DataType;
		unsigned int tid = pDataMan->get_first_data_id(ID_SPACE_CONFIG,DataType);
		while(tid) {
			if(DataType == DT_POKER_LEVELEXP_CONFIG) {
				pConfig = (POKER_LEVELEXP_CONFIG*)pDataMan->get_data_ptr(tid,ID_SPACE_CONFIG, DataType);
				break;
			}
			tid = pDataMan->get_next_data_id(ID_SPACE_CONFIG, DataType);
		}
	}
	if (pConfig && level < m_Essence.max_level) 
		ret = static_cast<int>(pConfig->exp[level - 1] * pConfig->exp_adjust[m_Essence.rank] + .5f);
	return ret;
}

///////////////////////////////////////////////////////////////////////////
//	
//	Implement CECIvtrAstrolabe
//	
///////////////////////////////////////////////////////////////////////////

CECIvtrAstrolabe::CECIvtrAstrolabe(int tid, int expire_date) : CECIvtrEquip(tid, expire_date)
{
	m_iCID	= ICID_ASTROLABE;

	memset(&_ess, 0, sizeof (_ess));

	//	Get database data
	elementdataman* pDB = g_pGame->GetElementDataMan();
	DATA_TYPE DataType;
	m_pDBEssence = (ASTROLABE_ESSENCE*)pDB->get_data_ptr(tid, ID_SPACE_ESSENCE, DataType);

	m_iPileLimit	= m_pDBEssence->pile_num_max;
	m_iPrice		= m_pDBEssence->price;
	m_iShopPrice	= m_pDBEssence->shop_price;
	m_iProcType		= m_pDBEssence->proc_type;
	m_i64EquipMask	= EQUIP_MASK64_ASTROLABE;
	m_iLevelReq		= m_pDBEssence->require_level;
	m_iProfReq		= m_pDBEssence->character_combo_id;

	_extend.swallow_exp = m_pDBEssence->base_swallow_exp;
	_extend.level_limit = m_pDBEssence->require_level;
	_extend.race_limit = m_pDBEssence->character_combo_id;

	_aptit_limit.max = m_pDBEssence->max_inner_point_value;
	_aptit_limit.min = m_pDBEssence->min_inner_point_value;
	_aptit_limit.total = m_pDBEssence->max_all_inner_point_value;
	_aptit_limit.init_total = m_pDBEssence->init_all_inner_point_value;
	_aptit_limit.init_max = m_pDBEssence->max_init_inner_point_value;

	enum
	{
		ASTROLABE_APTIT_MAX  		= 500,
		ASTROLABE_APTIT_MIN	 		= 10,
		ASTROLABE_APTIT_INIT 		= 500,
		ASTROLABE_APTIT_INIT_LIMIT 	= 200,
		ASTROLABE_APTIT_SUM_MAX 	= 2000,
	};
		
	if(_aptit_limit.max > ASTROLABE_APTIT_MAX) _aptit_limit.max = ASTROLABE_APTIT_MAX;
	if(_aptit_limit.min < ASTROLABE_APTIT_MIN) _aptit_limit.min = ASTROLABE_APTIT_MIN;
	if(_aptit_limit.total > ASTROLABE_APTIT_SUM_MAX) _aptit_limit.total = ASTROLABE_APTIT_SUM_MAX;
	if(_aptit_limit.init_total > ASTROLABE_APTIT_INIT) _aptit_limit.init_total = ASTROLABE_APTIT_INIT;
	if(_aptit_limit.init_max > ASTROLABE_APTIT_INIT_LIMIT) _aptit_limit.init_max = ASTROLABE_APTIT_INIT_LIMIT;

	m_iCurEndurance = 100;
	m_iMaxEndurance = 100;

	m_bNeedUpdate	= false;
}

CECIvtrAstrolabe::CECIvtrAstrolabe(const CECIvtrAstrolabe& s) : CECIvtrEquip(s)
{
	m_pDBEssence	= s.m_pDBEssence;
	_ess			= s._ess;
	_aptit_limit	= s._aptit_limit;
	_extend			= s._extend;
}

CECIvtrAstrolabe::~CECIvtrAstrolabe()
{
}

float CECIvtrAstrolabe::GetAddonRatio(int index)
{	
	if(index >= ASTROLABE_VIRTUAL_SLOT_COUNT) return 0.f; 
	int slot = -1,vslot = 0; 
	for(; vslot < ASTROLABE_VIRTUAL_SLOT_COUNT; ++vslot)
	{
		if(_ess.slot & (1 << vslot)) ++slot;
		if(slot == index) break;
	}
	if(slot != index) 
	{
		// log
		return 0.f;
	}

	if( _aptit_limit.total - _ess.SumAptit() > 0) // δ
		return 25.f + (_ess.level+1)*int(_ess.GetAptit(vslot)/100.f);
	else
		return 25.f + (_ess.level+1)*_ess.GetAptit(vslot)/100.f;
}

//	Set item detail information
bool CECIvtrAstrolabe::SetItemInfo(BYTE* pInfoData, int iDataLen)
{
	try
	{
		CECDataReader dr(pInfoData, iDataLen);	
		_ess = *(astrolabe_essence*)dr.Read_Data(sizeof(astrolabe_essence));

		elementdataman* pDataMan = g_pGame->GetElementDataMan();
		CECGame::ItemExtPropTable& PropTab = g_pGame->GetItemExtPropTable();

		int iNumProp = dr.Read_int();
		if (iNumProp > 0)
		{
			m_aProps.SetSize(iNumProp, 5);
			for (int i=0; i < iNumProp; i++)
			{
				PROPERTY& Prop = m_aProps[i];
				int iType = dr.Read_int();
				Prop.iType = iType & 0x1fff;
				Prop.iNumParam = (iType & 0x6000) >> 13;
				Prop.bEmbed = (iType & 0x8000) ? true : false;
				Prop.bSuite = (iType & 0x10000) ? true : false;
				Prop.bEngraved = (iType & 0x20000) ? true : false;
				Prop.bLocal = false;

				for (int j=0; j < Prop.iNumParam; j++)
				{
					int param = dr.Read_int();
					Prop.aParams[j] = (int)(VisualizeFloatPercent(param) * GetAddonRatio(j)) / 100;
				}
			}
		}
		else if (!iNumProp)
			m_aProps.RemoveAll(false);
		else
		{
			ASSERT(iNumProp >= 0);
			throw CECException(CECException::TYPE_DATAERR);
		}		
	}
	catch (CECException& e)
	{
		ASSERT(0);
		a_LogOutput(1, "CECIvtrAstrolabe::SetItemInfo, data read error (%d)", e.GetType());
		return false;
	}
	
	return true;
}

//	Get item icon file name
const char* CECIvtrAstrolabe::GetIconFile()
{
	return m_pDBEssence->file_icon;
}

//	Get item name
const wchar_t* CECIvtrAstrolabe::GetName()
{
	return m_pDBEssence->name;
}

//	Get item description text
const wchar_t* CECIvtrAstrolabe::GetNormalDesc(bool bRepair)
{
	if (m_bNeedUpdate)
		return NULL;

	//	Build addon and refine properties and save it
	int aPEEVals[MAX_PEEINDEX];
	int aRefines[MAX_REFINEINDEX];
	memset(aPEEVals, 0, sizeof (aPEEVals));
	memset(aRefines, 0, sizeof (aRefines));

	m_strDesc = _AL("");
	BuildAddOnPropDesc(aPEEVals, aRefines);
	AWString strAddon = m_strDesc;
	OutputDebugStringW(strAddon);
	addonsNames = m_strDesc;
	m_strDesc = _AL("");

	CECStringTab* pDescTab = g_pGame->GetItemDesc();
	CECHostPlayer* pHost = g_pGame->GetGameRun()->GetHostPlayer();
	
	int lblue = ITEMDESC_COL_LIGHTBLUE;
	int white = ITEMDESC_COL_WHITE;
	int red = ITEMDESC_COL_RED;
	int namecol = DecideNameCol();
	int col = ITEMDESC_COL_WHITE;

	AddDescText(namecol, true, pDescTab->GetWideString(ITEMDESC_NAME), GetName());

	AddIDDescText();

	AddProfReqDesc(m_iProfReq);

	//	Level requirement
	if (m_iLevelReq) {
		col = pHost->GetMaxLevelSofar() >= m_iLevelReq ? white : red;
		AddDescText(col, true, pDescTab->GetWideString(ITEMDESC_LEVELREQ), m_iLevelReq);
	}

	//	Add addon properties
	if (strAddon.GetLength())
		m_strDesc += strAddon;

	AddExtDescText();

	return m_strDesc;
}

//	Get drop model for shown
const char * CECIvtrAstrolabe::GetDropModel()
{
	return m_pDBEssence->file_matter;
}
/*
//	Add deadly strike rate provided by this equipment 
//	bSuite: true, get deadly strike generated by suite
//  By Sunxuewei 2008/9/3
int CECIvtrAstrolabe::GetDeadlyStrikeRate(bool bSuiteGen)
{
	if (bSuiteGen)
		return CECIvtrEquip::GetDeadlyStrikeRate(bSuiteGen);
	
	int iVal = 0;

	//	Get database data
	elementdataman* pDataMan = g_pGame->GetElementDataMan();
	CECGame::ItemExtPropTable& PropTab = g_pGame->GetItemExtPropTable();

	for(int i=0; i < 10; i++)
	{
		int idProp = (int)m_pDBEssence->rands[i];	

		CECGame::ItemExtPropTable::pair_type Pair = PropTab.get(idProp);
		BYTE byPropType = Pair.second ? *Pair.first : 0xff;

		if (byPropType == 45)	//	Deadly strike
		{
			DATA_TYPE DataType = DT_INVALID;
			const void* pData = pDataMan->get_data_ptr(idProp, ID_SPACE_ADDON, DataType);
			if (DataType != DT_EQUIPMENT_ADDON)
			{
				ASSERT(DataType == DT_EQUIPMENT_ADDON);
				return 0;
			}
			
			const EQUIPMENT_ADDON* pAddon = (const EQUIPMENT_ADDON*)pData;						
			float* fTemp = (float*)&pAddon->param1;			
			iVal += (int)(*fTemp*100 + 0.001f);
		}
	}

	return iVal;
}*/