// Filename	: EC_IntelligentRoute.h
// Creator	: Xu Wenbin
// Date		: 2013/08/15

#pragma once

#include <ARect.h>
#include <vector.h>
#include <A3DVector.h>
#include <MoveAgent.h>

class CECInstance;

class CECIntelligentRoute
{
public:
	typedef AutoMove::CMoveAgent	CMoveAgent;
	typedef CMoveAgent::BrushTest	BrushTest;

	enum SearchResult
	{
		enumSearchSuccess,			//	ɹ
		enumSearchStartEndCoincide,	//	յͬһλ
		enumSearchUnInitialized,	//	δʼ
		enumSearchStartInvalid,		//	Ƿ
		enumSearchEndInvalid,		//	յǷ
		enumSearchStartEndInvalid,	//	յǷ
		enumSearchNoPath,			//	δѵ·
		enumSearchExceedMaxExpand,	//	չ
	};
	enum RouteState
	{
		enumRouteIdle,				//	δѰ·
		enumRouteMoving,			//	·
		enumRoutePathFinished,		//	·ڵ
	};
	enum Usage
	{
		enumUsageNone,				//	;
		enumUsageWorkMove,			//	CECHPWorkMove ʹ
		enumUsageWorkTrace,			//	CECHPWorkTrace ʹ
	};

	~CECIntelligentRoute(){ Release(); }
	static CECIntelligentRoute & Instance();

	Usage GetUsage()const{ return m_usage; }
	void SetUsage(Usage iUsage){ m_usage = iUsage; }
	bool IsUsageMove()const{ return GetUsage() == enumUsageWorkMove; }
	bool IsUsageTrace()const{ return GetUsage() == enumUsageWorkTrace; }

	//	ݼ
	void ChangeWorldInstance(int idInstance);
	void Release();

	//	״̬ѯ
	RouteState GetState() const { return m_state; }
	const A3DVECTOR3 & GetDest()const{ return m_end; }
	
	//	·
	SearchResult Search(const A3DVECTOR3 & start, const A3DVECTOR3 & end, CMoveAgent::BrushTest *pBrushTest=NULL, int nMaxExpand=-1);
	void ResetSearch();

	//	·
	bool IsIdle()const{ return GetState() == enumRouteIdle; }
	bool IsMoveOn()const{ return GetState() == enumRouteMoving; }
	bool IsPathFinished()const{ return GetState() == enumRoutePathFinished; }
	A3DVECTOR3 GetCurDest();
	void OnPlayerPosChange(const A3DVECTOR3 & pos);

	//	·ʾ
	int	 GetLeftNodeCount();
	A3DVECTOR3 GetLeftNodePosXZ(int iOffset);

private:
	struct RangedMoveAgent			//	ǰͼĵѰ·
	{
		ARectI		rect;			//	ṩΧȫͼ½Ϊ(0,0)ϽΪ(CECInstance::GetColNum(), CECInstance::GetRowNum())
		A3DVECTOR3	origin;			//	ͼ½ǶӦеάλãͼ֮任
		CMoveAgent*	agent;			//	ںݡ·
		RangedMoveAgent(): rect(0, 0, 0, 0), origin(0.0f), agent(NULL)
		{}
		bool Contain(const A3DVECTOR3 &pos)const;
	};
	typedef abase::vector<RangedMoveAgent>	MoveAgentArray;

	//	Forbidden
	CECIntelligentRoute(const CECIntelligentRoute &);
	CECIntelligentRoute & operator = (const CECIntelligentRoute &);

	CECIntelligentRoute();
	RangedMoveAgent * GetCurAgent();
	A3DVECTOR3	GetNodePosXZ(int iNode);
	A3DVECTOR3	GetNodePosNoCheck(int iNode);
	A3DVECTOR3	GetNodePos(int iNode);
	int			FindNearestNode(const A3DVECTOR3 &curPos, int iNodeFrom);
	int			FindFarthestNode(const A3DVECTOR3 &curPos, int iNodeFrom);
	int			FindNextNode(const A3DVECTOR3 &curPos, int iNodeFrom);
	bool		CanFinishPath(const A3DVECTOR3 & pos);
	bool		CanMoveToNext(const A3DVECTOR3 & pos);

	CECInstance *	m_pInst;		//	Ѱ·ݶӦĵǰͼ
	MoveAgentArray	m_moveAgents;	//	õͼеѰ·

	RouteState		m_state;		//	Ѱ·ǰ״̬
	A3DVECTOR3		m_start, m_end;	//	Ѱ·㡢յ
	int				m_iCurMoveAgent;//	ϴε Search ʱȷϵѰ·
	int				m_iCurDest;		//	ǰǰ·ڵ±
	A3DVECTOR3		m_lastPos;		//	ϴƶλãλʱڼǷӦһ
	float			m_lastMove;		//	ϴƶ룬ڹһƶľ룬ӶжǷӦһ
	float			m_dist2CurDest;	//	 m_iCurDest ƶľ룬жǷӦһ

	Usage			m_usage;		//	ǰѰ·;
};