/*
 * FILE: ChangePill.h
 *
 * DESCRIPTION: 
 *
 * CREATED BY: Liyi, 2005/7/27
 *
 * HISTORY: 
 *
 * Copyright (c) 2004 Archosaur Studio, All Rights Reserved.
 */

#ifndef _EC_CHANGE_PILL_H_
#define _EC_CHANGE_PILL_H_

// #include "AC.h"
#include <vector.h>

//Ի
enum CusData_t
{
	CUS_HEAD_SCALE,
	CUS_UP_SCALE,
	CUS_WAIST_SCALE,
	CUS_ARM_WIDTH,
	CUS_LEG_WIDTH,
	CUS_BREAST_SCALE,

	CUS_ID_FACE,
	CUS_ID_FALING,
	CUS_SCALE_FACEH,
	CUS_SCALE_FACEV,
	CUS_SCALE_UP,
	CUS_SCALE_MIDDLE,
	CUS_SCALE_DOWN,
	
	CUS_OFFSET_FOREHEADH,
	CUS_OFFSET_FOREHEADV,
	CUS_OFFSET_FOREHEADZ,
	CUS_ROTATE_FOREHEAD,
	CUS_SCALE_FOREHEAD,
	
	CUS_OFFSET_YOKEBONEH,
	CUS_OFFSET_YOKEBONEV,
	CUS_OFFSET_YOKEBONEZ,
	CUS_ROTATE_YOKEBONE,
	CUS_SCALE_YOKEBONE,
	
	CUS_OFFSET_CHEEKH,
	CUS_OFFSET_CHEEKV,
	CUS_OFFSET_CHEEKZ,
	CUS_SCALE_CHEEK,
	
	CUS_OFFSET_CHAINV,
	CUS_OFFSET_CHAINZ,
	CUS_ROTATE_CHAIN,
	CUS_SCALE_CHAINH,
	
	CUS_OFFSET_JAWH,
	CUS_OFFSET_JAWV,
	CUS_OFFSET_JAWZ,
	CUS_SCALE_JAWSPECIAL,
	CUS_SCALE_JAWH,
	CUS_SCALE_JAWV,
	
	CUS_ID_EYE_BASETEX,
	CUS_ID_EYE_SHAPE,
	CUS_SCALE_EYEH,
	CUS_SCALE_EYEV,
	CUS_ROTATE_EYE,
	CUS_OFFSET_EYEH,
	CUS_OFFSET_EYEV,
	CUS_OFFSET_EYEZ,
	CUS_SCALE_EYE_BALL,
	
	CUS_SCALE_EYEH2,
	CUS_SCALE_EYEV2,
	CUS_ROTATE_EYE2,
	CUS_OFFSET_EYEH2,
	CUS_OFFSET_EYEV2,
	CUS_OFFSET_EYEZ2,
	CUS_SCALE_EYE_BALL2,
	
	CUS_ID_BROW_TEX,
	CUS_ID_BROW_SHAPE,
	
	CUS_SCALE_BROWH,
	CUS_SCALE_BROWV,
	CUS_ROTATE_BROW,
	CUS_OFFSET_BROWH,
	CUS_OFFSET_BROWV,
	CUS_OFFSET_BROWZ,
	
	CUS_SCALE_BROWH2,
	CUS_SCALE_BROWV2,
	CUS_ROTATE_BROW2,
	CUS_OFFSET_BROWH2,
	CUS_OFFSET_BROWV2,
	CUS_OFFSET_BROWZ2,
	
	CUS_ID_NOSE_TEX,
	CUS_ID_NOSETIP_SHAPE,
	CUS_ID_NOSEBRIDGE_SHAPE,
	
	CUS_SCALE_NOSETIPH,
	CUS_SCALE_NOSETIPV,
	CUS_OFFSET_NOSETIPV,
	CUS_SCALE_NOSETIPZ,
	CUS_SCALE_BRIDGETIPH,
	CUS_OFFSET_BRIDGETIPZ,
	
	CUS_ID_MOUTH_UPLIPLINE,
	CUS_ID_MOUTH_MIDLIPLINE,
	CUS_ID_MOUTH_DOWNLIPLINE,
	
	CUS_THICK_UPLIP,
	CUS_THICK_DOWNLIP,
	CUS_OFFSET_MOUTHV,
	CUS_OFFSET_MOUTHZ,
	CUS_SCALE_MOUTHH,
	CUS_SCALE_MOUTHH2,
	CUS_OFFSET_CORNEROFMOUTHSPECIAL,
	CUS_OFFSET_CORNEROFMOUTHSPECIAL2,
	
	CUS_ID_EAR_SHAPE,
	CUS_SCALE_EAR,
	CUS_OFFSET_EARV,
	
	CUS_ID_HAIR_MODEL,
	CUS_ID_HAIR_TEX,
	
	CUS_ID_MOUSTACHE_TEX,
	CUS_ID_MOUSTACHE_SKIN,
	CUS_ID_GOATEE_TEX,
	
	CUS_ID_EYE_HIGHTEX,
	
	CUS_COLOR_FACE,
	CUS_COLOR_EYE,
	CUS_COLOR_BROW,
	CUS_COLOR_MOUTH,
	CUS_COLOR_HAIR,
	CUS_COLOR_EYEBALL,
	CUS_COLOR_MOUSTACHE,
	
	CUS_NUM
};

class CECChangePill
{
public:
	struct ChgPillData_t
	{
		int nKey;
		int nValue;
	};

public:
	CECChangePill();
	virtual ~CECChangePill();

	bool	Load(const char* pszFileName);
	bool	IsEmpty(void) { return m_vecChgPillData.size() == 0;}
	int		GetChgPillDataCount(void) { return m_vecChgPillData.size();}
	int		GetCharacter(void) { return m_nCharacter;}
	int		GetGender(void) { return m_nGender;}
	ChgPillData_t* GetChgPillData(int nID) { return &m_vecChgPillData[nID];}


	//ձ
	void	ClearChangePillData(void);
protected:
	

protected:

	int m_nCharacter;
	int m_nGender;
	abase::vector<ChgPillData_t> m_vecChgPillData;
};

#endif