// Filename	: DlgSkillSubList.h
// Creator	: zhangyitian
// Date		: 2014/6/23

#ifndef _ELEMENTCLIENT_DLGSKILLSUBLIST_H_
#define _ELEMENTCLIENT_DLGSKILLSUBLIST_H_

#include "DlgBase.h"
#include "hashmap.h"
#include "EC_Observer.h"

class AUISubDialog;
class CECHostSkillModel;
class CECTaoistRank;


class CDlgSkillSubList : public CDlgBase, public CECObserver<CECHostSkillModel> {

	//AUI_DECLARE_EVENT_MAP();
	//AUI_DECLARE_COMMAND_MAP();

public:

	CDlgSkillSubList();
	~CDlgSkillSubList();

	virtual bool Release();

	void ResetGodEvil();	// ħ״̬

	virtual void OnModelChange(const CECHostSkillModel *p, const CECObservableChange *q);

	void SelectSkill(int skillID);

	void ScrollToShowSelectedSkill();	// 
	
	bool OnChangeLayoutBegin();			// ׼Ľ

	virtual void OnChangeLayoutEnd(bool bAllDone); 

	void ResetDialog();					// ¶Իв

	void EnableUpgrade(bool bEnable);

	int GetSelectedSkillID();
	void SetSelectedSkillID(int skillID);
	bool IsEvil();

	bool IsSkillOrConvertSkillExist(int skillID);	// ܱӦǷб

protected:
	virtual bool OnInitDialog();
	virtual void OnShowDialog();

private:
	void InitRankDlgs();										// ʼڶԻһԷڴ
	void UpdateOneSubDlg(int skillID);							// ޸ĳһ״̬
	void AddRankSubDig(int rankIndex);							// һ漶Ի
	void AddSkillSubDlg(int skillID);							// һܶԻ򣬵øúUpdateOneSubDlg
	void FitSize();

	void CreateOneRankDlg(const CECTaoistRank* taoistRank);		// ½һ漶ӦĶԻ
	void AddDlgsOfOneRank(const CECTaoistRank* taoistRank);		// ĳһ漶ӦмԻ

	void ShowLastSelectedSkill();


private:
	abase::hash_map<int, AUISubDialog*> m_rankSubDialogs;		// IDӦĶԻ򣬸ݽṹ仯
	abase::vector<AUISubDialog*> m_skillSubDialogs;				// пõļܶԻ򣬸ݽṹ仯

	abase::hash_map<int, AUISubDialog*> m_skillSubDialogsMap;	// ¼ÿIDӦĶԻ򣬸ݽṹ仯

	int m_skillSubCount;	// ǰʾļܸ
	int m_curBottom;		// ǰײ
	int m_skillHeight;		// ܶԻĸ߶
	int m_rankHeight;		// Իĸ߶

	AString m_rankDlgFile;		
	AString m_skillDlgFile;

	AString m_rankDlgName;
	AString m_skillDlgName;

	AString m_rankObjName;
	AString m_skillObjName;

	AUISubDialog* m_pSubSkill;
	AUISubDialog* m_pSubRank;

	int m_originWidth;		// ʼ
	int m_originHeight;		// ʼ߶
	int m_originBottom;		// ʼײ

	bool m_bAllocRankDlgs;			// ǷӶԻ
};

#endif