/*
 * FILE: DlgCustomizeFace.h
 *
 * DESCRIPTION: 
 *
 * CREATED BY: Liyi, 2005/8/18
 *
 * HISTORY: 
 *
 * Copyright (c) 2004 Archosaur Studio, All Rights Reserved.
 */
#ifndef _DLG_CUSTOMZIE_FACE_H_
#define _DLG_CUSTOMIZE_FACE_H_

#ifdef _WIN32
	#pragma once
#endif

#include "DlgCustomizeBase.h"
#include "AUI_ImageGrid.h"

class AUIImagePicture;
class AUISlider;
class AUIListBox;
class AUIImagePicture;

class CDlgCustomizeFace : public CDlgCustomizeBase  
{
	AUI_DECLARE_COMMAND_MAP()
	AUI_DECLARE_EVENT_MAP()
protected:
	// 
	AUI_ImageGrid m_ListBoxFaceShape;

	// 
	AUI_ImageGrid m_ListBoxFalingTex;
	
	//	
	AUI_ImageGrid m_ListBoxEar;

	typedef abase::vector<A2DSprite*>::iterator VecA2DSpriteIter_t;
	abase::vector<A2DSprite*> m_vecA2DSprite;

protected:
	
	void DoCalculate();
	bool InitResource();

	virtual bool OnInitContext();
	virtual AUIStillImageButton * GetSwithButton();
	virtual void OnShowDialog();
	virtual void OnTick();

	void ClearListCtrlAndA2DSprite();
public:	
	void OnCommandSwitchDlg(const char* szCommand);
	
	void OnLButtonUpListbox(WPARAM wParam, LPARAM lParam, AUIObject * pObj);
	void OnMouseWheelListbox(WPARAM wParam, LPARAM lParam, AUIObject * pObj);

	CDlgCustomizeFace();
	virtual ~CDlgCustomizeFace();
};



class CDlgCustomizeFace2 : public CDlgCustomizeBase  
{
	AUI_DECLARE_COMMAND_MAP()
	AUI_DECLARE_EVENT_MAP()
		
protected:
	//ddx control
	AUISlider* m_pSliderOffsetForeheadH;	//ͷĺ
	AUISlider* m_pSliderOffsetForeheadV;	//ͷ
	AUISlider* m_pSliderOffsetForeheadZ;	//ͷǰ
	AUISlider* m_pSliderRotateForehead;		//ͷת
	AUISlider* m_pSliderScaleForehead;		//ͷı
	
	AUISlider* m_pSliderOffsetYokeBoneH;	//ȧǵĺ
	AUISlider* m_pSliderOffsetYokeBoneV;	//ȧǵ
	AUISlider* m_pSliderOffsetYokeBoneZ;	//ȧǵǰƶ
	AUISlider* m_pSliderRotateYokeBone;		//ȧǵת
	AUISlider* m_pSliderScaleYokeBone;		//ȧǵı
	
	AUISlider* m_pSliderOffsetCheekH;		//յĺ
	AUISlider* m_pSliderOffsetCheekV;		//յ
	AUISlider* m_pSliderOffsetCheekZ;		//յǰƶ
	AUISlider* m_pSliderScaleCheek;			//յı
	
	AUISlider* m_pSliderOffsetChainV;		//°͵
	AUISlider* m_pSliderOffsetChainZ;		//°͵ǰƶ
	AUISlider* m_pSliderRotateChain;		//°͵?
	AUISlider* m_pSliderScaleChainH;		//°͵ұ
	
	AUISlider* m_pSliderOffsetJawH;			//ǵĺ
	AUISlider* m_pSliderOffsetJawV;			//ǵ
	AUISlider* m_pSliderOffsetJawZ;			//ǵǰƶ
	AUISlider* m_pSliderScaleJawSpecial;	//ǵ
	AUISlider* m_pSliderScaleJawH;			//ǵұ
	AUISlider* m_pSliderScaleJawV;			//ǵ±
	
	AUISlider * m_pSliderScaleEar;
	AUISlider * m_pSliderOffsetEarV;	
	
	//3ͥĹؼ
	AUISlider* m_pSliderPartUp;
	AUISlider* m_pSliderPartMiddle;
	AUISlider* m_pSliderPartDown;
	
	//̱
	AUISlider* m_pSliderScaleFaceH;
	AUISlider* m_pSliderScaleFaceV;
	
protected:
	virtual bool OnInitContext();
	virtual void DoDataExchange(bool bSave);
	
	void DoCalculate();
	bool InitResource();
	void SetSliderBound();
	
	
	void DefaultForehead();
	void DefaultYokeBone();
	void DefaultCheek();
	void DefaultChain();
	void DefaultJaw();
	void DefaultEar();
	void DefaultFace();
	
	virtual void OnShowDialog();
	
public:
	void LoadDefault();//Ҫڸλȱʡݴ
	
	CDlgCustomizeFace2();
	virtual ~CDlgCustomizeFace2();
	
	virtual AUIStillImageButton * GetSwithButton();
	void OnCommandMoveSlider(const char* szCommand);
	void OnCommandReset(const char* szCommand);
};

#endif
